/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.wildfly.security.manager.WildFlySecurityManager;

final class SecurityActions {
    private SecurityActions() {
    }

    static <T, R> R privilegedExecution(Function<T, R> function, T t) {
        return SecurityActions.privilegedExecution().execute(function, t);
    }

    static <T, U, R> R privilegedExecution(BiFunction<T, U, R> function, T t, U u) {
        return SecurityActions.privilegedExecution().execute(function, t, u);
    }

    private static Execution privilegedExecution() {
        return WildFlySecurityManager.isChecking() ? Execution.PRIVILEGED : Execution.NON_PRIVILEGED;
    }

    private static interface Execution {
        public static final Execution NON_PRIVILEGED = new Execution(){

            @Override
            public <T, R> R execute(Function<T, R> function, T t) {
                return function.apply(t);
            }

            @Override
            public <T, U, R> R execute(BiFunction<T, U, R> function, T t, U u) {
                return function.apply(t, u);
            }
        };
        public static final Execution PRIVILEGED = new Execution(){

            @Override
            public <T, R> R execute(Function<T, R> function, T t) {
                try {
                    return (R)AccessController.doPrivileged(() -> NON_PRIVILEGED.execute(function, t));
                }
                catch (PrivilegedActionException e) {
                    Execution.throwConverted(e);
                    throw new IllegalStateException();
                }
            }

            @Override
            public <T, U, R> R execute(BiFunction<T, U, R> function, T t, U u) {
                try {
                    return (R)AccessController.doPrivileged(() -> NON_PRIVILEGED.execute(function, t, u));
                }
                catch (PrivilegedActionException e) {
                    Execution.throwConverted(e);
                    throw new IllegalStateException();
                }
            }
        };

        public <T, R> R execute(Function<T, R> var1, T var2);

        public <T, U, R> R execute(BiFunction<T, U, R> var1, T var2, U var3);

        public static void throwConverted(PrivilegedActionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            throw new RuntimeException(cause);
        }
    }
}

