/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.operations;

import java.util.Locale;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ControlledProcessState;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.ProcessType;
import org.jboss.as.controller.RunningMode;
import org.jboss.as.controller.RunningModeControl;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleOperationDefinition;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.descriptions.DefaultOperationDescriptionProvider;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.common.ProcessReloadHandler;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.domain.controller.LocalHostControllerInfo;
import org.jboss.as.host.controller.HostControllerEnvironment;
import org.jboss.as.host.controller.HostModelUtil;
import org.jboss.as.host.controller.HostRunningModeControl;
import org.jboss.as.host.controller.RestartMode;
import org.jboss.as.host.controller.logging.HostControllerLogger;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceName;

public class HostProcessReloadHandler
extends ProcessReloadHandler<HostRunningModeControl> {
    private static final AttributeDefinition RESTART_SERVERS = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("restart-servers", ModelType.BOOLEAN, true).setDefaultValue(new ModelNode(true))).build();
    private static final AttributeDefinition USE_CURRENT_DOMAIN_CONFIG = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("use-current-domain-config", ModelType.BOOLEAN, true).setAlternatives(new String[]{"domain-config"})).setDefaultValue(new ModelNode(true))).build();
    private static final AttributeDefinition USE_CURRENT_HOST_CONFIG = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("use-current-host-config", ModelType.BOOLEAN, true).setAlternatives(new String[]{"host-config"})).setDefaultValue(new ModelNode(true))).build();
    private static final AttributeDefinition HOST_CONFIG = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("host-config", ModelType.STRING, true).setAlternatives(new String[]{"use-current-host-config"})).build();
    private static final AttributeDefinition DOMAIN_CONFIG = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("domain-config", ModelType.STRING, true).setAlternatives(new String[]{"use-current-domain-config"})).build();
    private static final AttributeDefinition[] MASTER_ATTRIBUTES = new AttributeDefinition[]{ADMIN_ONLY, RESTART_SERVERS, USE_CURRENT_DOMAIN_CONFIG, USE_CURRENT_HOST_CONFIG, DOMAIN_CONFIG, HOST_CONFIG};
    private static final AttributeDefinition[] SLAVE_ATTRIBUTES = new AttributeDefinition[]{ADMIN_ONLY, RESTART_SERVERS, USE_CURRENT_HOST_CONFIG, HOST_CONFIG};
    private final HostControllerEnvironment environment;
    private final LocalHostControllerInfo hostControllerInfo;
    private final ProcessType processType;

    public static OperationDefinition getDefinition(LocalHostControllerInfo hostControllerInfo) {
        return new DeferredParametersOperationDefinitionBuilder(hostControllerInfo, "reload", (ResourceDescriptionResolver)HostModelUtil.getResourceDescriptionResolver(new String[0])).setParameters(hostControllerInfo.isMasterDomainController() ? MASTER_ATTRIBUTES : SLAVE_ATTRIBUTES).withFlag(OperationEntry.Flag.HOST_CONTROLLER_ONLY).setRuntimeOnly().build();
    }

    public HostProcessReloadHandler(ServiceName rootService, HostRunningModeControl runningModeControl, ControlledProcessState processState, HostControllerEnvironment environment, LocalHostControllerInfo hostControllerInfo) {
        super(rootService, (RunningModeControl)runningModeControl, processState);
        this.processType = environment.getProcessType();
        this.environment = environment;
        this.hostControllerInfo = hostControllerInfo;
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        boolean adminOnly;
        if (this.processType == ProcessType.EMBEDDED_HOST_CONTROLLER && !(adminOnly = ADMIN_ONLY.resolveModelAttribute(context, operation).asBoolean(false))) {
            throw HostControllerLogger.ROOT_LOGGER.embeddedHostControllerRestartMustProvideAdminOnlyTrue();
        }
        super.execute(context, operation);
    }

    protected ProcessReloadHandler.ReloadContext<HostRunningModeControl> initializeReloadContext(OperationContext context, ModelNode operation) throws OperationFailedException {
        final boolean adminOnly = ADMIN_ONLY.resolveModelAttribute(context, operation).asBoolean(false);
        final boolean restartServers = RESTART_SERVERS.resolveModelAttribute(context, operation).asBoolean(true);
        final boolean useCurrentHostConfig = USE_CURRENT_HOST_CONFIG.resolveModelAttribute(context, operation).asBoolean(true);
        final boolean useCurrentDomainConfig = this.hostControllerInfo.isMasterDomainController() && USE_CURRENT_DOMAIN_CONFIG.resolveModelAttribute(context, operation).asBoolean(true);
        final String domainConfig = this.hostControllerInfo.isMasterDomainController() && operation.hasDefined(DOMAIN_CONFIG.getName()) ? DOMAIN_CONFIG.resolveModelAttribute(context, operation).asString() : null;
        final String hostConfig = operation.hasDefined(HOST_CONFIG.getName()) ? HOST_CONFIG.resolveModelAttribute(context, operation).asString() : null;
        final String hostName = context.getCurrentAddress().getLastElement().getValue();
        if (operation.hasDefined(USE_CURRENT_DOMAIN_CONFIG.getName()) && domainConfig != null) {
            throw HostControllerLogger.ROOT_LOGGER.cannotBothHaveFalseUseCurrentDomainConfigAndDomainConfig();
        }
        if (operation.hasDefined(USE_CURRENT_HOST_CONFIG.getName()) && hostConfig != null) {
            throw HostControllerLogger.ROOT_LOGGER.cannotBothHaveFalseUseCurrentHostConfigAndHostConfig();
        }
        if (domainConfig != null && !this.environment.getDomainConfigurationFile().checkCanFindNewBootFile(domainConfig)) {
            throw HostControllerLogger.ROOT_LOGGER.domainConfigForReloadNotFound(domainConfig);
        }
        if (hostConfig != null && !this.environment.getHostConfigurationFile().checkCanFindNewBootFile(hostConfig)) {
            throw HostControllerLogger.ROOT_LOGGER.domainConfigForReloadNotFound(hostConfig);
        }
        return new ProcessReloadHandler.ReloadContext<HostRunningModeControl>(){

            public void reloadInitiated(HostRunningModeControl runningModeControl) {
                runningModeControl.setRestartMode(restartServers ? RestartMode.SERVERS : RestartMode.HC_ONLY);
            }

            public void doReload(HostRunningModeControl runningModeControl) {
                runningModeControl.setRunningMode(adminOnly ? RunningMode.ADMIN_ONLY : RunningMode.NORMAL);
                runningModeControl.setReloaded();
                runningModeControl.setUseCurrentConfig(useCurrentHostConfig);
                runningModeControl.setUseCurrentDomainConfig(useCurrentDomainConfig);
                runningModeControl.setNewDomainBootFileName(domainConfig);
                runningModeControl.setNewBootFileName(hostConfig);
                runningModeControl.setReloadHostName(hostName);
            }
        };
    }

    private static class DeferredParametersOperationDefinitionBuilder
    extends SimpleOperationDefinitionBuilder {
        private final LocalHostControllerInfo hostControllerInfo;

        public DeferredParametersOperationDefinitionBuilder(LocalHostControllerInfo hostControllerInfo, String name, ResourceDescriptionResolver resolver) {
            super(name, resolver);
            this.hostControllerInfo = hostControllerInfo;
        }

        public SimpleOperationDefinition internalBuild(final ResourceDescriptionResolver resolver, final ResourceDescriptionResolver attributeResolver) {
            return new SimpleOperationDefinition(this.name, resolver, attributeResolver, this.entryType, this.flags, this.replyType, this.replyValueType, false, this.deprecationData, this.replyParameters, this.parameters){

                public DescriptionProvider getDescriptionProvider() {
                    return new DescriptionProvider(){

                        public ModelNode getModelDescription(Locale locale) {
                            AttributeDefinition[] params = hostControllerInfo.isMasterDomainController() ? MASTER_ATTRIBUTES : SLAVE_ATTRIBUTES;
                            return new DefaultOperationDescriptionProvider(this.getName(), resolver, attributeResolver, replyType, replyValueType, replyAllowNull, deprecationData, replyParameters, params, accessConstraints).getModelDescription(locale);
                        }
                    };
                }
            };
        }
    }
}

