/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.operations.coordination;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.domain.controller.LocalHostControllerInfo;
import org.jboss.as.domain.controller.logging.DomainControllerLogger;
import org.jboss.dmr.ModelNode;

class OperationRouting {
    private final Set<String> hosts = new HashSet<String>();
    private final boolean multiphase;

    static OperationRouting determineRouting(OperationContext context, ModelNode operation, LocalHostControllerInfo localHostControllerInfo, Set<String> hostNames) throws OperationFailedException {
        ImmutableManagementResourceRegistration rootRegistration = context.getRootResourceRegistration();
        return OperationRouting.determineRouting(operation, localHostControllerInfo, rootRegistration, hostNames);
    }

    private static OperationRouting determineRouting(ModelNode operation, LocalHostControllerInfo localHostControllerInfo, ImmutableManagementResourceRegistration rootRegistration, Set<String> hostNames) throws OperationFailedException {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
        String operationName = operation.require("operation").asString();
        Set<OperationEntry.Flag> operationFlags = OperationRouting.resolveOperationFlags(address, operationName, rootRegistration);
        return OperationRouting.determineRouting(operation, address, operationName, operationFlags, localHostControllerInfo, rootRegistration, hostNames);
    }

    private static Set<OperationEntry.Flag> resolveOperationFlags(PathAddress address, String operationName, ImmutableManagementResourceRegistration rootRegistration) throws OperationFailedException {
        Set result = null;
        boolean validAddress = false;
        OperationEntry ope = rootRegistration.getOperationEntry(address, operationName);
        if (ope != null) {
            return ope.getFlags();
        }
        ImmutableManagementResourceRegistration targetReg = rootRegistration.getSubModel(address);
        if (targetReg != null) {
            validAddress = true;
            OperationEntry opE = targetReg.getOperationEntry(PathAddress.EMPTY_ADDRESS, operationName);
            Set set = result = opE == null ? null : opE.getFlags();
        }
        if (result == null) {
            if (validAddress) {
                throw new OperationFailedException(ControllerLogger.ROOT_LOGGER.noHandlerForOperation(operationName, address));
            }
            throw new OperationFailedException(ControllerLogger.ROOT_LOGGER.noSuchResourceType(address));
        }
        return result;
    }

    private static OperationRouting determineRouting(ModelNode operation, PathAddress address, String operationName, Set<OperationEntry.Flag> operationFlags, LocalHostControllerInfo localHostControllerInfo, ImmutableManagementResourceRegistration rootRegistration, Set<String> hostNames) throws OperationFailedException {
        PathElement first;
        OperationRouting routing = null;
        Set<String> targetHost = null;
        boolean compositeOp = false;
        boolean profileChildOp = false;
        if (address.size() > 0) {
            first = address.getElement(0);
            if ("host".equals(first.getKey())) {
                if (first.isMultiTarget()) {
                    if (first.isWildcard()) {
                        targetHost = new HashSet<String>();
                        targetHost.addAll(hostNames);
                        targetHost.add(localHostControllerInfo.getLocalHostName());
                    } else {
                        targetHost = new HashSet<String>();
                        Collections.addAll(targetHost, first.getSegments());
                    }
                } else {
                    targetHost = Collections.singleton(first.getValue());
                }
            } else if ("profile".equals(first.getKey())) {
                profileChildOp = address.size() > 1;
            }
        } else {
            compositeOp = "composite".equals(operationName);
        }
        if (targetHost != null) {
            if (operationFlags.contains(OperationEntry.Flag.READ_ONLY) && !operationFlags.contains(OperationEntry.Flag.DOMAIN_PUSH_TO_SERVERS)) {
                routing = new OperationRouting(targetHost, false);
            } else if (address.size() > 1 && "server".equals((first = address.getElement(1)).getKey())) {
                routing = new OperationRouting(targetHost, false);
            }
            if (routing == null) {
                if (operationFlags.contains(OperationEntry.Flag.HOST_CONTROLLER_ONLY)) {
                    routing = new OperationRouting(targetHost, false);
                } else {
                    boolean twoStep = targetHost.contains(localHostControllerInfo.getLocalHostName());
                    routing = new OperationRouting(targetHost, twoStep);
                }
            }
        } else if (compositeOp) {
            if (operation.hasDefined("steps")) {
                HashSet<String> allHosts = new HashSet<String>();
                boolean fwdToAllHosts = false;
                boolean twoStep = false;
                for (ModelNode step : operation.get("steps").asList()) {
                    OperationRouting stepRouting = OperationRouting.determineRouting(step, localHostControllerInfo, rootRegistration, hostNames);
                    if (stepRouting.isMultiphase()) {
                        twoStep = true;
                        fwdToAllHosts = fwdToAllHosts || stepRouting.getHosts().isEmpty();
                    }
                    allHosts.addAll(stepRouting.getHosts());
                }
                routing = fwdToAllHosts ? new OperationRouting(true) : new OperationRouting(allHosts, twoStep);
            } else {
                routing = new OperationRouting(localHostControllerInfo);
            }
        } else if (!(!operationFlags.contains(OperationEntry.Flag.READ_ONLY) || (operationFlags.contains(OperationEntry.Flag.DOMAIN_PUSH_TO_SERVERS) || profileChildOp && operationFlags.contains(OperationEntry.Flag.RUNTIME_ONLY)) && !operationFlags.contains(OperationEntry.Flag.HOST_CONTROLLER_ONLY))) {
            routing = new OperationRouting(localHostControllerInfo);
        } else if (!localHostControllerInfo.isMasterDomainController()) {
            routing = new OperationRouting();
        } else if (operationFlags.contains(OperationEntry.Flag.MASTER_HOST_CONTROLLER_ONLY)) {
            routing = new OperationRouting(localHostControllerInfo);
        }
        if (routing == null) {
            routing = new OperationRouting(true);
        }
        DomainControllerLogger.HOST_CONTROLLER_LOGGER.tracef("Routing for operation %s is %s", operation, routing);
        return routing;
    }

    private OperationRouting() {
        this.multiphase = false;
    }

    private OperationRouting(boolean multiphase) {
        this.multiphase = multiphase;
    }

    private OperationRouting(LocalHostControllerInfo localHostControllerInfo) {
        this.hosts.add(localHostControllerInfo.getLocalHostName());
        this.multiphase = false;
    }

    private OperationRouting(Set<String> hosts, boolean multiphase) {
        this.hosts.addAll(hosts);
        this.multiphase = multiphase;
    }

    Set<String> getHosts() {
        return this.hosts;
    }

    String getSingleHost() {
        return this.hosts.size() == 1 ? this.hosts.iterator().next() : null;
    }

    boolean isMultiphase() {
        return this.multiphase;
    }

    boolean isLocalOnly(String localHostName) {
        return this.hosts.size() == 1 && this.hosts.contains(localHostName);
    }

    boolean isLocalCallNeeded(String localHostName) {
        return this.hosts.size() == 0 || this.hosts.contains(localHostName);
    }

    public String toString() {
        return "OperationRouting{hosts=" + this.hosts + ", multiphase=" + this.multiphase + '}';
    }
}

