/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.jboss.as.controller.CurrentOperationIdHolder;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ProxyOperationAddressTranslator;
import org.jboss.as.controller.TransformingProxyController;
import org.jboss.as.controller.client.OperationAttachments;
import org.jboss.as.controller.client.OperationMessageHandler;
import org.jboss.as.controller.client.OperationResponse;
import org.jboss.as.controller.client.helpers.domain.ServerStatus;
import org.jboss.as.controller.remote.BlockingQueueOperationListener;
import org.jboss.as.controller.remote.TransactionalProtocolClient;
import org.jboss.as.controller.remote.TransactionalProtocolHandlers;
import org.jboss.as.controller.transform.TransformationTarget;
import org.jboss.as.controller.transform.Transformers;
import org.jboss.as.host.controller.HostControllerEnvironment;
import org.jboss.as.host.controller.ManagedServerBootCmdFactory;
import org.jboss.as.host.controller.ManagedServerBootConfiguration;
import org.jboss.as.host.controller.ManagedServerProxy;
import org.jboss.as.host.controller.logging.HostControllerLogger;
import org.jboss.as.process.ProcessControllerClient;
import org.jboss.as.protocol.mgmt.ManagementChannelHandler;
import org.jboss.as.server.DomainServerCommunicationServices;
import org.jboss.as.server.ServerStartTask;
import org.jboss.as.server.security.DomainServerCredential;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;
import org.jboss.marshalling.ClassResolver;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.MarshallerFactory;
import org.jboss.marshalling.Marshalling;
import org.jboss.marshalling.MarshallingConfiguration;
import org.jboss.marshalling.SimpleClassResolver;
import org.jboss.msc.service.ServiceActivator;
import org.jboss.threads.AsyncFuture;
import org.wildfly.security.credential.Credential;

class ManagedServer {
    private static final Logger.Level DEBUG_LEVEL = Logger.Level.TRACE;
    private static final MarshallerFactory MARSHALLER_FACTORY = Marshalling.getMarshallerFactory((String)"river", (ClassLoader)Marshalling.class.getClassLoader());
    private static final MarshallingConfiguration CONFIG;
    private static final String SERVER_PROCESS_NAME_PREFIX = "Server:";
    private static final String SERVER_PROCESS_ID_PREFIX = "pcid:";
    private final DomainServerCredential domainServerCredential;
    private final String serverName;
    private final String serverProcessName;
    private final String hostControllerName;
    private final URI managementURI;
    private final ProcessControllerClient processControllerClient;
    private final ManagedServerProxy protocolClient;
    private final TransformingProxyController proxyController;
    private volatile boolean requiresReload;
    private volatile InternalState requiredState = InternalState.STOPPED;
    private volatile InternalState internalState = InternalState.STOPPED;
    private volatile int operationID = CurrentOperationIdHolder.getCurrentOperationID();
    private volatile ManagedServerBootConfiguration bootConfiguration;
    private volatile boolean unstable;
    private final PathAddress address;

    static String getServerProcessName(String serverName) {
        return SERVER_PROCESS_NAME_PREFIX + serverName;
    }

    static String getServerProcessId(int serverId) {
        return SERVER_PROCESS_ID_PREFIX + serverId;
    }

    static boolean isServerProcess(String serverProcessName) {
        return serverProcessName.startsWith(SERVER_PROCESS_NAME_PREFIX);
    }

    static String getServerName(String serverProcessName) {
        return serverProcessName.substring(SERVER_PROCESS_NAME_PREFIX.length());
    }

    ManagedServer(String hostControllerName, String serverName, DomainServerCredential domainServerCredential, ProcessControllerClient processControllerClient, URI managementURI, TransformationTarget transformationTarget) {
        assert (hostControllerName != null) : "hostControllerName is null";
        assert (serverName != null) : "serverName is null";
        assert (processControllerClient != null) : "processControllerSlave is null";
        assert (managementURI != null) : "managementURI is null";
        this.hostControllerName = hostControllerName;
        this.serverName = serverName;
        this.serverProcessName = ManagedServer.getServerProcessName(serverName);
        this.processControllerClient = processControllerClient;
        this.managementURI = managementURI;
        this.domainServerCredential = domainServerCredential;
        PathElement serverPath = PathElement.pathElement((String)"server", (String)serverName);
        this.address = PathAddress.EMPTY_ADDRESS.append(new PathElement[]{PathElement.pathElement((String)"host", (String)hostControllerName), serverPath});
        this.protocolClient = new ManagedServerProxy(this);
        this.proxyController = TransformingProxyController.Factory.create((TransactionalProtocolClient)this.protocolClient, (Transformers)Transformers.Factory.create((TransformationTarget)transformationTarget), (PathAddress)this.address, (ProxyOperationAddressTranslator)ProxyOperationAddressTranslator.SERVER);
    }

    Credential getCredential() {
        return this.domainServerCredential;
    }

    String getAuthToken() {
        return this.domainServerCredential.getToken();
    }

    String getServerName() {
        return this.serverName;
    }

    TransformingProxyController getProxyController() {
        return this.proxyController;
    }

    ServerStatus getState() {
        InternalState requiredState = this.requiredState;
        InternalState state = this.internalState;
        if (requiredState == InternalState.FAILED) {
            return ServerStatus.FAILED;
        }
        switch (state) {
            case STOPPED: {
                return ServerStatus.STOPPED;
            }
            case SERVER_STARTED: {
                return ServerStatus.STARTED;
            }
        }
        if (requiredState == InternalState.SERVER_STARTED) {
            return ServerStatus.STARTING;
        }
        return ServerStatus.STOPPING;
    }

    boolean isRequiresReload() {
        return this.requiresReload;
    }

    void requireReload() {
        this.requiresReload = true;
    }

    synchronized boolean reload(int permit, boolean suspend) {
        return this.internalSetState(new ReloadTask(permit, suspend), InternalState.SERVER_STARTED, InternalState.RELOADING);
    }

    synchronized void start(ManagedServerBootCmdFactory factory) {
        InternalState current;
        InternalState required = this.requiredState;
        if (required == InternalState.SERVER_STARTED) {
            return;
        }
        if (required != InternalState.FAILED && (current = this.internalState) != required) {
            throw new IllegalStateException();
        }
        this.operationID = CurrentOperationIdHolder.getCurrentOperationID();
        this.bootConfiguration = factory.createConfiguration();
        this.requiredState = InternalState.SERVER_STARTED;
        HostControllerLogger.ROOT_LOGGER.startingServer(this.serverName);
        this.transition();
    }

    synchronized void stop(Integer timeout) {
        InternalState required = this.requiredState;
        if (required != InternalState.STOPPED) {
            this.requiredState = InternalState.STOPPED;
            HostControllerLogger.ROOT_LOGGER.stoppingServer(this.serverName);
            if (this.internalState == InternalState.SERVER_STARTED) {
                this.internalSetState(new ServerStopTask(timeout), this.internalState, InternalState.PROCESS_STOPPING);
            } else {
                this.transition(false);
            }
        }
    }

    synchronized void destroy() {
        InternalState required = this.requiredState;
        if (required == InternalState.STOPPED) {
            if (this.internalState != InternalState.STOPPED) {
                try {
                    this.processControllerClient.destroyProcess(this.serverProcessName);
                }
                catch (IOException e) {
                    HostControllerLogger.ROOT_LOGGER.logf(DEBUG_LEVEL, e, "failed to send destroy_process message to %s", this.serverName);
                }
            }
        } else {
            this.stop(null);
            required = this.requiredState;
            if (required == InternalState.STOPPED) {
                this.destroy();
            }
        }
    }

    synchronized void kill() {
        InternalState required = this.requiredState;
        if (required == InternalState.STOPPED) {
            if (this.internalState != InternalState.STOPPED) {
                try {
                    this.processControllerClient.killProcess(this.serverProcessName);
                }
                catch (IOException e) {
                    HostControllerLogger.ROOT_LOGGER.logf(DEBUG_LEVEL, e, "failed to send kill_process message to %s", this.serverName);
                }
            }
        } else {
            this.stop(null);
            required = this.requiredState;
            if (required == InternalState.STOPPED) {
                this.kill();
            }
        }
    }

    synchronized void reconnectServerProcess(ManagedServerBootCmdFactory factory) {
        if (this.requiredState != InternalState.SERVER_STARTED) {
            this.bootConfiguration = factory;
            this.requiredState = InternalState.SERVER_STARTED;
            HostControllerLogger.ROOT_LOGGER.reconnectingServer(this.serverName);
            this.internalSetState(new ReconnectTask(), InternalState.STOPPED, InternalState.SEND_STDIN);
        }
    }

    synchronized void removeServerProcess() {
        this.requiredState = InternalState.STOPPED;
        this.internalSetState(new ProcessRemoveTask(), InternalState.STOPPED, InternalState.PROCESS_REMOVING);
    }

    synchronized void setServerProcessStopping() {
        this.requiredState = InternalState.STOPPED;
        this.internalSetState(null, InternalState.STOPPED, InternalState.PROCESS_STOPPING);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean awaitState(InternalState expected) {
        ManagedServer managedServer = this;
        synchronized (managedServer) {
            InternalState initialRequired = this.requiredState;
            InternalState required;
            while ((required = this.requiredState) != InternalState.FAILED) {
                if (initialRequired != required) {
                    return false;
                }
                InternalState current = this.internalState;
                if (expected == current) {
                    return true;
                }
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return false;
                }
            }
            return false;
        }
    }

    void processAdded() {
        this.finishTransition(InternalState.PROCESS_ADDING, InternalState.PROCESS_ADDED);
    }

    void processStarted() {
        this.finishTransition(InternalState.PROCESS_STARTING, InternalState.PROCESS_STARTED);
    }

    boolean processUnstable() {
        boolean change;
        boolean bl = change = !this.unstable;
        if (change) {
            this.unstable = true;
            HostControllerLogger.ROOT_LOGGER.managedServerUnstable(this.serverName);
        }
        return change;
    }

    synchronized TransactionalProtocolClient channelRegistered(ManagementChannelHandler channelAssociation) {
        InternalState current = this.internalState;
        channelAssociation.getAttachments().attach(TransactionalProtocolClient.SEND_IDENTITY, (Object)Boolean.TRUE);
        channelAssociation.getAttachments().attach(TransactionalProtocolClient.SEND_IN_VM, (Object)Boolean.TRUE);
        final TransactionalProtocolClient remoteClient = TransactionalProtocolHandlers.createClient((ManagementChannelHandler)channelAssociation);
        if (current == InternalState.RELOADING) {
            this.internalSetState(new TransitionTask(){

                @Override
                public boolean execute(ManagedServer server) throws Exception {
                    ManagedServer.this.protocolClient.connected(remoteClient);
                    ManagedServer.this.requiresReload = false;
                    return true;
                }
            }, InternalState.RELOADING, InternalState.SERVER_STARTING);
        } else {
            this.internalSetState(new TransitionTask(){

                @Override
                public boolean execute(ManagedServer server) throws Exception {
                    ManagedServer.this.protocolClient.connected(remoteClient);
                    return true;
                }
            }, InternalState.SEND_STDIN, InternalState.SERVER_STARTING);
        }
        return remoteClient;
    }

    synchronized void serverStarted(TransitionTask task) {
        this.internalSetState(task, InternalState.SERVER_STARTING, InternalState.SERVER_STARTED);
    }

    synchronized void serverStartFailed() {
        this.internalSetState(null, InternalState.SERVER_STARTING, InternalState.FAILED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean callbackUnregistered(TransactionalProtocolClient old, boolean shuttingDown) {
        this.protocolClient.disconnected(old);
        ManagedServer managedServer = this;
        synchronized (managedServer) {
            if (!shuttingDown && this.requiredState == InternalState.SERVER_STARTED) {
                InternalState state = this.internalState;
                if (state == InternalState.PROCESS_STOPPED || state == InternalState.PROCESS_STOPPING || state == InternalState.STOPPED) {
                    return true;
                }
                if (state == InternalState.RELOADING) {
                    return true;
                }
                try {
                    HostControllerLogger.ROOT_LOGGER.logf(DEBUG_LEVEL, "trying to reconnect to %s current-state (%s) required-state (%s)", this.serverName, (Object)state, (Object)this.requiredState);
                    this.internalSetState(new ReconnectTask(), state, InternalState.SEND_STDIN);
                }
                catch (Exception e) {
                    HostControllerLogger.ROOT_LOGGER.logf(DEBUG_LEVEL, e, "failed to send reconnect task", new Object[0]);
                }
                return false;
            }
            return true;
        }
    }

    synchronized void processFinished() {
        InternalState required = this.requiredState;
        InternalState state = this.internalState;
        if (required == InternalState.STOPPED && state == InternalState.PROCESS_STOPPING) {
            this.finishTransition(InternalState.PROCESS_STOPPING, InternalState.PROCESS_STOPPED);
        } else {
            this.requiredState = InternalState.STOPPED;
            if (!(this.internalSetState(this.getTransitionTask(InternalState.PROCESS_STOPPING), this.internalState, InternalState.PROCESS_STOPPING) && this.internalSetState(this.getTransitionTask(InternalState.PROCESS_REMOVING), this.internalState, InternalState.PROCESS_REMOVING) && this.internalSetState(this.getTransitionTask(InternalState.STOPPED), this.internalState, InternalState.STOPPED))) {
                this.requiredState = InternalState.FAILED;
                this.internalSetState(null, this.internalState, InternalState.PROCESS_STOPPED);
            }
        }
    }

    void processRemoved() {
        this.finishTransition(InternalState.PROCESS_REMOVING, InternalState.STOPPED);
        this.unstable = false;
    }

    private void transition() {
        this.transition(true);
    }

    private synchronized void transition(boolean checkAsync) {
        InternalState required = this.requiredState;
        InternalState current = this.internalState;
        if (checkAsync && current.isAsync()) {
            return;
        }
        InternalState next = ManagedServer.nextState(current, required);
        if (next != null) {
            TransitionTask task = this.getTransitionTask(next);
            this.internalSetState(task, current, next);
        }
    }

    synchronized void transitionFailed(InternalState state) {
        InternalState current = this.internalState;
        if (state == current) {
            switch (current) {
                case PROCESS_ADDING: {
                    this.internalState = InternalState.PROCESS_STOPPED;
                    break;
                }
                case PROCESS_STARTED: {
                    this.internalSetState(this.getTransitionTask(InternalState.PROCESS_STOPPING), InternalState.PROCESS_STARTED, InternalState.PROCESS_ADDED);
                    break;
                }
                case PROCESS_STARTING: {
                    this.internalState = InternalState.PROCESS_ADDED;
                    break;
                }
                case SEND_STDIN: 
                case SERVER_STARTING: {
                    this.internalState = InternalState.PROCESS_STARTED;
                }
            }
            this.requiredState = InternalState.FAILED;
            this.notifyAll();
        }
    }

    private synchronized void transitionFailed(InternalState state, Exception cause) {
        if (state == this.internalState) {
            switch (this.requiredState) {
                case SERVER_STARTED: 
                case PROCESS_ADDING: 
                case PROCESS_STARTED: 
                case PROCESS_STARTING: 
                case SERVER_STARTING: 
                case PROCESS_ADDED: {
                    HostControllerLogger.ROOT_LOGGER.failedToStartServer(cause, this.serverName);
                    break;
                }
                case STOPPED: 
                case PROCESS_REMOVING: 
                case PROCESS_STOPPED: 
                case PROCESS_STOPPING: {
                    HostControllerLogger.ROOT_LOGGER.failedToStopServer(cause, this.serverName);
                }
            }
        }
        this.transitionFailed(state);
    }

    private synchronized void finishTransition(InternalState current, InternalState next) {
        this.internalSetState(this.getTransitionTask(next), current, next);
        this.transition();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean internalSetState(TransitionTask task, InternalState current, InternalState next) {
        assert (Thread.holdsLock(this));
        InternalState internalState = this.internalState;
        HostControllerLogger.ROOT_LOGGER.logf(DEBUG_LEVEL, "changing server state (%s) from %s to %s", this.serverName, (Object)current, (Object)next);
        if (internalState == current) {
            try {
                if (task != null && !task.execute(this)) {
                    boolean bl = true;
                    return bl;
                }
                this.internalState = next;
                boolean bl = true;
                return bl;
            }
            catch (Exception e) {
                HostControllerLogger.ROOT_LOGGER.logf(DEBUG_LEVEL, e, "transition (%s > %s) failed for server \"%s\"", (Object)current, (Object)next, this.serverName);
                this.transitionFailed(current, e);
            }
            finally {
                this.notifyAll();
            }
        }
        return false;
    }

    private TransitionTask getTransitionTask(InternalState next) {
        switch (next) {
            case PROCESS_ADDING: {
                return new ProcessAddTask();
            }
            case PROCESS_STARTING: {
                return new ProcessStartTask();
            }
            case SEND_STDIN: {
                return new SendStdInTask();
            }
            case SERVER_STARTED: {
                return new ServerStartedTask();
            }
            case PROCESS_STOPPING: {
                return new ServerStopTask(null);
            }
            case PROCESS_REMOVING: {
                return new ProcessRemoveTask();
            }
        }
        return null;
    }

    private static InternalState nextState(InternalState state, InternalState required) {
        switch (state) {
            case STOPPED: {
                if (required != InternalState.SERVER_STARTED) break;
                return InternalState.PROCESS_ADDING;
            }
            case PROCESS_ADDING: {
                if (required != InternalState.SERVER_STARTED) break;
                return InternalState.PROCESS_ADDED;
            }
            case PROCESS_ADDED: {
                if (required == InternalState.SERVER_STARTED) {
                    return InternalState.PROCESS_STARTING;
                }
                if (required != InternalState.STOPPED) break;
                return InternalState.PROCESS_REMOVING;
            }
            case PROCESS_STARTING: {
                if (required != InternalState.SERVER_STARTED) break;
                return InternalState.PROCESS_STARTED;
            }
            case PROCESS_STARTED: {
                if (required == InternalState.SERVER_STARTED) {
                    return InternalState.SEND_STDIN;
                }
                if (required != InternalState.STOPPED) break;
                return InternalState.PROCESS_STOPPING;
            }
            case SEND_STDIN: {
                if (required == InternalState.SERVER_STARTED) {
                    return InternalState.SERVER_STARTING;
                }
                if (required != InternalState.STOPPED) break;
                return InternalState.PROCESS_STOPPING;
            }
            case SERVER_STARTING: {
                if (required == InternalState.SERVER_STARTED) {
                    return InternalState.SERVER_STARTED;
                }
                if (required != InternalState.STOPPED) break;
                return InternalState.PROCESS_STOPPING;
            }
            case SERVER_STARTED: {
                if (required != InternalState.STOPPED) break;
                return InternalState.PROCESS_STOPPING;
            }
            case RELOADING: {
                if (required == InternalState.SERVER_STARTED) {
                    return InternalState.SERVER_STARTED;
                }
                if (required != InternalState.STOPPED) break;
                return InternalState.PROCESS_STOPPING;
            }
            case PROCESS_STOPPING: {
                if (required != InternalState.STOPPED) break;
                return InternalState.PROCESS_STOPPED;
            }
            case PROCESS_STOPPED: {
                if (required == InternalState.SERVER_STARTED) {
                    return InternalState.PROCESS_STARTING;
                }
                if (required != InternalState.STOPPED) break;
                return InternalState.PROCESS_REMOVING;
            }
            case PROCESS_REMOVING: {
                if (required != InternalState.STOPPED) break;
                return InternalState.STOPPED;
            }
            default: {
                return null;
            }
        }
        return null;
    }

    AsyncFuture<OperationResponse> resume(BlockingQueueOperationListener<TransactionalProtocolClient.Operation> listener) throws IOException {
        ModelNode operation = new ModelNode();
        operation.get("operation").set("resume");
        operation.get("address").setEmptyList();
        return this.protocolClient.execute((TransactionalProtocolClient.TransactionalOperationListener<TransactionalProtocolClient.Operation>)listener, operation, OperationMessageHandler.DISCARD, OperationAttachments.EMPTY);
    }

    AsyncFuture<OperationResponse> suspend(int timeoutInSeconds, BlockingQueueOperationListener<TransactionalProtocolClient.Operation> listener) throws IOException {
        ModelNode operation = new ModelNode();
        operation.get("operation").set("suspend");
        operation.get("address").setEmptyList();
        operation.get("suspend-timeout").set(timeoutInSeconds);
        return this.protocolClient.execute((TransactionalProtocolClient.TransactionalOperationListener<TransactionalProtocolClient.Operation>)listener, operation, OperationMessageHandler.DISCARD, OperationAttachments.EMPTY);
    }

    private AsyncFuture<OperationResponse> shutdown(int timeoutInSeconds, BlockingQueueOperationListener<TransactionalProtocolClient.Operation> listener) throws IOException {
        ModelNode operation = new ModelNode();
        operation.get("operation").set("shutdown");
        operation.get("address").setEmptyList();
        operation.get("suspend-timeout").set(timeoutInSeconds);
        return this.protocolClient.execute((TransactionalProtocolClient.TransactionalOperationListener<TransactionalProtocolClient.Operation>)listener, operation, OperationMessageHandler.DISCARD, OperationAttachments.EMPTY);
    }

    PathAddress getAddress() {
        return this.address;
    }

    static {
        ClassLoader cl = ManagedServer.class.getClassLoader();
        MarshallingConfiguration config = new MarshallingConfiguration();
        config.setVersion(2);
        config.setClassResolver((ClassResolver)new SimpleClassResolver(cl));
        CONFIG = config;
    }

    static enum InternalState {
        STOPPED,
        PROCESS_ADDING(true),
        PROCESS_ADDED,
        PROCESS_STARTING(true),
        PROCESS_STARTED,
        SEND_STDIN(true),
        SERVER_STARTING(true),
        SERVER_STARTED,
        RELOADING(true),
        PROCESS_STOPPING(true),
        PROCESS_STOPPED,
        PROCESS_REMOVING(true),
        SUSPENDING(true),
        FAILED;

        private final boolean async;

        private InternalState() {
            this(false);
        }

        private InternalState(boolean async) {
            this.async = async;
        }

        boolean isAsync() {
            return this.async;
        }
    }

    private class ReloadTask
    implements TransitionTask {
        private final int permit;
        private final boolean suspend;

        private ReloadTask(int permit, boolean suspend) {
            this.permit = permit;
            this.suspend = suspend;
        }

        @Override
        public boolean execute(ManagedServer server) throws Exception {
            ModelNode operation = new ModelNode();
            operation.get("operation").set("reload");
            operation.get("address").setEmptyList();
            if (this.suspend) {
                operation.get("start-mode").set("suspend");
            }
            operation.get("operation-id").set(this.permit);
            try {
                TransactionalProtocolClient.PreparedOperation prepared = TransactionalProtocolHandlers.executeBlocking((ModelNode)operation, (TransactionalProtocolClient)ManagedServer.this.protocolClient);
                if (prepared.isFailed()) {
                    return false;
                }
                prepared.commit();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return true;
        }
    }

    @FunctionalInterface
    static interface TransitionTask {
        public boolean execute(ManagedServer var1) throws Exception;
    }

    private class ServerStopTask
    implements TransitionTask {
        private final Integer gracefulTimeout;

        private ServerStopTask(Integer gracefulTimeout) {
            this.gracefulTimeout = gracefulTimeout;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        @Override
        public boolean execute(ManagedServer server) throws Exception {
            block24: {
                assert (Thread.holdsLock(ManagedServer.this));
                try {
                    TransactionalProtocolClient.PreparedOperation prepared;
                    AsyncFuture<OperationResponse> future;
                    block25: {
                        if (this.gracefulTimeout == null) break block24;
                        BlockingQueueOperationListener listener = new BlockingQueueOperationListener();
                        future = null;
                        future = ManagedServer.this.shutdown(this.gracefulTimeout, (BlockingQueueOperationListener<TransactionalProtocolClient.Operation>)listener);
                        prepared = listener.retrievePreparedOperation();
                        if (!prepared.isFailed()) break block25;
                        boolean bl = false;
                        return bl;
                    }
                    try {
                        prepared.commit();
                        prepared.getFinalResult().get();
                    }
                    catch (IOException e) {
                        HostControllerLogger.ROOT_LOGGER.suspendExecutionFailed(e, ManagedServer.this.serverName);
                        boolean bl = false;
                        try {
                            ManagedServer.this.processControllerClient.stopProcess(ManagedServer.this.serverProcessName);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        return bl;
                    }
                    catch (InterruptedException e) {
                        HostControllerLogger.ROOT_LOGGER.interruptedAwaitingSuspendResponse(e, ManagedServer.this.serverName);
                        future.asyncCancel(true);
                        Thread.currentThread().interrupt();
                        boolean bl = false;
                        try {
                            ManagedServer.this.processControllerClient.stopProcess(ManagedServer.this.serverProcessName);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        return bl;
                    }
                    catch (ExecutionException e) {
                        HostControllerLogger.ROOT_LOGGER.suspendListenerFailed(e, ManagedServer.this.serverName);
                        future.asyncCancel(true);
                        boolean bl = false;
                        {
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                        }
                        try {
                            ManagedServer.this.processControllerClient.stopProcess(ManagedServer.this.serverProcessName);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        return bl;
                    }
                }
                finally {
                    try {
                        ManagedServer.this.processControllerClient.stopProcess(ManagedServer.this.serverProcessName);
                    }
                    catch (IOException iOException) {}
                }
            }
            return true;
        }
    }

    private class ReconnectTask
    implements TransitionTask {
        private ReconnectTask() {
        }

        @Override
        public boolean execute(ManagedServer server) throws Exception {
            assert (Thread.holdsLock(ManagedServer.this));
            ManagedServer.this.processControllerClient.reconnectServerProcess(ManagedServer.this.serverProcessName, ManagedServer.this.managementURI, ManagedServer.this.bootConfiguration.isManagementSubsystemEndpoint(), ManagedServer.this.getAuthToken());
            return true;
        }
    }

    private class ProcessRemoveTask
    implements TransitionTask {
        private ProcessRemoveTask() {
        }

        @Override
        public boolean execute(ManagedServer server) throws Exception {
            assert (Thread.holdsLock(ManagedServer.this));
            ManagedServer.this.processControllerClient.removeProcess(ManagedServer.this.serverProcessName);
            return true;
        }
    }

    private class ProcessAddTask
    implements TransitionTask {
        private ProcessAddTask() {
        }

        @Override
        public boolean execute(ManagedServer server) throws Exception {
            assert (Thread.holdsLock(ManagedServer.this));
            List<String> command = ManagedServer.this.bootConfiguration.getServerLaunchCommand();
            Map<String, String> env = ManagedServer.this.bootConfiguration.getServerLaunchEnvironment();
            HostControllerEnvironment environment = ManagedServer.this.bootConfiguration.getHostControllerEnvironment();
            int processId = ManagedServer.this.bootConfiguration.getServerProcessId();
            ManagedServer.this.processControllerClient.addProcess(ManagedServer.this.serverProcessName, processId, command.toArray(new String[command.size()]), environment.getHomeDir().getAbsolutePath(), env);
            return true;
        }
    }

    private class ProcessStartTask
    implements TransitionTask {
        private ProcessStartTask() {
        }

        @Override
        public boolean execute(ManagedServer server) throws Exception {
            assert (Thread.holdsLock(ManagedServer.this));
            ManagedServer.this.processControllerClient.startProcess(ManagedServer.this.serverProcessName);
            return true;
        }
    }

    private class SendStdInTask
    implements TransitionTask {
        private SendStdInTask() {
        }

        @Override
        public boolean execute(ManagedServer server) throws Exception {
            assert (Thread.holdsLock(ManagedServer.this));
            List bootUpdates = Collections.emptyList();
            Map<String, String> launchProperties = ManagedServer.this.bootConfiguration.getServerLaunchProperties();
            boolean useSubsystemEndpoint = ManagedServer.this.bootConfiguration.isManagementSubsystemEndpoint();
            ModelNode endpointConfig = ManagedServer.this.bootConfiguration.getSubsystemEndpointConfiguration();
            ServiceActivator hostControllerCommActivator = DomainServerCommunicationServices.create((ModelNode)endpointConfig, (URI)ManagedServer.this.managementURI, (String)ManagedServer.this.serverName, (String)ManagedServer.this.serverProcessName, (String)ManagedServer.this.getAuthToken(), (boolean)useSubsystemEndpoint, ManagedServer.this.bootConfiguration.getSSLContextSupplier());
            ServerStartTask startTask = new ServerStartTask(ManagedServer.this.hostControllerName, ManagedServer.this.serverName, 0, ManagedServer.this.operationID, Collections.singletonList(hostControllerCommActivator), bootUpdates, launchProperties, ManagedServer.this.bootConfiguration.isSuspended(), ManagedServer.this.bootConfiguration.isGracefulStartup());
            Marshaller marshaller = MARSHALLER_FACTORY.createMarshaller(CONFIG);
            OutputStream os = ManagedServer.this.processControllerClient.sendStdin(ManagedServer.this.serverProcessName);
            marshaller.start(Marshalling.createByteOutput((OutputStream)os));
            marshaller.writeObject((Object)startTask);
            marshaller.finish();
            marshaller.close();
            os.close();
            return true;
        }
    }

    private class ServerStartedTask
    implements TransitionTask {
        private ServerStartedTask() {
        }

        @Override
        public boolean execute(ManagedServer server) throws Exception {
            return true;
        }
    }
}

