/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.operations.deployment;

import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ProcessType;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.domain.controller.logging.DomainControllerLogger;
import org.jboss.as.domain.controller.operations.deployment.DeploymentUploadUtil;
import org.jboss.as.repository.ContentRepository;
import org.jboss.as.repository.ExplodedContentException;
import org.jboss.as.repository.HostFileRepository;
import org.jboss.as.server.controller.resources.DeploymentAttributes;
import org.jboss.as.server.deployment.DeploymentHandlerUtil;
import org.jboss.as.server.deployment.ModelContentReference;
import org.jboss.dmr.ModelNode;

public class DeploymentExplodeHandler
implements OperationStepHandler {
    private final ContentRepository contentRepository;
    private final HostFileRepository fileRepository;
    private final boolean backup;

    public DeploymentExplodeHandler(boolean backup, HostFileRepository fileRepository, ContentRepository contentRepository) {
        this.contentRepository = contentRepository;
        this.fileRepository = fileRepository;
        this.backup = backup;
    }

    public DeploymentExplodeHandler(ContentRepository contentRepository) {
        this.contentRepository = contentRepository;
        this.fileRepository = null;
        this.backup = false;
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        byte[] newHash;
        if (context.getProcessType() == ProcessType.SELF_CONTAINED) {
            throw DomainControllerLogger.ROOT_LOGGER.cannotExplodeDeploymentOfSelfContainedServer();
        }
        ModelNode explodedPath = DeploymentAttributes.DEPLOYMENT_CONTENT_PATH.resolveModelAttribute(context, operation);
        Resource deploymentResource = context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS);
        ModelNode contentItem = DeploymentHandlerUtil.getContentItem((Resource)deploymentResource);
        if (!DeploymentHandlerUtil.isManaged((ModelNode)contentItem)) {
            throw DomainControllerLogger.ROOT_LOGGER.cannotExplodeUnmanagedDeployment();
        }
        if (!DeploymentHandlerUtil.isArchive((ModelNode)contentItem) && !explodedPath.isDefined()) {
            throw DomainControllerLogger.ROOT_LOGGER.cannotExplodeAlreadyExplodedDeployment();
        }
        if (DeploymentHandlerUtil.isArchive((ModelNode)contentItem) && explodedPath.isDefined()) {
            throw DomainControllerLogger.ROOT_LOGGER.cannotExplodeSubDeploymentOfUnexplodedDeployment();
        }
        final PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
        ModelNode deploymentModel = deploymentResource.getModel();
        boolean enabled = DeploymentAttributes.ENABLED.resolveModelAttribute(context, deploymentModel).asBoolean();
        if (enabled) {
            throw DomainControllerLogger.ROOT_LOGGER.cannotExplodeEnabledDeployment();
        }
        final byte[] oldHash = DeploymentAttributes.CONTENT_HASH.resolveModelAttribute(context, contentItem).asBytes();
        if (this.fileRepository == null && this.contentRepository != null) {
            try {
                newHash = DeploymentUploadUtil.explodeContentAndTransformOperation(context, operation, this.contentRepository);
            }
            catch (ExplodedContentException e) {
                throw new OperationFailedException((Throwable)e);
            }
        } else {
            newHash = DeploymentUploadUtil.synchronizeSlaveHostController(operation, address, this.fileRepository, this.contentRepository, this.backup, oldHash);
        }
        if (newHash != null) {
            contentItem = new ModelNode();
            contentItem.get("hash").set(newHash);
            contentItem.get("archive").set(false);
            ModelNode content = new ModelNode();
            content.add(contentItem);
            deploymentModel.get("content").set(content);
            if (this.contentRepository != null) {
                context.completeStep(new OperationContext.ResultHandler(){

                    public void handleResult(OperationContext.ResultAction resultAction, OperationContext context, ModelNode operation) {
                        if (resultAction == OperationContext.ResultAction.KEEP) {
                            if (oldHash != null && DeploymentExplodeHandler.this.contentRepository.hasContent(oldHash)) {
                                DeploymentExplodeHandler.this.contentRepository.removeContent(ModelContentReference.fromModelAddress((PathAddress)address, (byte[])oldHash));
                            }
                            if (DeploymentExplodeHandler.this.contentRepository.hasContent(newHash)) {
                                DeploymentExplodeHandler.this.contentRepository.addContentReference(ModelContentReference.fromModelAddress((PathAddress)context.getCurrentAddress(), (byte[])newHash));
                            }
                        }
                    }
                });
            }
        }
    }
}

