/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.operations;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleOperationDefinition;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.access.management.SensitiveTargetAccessConstraintDefinition;
import org.jboss.as.controller.descriptions.common.ControllerResolver;
import org.jboss.as.controller.operations.common.OrderedChildTypesAttachment;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.domain.controller.operations.PathAddressFilter;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class GenericModelDescribeOperationHandler
implements OperationStepHandler {
    public static final GenericModelDescribeOperationHandler INSTANCE = new GenericModelDescribeOperationHandler("describe-model", false);
    public static final SimpleOperationDefinition DEFINITION = new SimpleOperationDefinitionBuilder("describe-model", ControllerResolver.getResolver((String[])new String[]{"subsystem"})).addAccessConstraint((AccessConstraintDefinition)SensitiveTargetAccessConstraintDefinition.READ_WHOLE_CONFIG).setReplyType(ModelType.LIST).setReplyValueType(ModelType.OBJECT).setPrivateEntry().build();
    private static final Set<String> ROOT_ATTRIBUTES = new HashSet<String>(Arrays.asList("domain-organization"));
    private final String operationName;
    private final boolean skipLocalAdd;

    protected GenericModelDescribeOperationHandler(String operationName, boolean skipAdd) {
        this.operationName = operationName;
        this.skipLocalAdd = skipAdd;
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        final PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
        PathAddressFilter filter = (PathAddressFilter)context.getAttachment(PathAddressFilter.KEY);
        if (filter != null && !filter.accepts(address)) {
            return;
        }
        ImmutableManagementResourceRegistration registration = context.getResourceRegistration();
        if (registration.isAlias() || registration.isRemote() || registration.isRuntimeOnly()) {
            return;
        }
        final Resource resource = context.readResource(PathAddress.EMPTY_ADDRESS, false);
        final ModelNode result = context.getResult();
        result.setEmptyList();
        final ModelNode results = new ModelNode().setEmptyList();
        final AtomicReference failureRef = new AtomicReference();
        final HashMap<String, ModelNode> includeResults = new HashMap<String, ModelNode>();
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                boolean failed = false;
                if (failureRef.get() != null) {
                    context.getFailureDescription().set((ModelNode)failureRef.get());
                    failed = true;
                } else {
                    for (ModelNode includeRsp : includeResults.values()) {
                        if (includeRsp.hasDefined("failure-description")) {
                            context.getFailureDescription().set(includeRsp.get("failure-description"));
                            failed = true;
                            break;
                        }
                        ModelNode includeResult = includeRsp.get("result");
                        if (!includeResult.isDefined()) continue;
                        for (ModelNode op : includeResult.asList()) {
                            GenericModelDescribeOperationHandler.this.addOrderedChildTypeInfo(context, resource, op);
                            result.add(op);
                        }
                    }
                }
                if (!failed) {
                    for (ModelNode childRsp : results.asList()) {
                        GenericModelDescribeOperationHandler.this.addOrderedChildTypeInfo(context, resource, childRsp);
                        result.add(childRsp);
                    }
                    context.getResult().set(result);
                }
            }
        }, OperationContext.Stage.MODEL, true);
        Set children = resource.getChildTypes();
        for (String childType : children) {
            for (Resource.ResourceEntry entry : resource.getChildren(childType)) {
                PathElement childPE = entry.getPathElement();
                PathAddress relativeChildAddress = PathAddress.EMPTY_ADDRESS.append(new PathElement[]{childPE});
                ImmutableManagementResourceRegistration childRegistration = registration.getSubModel(relativeChildAddress);
                if (childRegistration.isRuntimeOnly() || childRegistration.isRemote() || childRegistration.isAlias()) continue;
                PathAddress absoluteChildAddr = address.append(new PathElement[]{childPE});
                if (filter != null && !filter.accepts(absoluteChildAddr)) continue;
                OperationStepHandler stepHandler = childRegistration.getOperationHandler(PathAddress.EMPTY_ADDRESS, this.operationName);
                final ModelNode childRsp = new ModelNode();
                context.addStep(new OperationStepHandler(){

                    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                        if (failureRef.get() == null) {
                            if (childRsp.hasDefined("failure-description")) {
                                failureRef.set(childRsp.get("failure-description"));
                            } else if (childRsp.hasDefined("result")) {
                                GenericModelDescribeOperationHandler.this.addChildOperation(address, childRsp.require("result").asList(), results);
                            }
                        }
                    }
                }, OperationContext.Stage.MODEL, true);
                ModelNode childOperation = operation.clone();
                childOperation.get("operation").set(this.operationName);
                childOperation.get("address").set(absoluteChildAddr.toModelNode());
                context.addStep(childRsp, childOperation, stepHandler, OperationContext.Stage.MODEL, true);
            }
        }
        if (resource.isProxy() || resource.isRuntime()) {
            return;
        }
        ModelNode model = resource.getModel();
        OperationStepHandler addHandler = registration.getOperationHandler(PathAddress.EMPTY_ADDRESS, "add");
        if (addHandler != null) {
            ModelNode add = new ModelNode();
            add.get("operation").set("add");
            add.get("address").set(address.toModelNode());
            Set attributes = registration.getAttributeNames(PathAddress.EMPTY_ADDRESS);
            for (String attribute : attributes) {
                AttributeAccess attributeAccess;
                if (!model.hasDefined(attribute) || (attributeAccess = registration.getAttributeAccess(PathAddress.EMPTY_ADDRESS, attribute)).getStorageType() != AttributeAccess.Storage.CONFIGURATION) continue;
                add.get(attribute).set(model.get(attribute));
            }
            this.processMore(context, operation, resource, address, includeResults);
            if (!this.skipLocalAdd) {
                this.addOrderedChildTypeInfo(context, resource, add);
                result.add(add);
            }
        } else {
            Set attributes = registration.getAttributeNames(PathAddress.EMPTY_ADDRESS);
            for (String attribute : attributes) {
                AttributeAccess attributeAccess;
                if (!model.hasDefined(attribute) || address.size() == 0 && !ROOT_ATTRIBUTES.contains(attribute) || (attributeAccess = registration.getAttributeAccess(PathAddress.EMPTY_ADDRESS, attribute)).getStorageType() != AttributeAccess.Storage.CONFIGURATION) continue;
                ModelNode writeAttribute = new ModelNode();
                writeAttribute.get("operation").set("write-attribute");
                writeAttribute.get("address").set(address.toModelNode());
                writeAttribute.get("name").set(attribute);
                writeAttribute.get("value").set(model.get(attribute));
                this.addOrderedChildTypeInfo(context, resource, writeAttribute);
                result.add(writeAttribute);
            }
        }
    }

    private void addOrderedChildTypeInfo(OperationContext context, Resource resource, ModelNode operation) {
        OrderedChildTypesAttachment attachment = (OrderedChildTypesAttachment)context.getAttachment(OrderedChildTypesAttachment.KEY);
        if (attachment != null) {
            attachment.addOrderedChildResourceTypes(PathAddress.pathAddress((ModelNode)operation.get("address")), resource);
        }
    }

    protected void addChildOperation(PathAddress parent, List<ModelNode> operations, ModelNode results) {
        for (ModelNode operation : operations) {
            results.add(operation);
        }
    }

    protected void processMore(OperationContext context, ModelNode operation, Resource resource, PathAddress address, Map<String, ModelNode> includeResults) throws OperationFailedException {
    }
}

