/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.operations;

import java.util.ArrayList;
import java.util.List;
import org.jboss.as.controller.ControlledProcessState;
import org.jboss.as.domain.controller.LocalHostControllerInfo;
import org.jboss.as.host.controller.HostControllerEnvironment;
import org.jboss.as.host.controller.discovery.DiscoveryOption;
import org.jboss.as.host.controller.model.host.AdminOnlyDomainConfigPolicy;

public class LocalHostControllerInfoImpl
implements LocalHostControllerInfo {
    private final ControlledProcessState processState;
    private final HostControllerEnvironment hostEnvironment;
    private final String localHostName;
    private volatile boolean master;
    private volatile String nativeManagementInterface;
    private volatile int nativeManagementPort;
    private volatile String remoteDCUser;
    private volatile String remoteSecurityRealm;
    private volatile List<DiscoveryOption> remoteDiscoveryOptions = new ArrayList<DiscoveryOption>();
    private volatile boolean remoteIgnoreUnaffectedConfiguration;
    private volatile String httpManagementInterface;
    private volatile int httpManagementPort;
    private volatile String httpManagementSecureInterface;
    private volatile int httpManagementSecurePort;
    private volatile AdminOnlyDomainConfigPolicy adminOnlyDomainConfigPolicy = AdminOnlyDomainConfigPolicy.ALLOW_NO_CONFIG;

    public LocalHostControllerInfoImpl(ControlledProcessState processState, String localHostName) {
        this.processState = processState;
        this.hostEnvironment = null;
        this.localHostName = localHostName;
    }

    public LocalHostControllerInfoImpl(ControlledProcessState processState, HostControllerEnvironment hostEnvironment) {
        this.processState = processState;
        this.hostEnvironment = hostEnvironment;
        this.localHostName = null;
    }

    @Override
    public String getLocalHostName() {
        return this.hostEnvironment == null ? this.localHostName : this.hostEnvironment.getHostControllerName();
    }

    @Override
    public ControlledProcessState.State getProcessState() {
        return this.processState.getState();
    }

    @Override
    public boolean isMasterDomainController() {
        return this.master;
    }

    @Override
    public String getNativeManagementInterface() {
        return this.nativeManagementInterface;
    }

    @Override
    public int getNativeManagementPort() {
        return this.nativeManagementPort;
    }

    @Override
    public String getHttpManagementInterface() {
        return this.httpManagementInterface;
    }

    @Override
    public int getHttpManagementPort() {
        return this.httpManagementPort;
    }

    @Override
    public String getHttpManagementSecureInterface() {
        return this.httpManagementSecureInterface == null ? this.httpManagementInterface : this.httpManagementSecureInterface;
    }

    @Override
    public int getHttpManagementSecurePort() {
        return this.httpManagementSecurePort;
    }

    @Override
    public String getRemoteDomainControllerUsername() {
        return this.remoteDCUser;
    }

    public String getRemoteDomainControllerSecurityRealm() {
        return this.remoteSecurityRealm;
    }

    @Override
    public List<DiscoveryOption> getRemoteDomainControllerDiscoveryOptions() {
        return this.remoteDiscoveryOptions;
    }

    @Override
    public boolean isRemoteDomainControllerIgnoreUnaffectedConfiguration() {
        return this.remoteIgnoreUnaffectedConfiguration;
    }

    @Override
    public boolean isBackupDc() {
        return this.hostEnvironment == null ? false : this.hostEnvironment.isBackupDomainFiles();
    }

    @Override
    public boolean isUsingCachedDc() {
        return this.hostEnvironment == null ? false : this.hostEnvironment.isUseCachedDc();
    }

    public AdminOnlyDomainConfigPolicy getAdminOnlyDomainConfigPolicy() {
        return this.adminOnlyDomainConfigPolicy;
    }

    void setAdminOnlyDomainConfigPolicy(AdminOnlyDomainConfigPolicy adminOnlyDomainConfigPolicy) {
        this.adminOnlyDomainConfigPolicy = adminOnlyDomainConfigPolicy;
    }

    void setMasterDomainController(boolean master) {
        this.master = master;
    }

    void setNativeManagementInterface(String nativeManagementInterface) {
        this.nativeManagementInterface = nativeManagementInterface;
    }

    void setNativeManagementPort(int nativeManagementPort) {
        this.nativeManagementPort = nativeManagementPort;
    }

    void setHttpManagementInterface(String httpManagementInterface) {
        this.httpManagementInterface = httpManagementInterface;
    }

    void setHttpManagementPort(int httpManagementPort) {
        this.httpManagementPort = httpManagementPort;
    }

    void setHttpManagementSecureInterface(String httpManagementSecureInterface) {
        this.httpManagementSecureInterface = httpManagementSecureInterface;
    }

    void setHttpManagementSecurePort(int httpManagementSecurePort) {
        this.httpManagementSecurePort = httpManagementSecurePort;
    }

    void setRemoteDomainControllerUsername(String userName) {
        this.remoteDCUser = userName;
    }

    void setRemoteDomainControllerSecurityRealm(String remoteSecurityRealm) {
        this.remoteSecurityRealm = remoteSecurityRealm;
    }

    void addRemoteDomainControllerDiscoveryOption(DiscoveryOption discoveryOption) {
        this.remoteDiscoveryOptions.add(discoveryOption);
    }

    void setRemoteDomainControllerIgnoreUnaffectedConfiguration(boolean ignore) {
        this.remoteIgnoreUnaffectedConfiguration = ignore;
    }
}

