/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.operations.coordination;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jboss.as.controller.BlockingTimeout;
import org.jboss.as.controller.CurrentOperationIdHolder;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.ProxyController;
import org.jboss.as.controller.TransformingProxyController;
import org.jboss.as.controller.client.OperationResponse;
import org.jboss.as.controller.operations.DomainOperationTransformer;
import org.jboss.as.controller.operations.OperationAttachments;
import org.jboss.as.controller.remote.ResponseAttachmentInputStreamSupport;
import org.jboss.as.controller.remote.TransactionalProtocolClient;
import org.jboss.as.controller.transform.Transformers;
import org.jboss.as.domain.controller.logging.DomainControllerLogger;
import org.jboss.as.domain.controller.operations.coordination.HostControllerUpdateTask;
import org.jboss.as.domain.controller.operations.coordination.MultiphaseOverallContext;
import org.jboss.dmr.ModelNode;
import org.jboss.threads.AsyncFuture;

public class DomainSlaveHandler
implements OperationStepHandler {
    private final MultiphaseOverallContext multiphaseContext;
    private final Map<String, ProxyController> hostProxies;

    public DomainSlaveHandler(Map<String, ProxyController> hostProxies, MultiphaseOverallContext domainOperationContext) {
        this.hostProxies = hostProxies;
        this.multiphaseContext = domainOperationContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        if (context.hasFailureDescription()) {
            context.setRollbackOnly();
            return;
        }
        final BlockingTimeout blockingTimeout = BlockingTimeout.Factory.getDomainBlockingTimeout((OperationContext)context);
        HashSet<String> outstanding = new HashSet<String>(this.hostProxies.keySet());
        final ArrayList<TransactionalProtocolClient.PreparedOperation<HostControllerUpdateTask.ProxyOperation>> results = new ArrayList<TransactionalProtocolClient.PreparedOperation<HostControllerUpdateTask.ProxyOperation>>();
        final HashMap<String, HostControllerUpdateTask.ExecutedHostRequest> finalResults = new HashMap<String, HostControllerUpdateTask.ExecutedHostRequest>();
        HostControllerUpdateTask.ProxyOperationListener listener = new HostControllerUpdateTask.ProxyOperationListener();
        Transformers.TransformationInputs transformationInputs = Transformers.TransformationInputs.getOrCreate((OperationContext)context);
        for (Map.Entry<String, ProxyController> entry : this.hostProxies.entrySet()) {
            String host = entry.getKey();
            TransformingProxyController proxyController = (TransformingProxyController)entry.getValue();
            List transformers = (List)context.getAttachment(OperationAttachments.SLAVE_SERVER_OPERATION_TRANSFORMERS);
            ModelNode op = operation;
            if (transformers != null) {
                for (DomainOperationTransformer transformer : transformers) {
                    op = transformer.transform(context, op);
                    op.get(new String[]{"operation-headers", "execute-for-coordinator"}).set(true);
                }
            }
            ModelNode clonedOp = op.clone();
            clonedOp.get(new String[]{"operation-headers", "domain-controller-lock-id"}).set(CurrentOperationIdHolder.getCurrentOperationID().intValue());
            HostControllerUpdateTask task = new HostControllerUpdateTask(host, clonedOp, context, proxyController, transformationInputs);
            HostControllerUpdateTask.ExecutedHostRequest finalResult = task.execute(listener);
            this.multiphaseContext.recordHostRequest(host, finalResult);
            finalResults.put(host, finalResult);
        }
        boolean interrupted = false;
        boolean completeStepCalled = false;
        try {
            long timeout = 0L;
            while (outstanding.size() > 0) {
                timeout = blockingTimeout.getDomainBlockingTimeout(false);
                TransactionalProtocolClient.PreparedOperation prepared = null;
                try {
                    prepared = listener.retrievePreparedOperation(timeout, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException ie) {
                    interrupted = true;
                }
                if (prepared != null) {
                    String hostName = ((HostControllerUpdateTask.ProxyOperation)prepared.getOperation()).getName();
                    if (!outstanding.remove(hostName)) continue;
                    ModelNode preparedResult = prepared.getPreparedResult();
                    DomainControllerLogger.HOST_CONTROLLER_LOGGER.tracef("Preliminary result for remote host %s is %s", hostName, preparedResult);
                    HostControllerUpdateTask.ExecutedHostRequest request = (HostControllerUpdateTask.ExecutedHostRequest)finalResults.get(hostName);
                    boolean reject = request.rejectOperation(preparedResult);
                    if (reject) {
                        if (DomainControllerLogger.HOST_CONTROLLER_LOGGER.isDebugEnabled()) {
                            DomainControllerLogger.HOST_CONTROLLER_LOGGER.debugf("Rejecting result for remote host %s is %s", hostName, preparedResult);
                        }
                        ModelNode failedResult = new ModelNode();
                        failedResult.get("outcome").set("failed");
                        failedResult.get("failure-description").set(request.getFailureDescription());
                        this.multiphaseContext.addHostControllerPreparedResult(hostName, failedResult);
                    } else {
                        this.multiphaseContext.addHostControllerPreparedResult(hostName, preparedResult);
                    }
                    results.add((TransactionalProtocolClient.PreparedOperation<HostControllerUpdateTask.ProxyOperation>)prepared);
                    continue;
                }
                this.handleMissingHostResponses(finalResults, outstanding, !interrupted, timeout);
                break;
            }
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
            context.completeStep(new OperationContext.ResultHandler(){

                public void handleResult(OperationContext.ResultAction resultAction, OperationContext context, ModelNode operation) {
                    DomainSlaveHandler.this.finalizeOp(results, finalResults, false, context, blockingTimeout);
                }
            });
            completeStepCalled = true;
        }
        finally {
            if (!completeStepCalled) {
                this.finalizeOp(results, finalResults, interrupted, context, blockingTimeout);
            }
        }
    }

    private void handleMissingHostResponses(Map<String, HostControllerUpdateTask.ExecutedHostRequest> finalResults, Set<String> outstanding, boolean timedOut, long timeout) {
        this.multiphaseContext.setFailureReported(true);
        if (timedOut) {
            DomainControllerLogger.HOST_CONTROLLER_LOGGER.timedOutAwaitingHostPreparedResponses(timeout, outstanding, finalResults.keySet());
        } else {
            DomainControllerLogger.HOST_CONTROLLER_LOGGER.interruptedAwaitingHostPreparedResponse(finalResults.keySet());
        }
        for (HostControllerUpdateTask.ExecutedHostRequest finalResult : finalResults.values()) {
            finalResult.asyncCancel();
        }
        for (String hostName : outstanding) {
            ModelNode failureResponse;
            if (timedOut) {
                failureResponse = DomainSlaveHandler.getTimeoutResponse(timeout, hostName);
                finalResults.put(hostName, finalResults.get(hostName).toFailedRequest(failureResponse));
            } else {
                failureResponse = DomainSlaveHandler.getInterruptedResponse(hostName);
            }
            this.multiphaseContext.addHostControllerPreparedResult(hostName, failureResponse);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finalizeOp(List<TransactionalProtocolClient.PreparedOperation<HostControllerUpdateTask.ProxyOperation>> results, Map<String, HostControllerUpdateTask.ExecutedHostRequest> finalResults, boolean interrupted, OperationContext context, BlockingTimeout blockingTimeout) {
        boolean interruptThread = Thread.interrupted() || interrupted;
        try {
            boolean rollback = this.multiphaseContext.isCompleteRollback();
            for (TransactionalProtocolClient.PreparedOperation<HostControllerUpdateTask.ProxyOperation> prepared : results) {
                boolean bl = interruptThread = Thread.interrupted() || interruptThread;
                if (prepared.isDone()) continue;
                if (!rollback) {
                    prepared.commit();
                    continue;
                }
                prepared.rollback();
            }
            int patient = interruptThread ? 50 : blockingTimeout.getDomainBlockingTimeout(false);
            for (TransactionalProtocolClient.PreparedOperation<HostControllerUpdateTask.ProxyOperation> prepared : results) {
                String hostName = ((HostControllerUpdateTask.ProxyOperation)prepared.getOperation()).getName();
                HostControllerUpdateTask.ExecutedHostRequest request = finalResults.get(hostName);
                AsyncFuture future = prepared.getFinalResult();
                try {
                    OperationResponse finalResponse = (OperationResponse)future.get((long)patient, TimeUnit.MILLISECONDS);
                    ModelNode transformedResult = request.transformResult(finalResponse.getResponseNode());
                    this.multiphaseContext.addHostControllerFinalResult(hostName, transformedResult);
                    ResponseAttachmentInputStreamSupport.handleDomainOperationResponseStreams((OperationContext)context, (ModelNode)transformedResult, (List)finalResponse.getInputStreams());
                    DomainControllerLogger.HOST_CONTROLLER_LOGGER.tracef("Final result for remote host %s is %s", hostName, finalResponse.getResponseNode());
                    DomainControllerLogger.HOST_CONTROLLER_LOGGER.tracef("Transformed result from host %s is %s", hostName, transformedResult);
                }
                catch (InterruptedException e) {
                    interruptThread = true;
                    future.asyncCancel(true);
                    patient = patient == 0 ? 0 : 50;
                    DomainControllerLogger.HOST_CONTROLLER_LOGGER.interruptedAwaitingFinalResponse(hostName);
                }
                catch (ExecutionException e) {
                    DomainControllerLogger.HOST_CONTROLLER_LOGGER.caughtExceptionAwaitingFinalResponse(e.getCause(), hostName);
                }
                catch (TimeoutException e) {
                    future.asyncCancel(true);
                    if (interruptThread) {
                        DomainControllerLogger.HOST_CONTROLLER_LOGGER.interruptedAwaitingFinalResponse(hostName);
                    } else {
                        DomainControllerLogger.HOST_CONTROLLER_LOGGER.timedOutAwaitingFinalResponse(patient, hostName);
                    }
                    patient = 0;
                }
            }
        }
        finally {
            if (interruptThread) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private static ModelNode getTimeoutResponse(long timeout, String hostName) {
        String msg = DomainControllerLogger.HOST_CONTROLLER_LOGGER.timedOutAwaitingHostPreparedResponse(timeout, hostName);
        ModelNode response = new ModelNode();
        response.get("outcome").set("failed");
        response.get("failure-description").set(msg);
        return response;
    }

    private static ModelNode getInterruptedResponse(String hostName) {
        String msg = DomainControllerLogger.HOST_CONTROLLER_LOGGER.interruptedAwaitingResultFromHost(hostName);
        ModelNode response = new ModelNode();
        response.get("outcome").set("failed");
        response.get("failure-description").set(msg);
        return response;
    }
}

