/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.operations;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.client.helpers.Operations;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.operations.common.OrderedChildTypesAttachment;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.domain.controller.logging.DomainControllerLogger;
import org.jboss.as.domain.controller.operations.ReadMasterDomainOperationsHandler;
import org.jboss.as.domain.controller.operations.SyncServerStateOperationHandler;
import org.jboss.as.domain.controller.operations.deployment.SyncModelParameters;
import org.jboss.as.host.controller.mgmt.HostControllerRegistrationHandler;
import org.jboss.dmr.ModelNode;

class SyncModelOperationHandler
implements OperationStepHandler {
    private final Resource remoteModel;
    private final List<ModelNode> localOperations;
    private final Set<String> missingExtensions;
    private final SyncModelParameters parameters;
    private final OrderedChildTypesAttachment localOrderedChildTypes;
    private static final Comparator<String> ROOT_NODE_COMPARATOR = new Comparator<String>(){
        private final Map<String, Integer> orderedChildTypes;
        {
            String[] orderedTypes = new String[]{"extension", "system-property", "path", "core-service", "profile", "interface", "socket-binding-group", "deployment", "deployment-overlay", "management-client-content", "server-group"};
            HashMap<String, Integer> map = new HashMap<String, Integer>();
            for (int i = 0; i < orderedTypes.length; ++i) {
                map.put(orderedTypes[i], i);
            }
            this.orderedChildTypes = Collections.unmodifiableMap(map);
        }

        @Override
        public int compare(String type1, String type2) {
            if (type1.equals(type2)) {
                return 0;
            }
            if (this.getIndex(type1) < this.getIndex(type2)) {
                return -1;
            }
            return 1;
        }

        private int getIndex(String type) {
            Integer i = this.orderedChildTypes.get(type);
            if (i != null) {
                return i;
            }
            return -1;
        }
    };

    SyncModelOperationHandler(List<ModelNode> localOperations, Resource remoteModel, Set<String> missingExtensions, SyncModelParameters parameters, OrderedChildTypesAttachment localOrderedChildTypes) {
        this.localOperations = localOperations;
        this.remoteModel = remoteModel;
        this.missingExtensions = missingExtensions;
        this.parameters = parameters;
        this.localOrderedChildTypes = localOrderedChildTypes;
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        if (!this.missingExtensions.isEmpty()) {
            throw DomainControllerLogger.HOST_CONTROLLER_LOGGER.missingExtensions(this.missingExtensions);
        }
        ModelNode readOp = new ModelNode();
        readOp.get("operation").set("read-master-domain-operations");
        readOp.get("address").setEmptyList();
        ReadMasterDomainOperationsHandler readOperationsHandler = new ReadMasterDomainOperationsHandler();
        HostControllerRegistrationHandler.OperationExecutor operationExecutor = this.parameters.getOperationExecutor();
        ModelNode result = operationExecutor.executeReadOnly(readOp, this.remoteModel, readOperationsHandler, ModelController.OperationTransactionControl.COMMIT);
        if (result.hasDefined("failure-description")) {
            context.getFailureDescription().set(result.get("failure-description"));
            return;
        }
        List remoteOperations = result.get("result").asList();
        Node currentRoot = new Node(null, PathAddress.EMPTY_ADDRESS);
        Node remoteRoot = new Node(null, PathAddress.EMPTY_ADDRESS);
        this.process(currentRoot, this.localOperations, this.localOrderedChildTypes);
        this.process(remoteRoot, remoteOperations, readOperationsHandler.getOrderedChildTypes());
        OrderedOperationsCollection operations = new OrderedOperationsCollection(context);
        this.processAttributes(currentRoot, remoteRoot, operations, context.getRootResourceRegistration());
        this.processChildren(currentRoot, remoteRoot, operations, context.getRootResourceRegistration());
        List<ModelNode> ops = operations.getReverseList();
        for (ModelNode op : ops) {
            String operationName = op.require("operation").asString();
            PathAddress address = PathAddress.pathAddress((ModelNode)op.require("address"));
            if (this.parameters.getIgnoredResourceRegistry().isResourceExcluded(address)) continue;
            ImmutableManagementResourceRegistration rootRegistration = context.getRootResourceRegistration();
            OperationStepHandler stepHandler = rootRegistration.getOperationHandler(address, operationName);
            if (stepHandler != null) {
                context.addStep(op, stepHandler, OperationContext.Stage.MODEL, true);
                continue;
            }
            ImmutableManagementResourceRegistration child = rootRegistration.getSubModel(address);
            if (child == null) {
                context.getFailureDescription().set(ControllerLogger.ROOT_LOGGER.noSuchResourceType(address));
                continue;
            }
            context.getFailureDescription().set(ControllerLogger.ROOT_LOGGER.noHandlerForOperation(operationName, address));
        }
        if (!context.isBooting() && operations.getAllOps().size() > 0 && this.parameters.isFullModelTransfer()) {
            context.addStep((OperationStepHandler)new SyncServerStateOperationHandler(this.parameters, operations.getAllOps()), OperationContext.Stage.MODEL, true);
        }
    }

    private void processAttributes(Node current, Node remote, OrderedOperationsCollection operations, ImmutableManagementResourceRegistration registration) {
        for (String attribute : remote.attributes.keySet()) {
            ModelNode currentOp = (ModelNode)current.attributes.remove(attribute);
            if (currentOp == null) {
                operations.add((ModelNode)remote.attributes.get(attribute));
                continue;
            }
            ModelNode remoteOp = (ModelNode)remote.attributes.get(attribute);
            if (remoteOp.equals(currentOp)) continue;
            operations.add(remoteOp);
        }
        for (String attribute : current.attributes.keySet()) {
            ModelNode op = Operations.createUndefineAttributeOperation((ModelNode)current.address.toModelNode(), (String)attribute);
            operations.add(op);
        }
    }

    private void processChildren(Node current, Node remote, OrderedOperationsCollection operations, ImmutableManagementResourceRegistration registration) {
        ChildContext childContext = ChildContext.create(current, remote);
        for (String type : childContext.orderedInsertCapableTypes) {
            this.processOrderedChildrenOfType(childContext, type, operations, registration, true);
        }
        for (String type : childContext.orderedNotInsertCapableTypes) {
            this.processOrderedChildrenOfType(childContext, type, operations, registration, false);
        }
        for (String type : childContext.nonOrderedTypes) {
            this.processNonOrderedChildrenOfType(childContext, type, operations, registration);
        }
    }

    private void processOrderedChildrenOfType(ChildContext childContext, String type, OrderedOperationsCollection operations, ImmutableManagementResourceRegistration registration, boolean attemptInsert) {
        Map<PathElement, Node> remoteChildren = childContext.getRemoteChildrenOfType(type);
        Map<PathElement, Node> currentChildren = childContext.getCurrentChildrenOfType(type);
        this.removeCurrentOnlyChildren(currentChildren, remoteChildren, operations, registration);
        HashMap<PathElement, Integer> currentIndexes = new HashMap<PathElement, Integer>();
        int i = 0;
        for (PathElement element : currentChildren.keySet()) {
            currentIndexes.put(element, i++);
        }
        LinkedHashMap<Integer, PathElement> addedIndexes = new LinkedHashMap<Integer, PathElement>();
        i = 0;
        int lastCurrent = -1;
        boolean differentOrder = false;
        boolean allAddsAtEnd = true;
        for (PathElement element : remoteChildren.keySet()) {
            Integer currentIndex = (Integer)currentIndexes.get(element);
            if (currentIndex == null) {
                addedIndexes.put(i, element);
                if (allAddsAtEnd && i <= currentIndexes.size() - 1) {
                    allAddsAtEnd = false;
                }
            } else {
                if (!differentOrder && currentIndex < lastCurrent) {
                    differentOrder = true;
                }
                lastCurrent = currentIndex;
            }
            ++i;
        }
        this.processOrderedChildModels(currentChildren, remoteChildren, addedIndexes, attemptInsert, differentOrder, allAddsAtEnd, operations, registration);
    }

    private void processOrderedChildModels(Map<PathElement, Node> currentChildren, Map<PathElement, Node> remoteChildren, Map<Integer, PathElement> addedIndexes, boolean attemptInsert, boolean differentOrder, boolean allAddsAtEnd, OrderedOperationsCollection operations, ImmutableManagementResourceRegistration registration) {
        block11: {
            block10: {
                if (differentOrder || addedIndexes.size() != 0 && !allAddsAtEnd) break block10;
                for (Node current : currentChildren.values()) {
                    Node node = remoteChildren.get(current.element);
                    this.compareExistsInBothModels(current, node, operations, registration.getSubModel(PathAddress.pathAddress((PathElement[])new PathElement[]{current.element})));
                }
                if (addedIndexes.size() <= 0) break block11;
                for (PathElement element : addedIndexes.values()) {
                    Node node = remoteChildren.get(element);
                    this.addChildRecursive(node, operations, registration.getSubModel(PathAddress.pathAddress((PathElement[])new PathElement[]{element})));
                }
                break block11;
            }
            boolean added = false;
            if (attemptInsert && !differentOrder) {
                added = true;
                int i = 0;
                for (Node remote : remoteChildren.values()) {
                    if (addedIndexes.get(i) != null) {
                        DescriptionProvider desc;
                        remote.add.get("add-index").set(i);
                        ImmutableManagementResourceRegistration childReg = registration.getSubModel(PathAddress.pathAddress((PathElement[])new PathElement[]{remote.element}));
                        if (i == 0 && !(desc = childReg.getOperationDescription(PathAddress.EMPTY_ADDRESS, "add")).getModelDescription(Locale.ENGLISH).hasDefined(new String[]{"request-properties", "add-index"})) {
                            added = false;
                            break;
                        }
                        this.addChildRecursive(remote, operations, childReg);
                    } else {
                        Node current = currentChildren.get(remote.element);
                        this.compareExistsInBothModels(current, remote, operations, registration.getSubModel(PathAddress.pathAddress((PathElement[])new PathElement[]{current.element})));
                    }
                    ++i;
                }
            }
            if (!added) {
                for (Node node : currentChildren.values()) {
                    this.removeChildRecursive(node, operations, registration.getSubModel(PathAddress.pathAddress((PathElement[])new PathElement[]{node.element})), true);
                }
                for (Node node : remoteChildren.values()) {
                    this.addChildRecursive(node, operations, registration.getSubModel(PathAddress.pathAddress((PathElement[])new PathElement[]{node.element})));
                }
            }
        }
    }

    private void processNonOrderedChildrenOfType(ChildContext childContext, String type, OrderedOperationsCollection operations, ImmutableManagementResourceRegistration registration) {
        Map<PathElement, Node> remoteChildren = childContext.getRemoteChildrenOfType(type);
        Map<PathElement, Node> currentChildren = childContext.getCurrentChildrenOfType(type);
        for (Node remoteChild : remoteChildren.values()) {
            Node currentChild;
            Node node = currentChild = currentChildren == null ? null : currentChildren.remove(remoteChild.element);
            if (currentChild != null && remoteChild != null) {
                this.compareExistsInBothModels(currentChild, remoteChild, operations, registration.getSubModel(PathAddress.pathAddress((PathElement[])new PathElement[]{currentChild.element})));
                continue;
            }
            if (currentChild == null && remoteChild != null) {
                this.addChildRecursive(remoteChild, operations, registration.getSubModel(PathAddress.pathAddress((PathElement[])new PathElement[]{remoteChild.element})));
                continue;
            }
            if (currentChild != null && remoteChild == null) {
                this.removeChildRecursive(currentChild, operations, registration.getSubModel(PathAddress.pathAddress((PathElement[])new PathElement[]{currentChild.element})), false);
                continue;
            }
            throw new IllegalStateException();
        }
        for (Node currentChild : currentChildren.values()) {
            this.removeChildRecursive(currentChild, operations, registration.getSubModel(PathAddress.pathAddress((PathElement[])new PathElement[]{currentChild.element})), false);
        }
    }

    private void addChildRecursive(Node remote, OrderedOperationsCollection operations, ImmutableManagementResourceRegistration registration) {
        assert (remote != null) : "remote cannot be null";
        if (remote.add != null) {
            operations.add(remote.add);
        }
        for (ModelNode modelNode : remote.attributes.values()) {
            operations.add(modelNode);
        }
        for (ModelNode modelNode : remote.operations) {
            operations.add(modelNode);
        }
        for (Map.Entry entry : remote.childrenByType.entrySet()) {
            for (Node child : ((Map)entry.getValue()).values()) {
                this.addChildRecursive(child, operations, registration.getSubModel(PathAddress.pathAddress((PathElement[])new PathElement[]{child.element})));
            }
        }
    }

    private void removeCurrentOnlyChildren(Map<PathElement, Node> currentChildren, Map<PathElement, Node> remoteChildren, OrderedOperationsCollection operations, ImmutableManagementResourceRegistration registration) {
        ArrayList<PathElement> removedElements = new ArrayList<PathElement>();
        for (Node node : currentChildren.values()) {
            if (remoteChildren.containsKey(node.element)) continue;
            removedElements.add(node.element);
        }
        for (PathElement removedElement : removedElements) {
            Node removedCurrent = currentChildren.remove(removedElement);
            this.removeChildRecursive(removedCurrent, operations, registration.getSubModel(PathAddress.pathAddress((PathElement[])new PathElement[]{removedElement})), false);
        }
    }

    private void compareExistsInBothModels(Node current, Node remote, OrderedOperationsCollection operations, ImmutableManagementResourceRegistration registration) {
        assert (current != null) : "current cannot be null";
        assert (remote != null) : "remote cannot be null";
        if (current.add != null && remote.add != null) {
            if (!current.add.equals(remote.add)) {
                HashMap<String, ModelNode> remoteAttributes = new HashMap<String, ModelNode>(remote.attributes);
                boolean dropAndReadd = false;
                for (String attribute : registration.getAttributeNames(PathAddress.EMPTY_ADDRESS)) {
                    ModelNode removeValue;
                    ModelNode currentValue;
                    AttributeAccess access = registration.getAttributeAccess(PathAddress.EMPTY_ADDRESS, attribute);
                    if (access.getStorageType() != AttributeAccess.Storage.CONFIGURATION) continue;
                    boolean hasCurrent = current.add.hasDefined(attribute);
                    boolean hasRemote = remote.add.hasDefined(attribute);
                    if (access.getAccessType() == AttributeAccess.AccessType.READ_WRITE) {
                        ModelNode op;
                        if (hasRemote) {
                            if (hasCurrent && remote.add.get(attribute).equals(current.add.get(attribute))) continue;
                            op = Operations.createWriteAttributeOperation((ModelNode)current.address.toModelNode(), (String)attribute, (ModelNode)remote.add.get(attribute));
                            if (remoteAttributes.containsKey(attribute)) {
                                throw new IllegalStateException();
                            }
                            remoteAttributes.put(attribute, op);
                            continue;
                        }
                        if (!hasCurrent) continue;
                        op = Operations.createUndefineAttributeOperation((ModelNode)current.address.toModelNode(), (String)attribute);
                        if (remoteAttributes.containsKey(attribute)) {
                            throw new IllegalStateException();
                        }
                        remoteAttributes.put(attribute, op);
                        continue;
                    }
                    if (access.getAccessType() != AttributeAccess.AccessType.READ_ONLY || (currentValue = hasCurrent ? current.add.get(attribute) : new ModelNode()).equals(removeValue = hasRemote ? remote.add.get(attribute) : new ModelNode())) continue;
                    dropAndReadd = true;
                    break;
                }
                if (dropAndReadd) {
                    this.removeChildRecursive(current, operations, registration.getSubModel(PathAddress.EMPTY_ADDRESS), true);
                    this.addChildRecursive(remote, operations, registration.getSubModel(PathAddress.EMPTY_ADDRESS));
                } else {
                    remote.attributes.putAll(remoteAttributes);
                }
            }
            this.processAttributes(current, remote, operations, registration);
            this.processChildren(current, remote, operations, registration);
        }
    }

    private void removeChildRecursive(Node current, OrderedOperationsCollection operations, ImmutableManagementResourceRegistration registration, boolean dropForReadd) {
        if (registration.getOperationHandler(PathAddress.EMPTY_ADDRESS, "remove") != null) {
            ModelNode op = Operations.createRemoveOperation((ModelNode)current.address.toModelNode());
            if (dropForReadd) {
                op.get(new String[]{"operation-headers", "sync-dropped-for-readd"}).set(true);
            }
            operations.add(op);
        }
        for (Map.Entry childrenByType : current.childrenByType.entrySet()) {
            for (Node child : ((Map)childrenByType.getValue()).values()) {
                this.removeChildRecursive(child, operations, registration.getSubModel(PathAddress.pathAddress((PathElement[])new PathElement[]{child.element})), dropForReadd);
            }
        }
    }

    private void process(Node rootNode, List<ModelNode> operations, OrderedChildTypesAttachment orderedChildTypesAttachment) {
        for (ModelNode operation : operations) {
            String operationName = operation.get("operation").asString();
            PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
            Node node = address.size() == 0 ? rootNode : rootNode.getOrCreate(null, address.iterator(), PathAddress.EMPTY_ADDRESS, orderedChildTypesAttachment);
            if (operationName.equals("add")) {
                node.add = operation;
                continue;
            }
            if (operationName.equals("write-attribute")) {
                String name = operation.get("name").asString();
                node.attributes.put(name, operation);
                continue;
            }
            node.operations.add(operation);
        }
    }

    private static final class OrderedOperationsCollection {
        private final List<ModelNode> extensionAdds = new ArrayList<ModelNode>();
        private final List<ModelNode> nonExtensionAdds = new ArrayList<ModelNode>();
        private final List<ModelNode> extensionRemoves = new ArrayList<ModelNode>();
        private final List<ModelNode> nonExtensionRemoves = new ArrayList<ModelNode>();
        private final List<ModelNode> allOps = new ArrayList<ModelNode>();
        private final boolean booting;

        OrderedOperationsCollection(OperationContext context) {
            this.booting = context.isBooting();
        }

        void add(ModelNode op) {
            String type;
            String name = op.require("operation").asString();
            PathAddress addr = PathAddress.pathAddress((ModelNode)op.require("address"));
            String string = type = addr.size() == 0 ? "" : addr.getElement(0).getKey();
            if (name.equals("add") || name.equals("write-attribute") || name.equals("undefine-attribute")) {
                if (type.equals("extension")) {
                    this.extensionAdds.add(op);
                } else if (type.equals("management-client-content")) {
                    if (this.booting) {
                        this.nonExtensionAdds.add(op);
                    }
                } else {
                    this.nonExtensionAdds.add(op);
                }
            } else if (name.equals("remove")) {
                if (type.equals("extension")) {
                    this.extensionRemoves.add(op);
                } else {
                    this.nonExtensionRemoves.add(op);
                }
            } else assert (false) : "Unknown operation " + name;
            this.allOps.add(op);
        }

        List<ModelNode> getReverseList() {
            ArrayList<ModelNode> result = new ArrayList<ModelNode>();
            ModelNode nonExtensionComposite = Util.createEmptyOperation((String)"composite", (PathAddress)PathAddress.EMPTY_ADDRESS);
            ModelNode nonExtensionSteps = nonExtensionComposite.get("steps").setEmptyList();
            ListIterator<ModelNode> it = this.nonExtensionRemoves.listIterator(this.nonExtensionRemoves.size());
            while (it.hasPrevious()) {
                nonExtensionSteps.add(it.previous());
            }
            for (ModelNode op : this.nonExtensionAdds) {
                nonExtensionSteps.add(op);
            }
            if (nonExtensionSteps.asList().size() > 0) {
                result.add(nonExtensionComposite);
            }
            result.addAll(this.extensionAdds);
            result.addAll(this.extensionRemoves);
            return result;
        }

        List<ModelNode> getAllOps() {
            return this.allOps;
        }
    }

    private static class ChildContext {
        private final Node current;
        private final Node remote;
        private final Set<String> orderedInsertCapableTypes;
        private final Set<String> orderedNotInsertCapableTypes;
        private final Set<String> nonOrderedTypes;

        private ChildContext(Node current, Node remote, Set<String> orderedInsertCapableTypes, Set<String> orderedNotInsertCapableTypes, Set<String> nonOrderedTypes) {
            this.current = current;
            this.remote = remote;
            this.orderedInsertCapableTypes = orderedInsertCapableTypes;
            this.orderedNotInsertCapableTypes = orderedNotInsertCapableTypes;
            this.nonOrderedTypes = nonOrderedTypes;
        }

        static ChildContext create(Node current, Node remote) {
            Set<String> orderedInsertCapableTypes = ChildContext.getOrderedInsertCapable(current);
            Set<String> orderedNotInsertCapableTypes = ChildContext.getOrderedNotInsertCapable(current, remote);
            Set<String> nonOrderedTypes = null;
            if (current != null) {
                nonOrderedTypes = current.createNewChildSet();
                for (String type : current.childrenByType.keySet()) {
                    if (orderedInsertCapableTypes.contains(type) || orderedNotInsertCapableTypes.contains(type)) continue;
                    nonOrderedTypes.add(type);
                }
            }
            if (remote != null) {
                if (nonOrderedTypes == null) {
                    nonOrderedTypes = remote.createNewChildSet();
                }
                for (String type : remote.childrenByType.keySet()) {
                    if (orderedInsertCapableTypes.contains(type) || orderedNotInsertCapableTypes.contains(type)) continue;
                    nonOrderedTypes.add(type);
                }
            }
            return new ChildContext(current, remote, orderedInsertCapableTypes, orderedNotInsertCapableTypes, nonOrderedTypes);
        }

        private static Set<String> getOrderedInsertCapable(Node current) {
            if (current.orderedChildTypes.size() > 0) {
                return new HashSet<String>(current.orderedChildTypes);
            }
            return Collections.emptySet();
        }

        private static Set<String> getOrderedNotInsertCapable(Node current, Node remote) {
            if (remote.orderedChildTypes.size() > 0) {
                HashSet<String> orderedNotInsertCapable = null;
                for (String type : remote.orderedChildTypes) {
                    if (current.orderedChildTypes.contains(type)) continue;
                    if (orderedNotInsertCapable == null) {
                        orderedNotInsertCapable = new HashSet<String>();
                    }
                    orderedNotInsertCapable.add(type);
                }
                if (orderedNotInsertCapable != null) {
                    return orderedNotInsertCapable;
                }
            }
            return Collections.emptySet();
        }

        Map<PathElement, Node> getRemoteChildrenOfType(String type) {
            Map map = (Map)this.remote.childrenByType.get(type);
            if (map != null) {
                return map;
            }
            return Collections.emptyMap();
        }

        Map<PathElement, Node> getCurrentChildrenOfType(String type) {
            Map map = (Map)this.current.childrenByType.get(type);
            if (map != null) {
                return map;
            }
            return Collections.emptyMap();
        }
    }

    private static class Node {
        private final PathElement element;
        private final PathAddress address;
        private ModelNode add;
        private Map<String, ModelNode> attributes = new HashMap<String, ModelNode>();
        private final List<ModelNode> operations = new ArrayList<ModelNode>();
        private final Set<String> orderedChildTypes = new HashSet<String>();
        private final Map<String, Map<PathElement, Node>> childrenByType;

        private Node(PathElement element, PathAddress address) {
            this.element = element;
            this.address = address;
            this.childrenByType = element == null ? new TreeMap(ROOT_NODE_COMPARATOR) : new LinkedHashMap();
        }

        Node getOrCreate(PathElement element, Iterator<PathElement> i, PathAddress current, OrderedChildTypesAttachment orderedChildTypesAttachment) {
            if (i.hasNext()) {
                Node node;
                PathElement next = i.next();
                PathAddress addr = current.append(new PathElement[]{next});
                Map<PathElement, Node> children = this.childrenByType.get(next.getKey());
                if (children == null) {
                    children = new LinkedHashMap<PathElement, Node>();
                    this.childrenByType.put(next.getKey(), children);
                }
                if ((node = children.get(next)) == null) {
                    node = new Node(next, addr);
                    children.put(next, node);
                    Set orderedChildTypes = orderedChildTypesAttachment.getOrderedChildTypes(addr);
                    if (orderedChildTypes != null) {
                        node.orderedChildTypes.addAll(orderedChildTypes);
                    }
                }
                return node.getOrCreate(next, i, addr, orderedChildTypesAttachment);
            }
            if (element == null) {
                throw new IllegalStateException();
            }
            if (this.address.equals(current)) {
                return this;
            }
            throw new IllegalStateException(current.toString());
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            this.toString(sb, 0);
            return sb.toString();
        }

        void toString(StringBuilder builder, int depth) {
            for (int i = 0; i < depth; ++i) {
                builder.append(" ");
            }
            builder.append("Node: {").append(this.address).append("\n");
            for (Map<PathElement, Node> children : this.childrenByType.values()) {
                for (Node child : children.values()) {
                    child.toString(builder, depth + 1);
                }
            }
            for (int i = 0; i < depth; ++i) {
                builder.append(" ");
            }
            builder.append("}\n");
        }

        Set<String> createNewChildSet() {
            if (this.element == null) {
                return new TreeSet<String>(ROOT_NODE_COMPARATOR);
            }
            return new HashSet<String>();
        }
    }
}

