/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.discovery;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import java.util.TreeMap;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.jboss.as.host.controller.discovery.DomainControllerData;
import org.jboss.as.host.controller.logging.HostControllerLogger;
import org.wildfly.common.xml.XMLReaderFactoryUtil;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class S3Util {
    private static final String SEPARATOR = "####";

    public static List<DomainControllerData> domainControllerDataFromByteBuffer(byte[] buffer) throws Exception {
        ArrayList<DomainControllerData> retval = new ArrayList<DomainControllerData>();
        if (buffer == null) {
            return retval;
        }
        ByteArrayInputStream in_stream = new ByteArrayInputStream(buffer);
        DataInputStream in = new DataInputStream(in_stream);
        String content = SEPARATOR;
        while (SEPARATOR.equals(content)) {
            DomainControllerData data = new DomainControllerData();
            data.readFrom(in);
            retval.add(data);
            try {
                content = S3Util.readString(in);
            }
            catch (EOFException ex) {
                content = null;
            }
        }
        in.close();
        return retval;
    }

    public static byte[] domainControllerDataToByteBuffer(List<DomainControllerData> data) throws Exception {
        byte[] result;
        ByteArrayOutputStream out_stream = new ByteArrayOutputStream(512);
        try (DataOutputStream out = new DataOutputStream(out_stream);){
            Iterator<DomainControllerData> iter = data.iterator();
            while (iter.hasNext()) {
                DomainControllerData dcData = iter.next();
                dcData.writeTo(out);
                if (!iter.hasNext()) continue;
                S3Util.writeString(SEPARATOR, out);
            }
            result = out_stream.toByteArray();
        }
        return result;
    }

    protected static String sanitize(String name) {
        String retval = name;
        retval = retval.replace('/', '-');
        retval = retval.replace('\\', '-');
        return retval;
    }

    public static String generatePreSignedUrl(String awsAccessKey, String awsSecretAccessKey, String method, String bucket, String key, long expirationDate) {
        HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
        if (method.equalsIgnoreCase("PUT")) {
            headers.put("x-amz-acl", Arrays.asList("public-read"));
        }
        return Utils.generateQueryStringAuthentication(awsAccessKey, awsSecretAccessKey, method, bucket, key, new HashMap(), headers, expirationDate);
    }

    public static String readString(DataInput in) throws Exception {
        byte b = in.readByte();
        if (b == 1) {
            return in.readUTF();
        }
        return null;
    }

    public static void writeString(String s, DataOutput out) throws Exception {
        if (s != null) {
            out.write(1);
            out.writeUTF(s);
        } else {
            out.write(0);
        }
    }

    static class Utils {
        static final String METADATA_PREFIX = "x-amz-meta-";
        static final String AMAZON_HEADER_PREFIX = "x-amz-";
        static final String ALTERNATIVE_DATE_HEADER = "x-amz-date";
        public static final String DEFAULT_HOST = "s3.amazonaws.com";
        public static final int SECURE_PORT = 443;
        public static final int INSECURE_PORT = 80;
        private static final String HMAC_SHA1_ALGORITHM = "HmacSHA1";

        Utils() {
        }

        static String makeCanonicalString(String method, String bucket, String key, Map pathArgs, Map headers) {
            return Utils.makeCanonicalString(method, bucket, key, pathArgs, headers, null);
        }

        static String makeCanonicalString(String method, String bucketName, String key, Map pathArgs, Map headers, String expires) {
            StringBuilder buf = new StringBuilder();
            buf.append(method + "\n");
            TreeMap<String, String> interestingHeaders = new TreeMap<String, String>();
            if (headers != null) {
                for (String hashKey : headers.keySet()) {
                    String lk;
                    if (hashKey == null || !(lk = hashKey.toLowerCase(Locale.ENGLISH)).equals("content-type") && !lk.equals("content-md5") && !lk.equals("date") && !lk.startsWith(AMAZON_HEADER_PREFIX)) continue;
                    List s = (List)headers.get(hashKey);
                    interestingHeaders.put(lk, Utils.concatenateList(s));
                }
            }
            if (interestingHeaders.containsKey(ALTERNATIVE_DATE_HEADER)) {
                interestingHeaders.put("date", "");
            }
            if (expires != null) {
                interestingHeaders.put("date", expires);
            }
            if (!interestingHeaders.containsKey("content-type")) {
                interestingHeaders.put("content-type", "");
            }
            if (!interestingHeaders.containsKey("content-md5")) {
                interestingHeaders.put("content-md5", "");
            }
            for (String headerKey : interestingHeaders.keySet()) {
                if (headerKey.startsWith(AMAZON_HEADER_PREFIX)) {
                    buf.append(headerKey).append(':').append(interestingHeaders.get(headerKey));
                } else {
                    buf.append(interestingHeaders.get(headerKey));
                }
                buf.append("\n");
            }
            if (bucketName != null && bucketName.length() != 0) {
                buf.append("/" + bucketName);
            }
            buf.append("/");
            if (key != null) {
                buf.append(key);
            }
            if (pathArgs != null) {
                if (pathArgs.containsKey("acl")) {
                    buf.append("?acl");
                } else if (pathArgs.containsKey("torrent")) {
                    buf.append("?torrent");
                } else if (pathArgs.containsKey("logging")) {
                    buf.append("?logging");
                } else if (pathArgs.containsKey("location")) {
                    buf.append("?location");
                }
            }
            return buf.toString();
        }

        static String encode(String awsSecretAccessKey, String canonicalString, boolean urlencode) {
            SecretKeySpec signingKey = new SecretKeySpec(awsSecretAccessKey.getBytes(), HMAC_SHA1_ALGORITHM);
            Mac mac = null;
            try {
                mac = Mac.getInstance(HMAC_SHA1_ALGORITHM);
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e.getLocalizedMessage());
            }
            try {
                mac.init(signingKey);
            }
            catch (InvalidKeyException e) {
                throw new RuntimeException(e.getLocalizedMessage());
            }
            String b64 = Base64.getEncoder().encodeToString(mac.doFinal(canonicalString.getBytes()));
            if (urlencode) {
                return Utils.urlencode(b64);
            }
            return b64;
        }

        static Map paramsForListOptions(String prefix, String marker, Integer maxKeys) {
            return Utils.paramsForListOptions(prefix, marker, maxKeys, null);
        }

        static Map paramsForListOptions(String prefix, String marker, Integer maxKeys, String delimiter) {
            HashMap<String, String> argParams = new HashMap<String, String>();
            if (prefix != null) {
                argParams.put("prefix", Utils.urlencode(prefix));
            }
            if (marker != null) {
                argParams.put("marker", Utils.urlencode(marker));
            }
            if (delimiter != null) {
                argParams.put("delimiter", Utils.urlencode(delimiter));
            }
            if (maxKeys != null) {
                argParams.put("max-keys", Integer.toString(maxKeys));
            }
            return argParams;
        }

        public static String convertPathArgsHashToString(Map pathArgs) {
            StringBuilder pathArgsString = new StringBuilder();
            boolean firstRun = true;
            if (pathArgs != null) {
                for (String argument : pathArgs.keySet()) {
                    if (firstRun) {
                        firstRun = false;
                        pathArgsString.append("?");
                    } else {
                        pathArgsString.append("&");
                    }
                    String argumentValue = (String)pathArgs.get(argument);
                    pathArgsString.append(argument);
                    if (argumentValue == null) continue;
                    pathArgsString.append("=");
                    pathArgsString.append(argumentValue);
                }
            }
            return pathArgsString.toString();
        }

        static String urlencode(String unencoded) {
            try {
                return URLEncoder.encode(unencoded, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e.getLocalizedMessage());
            }
        }

        static XMLReader createXMLReader() {
            try {
                return XMLReaderFactoryUtil.create();
            }
            catch (SAXException e) {
                System.setProperty("org.xml.sax.driver", "org.apache.crimson.parser.XMLReaderImpl");
                try {
                    return XMLReaderFactoryUtil.create();
                }
                catch (SAXException e2) {
                    throw HostControllerLogger.ROOT_LOGGER.cannotInitializeSaxDriver();
                }
            }
        }

        private static String concatenateList(List values) {
            StringBuilder buf = new StringBuilder();
            int size = values.size();
            for (int i = 0; i < size; ++i) {
                buf.append(((String)values.get(i)).replaceAll("\n", "").trim());
                if (i == size - 1) continue;
                buf.append(",");
            }
            return buf.toString();
        }

        static boolean validateBucketName(String bucketName, CallingFormat callingFormat) {
            if (callingFormat == CallingFormat.getPathCallingFormat()) {
                int MIN_BUCKET_LENGTH = 3;
                int MAX_BUCKET_LENGTH = 255;
                String BUCKET_NAME_REGEX = "^[0-9A-Za-z\\.\\-_]*$";
                return null != bucketName && bucketName.length() >= 3 && bucketName.length() <= 255 && bucketName.matches("^[0-9A-Za-z\\.\\-_]*$");
            }
            return Utils.isValidSubdomainBucketName(bucketName);
        }

        static boolean isValidSubdomainBucketName(String bucketName) {
            int MIN_BUCKET_LENGTH = 3;
            int MAX_BUCKET_LENGTH = 63;
            String IPv4_REGEX = "^[0-9]+\\.[0-9]+\\.[0-9]+\\.[0-9]+$";
            String BUCKET_NAME_REGEX = "^[a-z0-9]([a-z0-9\\-\\_]*[a-z0-9])?(\\.[a-z0-9]([a-z0-9\\-\\_]*[a-z0-9])?)*$";
            return null != bucketName && bucketName.length() >= 3 && bucketName.length() <= 63 && !bucketName.matches("^[0-9]+\\.[0-9]+\\.[0-9]+\\.[0-9]+$") && bucketName.matches("^[a-z0-9]([a-z0-9\\-\\_]*[a-z0-9])?(\\.[a-z0-9]([a-z0-9\\-\\_]*[a-z0-9])?)*$");
        }

        static CallingFormat getCallingFormatForBucket(CallingFormat desiredFormat, String bucketName) {
            CallingFormat callingFormat = desiredFormat;
            if (callingFormat == CallingFormat.getSubdomainCallingFormat() && !Utils.isValidSubdomainBucketName(bucketName)) {
                callingFormat = CallingFormat.getPathCallingFormat();
            }
            return callingFormat;
        }

        public static String generateQueryStringAuthentication(String awsAccessKey, String awsSecretAccessKey, String method, String bucket, String key, Map pathArgs, Map headers) {
            int defaultExpiresIn = 300;
            long expirationDate = System.currentTimeMillis() / 1000L + (long)defaultExpiresIn;
            return Utils.generateQueryStringAuthentication(awsAccessKey, awsSecretAccessKey, method, bucket, key, pathArgs, headers, expirationDate);
        }

        public static String generateQueryStringAuthentication(String awsAccessKey, String awsSecretAccessKey, String method, String bucket, String key, Map pathArgs, Map headers, long expirationDate) {
            method = method.toUpperCase(Locale.ENGLISH);
            String canonicalString = Utils.makeCanonicalString(method, bucket, key, pathArgs, headers, "" + expirationDate);
            String encodedCanonical = Utils.encode(awsSecretAccessKey, canonicalString, true);
            return "https://s3.amazonaws.com/" + bucket + "/" + key + "?AWSAccessKeyId=" + awsAccessKey + "&Expires=" + expirationDate + "&Signature=" + encodedCanonical;
        }
    }

    static abstract class CallingFormat {
        protected static CallingFormat pathCallingFormat = new PathCallingFormat();
        protected static CallingFormat subdomainCallingFormat = new SubdomainCallingFormat();
        protected static CallingFormat vanityCallingFormat = new VanityCallingFormat();

        CallingFormat() {
        }

        public abstract boolean supportsLocatedBuckets();

        public abstract String getEndpoint(String var1, int var2, String var3);

        public abstract String getPathBase(String var1, String var2);

        public abstract URL getURL(boolean var1, String var2, int var3, String var4, String var5, Map var6) throws MalformedURLException;

        public static CallingFormat getPathCallingFormat() {
            return pathCallingFormat;
        }

        public static CallingFormat getSubdomainCallingFormat() {
            return subdomainCallingFormat;
        }

        public static CallingFormat getVanityCallingFormat() {
            return vanityCallingFormat;
        }

        private static class PathCallingFormat
        extends CallingFormat {
            private PathCallingFormat() {
            }

            @Override
            public boolean supportsLocatedBuckets() {
                return false;
            }

            @Override
            public String getPathBase(String bucket, String key) {
                return PathCallingFormat.isBucketSpecified(bucket) ? "/" + bucket + "/" + key : "/";
            }

            @Override
            public String getEndpoint(String server, int port, String bucket) {
                return server + ":" + port;
            }

            @Override
            public URL getURL(boolean isSecure, String server, int port, String bucket, String key, Map pathArgs) throws MalformedURLException {
                String pathBase = PathCallingFormat.isBucketSpecified(bucket) ? "/" + bucket + "/" + key : "/";
                String pathArguments = Utils.convertPathArgsHashToString(pathArgs);
                return new URL(isSecure ? "https" : "http", server, port, pathBase + pathArguments);
            }

            private static boolean isBucketSpecified(String bucket) {
                return bucket != null && bucket.length() != 0;
            }
        }

        private static class SubdomainCallingFormat
        extends CallingFormat {
            private SubdomainCallingFormat() {
            }

            @Override
            public boolean supportsLocatedBuckets() {
                return true;
            }

            public String getServer(String server, String bucket) {
                return bucket + "." + server;
            }

            @Override
            public String getEndpoint(String server, int port, String bucket) {
                return this.getServer(server, bucket) + ":" + port;
            }

            @Override
            public String getPathBase(String bucket, String key) {
                return "/" + key;
            }

            @Override
            public URL getURL(boolean isSecure, String server, int port, String bucket, String key, Map pathArgs) throws MalformedURLException {
                if (bucket == null || bucket.length() == 0) {
                    String pathArguments = Utils.convertPathArgsHashToString(pathArgs);
                    return new URL(isSecure ? "https" : "http", server, port, "/" + pathArguments);
                }
                String serverToUse = this.getServer(server, bucket);
                String pathBase = this.getPathBase(bucket, key);
                String pathArguments = Utils.convertPathArgsHashToString(pathArgs);
                return new URL(isSecure ? "https" : "http", serverToUse, port, pathBase + pathArguments);
            }
        }

        private static class VanityCallingFormat
        extends SubdomainCallingFormat {
            private VanityCallingFormat() {
            }

            @Override
            public String getServer(String server, String bucket) {
                return bucket;
            }
        }
    }

    static class S3Object {
        public byte[] data;
        public Map metadata;

        public S3Object(byte[] data, Map metadata) {
            this.data = data;
            this.metadata = metadata;
        }
    }

    static class ListAllMyBucketsResponse
    extends Response {
        public List entries;

        public ListAllMyBucketsResponse(HttpURLConnection connection) throws IOException {
            super(connection);
            if (connection.getResponseCode() < 400) {
                try {
                    XMLReader xr = Utils.createXMLReader();
                    ListAllMyBucketsHandler handler = new ListAllMyBucketsHandler();
                    xr.setContentHandler(handler);
                    xr.setErrorHandler(handler);
                    xr.parse(new InputSource(connection.getInputStream()));
                    this.entries = handler.getEntries();
                }
                catch (SAXException e) {
                    throw HostControllerLogger.ROOT_LOGGER.errorParsingBucketListings(e);
                }
            }
        }

        static class ListAllMyBucketsHandler
        extends DefaultHandler {
            private List entries = new ArrayList();
            private Bucket currBucket = null;
            private StringBuffer currText = null;
            private SimpleDateFormat iso8601Parser = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");

            public ListAllMyBucketsHandler() {
                this.iso8601Parser.setTimeZone(new SimpleTimeZone(0, "GMT"));
                this.currText = new StringBuffer();
            }

            @Override
            public void startDocument() {
            }

            @Override
            public void endDocument() {
            }

            @Override
            public void startElement(String uri, String name, String qName, Attributes attrs) {
                if (name.equals("Bucket")) {
                    this.currBucket = new Bucket();
                }
            }

            @Override
            public void endElement(String uri, String name, String qName) {
                if (name.equals("Bucket")) {
                    this.entries.add(this.currBucket);
                } else if (name.equals("Name")) {
                    this.currBucket.name = this.currText.toString();
                } else if (name.equals("CreationDate")) {
                    try {
                        this.currBucket.creationDate = this.iso8601Parser.parse(this.currText.toString());
                    }
                    catch (ParseException e) {
                        throw HostControllerLogger.ROOT_LOGGER.errorParsingBucketListings(e);
                    }
                }
                this.currText = new StringBuffer();
            }

            @Override
            public void characters(char[] ch, int start, int length) {
                this.currText.append(ch, start, length);
            }

            public List getEntries() {
                return this.entries;
            }
        }
    }

    static class CommonPrefixEntry {
        public String prefix;

        CommonPrefixEntry() {
        }
    }

    static class ListBucketResponse
    extends Response {
        public String name = null;
        public String prefix = null;
        public String marker = null;
        public String delimiter = null;
        public int maxKeys = 0;
        public boolean isTruncated = false;
        public String nextMarker = null;
        public List entries = null;
        public List commonPrefixEntries = null;

        public ListBucketResponse(HttpURLConnection connection) throws IOException {
            super(connection);
            if (connection.getResponseCode() < 400) {
                try {
                    XMLReader xr = Utils.createXMLReader();
                    ListBucketHandler handler = new ListBucketHandler();
                    xr.setContentHandler(handler);
                    xr.setErrorHandler(handler);
                    xr.parse(new InputSource(connection.getInputStream()));
                    this.name = handler.getName();
                    this.prefix = handler.getPrefix();
                    this.marker = handler.getMarker();
                    this.delimiter = handler.getDelimiter();
                    this.maxKeys = handler.getMaxKeys();
                    this.isTruncated = handler.getIsTruncated();
                    this.nextMarker = handler.getNextMarker();
                    this.entries = handler.getKeyEntries();
                    this.commonPrefixEntries = handler.getCommonPrefixEntries();
                }
                catch (SAXException e) {
                    throw HostControllerLogger.ROOT_LOGGER.errorParsingBucketListings(e);
                }
            }
        }

        static class ListBucketHandler
        extends DefaultHandler {
            private String name = null;
            private String prefix = null;
            private String marker = null;
            private String delimiter = null;
            private int maxKeys = 0;
            private boolean isTruncated = false;
            private String nextMarker = null;
            private boolean isEchoedPrefix = false;
            private List keyEntries = new ArrayList();
            private ListEntry keyEntry = null;
            private List commonPrefixEntries = new ArrayList();
            private CommonPrefixEntry commonPrefixEntry = null;
            private StringBuffer currText = null;
            private SimpleDateFormat iso8601Parser = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");

            public ListBucketHandler() {
                this.iso8601Parser.setTimeZone(new SimpleTimeZone(0, "GMT"));
                this.currText = new StringBuffer();
            }

            @Override
            public void startDocument() {
                this.isEchoedPrefix = true;
            }

            @Override
            public void endDocument() {
            }

            @Override
            public void startElement(String uri, String name, String qName, Attributes attrs) {
                if (name.equals("Contents")) {
                    this.keyEntry = new ListEntry();
                } else if (name.equals("Owner")) {
                    this.keyEntry.owner = new Owner();
                } else if (name.equals("CommonPrefixes")) {
                    this.commonPrefixEntry = new CommonPrefixEntry();
                }
            }

            @Override
            public void endElement(String uri, String name, String qName) {
                if (name.equals("Name")) {
                    this.name = this.currText.toString();
                } else if (name.equals("Prefix") && this.isEchoedPrefix) {
                    this.prefix = this.currText.toString();
                    this.isEchoedPrefix = false;
                } else if (name.equals("Marker")) {
                    this.marker = this.currText.toString();
                } else if (name.equals("MaxKeys")) {
                    this.maxKeys = Integer.parseInt(this.currText.toString());
                } else if (name.equals("Delimiter")) {
                    this.delimiter = this.currText.toString();
                } else if (name.equals("IsTruncated")) {
                    this.isTruncated = Boolean.valueOf(this.currText.toString());
                } else if (name.equals("NextMarker")) {
                    this.nextMarker = this.currText.toString();
                } else if (name.equals("Contents")) {
                    this.keyEntries.add(this.keyEntry);
                } else if (name.equals("Key")) {
                    this.keyEntry.key = this.currText.toString();
                } else if (name.equals("LastModified")) {
                    try {
                        this.keyEntry.lastModified = this.iso8601Parser.parse(this.currText.toString());
                    }
                    catch (ParseException e) {
                        throw HostControllerLogger.ROOT_LOGGER.errorParsingBucketListings(e);
                    }
                } else if (name.equals("ETag")) {
                    this.keyEntry.eTag = this.currText.toString();
                } else if (name.equals("Size")) {
                    this.keyEntry.size = Long.parseLong(this.currText.toString());
                } else if (name.equals("StorageClass")) {
                    this.keyEntry.storageClass = this.currText.toString();
                } else if (name.equals("ID")) {
                    this.keyEntry.owner.id = this.currText.toString();
                } else if (name.equals("DisplayName")) {
                    this.keyEntry.owner.displayName = this.currText.toString();
                } else if (name.equals("CommonPrefixes")) {
                    this.commonPrefixEntries.add(this.commonPrefixEntry);
                } else if (name.equals("Prefix")) {
                    this.commonPrefixEntry.prefix = this.currText.toString();
                }
                if (this.currText.length() != 0) {
                    this.currText = new StringBuffer();
                }
            }

            @Override
            public void characters(char[] ch, int start, int length) {
                this.currText.append(ch, start, length);
            }

            public String getName() {
                return this.name;
            }

            public String getPrefix() {
                return this.prefix;
            }

            public String getMarker() {
                return this.marker;
            }

            public String getDelimiter() {
                return this.delimiter;
            }

            public int getMaxKeys() {
                return this.maxKeys;
            }

            public boolean getIsTruncated() {
                return this.isTruncated;
            }

            public String getNextMarker() {
                return this.nextMarker;
            }

            public List getKeyEntries() {
                return this.keyEntries;
            }

            public List getCommonPrefixEntries() {
                return this.commonPrefixEntries;
            }
        }
    }

    static class Bucket {
        public String name;
        public Date creationDate;

        public Bucket() {
            this.name = null;
            this.creationDate = null;
        }

        public Bucket(String name, Date creationDate) {
            this.name = name;
            this.creationDate = creationDate;
        }

        public String toString() {
            return this.name;
        }
    }

    static class LocationResponse
    extends Response {
        String location;

        public LocationResponse(HttpURLConnection connection) throws IOException {
            super(connection);
            if (connection.getResponseCode() < 400) {
                try {
                    XMLReader xr = Utils.createXMLReader();
                    LocationResponseHandler handler = new LocationResponseHandler();
                    xr.setContentHandler(handler);
                    xr.setErrorHandler(handler);
                    xr.parse(new InputSource(connection.getInputStream()));
                    this.location = handler.loc;
                }
                catch (SAXException e) {
                    throw HostControllerLogger.ROOT_LOGGER.errorParsingBucketListings(e);
                }
            } else {
                this.location = "<error>";
            }
        }

        public String getLocation() {
            return this.location;
        }

        static class LocationResponseHandler
        extends DefaultHandler {
            String loc = null;
            private StringBuffer currText = null;

            LocationResponseHandler() {
            }

            @Override
            public void startDocument() {
            }

            @Override
            public void startElement(String uri, String name, String qName, Attributes attrs) {
                if (name.equals("LocationConstraint")) {
                    this.currText = new StringBuffer();
                }
            }

            @Override
            public void endElement(String uri, String name, String qName) {
                if (name.equals("LocationConstraint")) {
                    this.loc = this.currText.toString();
                    this.currText = null;
                }
            }

            @Override
            public void characters(char[] ch, int start, int length) {
                if (this.currText != null) {
                    this.currText.append(ch, start, length);
                }
            }
        }
    }

    static class GetResponse
    extends Response {
        public S3Object object;

        public GetResponse(HttpURLConnection connection) throws IOException {
            super(connection);
            if (connection.getResponseCode() < 400) {
                Map metadata = GetResponse.extractMetadata(connection);
                byte[] body = GetResponse.slurpInputStream(connection.getInputStream());
                this.object = new S3Object(body, metadata);
            }
        }

        private static Map extractMetadata(HttpURLConnection connection) {
            TreeMap<String, List<String>> metadata = new TreeMap<String, List<String>>();
            Map<String, List<String>> headers = connection.getHeaderFields();
            for (String key : headers.keySet()) {
                if (key == null || !key.startsWith("x-amz-meta-")) continue;
                metadata.put(key.substring("x-amz-meta-".length()), headers.get(key));
            }
            return metadata;
        }

        static byte[] slurpInputStream(InputStream stream) throws IOException {
            int count;
            int chunkSize = 2048;
            byte[] buf = new byte[2048];
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream(2048);
            while ((count = stream.read(buf)) != -1) {
                byteStream.write(buf, 0, count);
            }
            return byteStream.toByteArray();
        }
    }

    static class Response {
        public HttpURLConnection connection;

        public Response(HttpURLConnection connection) throws IOException {
            this.connection = connection;
        }
    }

    static class Owner {
        public String id;
        public String displayName;

        Owner() {
        }
    }

    static class ListEntry {
        public String key;
        public Date lastModified;
        public String eTag;
        public long size;
        public String storageClass;
        public Owner owner;

        ListEntry() {
        }

        public String toString() {
            return this.key;
        }
    }

    static class AWSAuthConnection {
        public static final String LOCATION_DEFAULT = null;
        public static final String LOCATION_EU = "EU";
        private String awsAccessKeyId;
        private String awsSecretAccessKey;
        private boolean isSecure;
        private String server;
        private int port;
        private CallingFormat callingFormat;

        public AWSAuthConnection(String awsAccessKeyId, String awsSecretAccessKey) {
            this(awsAccessKeyId, awsSecretAccessKey, true);
        }

        public AWSAuthConnection(String awsAccessKeyId, String awsSecretAccessKey, boolean isSecure) {
            this(awsAccessKeyId, awsSecretAccessKey, isSecure, "s3.amazonaws.com");
        }

        public AWSAuthConnection(String awsAccessKeyId, String awsSecretAccessKey, boolean isSecure, String server) {
            this(awsAccessKeyId, awsSecretAccessKey, isSecure, server, isSecure ? 443 : 80);
        }

        public AWSAuthConnection(String awsAccessKeyId, String awsSecretAccessKey, boolean isSecure, String server, int port) {
            this(awsAccessKeyId, awsSecretAccessKey, isSecure, server, port, CallingFormat.getSubdomainCallingFormat());
        }

        public AWSAuthConnection(String awsAccessKeyId, String awsSecretAccessKey, boolean isSecure, String server, CallingFormat format) {
            this(awsAccessKeyId, awsSecretAccessKey, isSecure, server, isSecure ? 443 : 80, format);
        }

        public AWSAuthConnection(String awsAccessKeyId, String awsSecretAccessKey, boolean isSecure, String server, int port, CallingFormat format) {
            this.awsAccessKeyId = awsAccessKeyId;
            this.awsSecretAccessKey = awsSecretAccessKey;
            this.isSecure = isSecure;
            this.server = server;
            this.port = port;
            this.callingFormat = format;
        }

        public Response createBucket(String bucket, Map headers) throws IOException {
            return this.createBucket(bucket, null, headers);
        }

        public Response createBucket(String bucket, String location, Map headers) throws IOException {
            String body;
            if (location == null) {
                body = null;
            } else if (LOCATION_EU.equals(location)) {
                if (!this.callingFormat.supportsLocatedBuckets()) {
                    throw HostControllerLogger.ROOT_LOGGER.creatingBucketWithUnsupportedCallingFormat();
                }
                body = "<CreateBucketConstraint><LocationConstraint>" + location + "</LocationConstraint></CreateBucketConstraint>";
            } else {
                throw HostControllerLogger.ROOT_LOGGER.invalidS3Location(location);
            }
            if (!Utils.validateBucketName(bucket, this.callingFormat)) {
                throw HostControllerLogger.ROOT_LOGGER.invalidS3Bucket(bucket);
            }
            HttpURLConnection request = this.makeRequest("PUT", bucket, "", null, headers);
            if (body != null) {
                request.setDoOutput(true);
                request.getOutputStream().write(body.getBytes(StandardCharsets.UTF_8));
            }
            return new Response(request);
        }

        public boolean checkBucketExists(String bucket) throws IOException {
            HttpURLConnection response = this.makeRequest("HEAD", bucket, "", null, null);
            int httpCode = response.getResponseCode();
            if (httpCode >= 200 && httpCode < 300) {
                return true;
            }
            if (httpCode == 404) {
                return false;
            }
            throw HostControllerLogger.ROOT_LOGGER.bucketAuthenticationFailure(bucket, httpCode, response.getResponseMessage());
        }

        public ListBucketResponse listBucket(String bucket, String prefix, String marker, Integer maxKeys, Map headers) throws IOException {
            return this.listBucket(bucket, prefix, marker, maxKeys, null, headers);
        }

        public ListBucketResponse listBucket(String bucket, String prefix, String marker, Integer maxKeys, String delimiter, Map headers) throws IOException {
            Map pathArgs = Utils.paramsForListOptions(prefix, marker, maxKeys, delimiter);
            return new ListBucketResponse(this.makeRequest("GET", bucket, "", pathArgs, headers));
        }

        public Response deleteBucket(String bucket, Map headers) throws IOException {
            return new Response(this.makeRequest("DELETE", bucket, "", null, headers));
        }

        public Response put(String bucket, String key, S3Object object, Map headers) throws IOException {
            HttpURLConnection request = this.makeRequest("PUT", bucket, Utils.urlencode(key), null, headers, object);
            request.setDoOutput(true);
            request.getOutputStream().write(object.data == null ? new byte[]{} : object.data);
            return new Response(request);
        }

        public Response put(String preSignedUrl, S3Object object, Map headers) throws IOException {
            HttpURLConnection request = this.makePreSignedRequest("PUT", preSignedUrl, headers);
            request.setDoOutput(true);
            request.getOutputStream().write(object.data == null ? new byte[]{} : object.data);
            return new Response(request);
        }

        public Response copy(String sourceBucket, String sourceKey, String destinationBucket, String destinationKey, Map headers) throws IOException {
            S3Object object = new S3Object(new byte[0], new HashMap());
            headers = headers == null ? new HashMap<String, List<String>>() : new HashMap(headers);
            headers.put("x-amz-copy-source", Arrays.asList(sourceBucket + "/" + sourceKey));
            headers.put("x-amz-metadata-directive", Arrays.asList("COPY"));
            return AWSAuthConnection.verifyCopy(this.put(destinationBucket, destinationKey, object, headers));
        }

        public Response copy(String sourceBucket, String sourceKey, String destinationBucket, String destinationKey, Map metadata, Map headers) throws IOException {
            S3Object object = new S3Object(new byte[0], metadata);
            headers = headers == null ? new HashMap<String, List<String>>() : new HashMap(headers);
            headers.put("x-amz-copy-source", Arrays.asList(sourceBucket + "/" + sourceKey));
            headers.put("x-amz-metadata-directive", Arrays.asList("REPLACE"));
            return AWSAuthConnection.verifyCopy(this.put(destinationBucket, destinationKey, object, headers));
        }

        private static Response verifyCopy(Response response) throws IOException {
            if (response.connection.getResponseCode() < 400) {
                byte[] body = GetResponse.slurpInputStream(response.connection.getInputStream());
                String message = new String(body);
                if (message.contains("<Error")) {
                    throw new IOException(message.substring(message.indexOf("<Error")));
                }
                if (!message.contains("</CopyObjectResult>")) {
                    throw HostControllerLogger.ROOT_LOGGER.unexpectedResponse(message);
                }
            }
            return response;
        }

        public GetResponse get(String bucket, String key, Map headers) throws IOException {
            return new GetResponse(this.makeRequest("GET", bucket, Utils.urlencode(key), null, headers));
        }

        public Response delete(String bucket, String key, Map headers) throws IOException {
            return new Response(this.makeRequest("DELETE", bucket, Utils.urlencode(key), null, headers));
        }

        public Response delete(String preSignedUrl) throws IOException {
            return new Response(this.makePreSignedRequest("DELETE", preSignedUrl, null));
        }

        public GetResponse getBucketRequestPayment(String bucket, Map headers) throws IOException {
            HashMap<String, Object> pathArgs = new HashMap<String, Object>();
            pathArgs.put("requestPayment", null);
            return new GetResponse(this.makeRequest("GET", bucket, "", pathArgs, headers));
        }

        public Response putBucketRequestPayment(String bucket, String requestPaymentXMLDoc, Map headers) throws IOException {
            HashMap<String, Object> pathArgs = new HashMap<String, Object>();
            pathArgs.put("requestPayment", null);
            S3Object object = new S3Object(requestPaymentXMLDoc.getBytes(), null);
            HttpURLConnection request = this.makeRequest("PUT", bucket, "", pathArgs, headers, object);
            request.setDoOutput(true);
            request.getOutputStream().write(object.data == null ? new byte[]{} : object.data);
            return new Response(request);
        }

        public GetResponse getBucketLogging(String bucket, Map headers) throws IOException {
            HashMap<String, Object> pathArgs = new HashMap<String, Object>();
            pathArgs.put("logging", null);
            return new GetResponse(this.makeRequest("GET", bucket, "", pathArgs, headers));
        }

        public Response putBucketLogging(String bucket, String loggingXMLDoc, Map headers) throws IOException {
            HashMap<String, Object> pathArgs = new HashMap<String, Object>();
            pathArgs.put("logging", null);
            S3Object object = new S3Object(loggingXMLDoc.getBytes(), null);
            HttpURLConnection request = this.makeRequest("PUT", bucket, "", pathArgs, headers, object);
            request.setDoOutput(true);
            request.getOutputStream().write(object.data == null ? new byte[]{} : object.data);
            return new Response(request);
        }

        public GetResponse getBucketACL(String bucket, Map headers) throws IOException {
            return this.getACL(bucket, "", headers);
        }

        public GetResponse getACL(String bucket, String key, Map headers) throws IOException {
            if (key == null) {
                key = "";
            }
            HashMap<String, Object> pathArgs = new HashMap<String, Object>();
            pathArgs.put("acl", null);
            return new GetResponse(this.makeRequest("GET", bucket, Utils.urlencode(key), pathArgs, headers));
        }

        public Response putBucketACL(String bucket, String aclXMLDoc, Map headers) throws IOException {
            return this.putACL(bucket, "", aclXMLDoc, headers);
        }

        public Response putACL(String bucket, String key, String aclXMLDoc, Map headers) throws IOException {
            S3Object object = new S3Object(aclXMLDoc.getBytes(), null);
            HashMap<String, Object> pathArgs = new HashMap<String, Object>();
            pathArgs.put("acl", null);
            HttpURLConnection request = this.makeRequest("PUT", bucket, Utils.urlencode(key), pathArgs, headers, object);
            request.setDoOutput(true);
            request.getOutputStream().write(object.data == null ? new byte[]{} : object.data);
            return new Response(request);
        }

        public LocationResponse getBucketLocation(String bucket) throws IOException {
            HashMap<String, Object> pathArgs = new HashMap<String, Object>();
            pathArgs.put("location", null);
            return new LocationResponse(this.makeRequest("GET", bucket, "", pathArgs, null));
        }

        public ListAllMyBucketsResponse listAllMyBuckets(Map headers) throws IOException {
            return new ListAllMyBucketsResponse(this.makeRequest("GET", "", "", null, headers));
        }

        private HttpURLConnection makeRequest(String method, String bucketName, String key, Map pathArgs, Map headers) throws IOException {
            return this.makeRequest(method, bucketName, key, pathArgs, headers, null);
        }

        private HttpURLConnection makeRequest(String method, String bucket, String key, Map pathArgs, Map headers, S3Object object) throws IOException {
            CallingFormat format = Utils.getCallingFormatForBucket(this.callingFormat, bucket);
            if (this.isSecure && format != CallingFormat.getPathCallingFormat() && bucket.contains(".")) {
                System.err.println("You are making an SSL connection, however, the bucket contains periods and the wildcard certificate will not match by default.  Please consider using HTTP.");
            }
            URL url = format.getURL(this.isSecure, this.server, this.port, bucket, key, pathArgs);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod(method);
            if (!connection.getInstanceFollowRedirects() && format.supportsLocatedBuckets()) {
                throw HostControllerLogger.ROOT_LOGGER.httpRedirectSupportRequired();
            }
            AWSAuthConnection.addHeaders(connection, headers);
            if (object != null) {
                AWSAuthConnection.addMetadataHeaders(connection, object.metadata);
            }
            this.addAuthHeader(connection, method, bucket, key, pathArgs);
            return connection;
        }

        private HttpURLConnection makePreSignedRequest(String method, String preSignedUrl, Map headers) throws IOException {
            URL url = new URL(preSignedUrl);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod(method);
            AWSAuthConnection.addHeaders(connection, headers);
            return connection;
        }

        private static void addHeaders(HttpURLConnection connection, Map headers) {
            AWSAuthConnection.addHeaders(connection, headers, "");
        }

        private static void addMetadataHeaders(HttpURLConnection connection, Map metadata) {
            AWSAuthConnection.addHeaders(connection, metadata, "x-amz-meta-");
        }

        private static void addHeaders(HttpURLConnection connection, Map headers, String prefix) {
            if (headers != null) {
                for (String key : headers.keySet()) {
                    for (String value : (List)headers.get(key)) {
                        connection.addRequestProperty(prefix + key, value);
                    }
                }
            }
        }

        private void addAuthHeader(HttpURLConnection connection, String method, String bucket, String key, Map pathArgs) {
            if (connection.getRequestProperty("Date") == null) {
                connection.setRequestProperty("Date", AWSAuthConnection.httpDate());
            }
            if (connection.getRequestProperty("Content-Type") == null) {
                connection.setRequestProperty("Content-Type", "");
            }
            if (this.awsAccessKeyId != null && this.awsSecretAccessKey != null) {
                String canonicalString = Utils.makeCanonicalString(method, bucket, key, pathArgs, connection.getRequestProperties());
                String encodedCanonical = Utils.encode(this.awsSecretAccessKey, canonicalString, false);
                connection.setRequestProperty("Authorization", "AWS " + this.awsAccessKeyId + ":" + encodedCanonical);
            }
        }

        public static String httpDate() {
            String DateFormat2 = "EEE, dd MMM yyyy HH:mm:ss ";
            SimpleDateFormat format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss ", Locale.US);
            format.setTimeZone(TimeZone.getTimeZone("GMT"));
            return format.format(new Date()) + "GMT";
        }
    }

    static class PreSignedUrlParser {
        String bucket = "";
        String prefix = "";

        public PreSignedUrlParser(String preSignedUrl) {
            try {
                URL url = new URL(preSignedUrl);
                String path = url.getPath();
                String[] pathParts = path.split("/");
                if (pathParts.length < 3) {
                    throw HostControllerLogger.ROOT_LOGGER.preSignedUrlMustPointToFile(preSignedUrl);
                }
                if (pathParts.length > 4) {
                    throw HostControllerLogger.ROOT_LOGGER.invalidPreSignedUrlLength(preSignedUrl);
                }
                this.bucket = pathParts[1];
                if (pathParts.length > 3) {
                    this.prefix = pathParts[2];
                }
            }
            catch (MalformedURLException ex) {
                throw HostControllerLogger.ROOT_LOGGER.invalidPreSignedUrl(preSignedUrl);
            }
        }

        public String getBucket() {
            return this.bucket;
        }

        public String getPrefix() {
            return this.prefix;
        }
    }
}

