/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.mgmt;

import java.io.Closeable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.RunningMode;
import org.jboss.as.controller.client.Operation;
import org.jboss.as.controller.client.OperationBuilder;
import org.jboss.as.controller.client.OperationMessageHandler;
import org.jboss.as.controller.extension.ExtensionRegistry;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.remote.TransactionalProtocolClient;
import org.jboss.as.controller.transform.TransformationTarget;
import org.jboss.as.controller.transform.TransformationTargetImpl;
import org.jboss.as.controller.transform.TransformerRegistry;
import org.jboss.as.controller.transform.Transformers;
import org.jboss.as.domain.controller.DomainController;
import org.jboss.as.domain.controller.HostConnectionInfo;
import org.jboss.as.domain.controller.HostRegistrations;
import org.jboss.as.domain.controller.LocalHostControllerInfo;
import org.jboss.as.domain.controller.SlaveRegistrationException;
import org.jboss.as.domain.controller.logging.DomainControllerLogger;
import org.jboss.as.domain.controller.operations.ReadMasterDomainModelHandler;
import org.jboss.as.host.controller.logging.HostControllerLogger;
import org.jboss.as.host.controller.mgmt.DomainHostExcludeRegistry;
import org.jboss.as.host.controller.mgmt.HostInfo;
import org.jboss.as.host.controller.mgmt.SlaveChannelAttachments;
import org.jboss.as.process.protocol.ProtocolUtils;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.as.protocol.mgmt.ActiveOperation;
import org.jboss.as.protocol.mgmt.FlushableDataOutput;
import org.jboss.as.protocol.mgmt.ManagementChannelHandler;
import org.jboss.as.protocol.mgmt.ManagementProtocolHeader;
import org.jboss.as.protocol.mgmt.ManagementRequestContext;
import org.jboss.as.protocol.mgmt.ManagementRequestHandler;
import org.jboss.as.protocol.mgmt.ManagementRequestHandlerFactory;
import org.jboss.as.protocol.mgmt.ManagementRequestHeader;
import org.jboss.as.protocol.mgmt.ManagementResponseHeader;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.remoting3.Channel;
import org.jboss.remoting3.CloseHandler;
import org.jboss.threads.AsyncFutureTask;
import org.wildfly.common.Assert;

public class HostControllerRegistrationHandler
implements ManagementRequestHandlerFactory {
    private static final Operation READ_DOMAIN_MODEL;
    private static final ModelNode SUCCESSFUL_RESULT;
    private final ManagementChannelHandler handler;
    private final OperationExecutor operationExecutor;
    private final DomainController domainController;
    private final Executor registrationExecutor;
    private final HostRegistrations slaveHostRegistrations;
    private final String address;
    private final DomainHostExcludeRegistry domainHostExcludeRegistry;

    public HostControllerRegistrationHandler(ManagementChannelHandler handler, DomainController domainController, OperationExecutor operationExecutor, Executor registrations, HostRegistrations slaveHostRegistrations, DomainHostExcludeRegistry domainHostExcludeRegistry) {
        this.handler = handler;
        this.operationExecutor = operationExecutor;
        this.domainController = domainController;
        this.registrationExecutor = registrations;
        this.slaveHostRegistrations = slaveHostRegistrations;
        this.domainHostExcludeRegistry = domainHostExcludeRegistry;
        this.address = this.handler.getRemoteAddress().getHostAddress();
    }

    public ManagementRequestHandler<?, ?> resolveHandler(ManagementRequestHandlerFactory.RequestHandlerChain handlers, ManagementRequestHeader header) {
        if (header.getVersion() != 1) {
            this.handler.getAttachments().attach(TransactionalProtocolClient.SEND_IDENTITY, (Object)Boolean.TRUE);
        }
        byte operationId = header.getOperationId();
        switch (operationId) {
            case 81: {
                RegistrationContext context = new RegistrationContext(this.domainController.getExtensionRegistry(), true, this.domainHostExcludeRegistry);
                context.activeOperation = handlers.registerActiveOperation(Integer.valueOf(header.getBatchId()), (Object)context, (ActiveOperation.CompletedCallback)context);
                return new InitiateRegistrationHandler();
            }
            case 87: {
                RegistrationContext context = new RegistrationContext(this.domainController.getExtensionRegistry(), false, this.domainHostExcludeRegistry);
                context.activeOperation = handlers.registerActiveOperation(Integer.valueOf(header.getBatchId()), (Object)context, (ActiveOperation.CompletedCallback)context);
                return new InitiateRegistrationHandler();
            }
            case 89: {
                return new RegisterSubsystemVersionsHandler();
            }
            case 88: {
                return new CompleteRegistrationHandler();
            }
        }
        return handlers.resolveNext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void sendResponse(ManagementRequestContext<RegistrationContext> context, byte responseType, ModelNode response) throws IOException {
        ManagementResponseHeader header = ManagementResponseHeader.create((ManagementProtocolHeader)context.getRequestHeader());
        FlushableDataOutput output = context.writeMessage((ManagementProtocolHeader)header);
        try {
            HostControllerRegistrationHandler.sendResponse(output, responseType, response);
        }
        finally {
            StreamUtils.safeClose((Closeable)output);
        }
    }

    static void sendResponse(FlushableDataOutput output, byte responseType, ModelNode response) throws IOException {
        output.writeByte((int)responseType);
        if (response != null) {
            response.writeExternal((DataOutput)output);
        }
        output.writeByte(36);
        output.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void sendFailedResponse(ManagementRequestContext<RegistrationContext> context, byte errorCode, String message) throws IOException {
        ManagementResponseHeader header = ManagementResponseHeader.create((ManagementProtocolHeader)context.getRequestHeader());
        FlushableDataOutput output = context.writeMessage((ManagementProtocolHeader)header);
        try {
            output.writeByte(34);
            output.writeByte((int)errorCode);
            if (message == null) {
                output.writeUTF("unknown error");
            } else {
                output.writeUTF(message);
            }
            output.writeByte(36);
            output.close();
        }
        finally {
            StreamUtils.safeClose((Closeable)output);
        }
    }

    static {
        SUCCESSFUL_RESULT = new ModelNode();
        ModelNode mn = new ModelNode();
        mn.get("operation").set("read-master-domain-model");
        mn.get("address").setEmptyList();
        mn.protect();
        READ_DOMAIN_MODEL = OperationBuilder.create((ModelNode)mn).build();
        SUCCESSFUL_RESULT.get("outcome").set("success");
        SUCCESSFUL_RESULT.get("result").setEmptyObject();
        SUCCESSFUL_RESULT.protect();
    }

    public static interface OperationExecutor {
        public ModelNode execute(Operation var1, OperationMessageHandler var2, ModelController.OperationTransactionControl var3, OperationStepHandler var4);

        public ModelNode installSlaveExtensions(List<ModelNode> var1);

        public ModelNode executeReadOnly(ModelNode var1, OperationStepHandler var2, ModelController.OperationTransactionControl var3);

        public ModelNode executeReadOnly(ModelNode var1, Resource var2, OperationStepHandler var3, ModelController.OperationTransactionControl var4);

        public void acquireReadlock(Integer var1) throws IllegalArgumentException, InterruptedException;

        public void releaseReadlock(Integer var1) throws IllegalArgumentException;
    }

    private class RegistrationContext
    implements ModelController.OperationTransactionControl,
    ActiveOperation.CompletedCallback<Void> {
        private final ExtensionRegistry extensionRegistry;
        private final boolean registerProxyController;
        private volatile String hostName;
        private volatile HostInfo hostInfo;
        private ManagementRequestContext<RegistrationContext> responseChannel;
        private volatile IOTask<?> task;
        private volatile boolean failed;
        private volatile Transformers transformers;
        private ActiveOperation<Void, RegistrationContext> activeOperation;
        private final AtomicBoolean completed = new AtomicBoolean();
        private final DomainHostExcludeRegistry domainHostExcludeRegistry;

        private RegistrationContext(ExtensionRegistry extensionRegistry, boolean registerProxyController, DomainHostExcludeRegistry domainHostExcludeRegistry) {
            this.extensionRegistry = extensionRegistry;
            this.registerProxyController = registerProxyController;
            this.domainHostExcludeRegistry = domainHostExcludeRegistry;
        }

        private synchronized void initialize(String hostName, ModelNode hostInfo, ManagementRequestContext<RegistrationContext> responseChannel) {
            this.hostName = hostName;
            this.hostInfo = HostInfo.fromModelNode(hostInfo, this.domainHostExcludeRegistry);
            this.responseChannel = responseChannel;
        }

        public void completed(Void result) {
        }

        public void failed(Exception e) {
            this.failed(e, SlaveRegistrationException.ErrorCode.UNKNOWN, e.getClass().getName() + ":" + e.getMessage());
        }

        public void cancelled() {
        }

        public void operationPrepared(ModelController.OperationTransaction transaction, ModelNode result) {
            if (this.failed) {
                transaction.rollback();
            } else {
                try {
                    this.registerHost(transaction, result);
                }
                catch (SlaveRegistrationException e) {
                    this.failed(e, e.getErrorCode(), e.getErrorMessage());
                }
                catch (Exception e) {
                    this.failed(e, SlaveRegistrationException.ErrorCode.UNKNOWN, e.getClass().getName() + ":" + e.getMessage());
                }
                if (this.failed) {
                    transaction.rollback();
                }
            }
        }

        private void processRegistration() {
            if (HostControllerRegistrationHandler.this.domainController.isHostRegistered(this.hostName)) {
                HostControllerRegistrationHandler.this.domainController.pingRemoteHost(this.hostName);
                boolean inter = false;
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                finally {
                    if (HostControllerRegistrationHandler.this.domainController.isHostRegistered(this.hostName)) {
                        this.failed(SlaveRegistrationException.ErrorCode.HOST_ALREADY_EXISTS, DomainControllerLogger.ROOT_LOGGER.slaveAlreadyRegistered(this.hostName));
                    }
                }
            }
            if (!this.failed) {
                try {
                    HostRegistrationStepHandler handler = new HostRegistrationStepHandler(this.extensionRegistry.getTransformerRegistry(), this);
                    ModelNode result = HostControllerRegistrationHandler.this.operationExecutor.execute(READ_DOMAIN_MODEL, OperationMessageHandler.logging, this, handler);
                    if ("failed".equals(result.get("outcome").asString())) {
                        this.failed(SlaveRegistrationException.ErrorCode.UNKNOWN, result.get("failure-description").asString());
                        return;
                    }
                }
                catch (Exception e) {
                    this.failed(e);
                    return;
                }
                this.sendCompletedMessage();
                this.responseChannel.getChannel().addCloseHandler((CloseHandler)new CloseHandler<Channel>(){

                    public void handleClose(Channel closed, IOException exception) {
                        boolean cleanShutdown = !HostControllerRegistrationHandler.this.domainController.isHostRegistered(RegistrationContext.this.hostName);
                        HostControllerRegistrationHandler.this.domainController.unregisterRemoteHost(RegistrationContext.this.hostName, RegistrationContext.this.getRemoteConnectionId(), cleanShutdown);
                    }
                });
            }
        }

        private void processSubsystems(Transformers transformers, final ModelNode extensions) throws OperationFailedException {
            this.transformers = transformers;
            ModelNode subsystems = this.executeBlocking(new IOTask<ModelNode>(){

                @Override
                void sendMessage(FlushableDataOutput output) throws IOException {
                    HostControllerRegistrationHandler.sendResponse(output, (byte)33, extensions);
                }
            });
            if (this.failed) {
                throw new OperationFailedException("failed to setup transformers");
            }
            TransformationTarget target = transformers.getTarget();
            for (Property subsystem : subsystems.asPropertyList()) {
                String subsystemName = subsystem.getName();
                ModelNode version = subsystem.getValue();
                target.addSubsystemVersion(subsystemName, ModelVersion.fromString((String)version.asString()));
            }
        }

        protected void setSubsystems(ModelNode resolved, ManagementRequestContext<RegistrationContext> responseChannel) {
            this.responseChannel = responseChannel;
            this.completeTask(resolved);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void registerHost(ModelController.OperationTransaction transaction, ModelNode result) throws SlaveRegistrationException {
            if (this.sendResultToHost(transaction, result)) {
                return;
            }
            RegistrationContext registrationContext = this;
            synchronized (registrationContext) {
                Long pingPongId = this.hostInfo.getRemoteConnectionId();
                HostControllerRegistrationHandler.this.domainController.registerRemoteHost(this.hostName, HostControllerRegistrationHandler.this.handler, this.transformers, pingPongId, this.registerProxyController);
                if (this.failed) {
                    transaction.rollback();
                    return;
                }
                transaction.commit();
            }
            if (this.registerProxyController) {
                HostControllerLogger.DOMAIN_LOGGER.registeredRemoteSlaveHost(this.hostName, this.hostInfo.getPrettyProductName());
            }
        }

        private boolean sendResultToHost(ModelController.OperationTransaction transaction, final ModelNode result) {
            boolean registered = this.executeBlocking(new IOTask<Boolean>(){

                @Override
                void sendMessage(FlushableDataOutput output) throws IOException {
                    HostControllerRegistrationHandler.sendResponse(output, (byte)33, result);
                }
            });
            if (!registered) {
                transaction.rollback();
                return true;
            }
            return false;
        }

        void completeRegistration(ManagementRequestContext<RegistrationContext> responseChannel, boolean commit) {
            this.responseChannel = responseChannel;
            this.failed |= !commit;
            this.completeTask(!this.failed);
        }

        void failed(Throwable t, SlaveRegistrationException.ErrorCode error, String message) {
            byte errorCode = error.getCode();
            if (this.completed.compareAndSet(false, true)) {
                this.failed = true;
                IOTask<?> task = this.task;
                if (task != null) {
                    task.failed(t);
                }
                try {
                    HostControllerRegistrationHandler.sendFailedResponse(this.responseChannel, errorCode, message);
                }
                catch (IOException e) {
                    HostControllerLogger.DOMAIN_LOGGER.debugf(e, "failed to process message", new Object[0]);
                }
                this.activeOperation.getResultHandler().done(null);
                this.addFailureEvent(error);
            }
        }

        void failed(SlaveRegistrationException.ErrorCode error, String message) {
            Exception ex = new Exception(message);
            this.failed(ex, error, message);
        }

        void addFailureEvent(SlaveRegistrationException.ErrorCode error) {
            HostControllerRegistrationHandler.this.slaveHostRegistrations.addHostEvent(this.hostName, HostConnectionInfo.Events.create(switch (error) {
                case SlaveRegistrationException.ErrorCode.HOST_ALREADY_EXISTS -> HostConnectionInfo.EventType.REGISTRATION_EXISTING;
                case SlaveRegistrationException.ErrorCode.INCOMPATIBLE_VERSION -> HostConnectionInfo.EventType.REGISTRATION_REJECTED;
                default -> HostConnectionInfo.EventType.REGISTRATION_FAILED;
            }, HostControllerRegistrationHandler.this.address));
        }

        void sendCompletedMessage() {
            if (this.completed.compareAndSet(false, true)) {
                try {
                    HostControllerRegistrationHandler.sendResponse(this.responseChannel, (byte)33, null);
                }
                catch (IOException e) {
                    HostControllerLogger.DOMAIN_LOGGER.debugf(e, "failed to process message", new Object[0]);
                }
                this.activeOperation.getResultHandler().done(null);
            }
        }

        Long getRemoteConnectionId() {
            return this.hostInfo.getRemoteConnectionId();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean completeTask(Object result) {
            RegistrationContext registrationContext = this;
            synchronized (registrationContext) {
                if (this.failed) {
                    return false;
                }
                if (this.task != null) {
                    return this.task.completeStep(result);
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected <T> T executeBlocking(IOTask<T> task) {
            RegistrationContext registrationContext = this;
            synchronized (registrationContext) {
                this.task = task;
                try {
                    ManagementResponseHeader header = ManagementResponseHeader.create((ManagementProtocolHeader)this.responseChannel.getRequestHeader());
                    FlushableDataOutput output = this.responseChannel.writeMessage((ManagementProtocolHeader)header);
                    try {
                        task.sendMessage(output);
                    }
                    catch (IOException e) {
                        this.failed(e, SlaveRegistrationException.ErrorCode.UNKNOWN, DomainControllerLogger.ROOT_LOGGER.failedToSendMessage(e.getMessage()));
                        throw new IllegalStateException(e);
                    }
                    finally {
                        StreamUtils.safeClose((Closeable)output);
                    }
                }
                catch (IOException e) {
                    this.failed(e, SlaveRegistrationException.ErrorCode.UNKNOWN, DomainControllerLogger.ROOT_LOGGER.failedToSendResponseHeader(e.getMessage()));
                    throw new IllegalStateException(e);
                }
            }
            try {
                return (T)task.get();
            }
            catch (InterruptedException e) {
                this.failed(e, SlaveRegistrationException.ErrorCode.UNKNOWN, DomainControllerLogger.ROOT_LOGGER.registrationTaskGotInterrupted());
                throw new IllegalStateException(e);
            }
            catch (ExecutionException e) {
                this.failed(e, SlaveRegistrationException.ErrorCode.UNKNOWN, DomainControllerLogger.ROOT_LOGGER.registrationTaskFailed(e.getMessage()));
                throw new IllegalStateException(e);
            }
        }
    }

    class InitiateRegistrationHandler
    implements ManagementRequestHandler<Void, RegistrationContext> {
        InitiateRegistrationHandler() {
        }

        public void handleRequest(DataInput input, ActiveOperation.ResultHandler<Void> resultHandler, ManagementRequestContext<RegistrationContext> context) throws IOException {
            ProtocolUtils.expectHeader((DataInput)input, (int)32);
            String hostName = input.readUTF();
            ModelNode hostInfo = new ModelNode();
            hostInfo.readExternal(input);
            final RegistrationContext registration = (RegistrationContext)context.getAttachment();
            registration.initialize(hostName, hostInfo, context);
            if (HostControllerRegistrationHandler.this.domainController.getCurrentRunningMode() == RunningMode.ADMIN_ONLY) {
                registration.failed(SlaveRegistrationException.ErrorCode.MASTER_IS_ADMIN_ONLY, DomainControllerLogger.ROOT_LOGGER.adminOnlyModeCannotAcceptSlaves(RunningMode.ADMIN_ONLY));
                return;
            }
            if (!HostControllerRegistrationHandler.this.domainController.getLocalHostInfo().isMasterDomainController()) {
                registration.failed(SlaveRegistrationException.ErrorCode.HOST_IS_NOT_MASTER, DomainControllerLogger.ROOT_LOGGER.slaveControllerCannotAcceptOtherSlaves());
                return;
            }
            context.executeAsync((ManagementRequestContext.AsyncTask)new ManagementRequestContext.AsyncTask<RegistrationContext>(){

                public void execute(ManagementRequestContext<RegistrationContext> context) throws Exception {
                    if (Thread.currentThread().isInterrupted()) {
                        throw new IllegalStateException("interrupted");
                    }
                    registration.processRegistration();
                }
            }, HostControllerRegistrationHandler.this.registrationExecutor);
        }
    }

    class RegisterSubsystemVersionsHandler
    implements ManagementRequestHandler<Void, RegistrationContext> {
        RegisterSubsystemVersionsHandler() {
        }

        public void handleRequest(DataInput input, ActiveOperation.ResultHandler<Void> resultHandler, ManagementRequestContext<RegistrationContext> context) throws IOException {
            byte status = input.readByte();
            ModelNode subsystems = new ModelNode();
            subsystems.readExternal(input);
            RegistrationContext registration = (RegistrationContext)context.getAttachment();
            if (status == 33) {
                registration.setSubsystems(subsystems, context);
            } else {
                registration.setSubsystems(null, context);
            }
        }
    }

    static class CompleteRegistrationHandler
    implements ManagementRequestHandler<Void, RegistrationContext> {
        CompleteRegistrationHandler() {
        }

        public void handleRequest(DataInput input, ActiveOperation.ResultHandler<Void> resultHandler, ManagementRequestContext<RegistrationContext> context) throws IOException {
            byte status = input.readByte();
            String message = input.readUTF();
            RegistrationContext registration = (RegistrationContext)context.getAttachment();
            registration.completeRegistration(context, status == 33);
        }
    }

    static abstract class IOTask<T>
    extends AsyncFutureTask<T> {
        IOTask() {
            super(null);
        }

        abstract void sendMessage(FlushableDataOutput var1) throws IOException;

        boolean completeStep(Object result) {
            return this.setResult(result);
        }

        boolean failed(Throwable t) {
            Assert.checkNotNullParam((String)"Throwable", (Object)t);
            return super.setFailed(t);
        }
    }

    class HostRegistrationStepHandler
    implements OperationStepHandler {
        private final TransformerRegistry transformerRegistry;
        private final RegistrationContext registrationContext;

        protected HostRegistrationStepHandler(TransformerRegistry transformerRegistry, RegistrationContext registrationContext) {
            this.registrationContext = registrationContext;
            this.transformerRegistry = transformerRegistry;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            assert (this.registrationContext != null);
            assert (this.registrationContext.activeOperation != null);
            boolean locked = false;
            final Integer operationID = this.registrationContext.activeOperation.getOperationId();
            Assert.checkNotNullParam((String)"operationID", (Object)operationID);
            try {
                boolean rejected;
                try {
                    HostControllerRegistrationHandler.this.operationExecutor.acquireReadlock(operationID);
                }
                catch (IllegalArgumentException e) {
                    throw new OperationFailedException((Throwable)e);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw ControllerLogger.ROOT_LOGGER.operationCancelledAsynchronously();
                }
                locked = true;
                if (HostControllerRegistrationHandler.this.domainController.isHostRegistered(this.registrationContext.hostName)) {
                    String failureDescription = DomainControllerLogger.ROOT_LOGGER.slaveAlreadyRegistered(this.registrationContext.hostName);
                    this.registrationContext.failed(SlaveRegistrationException.ErrorCode.HOST_ALREADY_EXISTS, failureDescription);
                    context.getFailureDescription().set(failureDescription);
                    return;
                }
                Resource root = context.readResourceFromRoot(PathAddress.EMPTY_ADDRESS.append(new PathElement[]{PathElement.pathElement((String)"extension")}), true);
                HostInfo hostInfo = this.registrationContext.hostInfo;
                int major = hostInfo.getManagementMajorVersion();
                int minor = hostInfo.getManagementMinorVersion();
                int micro = hostInfo.getManagementMicroVersion();
                ModelVersion hostVersion = ModelVersion.create((int)major, (int)minor, (int)micro);
                boolean bl = rejected = major < 16;
                if (rejected) {
                    OperationFailedException failure = HostControllerLogger.ROOT_LOGGER.unsupportedManagementVersionForHost(major, minor, 16, 0);
                    this.registrationContext.failed(failure, SlaveRegistrationException.ErrorCode.INCOMPATIBLE_VERSION, failure.getMessage());
                    throw failure;
                }
                LocalHostControllerInfo domainInfo = HostControllerRegistrationHandler.this.domainController.getLocalHostInfo();
                if (domainInfo.getStability() != hostInfo.getStability()) {
                    OperationFailedException failure = HostControllerLogger.ROOT_LOGGER.incompatibleStability(domainInfo.getStability(), hostInfo.getStability());
                    this.registrationContext.failed(failure, SlaveRegistrationException.ErrorCode.INCOMPATIBLE_VERSION, failure.getMessage());
                    throw failure;
                }
                if (!(domainInfo.getProductConfig().getDefaultStability().enables(domainInfo.getStability()) || 30 == major && 0 == minor)) {
                    OperationFailedException failure = HostControllerLogger.ROOT_LOGGER.mixedDomainUnsupportedStability(domainInfo.getStability(), 30, 0, major, minor);
                    this.registrationContext.failed(failure, SlaveRegistrationException.ErrorCode.INCOMPATIBLE_VERSION, failure.getMessage());
                    throw failure;
                }
                TransformationTargetImpl target = TransformationTargetImpl.createForHost((String)hostInfo.getHostName(), (TransformerRegistry)this.transformerRegistry, (ModelVersion)hostVersion, Collections.emptyMap(), (Transformers.OperationExcludedTransformationRegistry)hostInfo);
                Transformers transformers = Transformers.Factory.create((TransformationTarget)target);
                try {
                    SlaveChannelAttachments.attachSlaveInfo(HostControllerRegistrationHandler.this.handler.getChannel(), this.registrationContext.hostName, transformers, hostInfo.getDomainIgnoredExtensions());
                }
                catch (IOException e) {
                    throw new OperationFailedException(e.getLocalizedMessage());
                }
                ModelNode extensions = new ModelNode();
                Transformers.TransformationInputs transformationInputs = Transformers.TransformationInputs.getOrCreate((OperationContext)context);
                Resource transformed = transformers.transformRootResource(transformationInputs, root);
                Set resources = transformed.getChildren("extension");
                for (Resource.ResourceEntry entry : resources) {
                    if (hostInfo.isResourceTransformationIgnored(PathAddress.pathAddress((PathElement[])new PathElement[]{entry.getPathElement()}))) continue;
                    extensions.add(entry.getName());
                }
                if (!extensions.isDefined()) {
                    throw new OperationFailedException(extensions.toString(), extensions);
                }
                this.registrationContext.processSubsystems(transformers, extensions);
                ReadMasterDomainModelHandler handler = new ReadMasterDomainModelHandler(hostInfo, transformers, HostControllerRegistrationHandler.this.domainController.getExtensionRegistry(), false);
                context.addStep(READ_DOMAIN_MODEL.getOperation(), (OperationStepHandler)handler, OperationContext.Stage.MODEL);
                context.completeStep(new OperationContext.ResultHandler(){

                    public void handleResult(OperationContext.ResultAction resultAction, OperationContext context, ModelNode operation) {
                        try {
                            HostControllerRegistrationHandler.this.operationExecutor.releaseReadlock(operationID);
                        }
                        catch (IllegalArgumentException e) {
                            HostControllerLogger.ROOT_LOGGER.hostRegistrationCannotReleaseSharedLock(operationID);
                        }
                    }
                });
                locked = false;
            }
            finally {
                if (locked) {
                    HostControllerRegistrationHandler.this.operationExecutor.releaseReadlock(operationID);
                }
            }
        }
    }
}

