/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.parsing;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.HashUtil;
import org.jboss.as.controller.extension.ExtensionRegistry;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.parsing.Attribute;
import org.jboss.as.controller.parsing.Element;
import org.jboss.as.controller.parsing.ExtensionXml;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.parsing.ProfileParsingCompletionHandler;
import org.jboss.as.domain.controller.operations.SocketBindingGroupResourceDefinition;
import org.jboss.as.domain.controller.resources.ServerGroupResourceDefinition;
import org.jboss.as.domain.management.access.AccessAuthorizationResourceDefinition;
import org.jboss.as.domain.management.parsing.AccessControlXml;
import org.jboss.as.domain.management.parsing.ManagementXml;
import org.jboss.as.domain.management.parsing.ManagementXmlDelegate;
import org.jboss.as.host.controller.parsing.DomainSocketBindingsXml;
import org.jboss.as.host.controller.parsing.JvmXml;
import org.jboss.as.server.parsing.CommonXml;
import org.jboss.as.server.parsing.SocketBindingsXml;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;
import org.jboss.staxmapper.IntVersion;
import org.jboss.staxmapper.XMLExtendedStreamReader;

final class DomainXml_Legacy
extends CommonXml
implements ManagementXmlDelegate {
    private final AccessControlXml accessControlXml;
    private final ExtensionXml extensionXml;
    private final ExtensionRegistry extensionRegistry;
    private final IntVersion version;
    private final String namespace;

    DomainXml_Legacy(ExtensionXml extensionXml, ExtensionRegistry extensionRegistry, IntVersion version, String namespace) {
        super((SocketBindingsXml)new DomainSocketBindingsXml());
        this.accessControlXml = AccessControlXml.newInstance((String)namespace);
        this.extensionXml = extensionXml;
        this.extensionRegistry = extensionRegistry;
        this.version = version;
        this.namespace = namespace;
    }

    public void readElement(XMLExtendedStreamReader reader, List<ModelNode> nodes) throws XMLStreamException {
        if (Element.forName((String)reader.getLocalName()) != Element.DOMAIN) {
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        IntVersion cutOff1_7 = new IntVersion(new int[]{1, 7});
        if (this.version.compareTo(cutOff1_7) < 0) {
            throw ParseUtils.unsupportedNamespace((XMLExtendedStreamReader)reader);
        }
        this.readDomainElement1_7(reader, new ModelNode(), nodes);
    }

    private void readDomainElement1_7(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
        this.parseNamespaces(reader, address, list);
        this.readDomainElementAttributes_1_7(reader, address, list);
        Element element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (String)this.namespace);
        if (element == Element.EXTENSIONS) {
            this.extensionXml.parseExtensions(reader, address, this.namespace, list);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (String)this.namespace);
        }
        if (element == Element.SYSTEM_PROPERTIES) {
            this.parseSystemProperties(reader, address, this.namespace, list, false);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (String)this.namespace);
        }
        if (element == Element.PATHS) {
            this.parsePaths(reader, address, this.namespace, list, false);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (String)this.namespace);
        }
        if (element == Element.MANAGEMENT) {
            ManagementXml managementXml = ManagementXml.newInstance((IntVersion)this.version, (String)this.namespace, (ManagementXmlDelegate)this, (boolean)true);
            managementXml.parseManagement(reader, address, list, false);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (String)this.namespace);
        }
        if (element == Element.PROFILES) {
            this.parseProfiles(reader, address, list);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (String)this.namespace);
        }
        HashSet<String> interfaceNames = new HashSet<String>();
        if (element == Element.INTERFACES) {
            this.parseInterfaces(reader, interfaceNames, address, this.version, this.namespace, list, false);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (String)this.namespace);
        }
        if (element == Element.SOCKET_BINDING_GROUPS) {
            this.parseDomainSocketBindingGroups(reader, address, list, interfaceNames);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (String)this.namespace);
        }
        if (element == Element.DEPLOYMENTS) {
            this.parseDeployments(reader, address, this.namespace, list, EnumSet.of(Attribute.NAME, Attribute.RUNTIME_NAME), EnumSet.of(Element.CONTENT, Element.FS_ARCHIVE, Element.FS_EXPLODED), false);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (String)this.namespace);
        }
        if (element == Element.DEPLOYMENT_OVERLAYS) {
            this.parseDeploymentOverlays(reader, this.namespace, new ModelNode(), list, true, false);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (String)this.namespace);
        }
        if (element == Element.SERVER_GROUPS) {
            this.parseServerGroups(reader, address, list);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (String)this.namespace);
        }
        if (element == Element.MANAGEMENT_CLIENT_CONTENT) {
            this.parseManagementClientContent(reader, address, list);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (String)this.namespace);
        } else if (element == null) {
            this.initializeRolloutPlans(address, list);
        } else {
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void readDomainElementAttributes_1_7(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
        int count = reader.getAttributeCount();
        block7: for (int i = 0; i < count; ++i) {
            if (ParseUtils.isXmlNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                switch (Attribute.forName((String)reader.getAttributeLocalName(i))) {
                    case SCHEMA_LOCATION: {
                        this.parseSchemaLocations(reader, address, list, i);
                        continue block7;
                    }
                    case NO_NAMESPACE_SCHEMA_LOCATION: {
                        continue block7;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
            switch (Attribute.forName((String)reader.getAttributeLocalName(i))) {
                case NAME: {
                    ModelNode op = new ModelNode();
                    op.get("operation").set("write-attribute");
                    op.get("name").set("name");
                    op.get("value").set(ParseUtils.parsePossibleExpression((String)reader.getAttributeValue(i)));
                    list.add(op);
                    continue block7;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
    }

    private void parseDomainSocketBindingGroups(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list, Set<String> interfaces) throws XMLStreamException {
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (String)this.namespace);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case SOCKET_BINDING_GROUP: {
                    this.parseSocketBindingGroup_1_7(reader, interfaces, address, list);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseSocketBindingGroup_1_7(XMLExtendedStreamReader reader, Set<String> interfaces, ModelNode address, List<ModelNode> updates) throws XMLStreamException {
        HashSet<String> uniqueBindingNames = new HashSet<String>();
        String[] attrValues = ParseUtils.requireAttributes((XMLExtendedStreamReader)reader, (String[])new String[]{Attribute.NAME.getLocalName(), Attribute.DEFAULT_INTERFACE.getLocalName()});
        String socketBindingGroupName = attrValues[0];
        String defaultInterface = attrValues[1];
        ModelNode groupAddress = new ModelNode().set(address);
        groupAddress.add("socket-binding-group", socketBindingGroupName);
        ModelNode bindingGroupUpdate = new ModelNode();
        bindingGroupUpdate.get("address").set(groupAddress);
        bindingGroupUpdate.get("operation").set("add");
        SocketBindingGroupResourceDefinition.DEFAULT_INTERFACE.parseAndSetParameter(defaultInterface, bindingGroupUpdate, (XMLStreamReader)reader);
        if (bindingGroupUpdate.get(SocketBindingGroupResourceDefinition.DEFAULT_INTERFACE.getName()).getType() != ModelType.EXPRESSION && !interfaces.contains(defaultInterface)) {
            throw ControllerLogger.ROOT_LOGGER.unknownInterface(defaultInterface, Attribute.DEFAULT_INTERFACE.getLocalName(), Element.INTERFACES.getLocalName(), reader.getLocation());
        }
        updates.add(bindingGroupUpdate);
        block4: while (reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (String)this.namespace);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case SOCKET_BINDING: {
                    String bindingName = this.parseSocketBinding(reader, interfaces, groupAddress, updates);
                    if (uniqueBindingNames.add(bindingName)) continue block4;
                    throw ControllerLogger.ROOT_LOGGER.alreadyDeclared(Element.SOCKET_BINDING.getLocalName(), Element.OUTBOUND_SOCKET_BINDING.getLocalName(), bindingName, Element.SOCKET_BINDING_GROUP.getLocalName(), socketBindingGroupName, reader.getLocation());
                }
                case OUTBOUND_SOCKET_BINDING: {
                    String bindingName = this.parseOutboundSocketBinding(reader, interfaces, groupAddress, updates);
                    if (uniqueBindingNames.add(bindingName)) continue block4;
                    throw ControllerLogger.ROOT_LOGGER.alreadyDeclared(Element.SOCKET_BINDING.getLocalName(), Element.OUTBOUND_SOCKET_BINDING.getLocalName(), bindingName, Element.SOCKET_BINDING_GROUP.getLocalName(), socketBindingGroupName, reader.getLocation());
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseServerGroups(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        HashSet<String> names = new HashSet<String>();
        while (reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (String)this.namespace);
            Element serverGroup = Element.forName((String)reader.getLocalName());
            if (Element.SERVER_GROUP != serverGroup) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            ModelNode groupAddOp = new ModelNode();
            groupAddOp.get("operation").set("add");
            groupAddOp.get("address");
            String name = null;
            EnumSet<Attribute> required = EnumSet.of(Attribute.NAME, Attribute.PROFILE);
            int count = reader.getAttributeCount();
            block13: for (int i = 0; i < count; ++i) {
                String value = reader.getAttributeValue(i);
                if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
                Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
                required.remove(attribute);
                switch (attribute) {
                    case NAME: {
                        if (!names.add(value)) {
                            throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, (String)value);
                        }
                        name = value;
                        continue block13;
                    }
                    case PROFILE: {
                        ServerGroupResourceDefinition.PROFILE.parseAndSetParameter(value, groupAddOp, (XMLStreamReader)reader);
                        continue block13;
                    }
                    case MANAGEMENT_SUBSYSTEM_ENDPOINT: {
                        ServerGroupResourceDefinition.MANAGEMENT_SUBSYSTEM_ENDPOINT.parseAndSetParameter(value, groupAddOp, (XMLStreamReader)reader);
                        continue block13;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
            if (!required.isEmpty()) {
                throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
            }
            ModelNode groupAddress = new ModelNode().set(address);
            groupAddress.add("server-group", name);
            groupAddOp.get("address").set(groupAddress);
            list.add(groupAddOp);
            boolean sawDeployments = false;
            block14: while (reader.hasNext() && reader.nextTag() != 2) {
                ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (String)this.namespace);
                Element element = Element.forName((String)reader.getLocalName());
                switch (element) {
                    case JVM: {
                        JvmXml.parseJvm(reader, groupAddress, this.version, this.namespace, list, new HashSet<String>(), false);
                        continue block14;
                    }
                    case SOCKET_BINDING_GROUP: {
                        IntVersion version3_0 = new IntVersion(new int[]{3, 0});
                        if (this.version.compareTo(version3_0) < 0) {
                            this.parseSocketBindingGroupRef(reader, groupAddOp, ServerGroupResourceDefinition.SOCKET_BINDING_GROUP, ServerGroupResourceDefinition.SOCKET_BINDING_PORT_OFFSET, null);
                            continue block14;
                        }
                        this.parseSocketBindingGroupRef(reader, groupAddOp, ServerGroupResourceDefinition.SOCKET_BINDING_GROUP, ServerGroupResourceDefinition.SOCKET_BINDING_PORT_OFFSET, ServerGroupResourceDefinition.SOCKET_BINDING_DEFAULT_INTERFACE);
                        continue block14;
                    }
                    case DEPLOYMENTS: {
                        if (sawDeployments) {
                            throw ControllerLogger.ROOT_LOGGER.alreadyDefined(element.getLocalName(), reader.getLocation());
                        }
                        sawDeployments = true;
                        ArrayList deployments = new ArrayList();
                        this.parseDeployments(reader, groupAddress, this.namespace, deployments, EnumSet.of(Attribute.NAME, Attribute.RUNTIME_NAME, Attribute.ENABLED), Collections.emptySet(), true);
                        list.addAll(deployments);
                        continue block14;
                    }
                    case DEPLOYMENT_OVERLAYS: {
                        this.parseDeploymentOverlays(reader, this.namespace, groupAddress, list, false, true);
                        continue block14;
                    }
                    case SYSTEM_PROPERTIES: {
                        this.parseSystemProperties(reader, groupAddress, this.namespace, list, false);
                        continue block14;
                    }
                }
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
        }
    }

    private void parseProfiles(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        HashSet<String> names = new HashSet<String>();
        while (reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (String)this.namespace);
            Element element = Element.forName((String)reader.getLocalName());
            if (Element.PROFILE != element) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            ParseUtils.requireSingleAttribute((XMLExtendedStreamReader)reader, (String)Attribute.NAME.getLocalName());
            String name = reader.getAttributeValue(0);
            if (!names.add(name)) {
                throw ControllerLogger.ROOT_LOGGER.duplicateDeclaration("profile", name, reader.getLocation());
            }
            LinkedHashMap profileOps = new LinkedHashMap();
            while (reader.nextTag() != 2) {
                String readerNamespace = reader.getNamespaceURI();
                if (readerNamespace != null && !"http://www.w3.org/2001/XMLSchema-instance".equals(readerNamespace) && !this.namespace.equals(readerNamespace)) {
                    if (Element.forName((String)reader.getLocalName()) != Element.SUBSYSTEM) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    String namespace = reader.getNamespaceURI();
                    if (profileOps.containsKey(namespace)) {
                        throw ControllerLogger.ROOT_LOGGER.duplicateDeclaration("subsystem", name, reader.getLocation());
                    }
                    ArrayList subsystems = new ArrayList();
                    reader.handleAny(subsystems);
                    profileOps.put(namespace, subsystems);
                    continue;
                }
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            Set completionHandlers = this.extensionRegistry.getProfileParsingCompletionHandlers();
            for (ProfileParsingCompletionHandler completionHandler : completionHandlers) {
                completionHandler.handleProfileParsingCompletion(profileOps, list);
            }
            ModelNode profile = new ModelNode();
            profile.get("operation").set("add");
            profile.get("address").set(address).add("profile", name);
            list.add(profile);
            for (List subsystems : profileOps.values()) {
                for (ModelNode update : subsystems) {
                    ModelNode subsystemAddress = address.clone().set(address).add("profile", name);
                    for (Property path : update.get("address").asPropertyList()) {
                        subsystemAddress.add(path.getName(), path.getValue().asString());
                    }
                    update.get("address").set(subsystemAddress);
                    list.add(update);
                }
            }
        }
    }

    private void parseManagementClientContent(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        boolean rolloutPlansAdded = false;
        block3: while (reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (String)this.namespace);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case ROLLOUT_PLANS: {
                    this.parseRolloutPlans(reader, address, list);
                    rolloutPlansAdded = true;
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        if (!rolloutPlansAdded) {
            this.initializeRolloutPlans(address, list);
        }
    }

    private void parseRolloutPlans(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
        String hash = ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)Attribute.SHA1.getLocalName());
        ModelNode addAddress = address.clone().add("management-client-content", "rollout-plans");
        ModelNode addOp = Util.getEmptyOperation((String)"add", (ModelNode)addAddress);
        try {
            addOp.get("hash").set(HashUtil.hexStringToByteArray((String)hash));
        }
        catch (Exception e) {
            throw ControllerLogger.ROOT_LOGGER.invalidSha1Value((Throwable)e, hash, Attribute.SHA1.getLocalName(), reader.getLocation());
        }
        list.add(addOp);
    }

    private void initializeRolloutPlans(ModelNode address, List<ModelNode> list) {
        ModelNode addAddress = address.clone().add("management-client-content", "rollout-plans");
        ModelNode addOp = Util.getEmptyOperation((String)"add", (ModelNode)addAddress);
        list.add(addOp);
    }

    public boolean parseAccessControl(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> operationsList) throws XMLStreamException {
        ModelNode accAuthzAddr = address.clone().add("access", "authorization");
        int count = reader.getAttributeCount();
        for (int i = 0; i < count; ++i) {
            ModelNode op;
            ModelNode provider;
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            if (attribute == Attribute.PROVIDER) {
                provider = DomainXml_Legacy.parseAttributeValue((AttributeDefinition)AccessAuthorizationResourceDefinition.PROVIDER, (String)value, (XMLExtendedStreamReader)reader);
                op = Util.getWriteAttributeOperation((ModelNode)accAuthzAddr, (String)AccessAuthorizationResourceDefinition.PROVIDER.getName(), (ModelNode)provider);
                operationsList.add(op);
                continue;
            }
            if (attribute == Attribute.PERMISSION_COMBINATION_POLICY) {
                provider = DomainXml_Legacy.parseAttributeValue((AttributeDefinition)AccessAuthorizationResourceDefinition.PERMISSION_COMBINATION_POLICY, (String)value, (XMLExtendedStreamReader)reader);
                op = Util.getWriteAttributeOperation((ModelNode)accAuthzAddr, (String)AccessAuthorizationResourceDefinition.PERMISSION_COMBINATION_POLICY.getName(), (ModelNode)provider);
                operationsList.add(op);
                continue;
            }
            throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
        }
        block7: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (String)this.namespace);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case ROLE_MAPPING: {
                    this.accessControlXml.parseAccessControlRoleMapping(reader, accAuthzAddr, operationsList);
                    continue block7;
                }
                case SERVER_GROUP_SCOPED_ROLES: {
                    this.accessControlXml.parseServerGroupScopedRoles(reader, accAuthzAddr, operationsList);
                    continue block7;
                }
                case HOST_SCOPED_ROLES: {
                    this.accessControlXml.parseHostScopedRoles(reader, accAuthzAddr, operationsList);
                    continue block7;
                }
                case CONSTRAINTS: {
                    this.accessControlXml.parseAccessControlConstraints(reader, accAuthzAddr, operationsList);
                    continue block7;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        return true;
    }
}

