/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.operations;

import java.util.Locale;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.RunningMode;
import org.jboss.as.controller.client.helpers.domain.ServerStatus;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.host.controller.ServerInventory;
import org.jboss.as.host.controller.logging.HostControllerLogger;
import org.jboss.as.server.controller.resources.ServerRootResourceDefinition;
import org.jboss.dmr.ModelNode;

public class ServerStartHandler
implements OperationStepHandler {
    private final ServerInventory serverInventory;

    public ServerStartHandler(ServerInventory serverInventory) {
        this.serverInventory = serverInventory;
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        if (context.getRunningMode() == RunningMode.ADMIN_ONLY) {
            throw new OperationFailedException(HostControllerLogger.ROOT_LOGGER.cannotStartServersInvalidMode(context.getRunningMode()));
        }
        final String serverName = context.getCurrentAddressValue();
        final boolean blocking = ServerRootResourceDefinition.BLOCKING.resolveModelAttribute(context, operation).asBoolean();
        final boolean suspend = ServerRootResourceDefinition.START_MODE.resolveModelAttribute(context, operation).asString().toLowerCase(Locale.ENGLISH).equals("suspend");
        final ModelNode model = Resource.Tools.readModel((Resource)context.readResourceFromRoot(PathAddress.EMPTY_ADDRESS, true));
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                context.getServiceRegistry(true);
                final ServerStatus origStatus = ServerStartHandler.this.serverInventory.determineServerStatus(serverName);
                if (origStatus != ServerStatus.STARTED && origStatus != ServerStatus.STARTING) {
                    ServerStatus status = ServerStartHandler.this.serverInventory.startServer(serverName, model, blocking, suspend);
                    this.persistAutoStart(context);
                    context.getResult().set(status.toString());
                } else {
                    context.getResult().set(origStatus.toString());
                }
                context.completeStep(new OperationContext.RollbackHandler(){

                    public void handleRollback(OperationContext context, ModelNode operation) {
                        if (origStatus != ServerStatus.STARTED && origStatus != ServerStatus.STARTING) {
                            ServerStartHandler.this.serverInventory.stopServer(serverName, -1);
                            this.persistAutoStart(context);
                        }
                    }
                });
            }

            private void persistAutoStart(OperationContext context) {
                context.readResource(PathAddress.EMPTY_ADDRESS, false).getModel();
            }
        }, OperationContext.Stage.RUNTIME);
    }
}

