/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.operations.deployment;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.operations.CompositeOperationAwareTransmuter;
import org.jboss.as.controller.operations.OperationAttachments;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.domain.controller.logging.DomainControllerLogger;
import org.jboss.as.repository.ContentRepository;
import org.jboss.as.repository.ExplodedContent;
import org.jboss.as.repository.ExplodedContentException;
import org.jboss.as.repository.HostFileRepository;
import org.jboss.as.server.controller.resources.DeploymentAttributes;
import org.jboss.as.server.deployment.DeploymentHandlerUtil;
import org.jboss.as.server.deployment.DeploymentHandlerUtils;
import org.jboss.as.server.deployment.ModelContentReference;
import org.jboss.dmr.ModelNode;

class DeploymentUploadUtil {
    private DeploymentUploadUtil() {
    }

    public static byte[] storeContentAndTransformOperation(OperationContext context, ModelNode operation, ContentRepository contentRepository) throws IOException, OperationFailedException {
        if (!operation.hasDefined("content")) {
            throw DeploymentUploadUtil.createFailureException(DomainControllerLogger.ROOT_LOGGER.invalidContentDeclaration());
        }
        ModelNode content = operation.get("content").get(0);
        if (content.hasDefined("hash")) {
            throw DeploymentUploadUtil.createFailureException(DomainControllerLogger.ROOT_LOGGER.invalidContentDeclaration());
        }
        byte[] hash = DeploymentUploadUtil.storeDeploymentContent(context, operation, contentRepository);
        ModelNode slave = operation.clone();
        slave.get("content").setEmptyList().add().get("hash").set(hash);
        ArrayList<CompositeOperationAwareTransmuter> transformers = (ArrayList<CompositeOperationAwareTransmuter>)context.getAttachment(OperationAttachments.SLAVE_SERVER_OPERATION_TRANSMUTERS);
        if (transformers == null) {
            transformers = new ArrayList<CompositeOperationAwareTransmuter>();
            context.attach(OperationAttachments.SLAVE_SERVER_OPERATION_TRANSMUTERS, transformers);
        }
        transformers.add(new CompositeOperationAwareTransmuter(slave));
        return hash;
    }

    public static byte[] storeEmptyContentAndTransformOperation(OperationContext context, ModelNode operation, ContentRepository contentRepository) throws OperationFailedException {
        byte[] hash = DeploymentUploadUtil.storeEmptyDeploymentContent(context, contentRepository);
        ModelNode slave = operation.clone();
        slave.remove(DeploymentAttributes.EMPTY.getName());
        ModelNode contentItemNode = new ModelNode();
        contentItemNode.get(DeploymentAttributes.CONTENT_HASH.getName()).set(hash);
        contentItemNode.get(DeploymentAttributes.CONTENT_ARCHIVE.getName()).set(false);
        slave.get("content").setEmptyList().add(contentItemNode);
        ArrayList<CompositeOperationAwareTransmuter> transformers = (ArrayList<CompositeOperationAwareTransmuter>)context.getAttachment(OperationAttachments.SLAVE_SERVER_OPERATION_TRANSMUTERS);
        if (transformers == null) {
            transformers = new ArrayList<CompositeOperationAwareTransmuter>();
            context.attach(OperationAttachments.SLAVE_SERVER_OPERATION_TRANSMUTERS, transformers);
        }
        transformers.add(new CompositeOperationAwareTransmuter(slave));
        return hash;
    }

    public static byte[] explodeContentAndTransformOperation(OperationContext context, ModelNode operation, ContentRepository contentRepository) throws OperationFailedException, ExplodedContentException {
        Resource deploymentResource = context.readResource(PathAddress.EMPTY_ADDRESS);
        ModelNode contentItem = DeploymentHandlerUtil.getContentItem((Resource)deploymentResource);
        ModelNode explodedPath = DeploymentAttributes.DEPLOYMENT_CONTENT_PATH.resolveModelAttribute(context, operation);
        byte[] oldHash = DeploymentAttributes.CONTENT_HASH.resolveModelAttribute(context, contentItem).asBytes();
        byte[] hash = explodedPath.isDefined() ? contentRepository.explodeSubContent(oldHash, explodedPath.asString()) : contentRepository.explodeContent(oldHash);
        ModelNode slave = operation.clone();
        ModelNode addedContent = new ModelNode().setEmptyObject();
        addedContent.get("hash").set(hash);
        addedContent.get(DeploymentAttributes.TARGET_PATH.getName()).set("./");
        slave.get("content").setEmptyList().add(addedContent);
        ArrayList<CompositeOperationAwareTransmuter> transformers = (ArrayList<CompositeOperationAwareTransmuter>)context.getAttachment(OperationAttachments.SLAVE_SERVER_OPERATION_TRANSMUTERS);
        if (transformers == null) {
            transformers = new ArrayList<CompositeOperationAwareTransmuter>();
            context.attach(OperationAttachments.SLAVE_SERVER_OPERATION_TRANSMUTERS, transformers);
        }
        transformers.add(new CompositeOperationAwareTransmuter(slave));
        return hash;
    }

    public static byte[] addContentToExplodedAndTransformOperation(OperationContext context, ModelNode operation, ContentRepository contentRepository) throws OperationFailedException, ExplodedContentException {
        Resource deploymentResource = context.readResource(PathAddress.EMPTY_ADDRESS);
        ModelNode contentItem = DeploymentHandlerUtil.getContentItem((Resource)deploymentResource);
        byte[] oldHash = DeploymentAttributes.CONTENT_HASH.resolveModelAttribute(context, contentItem).asBytes();
        List contents = DeploymentAttributes.CONTENT_PARAM_ALL_EXPLODED.resolveModelAttribute(context, operation).asList();
        ArrayList<ExplodedContent> addedFiles = new ArrayList<ExplodedContent>(contents.size());
        ModelNode slave = operation.clone();
        ModelNode slaveAddedfiles = slave.get(DeploymentAttributes.UPDATED_PATHS.getName()).setEmptyList();
        for (ModelNode content : contents) {
            InputStream in = DeploymentHandlerUtils.hasValidContentAdditionParameterDefined((ModelNode)content) ? DeploymentUploadUtil.getInputStream(context, content) : null;
            String path = DeploymentAttributes.TARGET_PATH.resolveModelAttribute(context, content).asString();
            addedFiles.add(new ExplodedContent(path, in));
            slaveAddedfiles.add(path);
        }
        boolean overwrite = DeploymentAttributes.OVERWRITE.resolveModelAttribute(context, operation).asBoolean(true);
        byte[] hash = contentRepository.addContentToExploded(oldHash, addedFiles, overwrite);
        ModelNode addedContent = new ModelNode().setEmptyObject();
        addedContent.get("hash").set(hash);
        addedContent.get(DeploymentAttributes.TARGET_PATH.getName()).set(".");
        slave.get("content").setEmptyList().add(addedContent);
        ArrayList<CompositeOperationAwareTransmuter> transformers = (ArrayList<CompositeOperationAwareTransmuter>)context.getAttachment(OperationAttachments.SLAVE_SERVER_OPERATION_TRANSMUTERS);
        if (transformers == null) {
            transformers = new ArrayList<CompositeOperationAwareTransmuter>();
            context.attach(OperationAttachments.SLAVE_SERVER_OPERATION_TRANSMUTERS, transformers);
        }
        transformers.add(new CompositeOperationAwareTransmuter(slave));
        return hash;
    }

    public static byte[] removeContentFromExplodedAndTransformOperation(OperationContext context, ModelNode operation, ContentRepository contentRepository) throws OperationFailedException, ExplodedContentException {
        Resource deploymentResource = context.readResource(PathAddress.EMPTY_ADDRESS);
        ModelNode contentItemNode = DeploymentHandlerUtil.getContentItem((Resource)deploymentResource);
        byte[] oldHash = DeploymentAttributes.CONTENT_HASH.resolveModelAttribute(context, contentItemNode).asBytes();
        List paths = DeploymentAttributes.REMOVED_PATHS.unwrap((ExpressionResolver)context, operation);
        byte[] hash = contentRepository.removeContentFromExploded(oldHash, paths);
        ModelNode slave = operation.clone();
        slave.get("content").setEmptyList().add().get("hash").set(hash);
        slave.get("content").add().get("archive").set(false);
        ArrayList<CompositeOperationAwareTransmuter> transformers = (ArrayList<CompositeOperationAwareTransmuter>)context.getAttachment(OperationAttachments.SLAVE_SERVER_OPERATION_TRANSMUTERS);
        if (transformers == null) {
            transformers = new ArrayList<CompositeOperationAwareTransmuter>();
            context.attach(OperationAttachments.SLAVE_SERVER_OPERATION_TRANSMUTERS, transformers);
        }
        transformers.add(new CompositeOperationAwareTransmuter(slave));
        return hash;
    }

    public static byte[] synchronizeSlaveHostController(ModelNode operation, PathAddress address, HostFileRepository fileRepository, ContentRepository contentRepository, boolean backup, byte[] oldHash) {
        ModelNode operationContentItem = operation.get(DeploymentAttributes.CONTENT_RESOURCE_ALL.getName()).get(0);
        byte[] newHash = operationContentItem.require(DeploymentAttributes.CONTENT_HASH.getName()).asBytes();
        if (DeploymentUploadUtil.needRemoteContent(fileRepository, contentRepository, backup, oldHash)) {
            fileRepository.getDeploymentFiles(ModelContentReference.fromModelAddress((PathAddress)address, (byte[])newHash));
        }
        return newHash;
    }

    private static boolean needRemoteContent(HostFileRepository fileRepository, ContentRepository contentRepository, boolean backup, byte[] oldHash) {
        return fileRepository != null && (backup || contentRepository != null && contentRepository.hasContent(oldHash));
    }

    private static byte[] storeDeploymentContent(OperationContext context, ModelNode operation, ContentRepository contentRepository) throws IOException, OperationFailedException {
        try (InputStream in = DeploymentUploadUtil.getContents(context, operation);){
            byte[] byArray = contentRepository.addContent(in);
            return byArray;
        }
    }

    private static byte[] storeEmptyDeploymentContent(OperationContext context, ContentRepository contentRepository) throws OperationFailedException {
        try {
            return contentRepository.addContent(null);
        }
        catch (IOException e) {
            throw DeploymentUploadUtil.createFailureException(e.toString());
        }
    }

    private static InputStream getContents(OperationContext context, ModelNode operation) throws OperationFailedException {
        if (!operation.hasDefined("content")) {
            throw DeploymentUploadUtil.createFailureException(DomainControllerLogger.ROOT_LOGGER.invalidContentDeclaration());
        }
        return DeploymentUploadUtil.getInputStream(context, operation.require("content").get(0));
    }

    private static InputStream getInputStream(OperationContext context, ModelNode content) throws OperationFailedException {
        InputStream in = null;
        String message = "";
        if (content.hasDefined("input-stream-index")) {
            int streamIndex = content.get("input-stream-index").asInt();
            if (streamIndex > context.getAttachmentStreamCount() - 1) {
                message = DomainControllerLogger.ROOT_LOGGER.invalidValue("input-stream-index", streamIndex, context.getAttachmentStreamCount() - 1);
                throw DeploymentUploadUtil.createFailureException(message);
            }
            message = DomainControllerLogger.ROOT_LOGGER.nullStream(streamIndex);
            in = context.getAttachmentStream(streamIndex);
        } else if (content.hasDefined("bytes")) {
            in = new ByteArrayInputStream(content.get("bytes").asBytes());
            message = DomainControllerLogger.ROOT_LOGGER.invalidByteStream();
        } else if (content.hasDefined("url")) {
            String urlSpec = content.get("url").asString();
            try {
                message = DomainControllerLogger.ROOT_LOGGER.invalidUrlStream();
                in = new URL(urlSpec).openStream();
            }
            catch (MalformedURLException e) {
                throw DeploymentUploadUtil.createFailureException(message);
            }
            catch (IOException e) {
                throw DeploymentUploadUtil.createFailureException(message);
            }
        }
        if (in == null) {
            throw DeploymentUploadUtil.createFailureException(message);
        }
        return in;
    }

    private static OperationFailedException createFailureException(String msg) {
        return new OperationFailedException(msg);
    }
}

