/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.operations;

import java.util.Collections;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.RunningMode;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.host.controller.ServerInventory;
import org.jboss.as.host.controller.descriptions.HostResolver;
import org.jboss.as.host.controller.logging.HostControllerLogger;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class ServerSuspendHandler
implements OperationStepHandler {
    public static final String OPERATION_NAME = "suspend";
    private static final AttributeDefinition TIMEOUT = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("timeout", ModelType.INT, true).setDefaultValue(new ModelNode(0))).build();
    public static final OperationDefinition DEFINITION = ServerSuspendHandler.getOperationDefinition();
    private final ServerInventory serverInventory;

    public ServerSuspendHandler(ServerInventory serverInventory) {
        this.serverInventory = serverInventory;
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        if (context.getRunningMode() == RunningMode.ADMIN_ONLY) {
            throw new OperationFailedException(HostControllerLogger.ROOT_LOGGER.cannotStartServersInvalidMode(context.getRunningMode()));
        }
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
        PathElement element = address.getLastElement();
        final String serverName = element.getValue();
        final int timeout = TIMEOUT.resolveModelAttribute(context, operation).asInt();
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                context.getServiceRegistry(true);
                if (timeout != 0) {
                    ServerSuspendHandler.this.serverInventory.awaitServerSuspend(Collections.singleton(serverName), timeout);
                } else {
                    ServerSuspendHandler.this.serverInventory.suspendServer(serverName);
                }
            }
        }, OperationContext.Stage.RUNTIME);
    }

    static OperationDefinition getOperationDefinition() {
        assert (TIMEOUT != null);
        return new SimpleOperationDefinitionBuilder(OPERATION_NAME, HostResolver.getResolver("host.server")).setParameters(new AttributeDefinition[]{TIMEOUT}).setRuntimeOnly().withFlag(OperationEntry.Flag.HOST_CONTROLLER_ONLY).build();
    }
}

