/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller;

import java.io.IOException;
import java.net.URI;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Base64;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.RealmCallback;
import org.jboss.as.controller.CurrentOperationIdHolder;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.ProxyController;
import org.jboss.as.controller.client.helpers.domain.ServerStatus;
import org.jboss.as.controller.extension.ExtensionRegistry;
import org.jboss.as.controller.remote.TransactionalProtocolClient;
import org.jboss.as.controller.transform.TransformationTarget;
import org.jboss.as.controller.transform.TransformationTargetImpl;
import org.jboss.as.controller.transform.TransformerRegistry;
import org.jboss.as.domain.controller.DomainController;
import org.jboss.as.host.controller.HostControllerEnvironment;
import org.jboss.as.host.controller.ManagedServer;
import org.jboss.as.host.controller.ManagedServerBootCmdFactory;
import org.jboss.as.host.controller.ServerInventory;
import org.jboss.as.host.controller.logging.HostControllerLogger;
import org.jboss.as.process.ProcessControllerClient;
import org.jboss.as.process.ProcessInfo;
import org.jboss.as.process.ProcessMessageHandler;
import org.jboss.as.protocol.mgmt.ManagementChannelHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.remoting3.Channel;
import org.jboss.remoting3.CloseHandler;
import org.jboss.sasl.callback.DigestHashCallback;
import org.jboss.sasl.callback.VerifyPasswordCallback;
import org.jboss.sasl.util.UsernamePasswordHashUtil;

public class ServerInventoryImpl
implements ServerInventory {
    private final ConcurrentMap<String, ManagedServer> servers = new ConcurrentHashMap<String, ManagedServer>();
    private final HostControllerEnvironment environment;
    private final ProcessControllerClient processControllerClient;
    private final URI managementURI;
    private final DomainController domainController;
    private final ExtensionRegistry extensionRegistry;
    private volatile boolean shutdown;
    private volatile boolean connectionFinished;
    private volatile CountDownLatch processInventoryLatch;
    private volatile Map<String, ProcessInfo> processInfos;
    private final Object shutdownCondition = new Object();

    ServerInventoryImpl(DomainController domainController, HostControllerEnvironment environment, URI managementURI, ProcessControllerClient processControllerClient, ExtensionRegistry extensionRegistry) {
        this.domainController = domainController;
        this.environment = environment;
        this.managementURI = managementURI;
        this.processControllerClient = processControllerClient;
        this.extensionRegistry = extensionRegistry;
    }

    @Override
    public String getServerProcessName(String serverName) {
        return ManagedServer.getServerProcessName(serverName);
    }

    @Override
    public String getProcessServerName(String processName) {
        return ManagedServer.getServerName(processName);
    }

    @Override
    public synchronized Map<String, ProcessInfo> determineRunningProcesses() {
        this.processInventoryLatch = new CountDownLatch(1);
        try {
            this.processControllerClient.requestProcessInventory();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            if (!this.processInventoryLatch.await(30L, TimeUnit.SECONDS)) {
                throw HostControllerLogger.ROOT_LOGGER.couldNotGetServerInventory(30L, TimeUnit.SECONDS.toString().toLowerCase(Locale.US));
            }
        }
        catch (InterruptedException e) {
            throw HostControllerLogger.ROOT_LOGGER.couldNotGetServerInventory(30L, TimeUnit.SECONDS.toString().toLowerCase(Locale.US));
        }
        return this.processInfos;
    }

    @Override
    public Map<String, ProcessInfo> determineRunningProcesses(boolean serversOnly) {
        Map<String, ProcessInfo> processInfos = this.determineRunningProcesses();
        if (!serversOnly) {
            return processInfos;
        }
        HashMap<String, ProcessInfo> processes = new HashMap<String, ProcessInfo>();
        for (Map.Entry<String, ProcessInfo> procEntry : processInfos.entrySet()) {
            if (!ManagedServer.isServerProcess(procEntry.getKey())) continue;
            processes.put(procEntry.getKey(), procEntry.getValue());
        }
        return processes;
    }

    @Override
    public ServerStatus determineServerStatus(String serverName) {
        ManagedServer server = (ManagedServer)this.servers.get(serverName);
        if (server == null) {
            return ServerStatus.STOPPED;
        }
        return server.getState();
    }

    @Override
    public ServerStatus startServer(String serverName, ModelNode domainModel) {
        return this.startServer(serverName, domainModel, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServerStatus startServer(String serverName, ModelNode domainModel, boolean blocking) {
        if (this.shutdown || this.connectionFinished) {
            throw HostControllerLogger.ROOT_LOGGER.hostAlreadyShutdown();
        }
        ManagedServer server = (ManagedServer)this.servers.get(serverName);
        if (server != null && server.getState() == ServerStatus.FAILED) {
            HostControllerLogger.ROOT_LOGGER.failedToStartServer(null, serverName);
            this.stopServer(serverName, 1000, true);
            server = null;
        }
        if (server == null) {
            byte[] authBytes = new byte[16];
            new Random(new SecureRandom().nextLong()).nextBytes(authBytes);
            String authKey = Base64.getEncoder().encodeToString(authBytes);
            ManagedServer newServer = this.createManagedServer(serverName, authKey);
            server = this.servers.putIfAbsent(serverName, newServer);
            if (server == null) {
                server = newServer;
            }
        }
        server.start(this.createBootFactory(serverName, domainModel));
        Object object = this.shutdownCondition;
        synchronized (object) {
            this.shutdownCondition.notifyAll();
        }
        if (blocking) {
            server.awaitState(ManagedServer.InternalState.SERVER_STARTED);
        } else {
            server.awaitState(ManagedServer.InternalState.SERVER_STARTING);
        }
        return server.getState();
    }

    @Override
    public ServerStatus restartServer(String serverName, int gracefulTimeout, ModelNode domainModel) {
        return this.restartServer(serverName, gracefulTimeout, domainModel, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServerStatus restartServer(String serverName, int gracefulTimeout, ModelNode domainModel, boolean blocking) {
        this.stopServer(serverName, gracefulTimeout);
        Object object = this.shutdownCondition;
        synchronized (object) {
            while (true) {
                if (this.shutdown || this.connectionFinished) {
                    throw HostControllerLogger.ROOT_LOGGER.hostAlreadyShutdown();
                }
                if (!this.servers.containsKey(serverName)) break;
                try {
                    this.shutdownCondition.wait();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    break;
                }
            }
        }
        this.startServer(serverName, domainModel, blocking);
        return this.determineServerStatus(serverName);
    }

    @Override
    public ServerStatus stopServer(String serverName, int gracefulTimeout) {
        return this.stopServer(serverName, gracefulTimeout, false);
    }

    @Override
    public ServerStatus stopServer(String serverName, int gracefulTimeout, boolean blocking) {
        ManagedServer server = (ManagedServer)this.servers.get(serverName);
        if (server == null) {
            return ServerStatus.STOPPED;
        }
        Integer currentOperationID = CurrentOperationIdHolder.getCurrentOperationID();
        server.stop(currentOperationID == null ? -1 : currentOperationID, gracefulTimeout);
        if (blocking) {
            server.awaitState(ManagedServer.InternalState.STOPPED);
        }
        return server.getState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reconnectServer(String serverName, ModelNode domainModel, String authKey, boolean running, boolean stopping) {
        if (this.shutdown || this.connectionFinished) {
            throw HostControllerLogger.ROOT_LOGGER.hostAlreadyShutdown();
        }
        ManagedServer existing = (ManagedServer)this.servers.get(serverName);
        if (existing != null) {
            HostControllerLogger.ROOT_LOGGER.existingServerWithState(serverName, existing.getState());
            return;
        }
        ManagedServer server = this.createManagedServer(serverName, authKey);
        existing = this.servers.putIfAbsent(serverName, server);
        if (existing != null) {
            HostControllerLogger.ROOT_LOGGER.existingServerWithState(serverName, existing.getState());
            return;
        }
        if (running) {
            if (!stopping) {
                server.reconnectServerProcess(this.createBootFactory(serverName, domainModel));
            } else {
                server.setServerProcessStopping();
            }
        } else {
            server.removeServerProcess();
        }
        Object object = this.shutdownCondition;
        synchronized (object) {
            this.shutdownCondition.notifyAll();
        }
    }

    @Override
    public ServerStatus reloadServer(String serverName, boolean blocking) {
        if (this.shutdown || this.connectionFinished) {
            throw HostControllerLogger.ROOT_LOGGER.hostAlreadyShutdown();
        }
        ManagedServer server = (ManagedServer)this.servers.get(serverName);
        if (server == null) {
            return ServerStatus.STOPPED;
        }
        if (server.reload(CurrentOperationIdHolder.getCurrentOperationID())) {
            if (blocking) {
                server.awaitState(ManagedServer.InternalState.SERVER_STARTED);
            } else {
                server.awaitState(ManagedServer.InternalState.SERVER_STARTING);
            }
        }
        return this.determineServerStatus(serverName);
    }

    @Override
    public void destroyServer(String serverName) {
        ManagedServer server = (ManagedServer)this.servers.get(serverName);
        if (server == null) {
            return;
        }
        server.destroy();
    }

    @Override
    public void killServer(String serverName) {
        ManagedServer server = (ManagedServer)this.servers.get(serverName);
        if (server == null) {
            return;
        }
        server.kill();
    }

    @Override
    public void stopServers(int gracefulTimeout) {
        this.stopServers(gracefulTimeout, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopServers(int gracefulTimeout, boolean blockUntilStopped) {
        for (ManagedServer server : this.servers.values()) {
            Integer currentOperationID = CurrentOperationIdHolder.getCurrentOperationID();
            server.stop(currentOperationID == null ? -1 : currentOperationID, gracefulTimeout);
        }
        if (blockUntilStopped) {
            Object object = this.shutdownCondition;
            synchronized (object) {
                while (!this.connectionFinished) {
                    int count = 0;
                    block10: for (ManagedServer server : this.servers.values()) {
                        ServerStatus state = server.getState();
                        switch (state) {
                            case DISABLED: 
                            case FAILED: 
                            case STOPPED: {
                                continue block10;
                            }
                        }
                        ++count;
                    }
                    if (count == 0) break;
                    try {
                        this.shutdownCondition.wait();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        break;
                    }
                }
            }
        }
    }

    @Override
    public void awaitServersState(Collection<String> serverNames, boolean started) {
        for (String serverName : serverNames) {
            ManagedServer server = (ManagedServer)this.servers.get(serverName);
            if (server == null) continue;
            server.awaitState(started ? ManagedServer.InternalState.SERVER_STARTED : ManagedServer.InternalState.STOPPED);
        }
    }

    @Override
    public void suspendServer(String serverName) {
        ManagedServer server = (ManagedServer)this.servers.get(serverName);
        if (server == null) {
            return;
        }
        server.suspend();
    }

    @Override
    public void resumeServer(String serverName) {
        ManagedServer server = (ManagedServer)this.servers.get(serverName);
        if (server == null) {
            return;
        }
        server.resume();
    }

    @Override
    public boolean awaitServerSuspend(Set<String> waitForServers, int timeout) {
        long end = System.currentTimeMillis() + (long)timeout;
        for (String serverName : waitForServers) {
            ManagedServer server = (ManagedServer)this.servers.get(serverName);
            if (server == null) continue;
            if (timeout == -1) {
                server.awaitSuspended(-1L);
                continue;
            }
            long time = end - System.currentTimeMillis();
            if (time > 0L) {
                server.awaitSuspended(time);
                continue;
            }
            return false;
        }
        long time = end - System.currentTimeMillis();
        return time > 0L;
    }

    void shutdown(boolean shutdownServers, int gracefulTimeout, boolean blockUntilStopped) {
        boolean shutdown = this.shutdown;
        this.shutdown = true;
        if (!shutdown) {
            if (this.connectionFinished) {
                return;
            }
            if (shutdownServers) {
                this.stopServers(gracefulTimeout, blockUntilStopped);
            }
        }
    }

    @Override
    public ProxyController serverCommunicationRegistered(String serverProcessName, ManagementChannelHandler channelAssociation) {
        if (this.shutdown || this.connectionFinished) {
            throw HostControllerLogger.ROOT_LOGGER.hostAlreadyShutdown();
        }
        String serverName = ManagedServer.getServerName(serverProcessName);
        final ManagedServer server = (ManagedServer)this.servers.get(serverName);
        if (server == null) {
            HostControllerLogger.ROOT_LOGGER.noServerAvailable(serverName);
            return null;
        }
        try {
            final TransactionalProtocolClient client = server.channelRegistered(channelAssociation);
            Channel channel = channelAssociation.getChannel();
            channel.addCloseHandler((CloseHandler)new CloseHandler<Channel>(){

                public void handleClose(Channel closed, IOException exception) {
                    boolean shuttingDown;
                    boolean bl = shuttingDown = ServerInventoryImpl.this.shutdown || ServerInventoryImpl.this.connectionFinished;
                    if (server.callbackUnregistered(client, shuttingDown)) {
                        ServerInventoryImpl.this.domainController.unregisterRunningServer(server.getServerName());
                    }
                }
            });
            return server.getProxyController();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean serverReconnected(String serverProcessName, ManagementChannelHandler channelHandler) {
        String serverName = ManagedServer.getServerName(serverProcessName);
        ManagedServer server = (ManagedServer)this.servers.get(serverName);
        this.serverCommunicationRegistered(serverProcessName, channelHandler);
        this.serverStarted(serverProcessName);
        this.domainController.registerRunningServer((ProxyController)server.getProxyController());
        return !server.isRequiresReload();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serverProcessStopped(String serverProcessName) {
        String serverName = ManagedServer.getServerName(serverProcessName);
        ManagedServer server = (ManagedServer)this.servers.get(serverName);
        if (server == null) {
            HostControllerLogger.ROOT_LOGGER.noServerAvailable(serverName);
            return;
        }
        this.domainController.unregisterRunningServer(server.getServerName());
        server.processFinished();
        Object object = this.shutdownCondition;
        synchronized (object) {
            this.shutdownCondition.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connectionFinished() {
        this.connectionFinished = true;
        HostControllerLogger.ROOT_LOGGER.debug("process controller connection closed.");
        Object object = this.shutdownCondition;
        synchronized (object) {
            this.shutdownCondition.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serverStarted(String serverProcessName) {
        String serverName = ManagedServer.getServerName(serverProcessName);
        ManagedServer server = (ManagedServer)this.servers.get(serverName);
        if (server == null) {
            HostControllerLogger.ROOT_LOGGER.noServerAvailable(serverName);
            return;
        }
        server.serverStarted(null);
        Object object = this.shutdownCondition;
        synchronized (object) {
            this.shutdownCondition.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serverStartFailed(String serverProcessName) {
        String serverName = ManagedServer.getServerName(serverProcessName);
        ManagedServer server = (ManagedServer)this.servers.get(serverName);
        if (server == null) {
            HostControllerLogger.ROOT_LOGGER.noServerAvailable(serverName);
            return;
        }
        server.serverStartFailed();
        Object object = this.shutdownCondition;
        synchronized (object) {
            this.shutdownCondition.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serverProcessAdded(String serverProcessName) {
        String serverName = ManagedServer.getServerName(serverProcessName);
        ManagedServer server = (ManagedServer)this.servers.get(serverName);
        if (server == null) {
            HostControllerLogger.ROOT_LOGGER.noServerAvailable(serverName);
            return;
        }
        server.processAdded();
        Object object = this.shutdownCondition;
        synchronized (object) {
            this.shutdownCondition.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serverProcessStarted(String serverProcessName) {
        String serverName = ManagedServer.getServerName(serverProcessName);
        ManagedServer server = (ManagedServer)this.servers.get(serverName);
        if (server == null) {
            HostControllerLogger.ROOT_LOGGER.noServerAvailable(serverName);
            return;
        }
        server.processStarted();
        Object object = this.shutdownCondition;
        synchronized (object) {
            this.shutdownCondition.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serverProcessRemoved(String serverProcessName) {
        String serverName = ManagedServer.getServerName(serverProcessName);
        ManagedServer server = (ManagedServer)this.servers.remove(serverName);
        if (server == null) {
            HostControllerLogger.ROOT_LOGGER.noServerAvailable(serverName);
            return;
        }
        server.processRemoved();
        Object object = this.shutdownCondition;
        synchronized (object) {
            this.shutdownCondition.notifyAll();
        }
    }

    @Override
    public void operationFailed(String serverProcessName, ProcessMessageHandler.OperationType type) {
        String serverName = ManagedServer.getServerName(serverProcessName);
        ManagedServer server = (ManagedServer)this.servers.get(serverName);
        if (server == null) {
            HostControllerLogger.ROOT_LOGGER.noServerAvailable(serverName);
            return;
        }
        switch (type) {
            case ADD: {
                server.transitionFailed(ManagedServer.InternalState.PROCESS_ADDING);
                break;
            }
            case START: {
                server.transitionFailed(ManagedServer.InternalState.PROCESS_STARTING);
                break;
            }
            case STOP: {
                server.transitionFailed(ManagedServer.InternalState.PROCESS_STOPPING);
                break;
            }
            case SEND_STDIN: 
            case RECONNECT: {
                server.transitionFailed(ManagedServer.InternalState.SERVER_STARTING);
                break;
            }
            case REMOVE: {
                server.transitionFailed(ManagedServer.InternalState.PROCESS_REMOVING);
            }
        }
    }

    @Override
    public void processInventory(Map<String, ProcessInfo> processInfos) {
        this.processInfos = processInfos;
        if (this.processInventoryLatch != null) {
            this.processInventoryLatch.countDown();
        }
    }

    private ManagedServer createManagedServer(String serverName, String authKey) {
        String hostControllerName = this.domainController.getLocalHostInfo().getLocalHostName();
        Map subsystems = TransformerRegistry.resolveVersions((ExtensionRegistry)this.extensionRegistry);
        ModelVersion modelVersion = ModelVersion.create((int)4, (int)1, (int)0);
        TransformationTargetImpl target = TransformationTargetImpl.create((String)hostControllerName, (TransformerRegistry)this.extensionRegistry.getTransformerRegistry(), (ModelVersion)modelVersion, (Map)subsystems, (TransformationTarget.TransformationTargetType)TransformationTarget.TransformationTargetType.SERVER, (boolean)false);
        return new ManagedServer(hostControllerName, serverName, authKey, this.processControllerClient, this.managementURI, (TransformationTarget)target);
    }

    private ManagedServerBootCmdFactory createBootFactory(String serverName, ModelNode domainModel) {
        String hostControllerName = this.domainController.getLocalHostInfo().getLocalHostName();
        ModelNode hostModel = domainModel.require("host").require(hostControllerName);
        return new ManagedServerBootCmdFactory(serverName, domainModel, hostModel, this.environment, this.domainController.getExpressionResolver());
    }

    @Override
    public CallbackHandler getServerCallbackHandler() {
        return new CallbackHandler(){

            @Override
            public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                LinkedList<Callback> toRespondTo = new LinkedList<Callback>();
                String userName = null;
                String realm = null;
                ManagedServer server = null;
                for (Callback current : callbacks) {
                    if (current instanceof AuthorizeCallback) {
                        toRespondTo.add(current);
                        continue;
                    }
                    if (current instanceof NameCallback) {
                        NameCallback nameCallback = (NameCallback)current;
                        userName = nameCallback.getDefaultName();
                        if (!userName.startsWith("=")) continue;
                        server = (ManagedServer)ServerInventoryImpl.this.servers.get(userName.substring(1));
                        continue;
                    }
                    if (current instanceof PasswordCallback) {
                        toRespondTo.add(current);
                        continue;
                    }
                    if (current instanceof VerifyPasswordCallback) {
                        toRespondTo.add(current);
                        continue;
                    }
                    if (current instanceof DigestHashCallback) {
                        toRespondTo.add(current);
                        continue;
                    }
                    if (current instanceof RealmCallback) {
                        realm = ((RealmCallback)current).getDefaultText();
                        continue;
                    }
                    throw new UnsupportedCallbackException(current);
                }
                if (server == null) {
                    return;
                }
                for (Callback current : toRespondTo) {
                    if (current instanceof AuthorizeCallback) {
                        AuthorizeCallback authorizeCallback = (AuthorizeCallback)current;
                        authorizeCallback.setAuthorized(authorizeCallback.getAuthenticationID().equals(authorizeCallback.getAuthorizationID()));
                        continue;
                    }
                    if (current instanceof PasswordCallback) {
                        ((PasswordCallback)current).setPassword(server.getAuthKey().toCharArray());
                        continue;
                    }
                    if (current instanceof VerifyPasswordCallback) {
                        VerifyPasswordCallback vpc = (VerifyPasswordCallback)current;
                        vpc.setVerified(server.getAuthKey().equals(vpc.getPassword()));
                        continue;
                    }
                    if (!(current instanceof DigestHashCallback)) continue;
                    DigestHashCallback dhc = (DigestHashCallback)current;
                    try {
                        UsernamePasswordHashUtil uph = new UsernamePasswordHashUtil();
                        if (userName == null || realm == null) {
                            throw HostControllerLogger.ROOT_LOGGER.insufficientInformationToGenerateHash();
                        }
                        dhc.setHash(uph.generateHashedURP(userName, realm, server.getAuthKey().toCharArray()));
                    }
                    catch (NoSuchAlgorithmException e) {
                        throw HostControllerLogger.ROOT_LOGGER.unableToGenerateHash(e);
                    }
                }
            }
        };
    }
}

