/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.operations;

import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.ProcessType;
import org.jboss.as.domain.controller.LocalHostControllerInfo;
import org.jboss.as.host.controller.operations.LocalHostControllerInfoImpl;
import org.jboss.as.host.controller.operations.NativeManagementServices;
import org.jboss.as.host.controller.resources.NativeManagementResourceDefinition;
import org.jboss.as.remoting.management.ManagementRemotingServices;
import org.jboss.as.server.services.net.NetworkInterfaceService;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.remoting3.RemotingOptions;
import org.xnio.OptionMap;

public class NativeManagementAddHandler
extends AbstractAddStepHandler {
    public static final String OPERATION_NAME = "add";
    private final LocalHostControllerInfoImpl hostControllerInfo;

    public NativeManagementAddHandler(LocalHostControllerInfoImpl hostControllerInfo) {
        super(NativeManagementResourceDefinition.NATIVE_MANAGEMENT_CAPABILITY, NativeManagementResourceDefinition.ATTRIBUTE_DEFINITIONS);
        this.hostControllerInfo = hostControllerInfo;
    }

    protected boolean requiresRuntime(OperationContext context) {
        return context.getProcessType() != ProcessType.EMBEDDED_HOST_CONTROLLER;
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        NativeManagementAddHandler.populateHostControllerInfo(this.hostControllerInfo, context, model);
        ServiceTarget serviceTarget = context.getServiceTarget();
        boolean onDemand = context.isBooting();
        NativeManagementServices.installRemotingServicesIfNotInstalled(serviceTarget, this.hostControllerInfo.getLocalHostName(), context.getServiceRegistry(false), onDemand);
        OptionMap options = NativeManagementAddHandler.createConnectorOptions(context, model);
        NativeManagementAddHandler.installNativeManagementServices(serviceTarget, this.hostControllerInfo, options);
    }

    static void populateHostControllerInfo(LocalHostControllerInfoImpl hostControllerInfo, OperationContext context, ModelNode model) throws OperationFailedException {
        hostControllerInfo.setNativeManagementInterface(NativeManagementResourceDefinition.INTERFACE.resolveModelAttribute(context, model).asString());
        ModelNode portNode = NativeManagementResourceDefinition.NATIVE_PORT.resolveModelAttribute(context, model);
        hostControllerInfo.setNativeManagementPort(portNode.isDefined() ? portNode.asInt() : -1);
        ModelNode realmNode = NativeManagementResourceDefinition.SECURITY_REALM.resolveModelAttribute(context, model);
        hostControllerInfo.setNativeManagementSecurityRealm(realmNode.isDefined() ? realmNode.asString() : null);
    }

    public static void installNativeManagementServices(ServiceTarget serviceTarget, LocalHostControllerInfo hostControllerInfo, OptionMap options) {
        String nativeSecurityRealm = hostControllerInfo.getNativeManagementSecurityRealm();
        ServiceName nativeManagementInterfaceBinding = NetworkInterfaceService.JBOSS_NETWORK_INTERFACE.append(new String[]{hostControllerInfo.getNativeManagementInterface()});
        ManagementRemotingServices.installDomainConnectorServices((ServiceTarget)serviceTarget, (ServiceName)ManagementRemotingServices.MANAGEMENT_ENDPOINT, (ServiceName)nativeManagementInterfaceBinding, (int)hostControllerInfo.getNativeManagementPort(), (String)nativeSecurityRealm, (OptionMap)options);
    }

    private static OptionMap createConnectorOptions(OperationContext context, ModelNode model) throws OperationFailedException {
        OptionMap.Builder builder = OptionMap.builder();
        builder.addAll(NativeManagementServices.CONNECTION_OPTIONS);
        builder.set(RemotingOptions.SASL_PROTOCOL, (Object)NativeManagementResourceDefinition.SASL_PROTOCOL.resolveModelAttribute(context, model).asString());
        ModelNode serverName = NativeManagementResourceDefinition.SERVER_NAME.resolveModelAttribute(context, model);
        if (serverName.isDefined()) {
            builder.set(RemotingOptions.SERVER_NAME, (Object)serverName.asString());
        }
        return builder.getMap();
    }
}

