/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.mgmt;

import java.io.File;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.domain.controller.DomainController;
import org.jboss.as.host.controller.ServerInventory;
import org.jboss.as.host.controller.mgmt.ServerToHostProtocolHandler;
import org.jboss.as.protocol.mgmt.ManagementChannelHandler;
import org.jboss.as.protocol.mgmt.ManagementClientChannelStrategy;
import org.jboss.as.protocol.mgmt.ManagementPongRequestHandler;
import org.jboss.as.protocol.mgmt.ManagementRequestHandlerFactory;
import org.jboss.as.protocol.mgmt.support.ManagementChannelInitialization;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.remoting3.Channel;
import org.jboss.threads.JBossThreadFactory;

public class ServerToHostOperationHandlerFactoryService
implements ManagementChannelInitialization,
Service<ManagementChannelInitialization> {
    public static final ServiceName SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"management", "server", "to", "host", "controller"});
    private final ExecutorService executorService;
    private final InjectedValue<ServerInventory> serverInventory = new InjectedValue();
    private final ServerToHostProtocolHandler.OperationExecutor operationExecutor;
    private final DomainController domainController;
    private final ExpressionResolver expressionResolver;
    private final File tempDir;
    private final ThreadFactory threadFactory = (ThreadFactory)AccessController.doPrivileged(new PrivilegedAction<JBossThreadFactory>(){

        @Override
        public JBossThreadFactory run() {
            return new JBossThreadFactory(new ThreadGroup("server-registration-threads"), Boolean.FALSE, null, "%G - %t", null, null);
        }
    });
    private volatile ExecutorService registrations;

    ServerToHostOperationHandlerFactoryService(ExecutorService executorService, ServerToHostProtocolHandler.OperationExecutor operationExecutor, DomainController domainController, ExpressionResolver expressionResolver, File tempDir) {
        this.executorService = executorService;
        this.operationExecutor = operationExecutor;
        this.domainController = domainController;
        this.expressionResolver = expressionResolver;
        this.tempDir = tempDir;
    }

    public static void install(ServiceTarget serviceTarget, ServiceName serverInventoryName, ExecutorService executorService, ServerToHostProtocolHandler.OperationExecutor operationExecutor, DomainController domainController, ExpressionResolver expressionResolver, File tempDir) {
        ServerToHostOperationHandlerFactoryService serverToHost = new ServerToHostOperationHandlerFactoryService(executorService, operationExecutor, domainController, expressionResolver, tempDir);
        serviceTarget.addService(SERVICE_NAME, (Service)serverToHost).addDependency(serverInventoryName, ServerInventory.class, serverToHost.serverInventory).install();
    }

    public synchronized void start(StartContext context) throws StartException {
        this.registrations = Executors.newSingleThreadExecutor(this.threadFactory);
    }

    public synchronized void stop(StopContext context) {
        ExecutorService executorService = this.registrations;
        this.registrations = null;
        if (executorService != null) {
            executorService.shutdown();
        }
    }

    public synchronized ManagementChannelInitialization getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public ManagementChannelHandler startReceiving(Channel channel) {
        ManagementClientChannelStrategy strategy = ManagementClientChannelStrategy.create((Channel)channel);
        ManagementChannelHandler channelHandler = new ManagementChannelHandler(strategy, this.executorService);
        channelHandler.getAttachments().attach(ManagementChannelHandler.TEMP_DIR, (Object)this.tempDir);
        ServerToHostProtocolHandler registrationHandler = new ServerToHostProtocolHandler((ServerInventory)this.serverInventory.getValue(), this.operationExecutor, this.domainController, channelHandler, this.registrations, this.expressionResolver);
        channelHandler.addHandlerFactory((ManagementRequestHandlerFactory)new ManagementPongRequestHandler());
        channelHandler.addHandlerFactory((ManagementRequestHandlerFactory)registrationHandler);
        channel.receiveMessage(channelHandler.getReceiver());
        return channelHandler;
    }
}

