/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.model.jvm;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.as.host.controller.logging.HostControllerLogger;
import org.jboss.as.host.controller.model.jvm.JvmAttributes;
import org.jboss.as.host.controller.model.jvm.JvmOptionsElement;
import org.jboss.as.host.controller.model.jvm.JvmType;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.wildfly.security.manager.WildFlySecurityManager;

public class JvmElement {
    private static final long serialVersionUID = 4963103173530602991L;
    private final String name;
    private JvmType type = JvmType.ORACLE;
    private String javaHome;
    private Boolean debugEnabled;
    private String debugOptions;
    private Boolean envClasspathIgnored;
    private String heapSize;
    private String maxHeap;
    private String permgenSize;
    private String maxPermgen;
    private String agentPath;
    private String agentLib;
    private String javaagent;
    private String stack;
    private String launchCommand;
    private final JvmOptionsElement jvmOptionsElement = new JvmOptionsElement();
    private final JvmOptionsElement moduleOptionsElement = new JvmOptionsElement();
    private Map<String, String> environmentVariables = new HashMap<String, String>();

    public JvmElement(String name) {
        this.name = name;
    }

    public JvmElement(String name, ModelNode ... toCombine) {
        this.determinateJVMParams();
        this.name = name;
        if (name == null) {
            this.heapSize = "64m";
            this.maxHeap = "256m";
        }
        for (ModelNode node : toCombine) {
            if (node == null) continue;
            if (node.hasDefined("agent-lib")) {
                this.agentLib = node.get("agent-lib").asString();
            }
            if (node.hasDefined("agent-path")) {
                this.agentPath = node.get("agent-path").asString();
            }
            if (node.hasDefined("debug-enabled")) {
                this.debugEnabled = node.get("debug-enabled").asBoolean();
            }
            if (node.hasDefined("debug-options")) {
                this.debugOptions = node.get("debug-options").asString();
            }
            if (node.hasDefined("env-classpath-ignored")) {
                this.envClasspathIgnored = node.get("env-classpath-ignored").asBoolean();
            }
            if (node.hasDefined("environment-variables")) {
                for (Property property : node.get("environment-variables").asPropertyList()) {
                    this.environmentVariables.put(property.getName(), property.getValue().asString());
                }
            }
            if (node.hasDefined("launch-command")) {
                this.launchCommand = node.get("launch-command").asString();
            }
            if (node.hasDefined(JvmAttributes.MODULE_OPTIONS.getName())) {
                for (ModelNode option : node.get(JvmAttributes.MODULE_OPTIONS.getName()).asList()) {
                    this.moduleOptionsElement.addOption(option.asString());
                }
            }
            if (node.hasDefined("heap-size")) {
                this.heapSize = node.get("heap-size").asString();
            }
            if (node.hasDefined("max-heap-size")) {
                this.maxHeap = node.get("max-heap-size").asString();
            }
            if (node.hasDefined("java-agent")) {
                this.javaagent = node.get("java-agent").asString();
            }
            if (node.hasDefined("java-home")) {
                this.javaHome = node.get("java-home").asString();
            }
            if (node.hasDefined("jvm-options")) {
                for (ModelNode option : node.get("jvm-options").asList()) {
                    this.jvmOptionsElement.addOption(option.asString());
                }
            }
            if (node.hasDefined("permgen-size")) {
                this.permgenSize = node.get("permgen-size").asString();
            }
            if (node.hasDefined("max-permgen-size")) {
                this.maxPermgen = node.get("max-permgen-size").asString();
            }
            if (!node.hasDefined("stack-size")) continue;
            this.stack = node.get("stack-size").asString();
        }
    }

    public String getJavaHome() {
        return this.javaHome;
    }

    void setJavaHome(String javaHome) {
        this.javaHome = javaHome;
    }

    public JvmType getJvmType() {
        return this.type;
    }

    void setJvmType(JvmType type) {
        this.type = type;
    }

    public String getPermgenSize() {
        return this.permgenSize;
    }

    void setPermgenSize(String permgenSize) {
        this.permgenSize = permgenSize;
    }

    public String getMaxPermgen() {
        return this.maxPermgen;
    }

    void setMaxPermgen(String maxPermgen) {
        this.maxPermgen = maxPermgen;
    }

    public String getHeapSize() {
        return this.heapSize;
    }

    void setHeapSize(String heapSize) {
        this.heapSize = heapSize;
    }

    public String getMaxHeap() {
        return this.maxHeap;
    }

    void setMaxHeap(String maxHeap) {
        this.maxHeap = maxHeap;
    }

    public String getName() {
        return this.name;
    }

    public Boolean isDebugEnabled() {
        return this.debugEnabled;
    }

    void setDebugEnabled(Boolean debugEnabled) {
        this.debugEnabled = debugEnabled;
    }

    public String getDebugOptions() {
        return this.debugOptions;
    }

    void setDebugOptions(String debugOptions) {
        this.debugOptions = debugOptions;
    }

    public String getStack() {
        return this.stack;
    }

    void setStack(String stack) {
        this.stack = stack;
    }

    public Boolean isEnvClasspathIgnored() {
        return this.envClasspathIgnored;
    }

    void setEnvClasspathIgnored(Boolean envClasspathIgnored) {
        this.envClasspathIgnored = envClasspathIgnored;
    }

    public JvmOptionsElement getJvmOptions() {
        return this.jvmOptionsElement;
    }

    public JvmOptionsElement getModuleOptions() {
        return this.moduleOptionsElement;
    }

    public Map<String, String> getEnvironmentVariables() {
        return this.environmentVariables;
    }

    public String getAgentPath() {
        return this.agentPath;
    }

    void setAgentPath(String agentPath) {
        if (this.agentLib != null) {
            throw HostControllerLogger.ROOT_LOGGER.attemptingToSet("agent-path", "agent-lib");
        }
        this.agentPath = agentPath;
    }

    public String getAgentLib() {
        return this.agentLib;
    }

    void setAgentLib(String agentLib) {
        if (this.agentPath != null) {
            throw HostControllerLogger.ROOT_LOGGER.attemptingToSet("agent-lib", "agent-path");
        }
        this.agentLib = agentLib;
    }

    public String getLaunchCommand() {
        return this.launchCommand;
    }

    void setLaunchCommand(String launchCommand) {
        this.launchCommand = launchCommand;
    }

    public String getJavaagent() {
        return this.javaagent;
    }

    void setJavaagent(String javaagent) {
        this.javaagent = javaagent;
    }

    private void determinateJVMParams() {
        String vendor = WildFlySecurityManager.getPropertyPrivileged((String)"java.vendor", (String)"oracle").toLowerCase();
        this.type = vendor.contains("ibm") ? JvmType.IBM : JvmType.ORACLE;
    }

    public static int getJVMMajorVersion() {
        try {
            String vmVersionStr = WildFlySecurityManager.getPropertyPrivileged((String)"java.specification.version", null);
            Matcher matcher = Pattern.compile("^(?:1\\.)?(\\d+)$").matcher(vmVersionStr);
            if (matcher.find()) {
                return Integer.valueOf(matcher.group(1));
            }
            throw new RuntimeException("Unknown version of jvm " + vmVersionStr);
        }
        catch (Exception e) {
            return 8;
        }
    }
}

