/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.operations;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.host.controller.discovery.DiscoveryOption;
import org.jboss.as.host.controller.discovery.DiscoveryOptionResourceDefinition;
import org.jboss.as.host.controller.logging.HostControllerLogger;
import org.jboss.as.host.controller.operations.AbstractDiscoveryOptionAddHandler;
import org.jboss.as.host.controller.operations.LocalHostControllerInfoImpl;
import org.jboss.dmr.ModelNode;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;

public class DiscoveryOptionAddHandler
extends AbstractDiscoveryOptionAddHandler {
    private final LocalHostControllerInfoImpl hostControllerInfo;

    public DiscoveryOptionAddHandler(LocalHostControllerInfoImpl hostControllerInfo) {
        this.hostControllerInfo = hostControllerInfo;
    }

    protected boolean requiresRuntime(OperationContext context) {
        return true;
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        if (context.isBooting()) {
            this.populateHostControllerInfo(this.hostControllerInfo, context, operation);
        } else {
            context.reloadRequired();
        }
    }

    protected void populateModel(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        DiscoveryOptionAddHandler.updateOptionsAttribute(context, operation, "custom-discovery");
    }

    protected void populateHostControllerInfo(LocalHostControllerInfoImpl hostControllerInfo, OperationContext context, ModelNode operation) throws OperationFailedException {
        ModelNode codeNode = DiscoveryOptionResourceDefinition.CODE.resolveModelAttribute(context, operation);
        String discoveryOptionClassName = codeNode.isDefined() ? codeNode.asString() : null;
        ModelNode moduleNode = DiscoveryOptionResourceDefinition.MODULE.resolveModelAttribute(context, operation);
        String moduleName = moduleNode.isDefined() ? moduleNode.asString() : null;
        HashMap discoveryOptionProperties = new HashMap();
        if (operation.hasDefined(DiscoveryOptionResourceDefinition.PROPERTIES.getName())) {
            for (Map.Entry discoveryOptionProperty : DiscoveryOptionResourceDefinition.PROPERTIES.unwrap((ExpressionResolver)context, operation).entrySet()) {
                discoveryOptionProperties.put(discoveryOptionProperty.getKey(), new ModelNode((String)discoveryOptionProperty.getValue()));
            }
        }
        try {
            ModuleIdentifier moduleID = moduleName != null ? ModuleIdentifier.fromString((String)moduleName) : Module.forClass(((Object)((Object)this)).getClass()).getIdentifier();
            Class<DiscoveryOption> discoveryOptionClass = Module.loadClassFromCallerModuleLoader((ModuleIdentifier)moduleID, (String)discoveryOptionClassName).asSubclass(DiscoveryOption.class);
            Constructor<DiscoveryOption> constructor = discoveryOptionClass.getConstructor(Map.class);
            DiscoveryOption discoveryOption = constructor.newInstance(discoveryOptionProperties);
            hostControllerInfo.addRemoteDomainControllerDiscoveryOption(discoveryOption);
        }
        catch (Exception e) {
            throw HostControllerLogger.ROOT_LOGGER.cannotInstantiateDiscoveryOptionClass(discoveryOptionClassName, e.getLocalizedMessage());
        }
    }
}

