/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.parsing;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.RunningMode;
import org.jboss.as.controller.extension.ExtensionRegistry;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.management.BaseHttpInterfaceResourceDefinition;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.parsing.Attribute;
import org.jboss.as.controller.parsing.Element;
import org.jboss.as.controller.parsing.ExtensionXml;
import org.jboss.as.controller.parsing.Namespace;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.parsing.ProfileParsingCompletionHandler;
import org.jboss.as.controller.parsing.WriteUtils;
import org.jboss.as.controller.persistence.ModelMarshallingContext;
import org.jboss.as.domain.management.parsing.AuditLogXml;
import org.jboss.as.domain.management.parsing.ManagementXml;
import org.jboss.as.domain.management.parsing.ManagementXmlDelegate;
import org.jboss.as.host.controller.discovery.DiscoveryOptionResourceDefinition;
import org.jboss.as.host.controller.discovery.StaticDiscoveryResourceDefinition;
import org.jboss.as.host.controller.ignored.IgnoredDomainTypeResourceDefinition;
import org.jboss.as.host.controller.logging.HostControllerLogger;
import org.jboss.as.host.controller.model.host.AdminOnlyDomainConfigPolicy;
import org.jboss.as.host.controller.model.host.HostResourceDefinition;
import org.jboss.as.host.controller.operations.DomainControllerWriteAttributeHandler;
import org.jboss.as.host.controller.operations.RemoteDomainControllerAddHandler;
import org.jboss.as.host.controller.parsing.JvmXml;
import org.jboss.as.host.controller.resources.HttpManagementResourceDefinition;
import org.jboss.as.host.controller.resources.NativeManagementResourceDefinition;
import org.jboss.as.host.controller.resources.ServerConfigResourceDefinition;
import org.jboss.as.host.controller.resources.SslLoopbackResourceDefinition;
import org.jboss.as.server.parsing.CommonXml;
import org.jboss.as.server.parsing.SocketBindingsXml;
import org.jboss.as.server.services.net.SocketBindingGroupResourceDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

final class HostXml_18
extends CommonXml
implements ManagementXmlDelegate {
    private final AuditLogXml auditLogDelegate;
    private final String defaultHostControllerName;
    private final RunningMode runningMode;
    private final boolean isCachedDc;
    private final ExtensionRegistry extensionRegistry;
    private final ExtensionXml extensionXml;
    private final Namespace namespace;

    HostXml_18(String defaultHostControllerName, RunningMode runningMode, boolean isCachedDC, ExtensionRegistry extensionRegistry, ExtensionXml extensionXml, Namespace namespace) {
        super((SocketBindingsXml)new SocketBindingsXml.HostSocketBindingsXml());
        this.auditLogDelegate = AuditLogXml.newInstance((Namespace)namespace, (boolean)true);
        this.defaultHostControllerName = defaultHostControllerName;
        this.runningMode = runningMode;
        this.isCachedDc = isCachedDC;
        this.extensionRegistry = extensionRegistry;
        this.extensionXml = extensionXml;
        this.namespace = namespace;
    }

    public void readElement(XMLExtendedStreamReader reader, List<ModelNode> operationList) throws XMLStreamException {
        ModelNode address = new ModelNode().setEmptyList();
        if (Element.forName((String)reader.getLocalName()) != Element.HOST) {
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        for (Namespace current : Namespace.domainValues()) {
            if (!this.namespace.equals((Object)current)) continue;
            this.readHostElement(reader, address, operationList);
            return;
        }
        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
    }

    void writeContent(XMLExtendedStreamWriter writer, ModelMarshallingContext context) throws XMLStreamException {
        boolean hasCoreServices;
        ModelNode modelNode = context.getModelNode();
        writer.writeStartDocument();
        writer.writeStartElement(Element.HOST.getLocalName());
        writer.writeDefaultNamespace(Namespace.CURRENT.getUriString());
        this.writeNamespaces(writer, modelNode);
        this.writeSchemaLocation(writer, modelNode);
        if (modelNode.hasDefined("name")) {
            HostResourceDefinition.NAME.marshallAsAttribute(modelNode, (XMLStreamWriter)writer);
        }
        if (modelNode.hasDefined("organization")) {
            HostResourceDefinition.ORGANIZATION_IDENTIFIER.marshallAsAttribute(modelNode, (XMLStreamWriter)writer);
        }
        if (modelNode.hasDefined("extension")) {
            this.extensionXml.writeExtensions(writer, modelNode.get("extension"));
        }
        if (modelNode.hasDefined("system-property")) {
            this.writeProperties(writer, modelNode.get("system-property"), Element.SYSTEM_PROPERTIES, false);
        }
        if (modelNode.hasDefined("path")) {
            this.writePaths(writer, modelNode.get("path"), false);
        }
        if ((hasCoreServices = modelNode.hasDefined("core-service")) && modelNode.get("core-service").hasDefined("vault")) {
            this.writeVault(writer, modelNode.get(new String[]{"core-service", "vault"}));
        }
        if (hasCoreServices) {
            ManagementXml managementXml = ManagementXml.newInstance((Namespace)Namespace.CURRENT, (ManagementXmlDelegate)this, (boolean)false);
            managementXml.writeManagement(writer, modelNode.get(new String[]{"core-service", "management"}), true);
        }
        if (modelNode.hasDefined("domain-controller")) {
            ModelNode ignoredResources = null;
            ModelNode discoveryOptions = null;
            if (hasCoreServices && modelNode.get("core-service").hasDefined("ignored-resources") && modelNode.get(new String[]{"core-service", "ignored-resources"}).hasDefined("ignored-resource-type")) {
                ignoredResources = modelNode.get(new String[]{"core-service", "ignored-resources", "ignored-resource-type"});
            }
            if (hasCoreServices && modelNode.get("core-service").hasDefined("discovery-options") && modelNode.get(new String[]{"core-service", "discovery-options"}).hasDefined("options")) {
                discoveryOptions = modelNode.get(new String[]{"core-service", "discovery-options", "options"});
            }
            this.writeDomainController(writer, modelNode.get("domain-controller"), ignoredResources, discoveryOptions);
        }
        if (modelNode.hasDefined("interface")) {
            this.writeInterfaces(writer, modelNode.get("interface"));
        }
        if (modelNode.hasDefined("jvm")) {
            writer.writeStartElement(Element.JVMS.getLocalName());
            ModelNode jvms = modelNode.get("jvm");
            for (String jvm : jvms.keys()) {
                JvmXml.writeJVMElement(writer, jvm, jvms.get(jvm));
            }
            writer.writeEndElement();
        }
        if (modelNode.hasDefined("server-config")) {
            writer.writeStartElement(Element.SERVERS.getLocalName());
            HostResourceDefinition.DIRECTORY_GROUPING.marshallAsAttribute(modelNode, (XMLStreamWriter)writer);
            this.writeServers(writer, modelNode.get("server-config"));
            writer.writeEndElement();
        } else if (modelNode.hasDefined("directory-grouping")) {
            writer.writeEmptyElement(Element.SERVERS.getLocalName());
            HostResourceDefinition.DIRECTORY_GROUPING.marshallAsAttribute(modelNode, (XMLStreamWriter)writer);
        }
        this.writeHostProfile(writer, context);
        if (modelNode.hasDefined("socket-binding-group")) {
            Set groups = modelNode.get("socket-binding-group").keys();
            if (groups.size() > 1) {
                throw ControllerLogger.ROOT_LOGGER.multipleModelNodes("socket-binding-group");
            }
            for (String group : groups) {
                this.writeSocketBindingGroup(writer, modelNode.get(new String[]{"socket-binding-group", group}), group);
            }
        }
        writer.writeEndElement();
        writer.writeEndDocument();
    }

    private void readHostElement(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
        String hostName = null;
        String organization = null;
        LinkedList namespaceOperations = new LinkedList();
        this.parseNamespaces(reader, address, namespaceOperations);
        int count = reader.getAttributeCount();
        block12: for (int i = 0; i < count; ++i) {
            switch (Namespace.forUri((String)reader.getAttributeNamespace(i))) {
                case NONE: {
                    String value = reader.getAttributeValue(i);
                    Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
                    switch (attribute) {
                        case NAME: {
                            hostName = value;
                            continue block12;
                        }
                        case ORGANIZATION: {
                            organization = value;
                            continue block12;
                        }
                    }
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
                case XML_SCHEMA_INSTANCE: {
                    switch (Attribute.forName((String)reader.getAttributeLocalName(i))) {
                        case SCHEMA_LOCATION: {
                            this.parseSchemaLocations(reader, address, namespaceOperations, i);
                            continue block12;
                        }
                        case NO_NAMESPACE_SCHEMA_LOCATION: {
                            continue block12;
                        }
                    }
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ModelNode hostAddOp = this.addLocalHost(address, list, hostName);
        this.setOrganization(address, list, organization);
        for (ModelNode operation : namespaceOperations) {
            operation.get("address").set(address);
            list.add(operation);
        }
        Element element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
        if (element == Element.EXTENSIONS) {
            this.extensionXml.parseExtensions(reader, address, this.namespace, list);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
        }
        if (element == Element.SYSTEM_PROPERTIES) {
            this.parseSystemProperties(reader, address, this.namespace, list, false);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
        }
        if (element == Element.PATHS) {
            this.parsePaths(reader, address, this.namespace, list, true);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
        }
        if (element == Element.VAULT) {
            this.parseVault(reader, address, this.namespace, list);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
        }
        if (element != Element.MANAGEMENT) {
            throw ParseUtils.missingRequiredElement((XMLExtendedStreamReader)reader, EnumSet.of(Element.MANAGEMENT));
        }
        ManagementXml managementXml = ManagementXml.newInstance((Namespace)this.namespace, (ManagementXmlDelegate)this, (boolean)false);
        managementXml.parseManagement(reader, address, list, true);
        element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
        if (element == Element.DOMAIN_CONTROLLER) {
            this.parseDomainController(reader, address, list, hostAddOp);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
        }
        HashSet<String> interfaceNames = new HashSet<String>();
        if (element == Element.INTERFACES) {
            this.parseInterfaces(reader, interfaceNames, address, this.namespace, list, true);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
        }
        if (element == Element.JVMS) {
            this.parseJvms(reader, address, list);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
        }
        if (element == Element.SERVERS) {
            this.parseServers(reader, address, list);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
        }
        if (element == Element.PROFILE) {
            this.parseHostProfile(reader, address, list);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
        }
        if (element == Element.SOCKET_BINDING_GROUP) {
            this.parseSocketBindingGroup(reader, interfaceNames, address, list);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
        }
        if (element != null) {
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseHttpManagementInterfaceAttributes(XMLExtendedStreamReader reader, ModelNode addOp) throws XMLStreamException {
        int count = reader.getAttributeCount();
        block10: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case HTTP_AUTHENTICATION_FACTORY: {
                    HttpManagementResourceDefinition.HTTP_AUTHENTICATION_FACTORY.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block10;
                }
                case SASL_PROTOCOL: {
                    HttpManagementResourceDefinition.SASL_PROTOCOL.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block10;
                }
                case SECURITY_REALM: {
                    HttpManagementResourceDefinition.SECURITY_REALM.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block10;
                }
                case SERVER_NAME: {
                    HttpManagementResourceDefinition.SERVER_NAME.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block10;
                }
                case SSL_CONTEXT: {
                    HttpManagementResourceDefinition.SSL_CONTEXT.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block10;
                }
                case CONSOLE_ENABLED: {
                    HttpManagementResourceDefinition.CONSOLE_ENABLED.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block10;
                }
                case HTTP_UPGRADE_ENABLED: {
                    ModelNode httpUpgrade = addOp.get("http-upgrade");
                    HttpManagementResourceDefinition.ENABLED.parseAndSetParameter(value, httpUpgrade, (XMLStreamReader)reader);
                    continue block10;
                }
                case ALLOWED_ORIGINS: {
                    HttpManagementResourceDefinition.ALLOWED_ORIGINS.getParser().parseAndSetParameter((AttributeDefinition)HttpManagementResourceDefinition.ALLOWED_ORIGINS, value, addOp, (XMLStreamReader)reader);
                    continue block10;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
    }

    private void parseNativeManagementInterfaceAttributes(XMLExtendedStreamReader reader, ModelNode addOp) throws XMLStreamException {
        int count = reader.getAttributeCount();
        block7: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case SASL_AUTHENTICATION_FACTORY: {
                    NativeManagementResourceDefinition.SASL_AUTHENTICATION_FACTORY.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block7;
                }
                case SASL_PROTOCOL: {
                    NativeManagementResourceDefinition.SASL_PROTOCOL.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block7;
                }
                case SECURITY_REALM: {
                    NativeManagementResourceDefinition.SECURITY_REALM.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block7;
                }
                case SERVER_NAME: {
                    NativeManagementResourceDefinition.SERVER_NAME.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block7;
                }
                case SSL_CONTEXT: {
                    NativeManagementResourceDefinition.SSL_CONTEXT.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block7;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
    }

    private void parseNativeManagementInterface(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
        ModelNode operationAddress = address.clone();
        operationAddress.add("management-interface", "native-interface");
        ModelNode addOp = Util.getEmptyOperation((String)"add", (ModelNode)operationAddress);
        this.parseNativeManagementInterfaceAttributes(reader, addOp);
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case SOCKET: {
                    this.parseNativeManagementSocket(reader, addOp);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        list.add(addOp);
    }

    private void parseHttpManagementInterface(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
        ModelNode operationAddress = address.clone();
        operationAddress.add("management-interface", "http-interface");
        ModelNode addOp = Util.getEmptyOperation((String)"add", (ModelNode)operationAddress);
        int socketCount = 0;
        int httpUpgradeCount = 0;
        this.parseHttpManagementInterfaceAttributes(reader, addOp);
        block5: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case SOCKET: {
                    if (++socketCount > 1) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    this.parseHttpManagementSocket(reader, addOp);
                    continue block5;
                }
                case HTTP_UPGRADE: {
                    if (++httpUpgradeCount > 1) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    this.parseHttpUpgrade(reader, addOp);
                    continue block5;
                }
                case CONSTANT_HEADERS: {
                    this.parseConstantHeaders(reader, addOp);
                    continue block5;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        list.add(addOp);
    }

    private void parseConstantHeaders(XMLExtendedStreamReader reader, ModelNode addOp) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        ModelNode constantHeaders = new ModelNode();
        while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
            if (Element.forName((String)reader.getLocalName()) != Element.HEADER_MAPPING) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            ModelNode headerMapping = new ModelNode();
            ParseUtils.requireSingleAttribute((XMLExtendedStreamReader)reader, (String)Attribute.PATH.getLocalName());
            HttpManagementResourceDefinition.PATH.parseAndSetParameter(reader.getAttributeValue(0), headerMapping, (XMLStreamReader)reader);
            ModelNode headers = new ModelNode();
            boolean headerFound = false;
            while (reader.hasNext() && reader.nextTag() != 2) {
                ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
                if (Element.forName((String)reader.getLocalName()) != Element.HEADER) {
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
                headerFound = true;
                ModelNode header = new ModelNode();
                int count = reader.getAttributeCount();
                block6: for (int i = 0; i < count; ++i) {
                    String value = reader.getAttributeValue(i);
                    if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                    Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
                    switch (attribute) {
                        case NAME: {
                            HttpManagementResourceDefinition.HEADER_NAME.parseAndSetParameter(value, header, (XMLStreamReader)reader);
                            continue block6;
                        }
                        case VALUE: {
                            HttpManagementResourceDefinition.HEADER_VALUE.parseAndSetParameter(value, header, (XMLStreamReader)reader);
                            continue block6;
                        }
                        default: {
                            throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                        }
                    }
                }
                headers.add(header);
                ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
            }
            if (!headerFound) {
                throw ParseUtils.missingRequiredElement((XMLExtendedStreamReader)reader, Collections.singleton(Element.HEADER.getLocalName()));
            }
            headerMapping.get("headers").set(headers);
            constantHeaders.add(headerMapping);
        }
        addOp.get("constant-headers").set(constantHeaders);
    }

    private void parseNativeManagementSocket(XMLExtendedStreamReader reader, ModelNode addOp) throws XMLStreamException {
        boolean hasInterface = false;
        int count = reader.getAttributeCount();
        block4: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case INTERFACE: {
                    NativeManagementResourceDefinition.INTERFACE.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    hasInterface = true;
                    continue block4;
                }
                case PORT: {
                    NativeManagementResourceDefinition.NATIVE_PORT.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        if (!hasInterface) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.INTERFACE.getLocalName()));
        }
    }

    private void parseHttpManagementSocket(XMLExtendedStreamReader reader, ModelNode addOp) throws XMLStreamException {
        boolean hasInterface = false;
        int count = reader.getAttributeCount();
        block6: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case INTERFACE: {
                    HttpManagementResourceDefinition.INTERFACE.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    hasInterface = true;
                    continue block6;
                }
                case PORT: {
                    HttpManagementResourceDefinition.HTTP_PORT.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block6;
                }
                case SECURE_PORT: {
                    HttpManagementResourceDefinition.HTTPS_PORT.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block6;
                }
                case SECURE_INTERFACE: {
                    HttpManagementResourceDefinition.SECURE_INTERFACE.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        if (!hasInterface) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.INTERFACE.getLocalName()));
        }
    }

    private void parseHttpUpgrade(XMLExtendedStreamReader reader, ModelNode addOp) throws XMLStreamException {
        int count = reader.getAttributeCount();
        block4: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case ENABLED: {
                    ModelNode httpUpgrade = addOp.get("http-upgrade");
                    HttpManagementResourceDefinition.ENABLED.parseAndSetParameter(value, httpUpgrade, (XMLStreamReader)reader);
                    continue block4;
                }
                case SASL_AUTHENTICATION_FACTORY: {
                    ModelNode httpUpgrade = addOp.get("http-upgrade");
                    HttpManagementResourceDefinition.SASL_AUTHENTICATION_FACTORY.parseAndSetParameter(value, httpUpgrade, (XMLStreamReader)reader);
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void setOrganization(ModelNode address, List<ModelNode> operationList, String value) {
        if (value != null && !value.isEmpty()) {
            ModelNode update = Util.getWriteAttributeOperation((ModelNode)address, (String)"organization", (String)value);
            operationList.add(update);
        }
    }

    private ModelNode addLocalHost(ModelNode address, List<ModelNode> operationList, String hostName) {
        String resolvedHost = hostName != null ? hostName : this.defaultHostControllerName;
        address.add("host", resolvedHost);
        ModelNode hostAddOp = new ModelNode();
        hostAddOp.get("operation").set("add");
        hostAddOp.get("address").set(address);
        operationList.add(hostAddOp);
        ModelNode nameValue = hostName == null ? new ModelNode() : new ModelNode(hostName);
        ModelNode writeName = Util.getWriteAttributeOperation((ModelNode)address, (String)"name", (ModelNode)nameValue);
        operationList.add(writeName);
        return hostAddOp;
    }

    private void parseDomainController(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list, ModelNode hostAddOp) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        boolean hasLocal = false;
        boolean hasRemote = false;
        block4: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case LOCAL: {
                    if (hasLocal) {
                        throw ControllerLogger.ROOT_LOGGER.childAlreadyDeclared(element.getLocalName(), Element.DOMAIN_CONTROLLER.getLocalName(), reader.getLocation());
                    }
                    if (hasRemote) {
                        throw ControllerLogger.ROOT_LOGGER.childAlreadyDeclared(Element.REMOTE.getLocalName(), Element.DOMAIN_CONTROLLER.getLocalName(), reader.getLocation());
                    }
                    hostAddOp.get("is-domain-controller").set(true);
                    this.parseLocalDomainController(reader, address, list);
                    hasLocal = true;
                    continue block4;
                }
                case REMOTE: {
                    if (hasRemote) {
                        throw ControllerLogger.ROOT_LOGGER.childAlreadyDeclared(element.getLocalName(), Element.DOMAIN_CONTROLLER.getLocalName(), reader.getLocation());
                    }
                    if (hasLocal) {
                        throw ControllerLogger.ROOT_LOGGER.childAlreadyDeclared(Element.LOCAL.getLocalName(), Element.DOMAIN_CONTROLLER.getLocalName(), reader.getLocation());
                    }
                    hostAddOp.get("is-domain-controller").set(false);
                    this.parseRemoteDomainController(reader, address, list);
                    hasRemote = true;
                    continue block4;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        if (!hasLocal && !hasRemote) {
            throw ControllerLogger.ROOT_LOGGER.domainControllerMustBeDeclared(Element.REMOTE.getLocalName(), Element.LOCAL.getLocalName(), reader.getLocation());
        }
    }

    private void parseLocalDomainController(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        boolean hasDiscoveryOptions = false;
        HashSet<String> staticDiscoveryOptionNames = new HashSet<String>();
        HashSet<String> discoveryOptionNames = new HashSet<String>();
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case DISCOVERY_OPTIONS: {
                    if (hasDiscoveryOptions) {
                        throw ControllerLogger.ROOT_LOGGER.alreadyDefined(element.getLocalName(), reader.getLocation());
                    }
                    this.parseDiscoveryOptions(reader, address, list, staticDiscoveryOptionNames, discoveryOptionNames);
                    hasDiscoveryOptions = true;
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseRemoteDomainController(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
        boolean requireDiscoveryOptions = false;
        boolean hasDiscoveryOptions = false;
        requireDiscoveryOptions = this.parseRemoteDomainControllerAttributes(reader, address, list);
        HashSet<String> types = new HashSet<String>();
        HashSet<String> staticDiscoveryOptionNames = new HashSet<String>();
        HashSet<String> discoveryOptionNames = new HashSet<String>();
        block4: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case IGNORED_RESOURCE: {
                    this.parseIgnoredResource(reader, address, list, types);
                    continue block4;
                }
                case DISCOVERY_OPTIONS: {
                    if (hasDiscoveryOptions) {
                        throw ControllerLogger.ROOT_LOGGER.alreadyDefined(element.getLocalName(), reader.getLocation());
                    }
                    this.parseDiscoveryOptions(reader, address, list, staticDiscoveryOptionNames, discoveryOptionNames);
                    hasDiscoveryOptions = true;
                    continue block4;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        if (requireDiscoveryOptions && !hasDiscoveryOptions) {
            throw ControllerLogger.ROOT_LOGGER.discoveryOptionsMustBeDeclared("--admin-only", Attribute.ADMIN_ONLY_POLICY.getLocalName(), AdminOnlyDomainConfigPolicy.FETCH_FROM_MASTER.toString(), Element.DISCOVERY_OPTIONS.getLocalName(), Attribute.HOST.getLocalName(), Attribute.PORT.getLocalName(), reader.getLocation());
        }
    }

    private boolean parseRemoteDomainControllerAttributes(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
        ModelNode remoteDc = new ModelNode();
        ModelNode updateDc = remoteDc.get("remote").setEmptyObject();
        AdminOnlyDomainConfigPolicy adminOnlyPolicy = AdminOnlyDomainConfigPolicy.DEFAULT;
        boolean requireDiscoveryOptions = false;
        int count = reader.getAttributeCount();
        block10: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case HOST: {
                    DomainControllerWriteAttributeHandler.HOST.parseAndSetParameter(value, updateDc, (XMLStreamReader)reader);
                    continue block10;
                }
                case PORT: {
                    DomainControllerWriteAttributeHandler.PORT.parseAndSetParameter(value, updateDc, (XMLStreamReader)reader);
                    continue block10;
                }
                case PROTOCOL: {
                    DomainControllerWriteAttributeHandler.PROTOCOL.parseAndSetParameter(value, updateDc, (XMLStreamReader)reader);
                    continue block10;
                }
                case AUTHENTICATION_CONTEXT: {
                    DomainControllerWriteAttributeHandler.AUTHENTICATION_CONTEXT.parseAndSetParameter(value, updateDc, (XMLStreamReader)reader);
                    continue block10;
                }
                case SECURITY_REALM: {
                    DomainControllerWriteAttributeHandler.SECURITY_REALM.parseAndSetParameter(value, updateDc, (XMLStreamReader)reader);
                    continue block10;
                }
                case USERNAME: {
                    DomainControllerWriteAttributeHandler.USERNAME.parseAndSetParameter(value, updateDc, (XMLStreamReader)reader);
                    continue block10;
                }
                case IGNORE_UNUSED_CONFIG: {
                    DomainControllerWriteAttributeHandler.IGNORE_UNUSED_CONFIG.parseAndSetParameter(value, updateDc, (XMLStreamReader)reader);
                    continue block10;
                }
                case ADMIN_ONLY_POLICY: {
                    DomainControllerWriteAttributeHandler.ADMIN_ONLY_POLICY.parseAndSetParameter(value, updateDc, (XMLStreamReader)reader);
                    ModelNode nodeValue = updateDc.get(DomainControllerWriteAttributeHandler.ADMIN_ONLY_POLICY.getName());
                    if (nodeValue.getType() == ModelType.EXPRESSION) continue block10;
                    adminOnlyPolicy = AdminOnlyDomainConfigPolicy.getPolicy(nodeValue.asString());
                    continue block10;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!updateDc.hasDefined(DomainControllerWriteAttributeHandler.HOST.getName())) {
            requireDiscoveryOptions = this.isRequireDiscoveryOptions(adminOnlyPolicy);
        }
        if (!updateDc.hasDefined(DomainControllerWriteAttributeHandler.PORT.getName())) {
            requireDiscoveryOptions = requireDiscoveryOptions || this.isRequireDiscoveryOptions(adminOnlyPolicy);
        }
        ModelNode update = Util.getWriteAttributeOperation((ModelNode)address, (String)"domain-controller", (ModelNode)remoteDc);
        list.add(update);
        return requireDiscoveryOptions;
    }

    private boolean isRequireDiscoveryOptions(AdminOnlyDomainConfigPolicy adminOnlyPolicy) {
        return !this.isCachedDc && (this.runningMode != RunningMode.ADMIN_ONLY || adminOnlyPolicy == AdminOnlyDomainConfigPolicy.FETCH_FROM_MASTER);
    }

    private void parseIgnoredResource(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list, Set<String> foundTypes) throws XMLStreamException {
        ModelNode op = new ModelNode();
        op.get("operation").set("add");
        String type = null;
        int count = reader.getAttributeCount();
        block7: for (int i = 0; i < count; ++i) {
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case TYPE: {
                    if (!foundTypes.add(value)) {
                        throw HostControllerLogger.ROOT_LOGGER.duplicateIgnoredResourceType(Element.IGNORED_RESOURCE.getLocalName(), value, reader.getLocation());
                    }
                    type = value;
                    continue block7;
                }
                case WILDCARD: {
                    IgnoredDomainTypeResourceDefinition.WILDCARD.parseAndSetParameter(value, op, (XMLStreamReader)reader);
                    continue block7;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (type == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.TYPE.getLocalName()));
        }
        ModelNode addr = op.get("address").set(address);
        addr.add("core-service", "ignored-resources");
        addr.add("ignored-resource-type", type);
        block8: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case INSTANCE: {
                    String name = ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"name");
                    IgnoredDomainTypeResourceDefinition.NAMES.parseAndAddParameterElement(name, op, (XMLStreamReader)reader);
                    continue block8;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        list.add(op);
    }

    protected void parseDiscoveryOptions(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list, Set<String> staticDiscoveryOptionNames, Set<String> discoveryOptionNames) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        block4: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case DISCOVERY_OPTION: {
                    this.parseDiscoveryOption(reader, address, list, discoveryOptionNames);
                    continue block4;
                }
                case STATIC_DISCOVERY: {
                    this.parseStaticDiscoveryOption(reader, address, list, staticDiscoveryOptionNames);
                    continue block4;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    protected void parseStaticDiscoveryOption(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list, Set<String> staticDiscoveryOptionNames) throws XMLStreamException {
        ModelNode staticDiscoveryOptionAddress = address.clone();
        staticDiscoveryOptionAddress.add("core-service", "discovery-options");
        ModelNode addOp = Util.getEmptyOperation((String)"add", (ModelNode)new ModelNode());
        list.add(addOp);
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME, Attribute.HOST, Attribute.PORT);
        int count = reader.getAttributeCount();
        block6: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            required.remove(attribute);
            switch (attribute) {
                case NAME: {
                    if (!staticDiscoveryOptionNames.add(value)) {
                        throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, (String)value);
                    }
                    addOp.get("address").set(staticDiscoveryOptionAddress).add("static-discovery", value);
                    continue block6;
                }
                case HOST: {
                    StaticDiscoveryResourceDefinition.HOST.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block6;
                }
                case PROTOCOL: {
                    StaticDiscoveryResourceDefinition.PROTOCOL.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block6;
                }
                case PORT: {
                    StaticDiscoveryResourceDefinition.PORT.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (required.size() > 0) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    protected void parseDiscoveryOption(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list, Set<String> discoveryOptionNames) throws XMLStreamException {
        ModelNode addOp = this.parseDiscoveryOptionAttributes(reader, address, list, discoveryOptionNames);
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case PROPERTY: {
                    this.parseDiscoveryOptionProperty(reader, addOp.get("properties"));
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private ModelNode parseDiscoveryOptionAttributes(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list, Set<String> discoveryOptionNames) throws XMLStreamException {
        ModelNode discoveryOptionAddress = address.clone();
        discoveryOptionAddress.add("core-service", "discovery-options");
        ModelNode addOp = Util.getEmptyOperation((String)"add", (ModelNode)new ModelNode());
        list.add(addOp);
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME, Attribute.CODE);
        int count = reader.getAttributeCount();
        block5: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            required.remove(attribute);
            switch (attribute) {
                case NAME: {
                    if (!discoveryOptionNames.add(value)) {
                        throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, (String)value);
                    }
                    addOp.get("address").set(discoveryOptionAddress).add("discovery-option", value);
                    continue block5;
                }
                case CODE: {
                    DiscoveryOptionResourceDefinition.CODE.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block5;
                }
                case MODULE: {
                    DiscoveryOptionResourceDefinition.MODULE.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block5;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (required.size() > 0) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        return addOp;
    }

    protected void parseDiscoveryOptionProperty(XMLExtendedStreamReader reader, ModelNode discoveryOptionProperties) throws XMLStreamException {
        String propertyName = null;
        String propertyValue = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME, Attribute.VALUE);
        int count = reader.getAttributeCount();
        block4: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            required.remove(attribute);
            switch (attribute) {
                case NAME: {
                    propertyName = value;
                    continue block4;
                }
                case VALUE: {
                    propertyValue = value;
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (required.size() > 0) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        discoveryOptionProperties.add(propertyName, propertyValue);
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void parseJvms(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        HashSet<String> names = new HashSet<String>();
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case JVM: {
                    JvmXml.parseJvm(reader, address, this.namespace, list, names, false);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseServersAttributes(XMLExtendedStreamReader reader, ModelNode parentAddress, List<ModelNode> list) throws XMLStreamException {
        int count = reader.getAttributeCount();
        block3: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case DIRECTORY_GROUPING: {
                    ModelNode address = parentAddress.clone();
                    list.add(Util.getWriteAttributeOperation((ModelNode)address, (String)"directory-grouping", (ModelNode)HostResourceDefinition.DIRECTORY_GROUPING.parse(value, (XMLStreamReader)reader)));
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
    }

    private void parseServers(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
        this.parseServersAttributes(reader, address, list);
        HashSet<String> names = new HashSet<String>();
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case SERVER: {
                    this.parseServer(reader, address, list, names);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseServer(XMLExtendedStreamReader reader, ModelNode parentAddress, List<ModelNode> list, Set<String> serverNames) throws XMLStreamException {
        ModelNode addUpdate = this.parseServerAttributes(reader, parentAddress, serverNames);
        ModelNode address = addUpdate.require("address");
        list.add(addUpdate);
        this.parseServerContent(reader, addUpdate, address, list);
    }

    private void parseServerContent(XMLExtendedStreamReader reader, ModelNode serverAddOperation, ModelNode serverAddress, List<ModelNode> list) throws XMLStreamException {
        boolean sawJvm = false;
        boolean sawSystemProperties = false;
        boolean sawSocketBinding = false;
        boolean sawSSL = false;
        HashSet interfaceNames = new HashSet();
        block8: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case INTERFACES: {
                    this.parseInterfaces(reader, interfaceNames, serverAddress, this.namespace, list, true);
                    continue block8;
                }
                case JVM: {
                    if (sawJvm) {
                        throw ControllerLogger.ROOT_LOGGER.alreadyDefined(element.getLocalName(), reader.getLocation());
                    }
                    JvmXml.parseJvm(reader, serverAddress, this.namespace, list, new HashSet<String>(), true);
                    sawJvm = true;
                    continue block8;
                }
                case PATHS: {
                    this.parsePaths(reader, serverAddress, this.namespace, list, true);
                    continue block8;
                }
                case SOCKET_BINDINGS: {
                    if (sawSocketBinding) {
                        throw ControllerLogger.ROOT_LOGGER.alreadyDefined(element.getLocalName(), reader.getLocation());
                    }
                    this.parseServerSocketBindings(reader, serverAddOperation);
                    sawSocketBinding = true;
                    continue block8;
                }
                case SSL: {
                    if (sawSSL) {
                        throw ControllerLogger.ROOT_LOGGER.alreadyDefined(element.getLocalName(), reader.getLocation());
                    }
                    this.parseServerSsl(serverAddress, reader, list);
                    sawSSL = true;
                    continue block8;
                }
                case SYSTEM_PROPERTIES: {
                    if (sawSystemProperties) {
                        throw ControllerLogger.ROOT_LOGGER.alreadyDefined(element.getLocalName(), reader.getLocation());
                    }
                    this.parseSystemProperties(reader, serverAddress, this.namespace, list, false);
                    sawSystemProperties = true;
                    continue block8;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private ModelNode parseServerAttributes(XMLExtendedStreamReader reader, ModelNode parentAddress, Set<String> serverNames) throws XMLStreamException {
        ModelNode addUpdate = new ModelNode();
        addUpdate.get("operation").set("add");
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME, Attribute.GROUP);
        int count = reader.getAttributeCount();
        block6: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            required.remove(attribute);
            switch (attribute) {
                case NAME: {
                    if (!serverNames.add(value)) {
                        throw ControllerLogger.ROOT_LOGGER.duplicateDeclaration("server", value, reader.getLocation());
                    }
                    ModelNode address = parentAddress.clone().add("server-config", value);
                    addUpdate.get("address").set(address);
                    continue block6;
                }
                case GROUP: {
                    ServerConfigResourceDefinition.GROUP.parseAndSetParameter(value, addUpdate, (XMLStreamReader)reader);
                    continue block6;
                }
                case AUTO_START: {
                    ServerConfigResourceDefinition.AUTO_START.parseAndSetParameter(value, addUpdate, (XMLStreamReader)reader);
                    continue block6;
                }
                case UPDATE_AUTO_START_WITH_SERVER_STATUS: {
                    ServerConfigResourceDefinition.UPDATE_AUTO_START_WITH_SERVER_STATUS.parseAndSetParameter(value, addUpdate, (XMLStreamReader)reader);
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (required.size() > 0) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        return addUpdate;
    }

    private void parseServerSocketBindings(XMLExtendedStreamReader reader, ModelNode serverAddOperation) throws XMLStreamException {
        int count = reader.getAttributeCount();
        block5: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case SOCKET_BINDING_GROUP: {
                    ServerConfigResourceDefinition.SOCKET_BINDING_GROUP.parseAndSetParameter(value, serverAddOperation, (XMLStreamReader)reader);
                    continue block5;
                }
                case DEFAULT_INTERFACE: {
                    ServerConfigResourceDefinition.SOCKET_BINDING_DEFAULT_INTERFACE.parseAndSetParameter(value, serverAddOperation, (XMLStreamReader)reader);
                    continue block5;
                }
                case PORT_OFFSET: {
                    ServerConfigResourceDefinition.SOCKET_BINDING_PORT_OFFSET.parseAndSetParameter(value, serverAddOperation, (XMLStreamReader)reader);
                    continue block5;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void parseServerSsl(ModelNode parentAddress, XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ModelNode addOp = new ModelNode();
        addOp.get("operation").set("add");
        ModelNode address = parentAddress.clone();
        address.add("ssl", "loopback");
        addOp.get("address").set(address);
        operations.add(addOp);
        int count = reader.getAttributeCount();
        block7: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case SSL_PROTOCOL: {
                    SslLoopbackResourceDefinition.SSL_PROTOCOCOL.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block7;
                }
                case TRUST_MANAGER_ALGORITHM: {
                    SslLoopbackResourceDefinition.TRUST_MANAGER_ALGORITHM.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block7;
                }
                case TRUSTSTORE_TYPE: {
                    SslLoopbackResourceDefinition.TRUSTSTORE_TYPE.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block7;
                }
                case TRUSTSTORE_PATH: {
                    SslLoopbackResourceDefinition.TRUSTSTORE_PATH.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block7;
                }
                case TRUSTSTORE_PASSWORD: {
                    SslLoopbackResourceDefinition.TRUSTSTORE_PASSWORD.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block7;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void parseHostProfile(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        LinkedHashMap profileOps = new LinkedHashMap();
        while (reader.hasNext() && reader.nextTag() != 2) {
            if (Element.forName((String)reader.getLocalName()) != Element.SUBSYSTEM) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            String namespace = reader.getNamespaceURI();
            if (profileOps.containsKey(namespace)) {
                throw ControllerLogger.ROOT_LOGGER.duplicateDeclaration("subsystem", reader.getLocation());
            }
            ArrayList subsystems = new ArrayList();
            reader.handleAny(subsystems);
            profileOps.put(namespace, subsystems);
        }
        Set completionHandlers = this.extensionRegistry.getProfileParsingCompletionHandlers();
        for (ProfileParsingCompletionHandler completionHandler : completionHandlers) {
            completionHandler.handleProfileParsingCompletion(profileOps, list);
        }
        for (List subsystems : profileOps.values()) {
            for (ModelNode update : subsystems) {
                ModelNode subsystemAddress = address.clone();
                for (Property path : update.get("address").asPropertyList()) {
                    subsystemAddress.add(path.getName(), path.getValue().asString());
                }
                update.get("address").set(subsystemAddress);
                list.add(update);
            }
        }
    }

    private void parseSocketBindingGroup(XMLExtendedStreamReader reader, Set<String> interfaces, ModelNode address, List<ModelNode> updates) throws XMLStreamException {
        HashSet<String> uniqueBindingNames = new HashSet<String>();
        ModelNode op = Util.getEmptyOperation((String)"add", null);
        String socketBindingGroupName = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME, Attribute.DEFAULT_INTERFACE);
        int count = reader.getAttributeCount();
        block9: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    socketBindingGroupName = value;
                    required.remove(attribute);
                    continue block9;
                }
                case DEFAULT_INTERFACE: {
                    SocketBindingGroupResourceDefinition.DEFAULT_INTERFACE.parseAndSetParameter(value, op, (XMLStreamReader)reader);
                    required.remove(attribute);
                    if (op.get(SocketBindingGroupResourceDefinition.DEFAULT_INTERFACE.getName()).getType() == ModelType.EXPRESSION || interfaces.contains(value)) continue block9;
                    throw ControllerLogger.ROOT_LOGGER.unknownInterface(value, Attribute.DEFAULT_INTERFACE.getLocalName(), Element.INTERFACES.getLocalName(), reader.getLocation());
                }
                case PORT_OFFSET: {
                    SocketBindingGroupResourceDefinition.PORT_OFFSET.parseAndSetParameter(value, op, (XMLStreamReader)reader);
                    continue block9;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        ModelNode groupAddress = address.clone().add("socket-binding-group", socketBindingGroupName);
        op.get("address").set(groupAddress);
        updates.add(op);
        block10: while (reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case SOCKET_BINDING: {
                    String bindingName = this.parseSocketBinding(reader, interfaces, groupAddress, updates);
                    if (uniqueBindingNames.add(bindingName)) continue block10;
                    throw ControllerLogger.ROOT_LOGGER.alreadyDeclared(Element.SOCKET_BINDING.getLocalName(), Element.OUTBOUND_SOCKET_BINDING.getLocalName(), bindingName, Element.SOCKET_BINDING_GROUP.getLocalName(), socketBindingGroupName, reader.getLocation());
                }
                case OUTBOUND_SOCKET_BINDING: {
                    String bindingName = this.parseOutboundSocketBinding(reader, interfaces, groupAddress, updates);
                    if (uniqueBindingNames.add(bindingName)) continue block10;
                    throw ControllerLogger.ROOT_LOGGER.alreadyDeclared(Element.SOCKET_BINDING.getLocalName(), Element.OUTBOUND_SOCKET_BINDING.getLocalName(), bindingName, Element.SOCKET_BINDING_GROUP.getLocalName(), socketBindingGroupName, reader.getLocation());
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void writeDomainController(XMLExtendedStreamWriter writer, ModelNode modelNode, ModelNode ignoredResources, ModelNode discoveryOptions) throws XMLStreamException {
        writer.writeStartElement(Element.DOMAIN_CONTROLLER.getLocalName());
        if (modelNode.hasDefined("local")) {
            if (discoveryOptions != null) {
                writer.writeStartElement(Element.LOCAL.getLocalName());
                this.writeDiscoveryOptions(writer, discoveryOptions);
                writer.writeEndElement();
            } else {
                writer.writeEmptyElement(Element.LOCAL.getLocalName());
            }
        } else if (modelNode.hasDefined("remote")) {
            writer.writeStartElement(Element.REMOTE.getLocalName());
            ModelNode remote = modelNode.get("remote");
            RemoteDomainControllerAddHandler.PROTOCOL.marshallAsAttribute(remote, (XMLStreamWriter)writer);
            RemoteDomainControllerAddHandler.HOST.marshallAsAttribute(remote, (XMLStreamWriter)writer);
            RemoteDomainControllerAddHandler.PORT.marshallAsAttribute(remote, (XMLStreamWriter)writer);
            RemoteDomainControllerAddHandler.AUTHENTICATION_CONTEXT.marshallAsAttribute(remote, (XMLStreamWriter)writer);
            RemoteDomainControllerAddHandler.SECURITY_REALM.marshallAsAttribute(remote, (XMLStreamWriter)writer);
            RemoteDomainControllerAddHandler.USERNAME.marshallAsAttribute(remote, (XMLStreamWriter)writer);
            RemoteDomainControllerAddHandler.IGNORE_UNUSED_CONFIG.marshallAsAttribute(remote, (XMLStreamWriter)writer);
            RemoteDomainControllerAddHandler.ADMIN_ONLY_POLICY.marshallAsAttribute(remote, (XMLStreamWriter)writer);
            if (ignoredResources != null) {
                this.writeIgnoredResources(writer, ignoredResources);
            }
            if (discoveryOptions != null) {
                this.writeDiscoveryOptions(writer, discoveryOptions);
            }
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    private void writeIgnoredResources(XMLExtendedStreamWriter writer, ModelNode ignoredTypes) throws XMLStreamException {
        for (String ignoredName : ignoredTypes.keys()) {
            boolean hasNames;
            ModelNode ignored = ignoredTypes.get(ignoredName);
            ModelNode names = ignored.hasDefined("names") ? ignored.get("names") : null;
            boolean bl = hasNames = names != null && names.asInt() > 0;
            if (hasNames) {
                writer.writeStartElement(Element.IGNORED_RESOURCE.getLocalName());
            } else {
                writer.writeEmptyElement(Element.IGNORED_RESOURCE.getLocalName());
            }
            writer.writeAttribute(Attribute.TYPE.getLocalName(), ignoredName);
            IgnoredDomainTypeResourceDefinition.WILDCARD.marshallAsAttribute(ignored, (XMLStreamWriter)writer);
            if (!hasNames) continue;
            for (ModelNode name : names.asList()) {
                writer.writeEmptyElement(Element.INSTANCE.getLocalName());
                writer.writeAttribute(Attribute.NAME.getLocalName(), name.asString());
            }
            writer.writeEndElement();
        }
    }

    private void writeDiscoveryOptions(XMLExtendedStreamWriter writer, ModelNode discoveryOptions) throws XMLStreamException {
        writer.writeStartElement(Element.DISCOVERY_OPTIONS.getLocalName());
        block4: for (Property property : discoveryOptions.asPropertyList()) {
            String type = property.getName().equals("static-discovery") ? "static-discovery" : "discovery-option";
            Element element = Element.forName((String)type);
            String optionName = property.getValue().get("name").asString();
            switch (element) {
                case STATIC_DISCOVERY: {
                    ModelNode staticDiscoveryOption = property.getValue();
                    writer.writeStartElement(element.getLocalName());
                    WriteUtils.writeAttribute((XMLExtendedStreamWriter)writer, (Attribute)Attribute.NAME, (String)optionName);
                    StaticDiscoveryResourceDefinition.PROTOCOL.marshallAsAttribute(staticDiscoveryOption, (XMLStreamWriter)writer);
                    StaticDiscoveryResourceDefinition.HOST.marshallAsAttribute(staticDiscoveryOption, (XMLStreamWriter)writer);
                    StaticDiscoveryResourceDefinition.PORT.marshallAsAttribute(staticDiscoveryOption, (XMLStreamWriter)writer);
                    writer.writeEndElement();
                    continue block4;
                }
                case DISCOVERY_OPTION: {
                    ModelNode discoveryOption = property.getValue();
                    writer.writeStartElement(element.getLocalName());
                    WriteUtils.writeAttribute((XMLExtendedStreamWriter)writer, (Attribute)Attribute.NAME, (String)optionName);
                    DiscoveryOptionResourceDefinition.CODE.marshallAsAttribute(discoveryOption, (XMLStreamWriter)writer);
                    DiscoveryOptionResourceDefinition.MODULE.marshallAsAttribute(discoveryOption, (XMLStreamWriter)writer);
                    if (discoveryOption.hasDefined("properties")) {
                        this.writeDiscoveryOptionProperties(writer, discoveryOption.get("properties"));
                    }
                    writer.writeEndElement();
                    continue block4;
                }
            }
            throw new RuntimeException(ControllerLogger.ROOT_LOGGER.unknownChildType(element.getLocalName()));
        }
        writer.writeEndElement();
    }

    private void writeDiscoveryOptionProperties(XMLExtendedStreamWriter writer, ModelNode discoveryOptionProperties) throws XMLStreamException {
        for (String property : discoveryOptionProperties.keys()) {
            writer.writeStartElement(Element.PROPERTY.getLocalName());
            WriteUtils.writeAttribute((XMLExtendedStreamWriter)writer, (Attribute)Attribute.NAME, (String)property);
            WriteUtils.writeAttribute((XMLExtendedStreamWriter)writer, (Attribute)Attribute.VALUE, (String)discoveryOptionProperties.get(property).asString());
            writer.writeEndElement();
        }
    }

    private void writeServers(XMLExtendedStreamWriter writer, ModelNode modelNode) throws XMLStreamException {
        for (String serverName : modelNode.keys()) {
            Iterator iterator;
            ModelNode server = modelNode.get(serverName);
            writer.writeStartElement(Element.SERVER.getLocalName());
            WriteUtils.writeAttribute((XMLExtendedStreamWriter)writer, (Attribute)Attribute.NAME, (String)serverName);
            ServerConfigResourceDefinition.GROUP.marshallAsAttribute(server, (XMLStreamWriter)writer);
            ServerConfigResourceDefinition.AUTO_START.marshallAsAttribute(server, (XMLStreamWriter)writer);
            ServerConfigResourceDefinition.UPDATE_AUTO_START_WITH_SERVER_STATUS.marshallAsAttribute(server, (XMLStreamWriter)writer);
            if (server.hasDefined("path")) {
                this.writePaths(writer, server.get("path"), false);
            }
            if (server.hasDefined("system-property")) {
                this.writeProperties(writer, server.get("system-property"), Element.SYSTEM_PROPERTIES, false);
            }
            if (server.hasDefined("interface")) {
                this.writeInterfaces(writer, server.get("interface"));
            }
            if (server.hasDefined("jvm") && (iterator = server.get("jvm").asPropertyList().iterator()).hasNext()) {
                Property jvm = (Property)iterator.next();
                JvmXml.writeJVMElement(writer, jvm.getName(), jvm.getValue());
            }
            if (server.hasDefined("socket-binding-group") || server.hasDefined("socket-binding-port-offset") || server.hasDefined("socket-binding-default-interface")) {
                writer.writeStartElement(Element.SOCKET_BINDINGS.getLocalName());
                ServerConfigResourceDefinition.SOCKET_BINDING_GROUP.marshallAsAttribute(server, (XMLStreamWriter)writer);
                ServerConfigResourceDefinition.SOCKET_BINDING_PORT_OFFSET.marshallAsAttribute(server, (XMLStreamWriter)writer);
                ServerConfigResourceDefinition.SOCKET_BINDING_DEFAULT_INTERFACE.marshallAsAttribute(server, (XMLStreamWriter)writer);
                writer.writeEndElement();
            }
            if (server.hasDefined(new String[]{"ssl", "loopback"})) {
                ModelNode ssl = server.get(new String[]{"ssl", "loopback"});
                writer.writeStartElement(Element.SSL.getLocalName());
                SslLoopbackResourceDefinition.SSL_PROTOCOCOL.marshallAsAttribute(ssl, (XMLStreamWriter)writer);
                SslLoopbackResourceDefinition.TRUST_MANAGER_ALGORITHM.marshallAsAttribute(ssl, (XMLStreamWriter)writer);
                SslLoopbackResourceDefinition.TRUSTSTORE_TYPE.marshallAsAttribute(ssl, (XMLStreamWriter)writer);
                SslLoopbackResourceDefinition.TRUSTSTORE_PATH.marshallAsAttribute(ssl, (XMLStreamWriter)writer);
                SslLoopbackResourceDefinition.TRUSTSTORE_PASSWORD.marshallAsAttribute(ssl, (XMLStreamWriter)writer);
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
    }

    private void writeHostProfile(XMLExtendedStreamWriter writer, ModelMarshallingContext context) throws XMLStreamException {
        ModelNode profileNode = context.getModelNode();
        if (!profileNode.hasDefined("subsystem")) {
            return;
        }
        writer.writeStartElement(Element.PROFILE.getLocalName());
        HostXml_18.writeSubsystems((ModelNode)profileNode, (XMLExtendedStreamWriter)writer, (ModelMarshallingContext)context);
        writer.writeEndElement();
    }

    public boolean parseManagementInterfaces(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> operationsList) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        boolean interfaceDefined = false;
        block4: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case NATIVE_INTERFACE: {
                    interfaceDefined = true;
                    this.parseNativeManagementInterface(reader, address, operationsList);
                    continue block4;
                }
                case HTTP_INTERFACE: {
                    interfaceDefined = true;
                    this.parseHttpManagementInterface(reader, address, operationsList);
                    continue block4;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        if (!interfaceDefined) {
            throw ParseUtils.missingOneOf((XMLExtendedStreamReader)reader, EnumSet.of(Element.NATIVE_INTERFACE, Element.HTTP_INTERFACE));
        }
        return true;
    }

    public boolean parseAuditLog(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
        this.auditLogDelegate.parseAuditLog(reader, address, this.namespace, list);
        return true;
    }

    public boolean writeNativeManagementProtocol(XMLExtendedStreamWriter writer, ModelNode protocol) throws XMLStreamException {
        writer.writeStartElement(Element.NATIVE_INTERFACE.getLocalName());
        NativeManagementResourceDefinition.SASL_AUTHENTICATION_FACTORY.marshallAsAttribute(protocol, (XMLStreamWriter)writer);
        NativeManagementResourceDefinition.SSL_CONTEXT.marshallAsAttribute(protocol, (XMLStreamWriter)writer);
        NativeManagementResourceDefinition.SECURITY_REALM.marshallAsAttribute(protocol, (XMLStreamWriter)writer);
        NativeManagementResourceDefinition.SASL_PROTOCOL.marshallAsAttribute(protocol, (XMLStreamWriter)writer);
        NativeManagementResourceDefinition.SERVER_NAME.marshallAsAttribute(protocol, (XMLStreamWriter)writer);
        writer.writeEmptyElement(Element.SOCKET.getLocalName());
        NativeManagementResourceDefinition.INTERFACE.marshallAsAttribute(protocol, (XMLStreamWriter)writer);
        NativeManagementResourceDefinition.NATIVE_PORT.marshallAsAttribute(protocol, (XMLStreamWriter)writer);
        writer.writeEndElement();
        return true;
    }

    public boolean writeHttpManagementProtocol(XMLExtendedStreamWriter writer, ModelNode protocol) throws XMLStreamException {
        writer.writeStartElement(Element.HTTP_INTERFACE.getLocalName());
        HttpManagementResourceDefinition.HTTP_AUTHENTICATION_FACTORY.marshallAsAttribute(protocol, (XMLStreamWriter)writer);
        HttpManagementResourceDefinition.SSL_CONTEXT.marshallAsAttribute(protocol, (XMLStreamWriter)writer);
        HttpManagementResourceDefinition.SECURITY_REALM.marshallAsAttribute(protocol, (XMLStreamWriter)writer);
        HttpManagementResourceDefinition.CONSOLE_ENABLED.marshallAsAttribute(protocol, (XMLStreamWriter)writer);
        HttpManagementResourceDefinition.ALLOWED_ORIGINS.getMarshaller().marshallAsAttribute((AttributeDefinition)HttpManagementResourceDefinition.ALLOWED_ORIGINS, protocol, true, (XMLStreamWriter)writer);
        HttpManagementResourceDefinition.SASL_PROTOCOL.marshallAsAttribute(protocol, (XMLStreamWriter)writer);
        HttpManagementResourceDefinition.SERVER_NAME.marshallAsAttribute(protocol, (XMLStreamWriter)writer);
        if (HttpManagementResourceDefinition.HTTP_UPGRADE.isMarshallable(protocol)) {
            writer.writeEmptyElement(Element.HTTP_UPGRADE.getLocalName());
            HttpManagementResourceDefinition.ENABLED.marshallAsAttribute(protocol.require("http-upgrade"), (XMLStreamWriter)writer);
            HttpManagementResourceDefinition.SASL_AUTHENTICATION_FACTORY.marshallAsAttribute(protocol.require("http-upgrade"), (XMLStreamWriter)writer);
        }
        writer.writeEmptyElement(Element.SOCKET.getLocalName());
        HttpManagementResourceDefinition.INTERFACE.marshallAsAttribute(protocol, (XMLStreamWriter)writer);
        HttpManagementResourceDefinition.HTTP_PORT.marshallAsAttribute(protocol, (XMLStreamWriter)writer);
        HttpManagementResourceDefinition.HTTPS_PORT.marshallAsAttribute(protocol, (XMLStreamWriter)writer);
        HttpManagementResourceDefinition.SECURE_INTERFACE.marshallAsAttribute(protocol, (XMLStreamWriter)writer);
        if (HttpManagementResourceDefinition.CONSTANT_HEADERS.isMarshallable(protocol)) {
            writer.writeStartElement(Element.CONSTANT_HEADERS.getLocalName());
            for (ModelNode headerMapping : protocol.require("constant-headers").asList()) {
                writer.writeStartElement(Element.HEADER_MAPPING.getLocalName());
                BaseHttpInterfaceResourceDefinition.PATH.marshallAsAttribute(headerMapping, (XMLStreamWriter)writer);
                for (ModelNode header : headerMapping.require("headers").asList()) {
                    writer.writeEmptyElement(Element.HEADER.getLocalName());
                    BaseHttpInterfaceResourceDefinition.HEADER_NAME.marshallAsAttribute(header, (XMLStreamWriter)writer);
                    BaseHttpInterfaceResourceDefinition.HEADER_VALUE.marshallAsAttribute(header, (XMLStreamWriter)writer);
                }
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
        writer.writeEndElement();
        return true;
    }

    public boolean writeAuditLog(XMLExtendedStreamWriter writer, ModelNode auditLog) throws XMLStreamException {
        this.auditLogDelegate.writeAuditLog(writer, auditLog);
        return true;
    }
}

