/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.operations;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ReloadRequiredWriteAttributeHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;

public class StaticDiscoveryWriteAttributeHandler
extends ReloadRequiredWriteAttributeHandler {
    public StaticDiscoveryWriteAttributeHandler(SimpleAttributeDefinition attribute) {
        super(new AttributeDefinition[]{attribute});
    }

    protected boolean requiresRuntime(OperationContext context) {
        return !context.isBooting();
    }

    protected void finishModelStage(OperationContext context, ModelNode operation, String attributeName, ModelNode newValue, ModelNode oldValue, Resource model) throws OperationFailedException {
        super.finishModelStage(context, operation, attributeName, newValue, oldValue, model);
        PathAddress operationAddress = context.getCurrentAddress();
        PathAddress discoveryOptionsAddress = operationAddress.getParent();
        ModelNode discoveryOptions = context.readResourceFromRoot(discoveryOptionsAddress, false).getModel();
        ModelNode currentListClone = discoveryOptions.get("options").clone();
        String name = context.getCurrentAddressValue();
        for (ModelNode element : currentListClone.asList()) {
            Property prop = element.asProperty();
            String discoveryOptionType = prop.getName();
            String discoveryOptionName = prop.getValue().get("name").asString();
            if (!discoveryOptionName.equals(name) || !discoveryOptionType.equals("static-discovery")) continue;
            ModelNode node = element.get("static-discovery");
            node.get(attributeName).set(newValue);
            break;
        }
        ModelNode writeOp = Util.getWriteAttributeOperation((PathAddress)discoveryOptionsAddress, (String)"options", (ModelNode)currentListClone);
        OperationStepHandler writeHandler = context.getRootResourceRegistration().getSubModel(discoveryOptionsAddress).getOperationHandler(PathAddress.EMPTY_ADDRESS, "write-attribute");
        context.addStep(writeOp, writeHandler, OperationContext.Stage.MODEL, true);
    }
}

