/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.logging;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Locale;
import java.util.concurrent.ExecutionException;
import javax.security.sasl.SaslException;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.RunningMode;
import org.jboss.as.controller.client.helpers.domain.ServerStatus;
import org.jboss.as.host.controller.discovery.DiscoveryOption;
import org.jboss.as.host.controller.logging.HostControllerLogger;
import org.jboss.as.host.controller.model.host.AdminOnlyDomainConfigPolicy;
import org.jboss.as.host.controller.model.jvm.JvmType;
import org.jboss.as.protocol.mgmt.RequestProcessingException;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;
import org.jboss.remoting3.Channel;

public class HostControllerLogger_$logger
extends DelegatingBasicLogger
implements HostControllerLogger,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = HostControllerLogger_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;

    public HostControllerLogger_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    @Override
    public final void cannotConnect(URI uri, Exception cause) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)cause, this.cannotConnect$str(), (Object)uri);
    }

    protected String cannotConnect$str() {
        return "WFLYHC0001: Could not connect to remote domain controller %s";
    }

    @Override
    public final void cannotConnectToMaster(Exception e) {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.cannotConnectToMaster$str(), (Object)e);
    }

    protected String cannotConnectToMaster$str() {
        return "WFLYHC0002: Could not connect to master. Error was: %s";
    }

    @Override
    public final void creatingHttpManagementService(String interfaceName, int port, int securePort) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.creatingHttpManagementService$str(), (Object)interfaceName, (Object)port, (Object)securePort);
    }

    protected String creatingHttpManagementService$str() {
        return "WFLYHC0003: Creating http management service using network interface (%s) port (%d) securePort (%d)";
    }

    @Override
    public final void existingServerWithState(String serverName, ServerStatus state) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.existingServerWithState$str(), (Object)serverName, (Object)state);
    }

    protected String existingServerWithState$str() {
        return "WFLYHC0005: Existing server [%s] with status: %s";
    }

    @Override
    public final void failedToStartServer(Throwable cause, String serverName) {
        this.log.logf(FQCN, Logger.Level.ERROR, cause, this.failedToStartServer$str(), (Object)serverName);
    }

    protected String failedToStartServer$str() {
        return "WFLYHC0008: Failed to start server (%s)";
    }

    @Override
    public final void failedToStopServer(Throwable cause, String serverName) {
        this.log.logf(FQCN, Logger.Level.ERROR, cause, this.failedToStopServer$str(), (Object)serverName);
    }

    protected String failedToStopServer$str() {
        return "WFLYHC0009: Failed to stop server (%s)";
    }

    @Override
    public final void ignoringPermGen(JvmType type, String jvm) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.ignoringPermGen$str(), (Object)type, (Object)jvm);
    }

    protected String ignoringPermGen$str() {
        return "WFLYHC0011: Ignoring <permgen> for jvm '%s' type jvm: %s";
    }

    @Override
    public final void noDomainControllerConfigurationProvided(RunningMode currentRunningMode, String adminOnlyCmdLineArg, RunningMode validRunningMode) {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.noDomainControllerConfigurationProvided$str(), (Object)currentRunningMode, (Object)adminOnlyCmdLineArg, (Object)validRunningMode);
    }

    protected String noDomainControllerConfigurationProvided$str() {
        return "WFLYHC0012: No <domain-controller> configuration was provided and the current running mode ('%s') requires access to the Domain Controller host. Startup will be aborted. Use the %s command line argument to start in %s mode if you need to start without a domain controller connection and then use the management tools to configure one.";
    }

    @Override
    public final void httpManagementInterfaceIsUnsecured() {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.httpManagementInterfaceIsUnsecured$str(), new Object[0]);
    }

    protected String httpManagementInterfaceIsUnsecured$str() {
        return "WFLYHC0013: No security realm defined for http management service, all access will be unrestricted.";
    }

    @Override
    public final void noServerAvailable(String serverName) {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.noServerAvailable$str(), (Object)serverName);
    }

    protected String noServerAvailable$str() {
        return "WFLYHC0014: No server called %s available";
    }

    @Override
    public final void lostRemoteDomainConnection() {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.lostRemoteDomainConnection$str(), new Object[0]);
    }

    protected String lostRemoteDomainConnection$str() {
        return "WFLYHC0015: Connection to remote host-controller closed. Trying to reconnect.";
    }

    @Override
    public final void optionAlreadySet(String option, String jvm, String element) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.optionAlreadySet$str(), (Object)option, (Object)jvm, (Object)element);
    }

    protected String optionAlreadySet$str() {
        return "WFLYHC0016: Ignoring <option value=\"%s\" for jvm '%s' since '%s' was set";
    }

    @Override
    public final void reconnectingServer(String serverName) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.reconnectingServer$str(), (Object)serverName);
    }

    protected String reconnectingServer$str() {
        return "WFLYHC0018: Reconnecting server %s";
    }

    @Override
    public final void registeredRemoteSlaveHost(String hostName, String productName) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.registeredRemoteSlaveHost$str(), (Object)hostName, (Object)productName);
    }

    protected String registeredRemoteSlaveHost$str() {
        return "WFLYHC0019: Registered remote slave host \"%s\", %s";
    }

    @Override
    public final void registeringServer(String name) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.registeringServer$str(), (Object)name);
    }

    protected String registeringServer$str() {
        return "WFLYHC0020: Registering server %s";
    }

    @Override
    public final void serverConnected(String name, Channel channel) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.serverConnected$str(), (Object)name, (Object)channel);
    }

    protected String serverConnected$str() {
        return "WFLYHC0021: Server [%s] connected using connection [%s]";
    }

    @Override
    public final void startingServer(String serverName) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.startingServer$str(), (Object)serverName);
    }

    protected String startingServer$str() {
        return "WFLYHC0023: Starting server %s";
    }

    @Override
    public final void stoppingServer(String serverName) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.stoppingServer$str(), (Object)serverName);
    }

    protected String stoppingServer$str() {
        return "WFLYHC0024: Stopping server %s";
    }

    @Override
    public final void unregisteredRemoteSlaveHost(String host) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.unregisteredRemoteSlaveHost$str(), (Object)host);
    }

    protected String unregisteredRemoteSlaveHost$str() {
        return "WFLYHC0026: Unregistered remote slave host \"%s\"";
    }

    @Override
    public final void unregisteringServer(String name) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.unregisteringServer$str(), (Object)name);
    }

    protected String unregisteringServer$str() {
        return "WFLYHC0027: Unregistering server %s";
    }

    @Override
    public final void unregisteredAtRemoteHostController() {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.unregisteredAtRemoteHostController$str(), new Object[0]);
    }

    protected String unregisteredAtRemoteHostController$str() {
        return "WFLYHC0029: Unregistered at domain controller";
    }

    @Override
    public final void lostConnectionToRemoteHost(String hostId) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.lostConnectionToRemoteHost$str(), (Object)hostId);
    }

    protected String lostConnectionToRemoteHost$str() {
        return "WFLYHC0030: Connection to remote host \"%s\" closed unexpectedly";
    }

    @Override
    public final void invalidRemoteBackupPersisterState() {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.invalidRemoteBackupPersisterState$str(), new Object[0]);
    }

    protected String invalidRemoteBackupPersisterState$str() {
        return "WFLYHC0031: Cannot load the domain model using --backup";
    }

    @Override
    public final void caughtExceptionDuringBoot(Exception e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.caughtExceptionDuringBoot$str(), new Object[0]);
    }

    protected String caughtExceptionDuringBoot$str() {
        return "WFLYHC0033: Caught exception during boot";
    }

    protected String unsuccessfulBoot$str() {
        return "WFLYHC0034: Host Controller boot has failed in an unrecoverable manner; exiting. See previous messages for details.";
    }

    @Override
    public final String unsuccessfulBoot() {
        return String.format(this.getLoggingLocale(), this.unsuccessfulBoot$str(), new Object[0]);
    }

    @Override
    public final void reportAdminOnlyDomainXmlFailure() {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.reportAdminOnlyDomainXmlFailure$str(), new Object[0]);
    }

    protected String reportAdminOnlyDomainXmlFailure$str() {
        return "WFLYHC0035: Installation of the domain-wide configuration has failed. Because the running mode of this Host Controller is ADMIN_ONLY boot has been allowed to proceed. If ADMIN_ONLY mode were not in effect the process would be terminated due to a critical boot failure.";
    }

    @Override
    public final void masterHostControllerChanged() {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.masterHostControllerChanged$str(), new Object[0]);
    }

    protected String masterHostControllerChanged$str() {
        return "WFLYHC0037: The master host controller has been restarted. Re-registering this slave host controller with the new master.";
    }

    @Override
    public final void masterHostControllerUnreachable(long timeout) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.masterHostControllerUnreachable$str(), (Object)timeout);
    }

    protected String masterHostControllerUnreachable$str() {
        return "WFLYHC0038: The master host controller could not be reached in the last [%d] milliseconds. Re-connecting.";
    }

    @Override
    public final void slaveHostControllerChanged(String hostName) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.slaveHostControllerChanged$str(), (Object)hostName);
    }

    protected String slaveHostControllerChanged$str() {
        return "WFLYHC0039: The slave host controller \"%s\" has been restarted or is attempting to reconnect. Unregistering the current connection to this slave.";
    }

    @Override
    public final void slaveHostControllerUnreachable(String hostName, long timeout) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.slaveHostControllerUnreachable$str(), (Object)hostName, (Object)timeout);
    }

    protected String slaveHostControllerUnreachable$str() {
        return "WFLYHC0040: The slave host controller \"%s\"  could not be reached in the last [%d] milliseconds. Unregistering.";
    }

    protected String argumentExpected$str() {
        return "WFLYHC0041: Argument expected for option %s. %s";
    }

    @Override
    public final String argumentExpected(String option, String usageNote) {
        return String.format(this.getLoggingLocale(), this.argumentExpected$str(), option, usageNote);
    }

    protected String attemptingToSet$str() {
        return "WFLYHC0042: Attempting to set '%s' when '%s' was already set";
    }

    @Override
    public final IllegalArgumentException attemptingToSet(String attributeToSet, String attributeAlreadySet) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.attemptingToSet$str(), attributeToSet, attributeAlreadySet));
        HostControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    protected String authenticationFailureUnableToConnect$str() {
        return "WFLYHC0043: Unable to connect due to authentication failure.";
    }

    @Override
    public final IllegalStateException authenticationFailureUnableToConnect(Throwable cause) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.authenticationFailureUnableToConnect$str(), new Object[0]), cause);
        HostControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotAccessRemoteFileRepository$str() {
        return "WFLYHC0044: Cannot access a remote file repository from the master domain controller";
    }

    @Override
    public final IllegalStateException cannotAccessRemoteFileRepository() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.cannotAccessRemoteFileRepository$str(), new Object[0]));
        HostControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotCreateLocalDirectory$str() {
        return "WFLYHC0045: Unable to create local directory: %s";
    }

    @Override
    public final IOException cannotCreateLocalDirectory(File path) {
        IOException result = new IOException(String.format(this.getLoggingLocale(), this.cannotCreateLocalDirectory$str(), path));
        HostControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotObtainValidDefaultAddress$str() {
        return "WFLYHC0046: Cannot obtain a valid default address for communicating with the ProcessController using either %s or InetAddress.getLocalHost(). Please check your system's network configuration or use the %s command line switch to configure a valid address";
    }

    @Override
    public final RuntimeException cannotObtainValidDefaultAddress(Throwable cause, String defaultAddress, String option) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.cannotObtainValidDefaultAddress$str(), defaultAddress, option), cause);
        HostControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotRestartServer$str() {
        return "WFLYHC0047: Cannot restart server %s as it is not currently started; it is %s";
    }

    @Override
    public final String cannotRestartServer(String serverName, ServerStatus status) {
        return String.format(this.getLoggingLocale(), this.cannotRestartServer$str(), serverName, status);
    }

    protected String cannotStartServersInvalidMode$str() {
        return "WFLYHC0048: Cannot start servers when the Host Controller running mode is %s";
    }

    @Override
    public final String cannotStartServersInvalidMode(RunningMode mode) {
        return String.format(this.getLoggingLocale(), this.cannotStartServersInvalidMode$str(), mode);
    }

    protected String closeShouldBeManagedByService$str() {
        return "WFLYHC0049: Close should be managed by the service";
    }

    @Override
    public final UnsupportedOperationException closeShouldBeManagedByService() {
        UnsupportedOperationException result = new UnsupportedOperationException(String.format(this.getLoggingLocale(), this.closeShouldBeManagedByService$str(), new Object[0]));
        HostControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String configurationPersisterAlreadyInitialized$str() {
        return "WFLYHC0050: Configuration persister for domain model is already initialized";
    }

    @Override
    public final IllegalStateException configurationPersisterAlreadyInitialized() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.configurationPersisterAlreadyInitialized$str(), new Object[0]));
        HostControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String connectionToMasterInterrupted$str() {
        return "WFLYHC0051: Interrupted while trying to connect to master";
    }

    @Override
    public final IllegalStateException connectionToMasterInterrupted() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.connectionToMasterInterrupted$str(), new Object[0]));
        HostControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String connectionToMasterTimeout$str() {
        return "WFLYHC0052: Could not connect to master in %d attempts within %s ms";
    }

    @Override
    public final IllegalStateException connectionToMasterTimeout(Throwable cause, int retries, long timeout) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.connectionToMasterTimeout$str(), retries, timeout), cause);
        HostControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String couldNotGetServerInventory$str() {
        return "WFLYHC0053: Could not get the server inventory in %d %s";
    }

    @Override
    public final RuntimeException couldNotGetServerInventory(long time, String timeUnit) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.couldNotGetServerInventory$str(), time, timeUnit));
        HostControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String didNotReadEntireFile$str() {
        return "WFLYHC0054: Did not read the entire file. Missing: %d";
    }

    @Override
    public final IOException didNotReadEntireFile(long missing) {
        IOException result = new IOException(String.format(this.getLoggingLocale(), this.didNotReadEntireFile$str(), missing));
        HostControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String errorClosingDownHost$str() {
        return "WFLYHC0055: Error closing down host";
    }

    @Override
    public final RuntimeException errorClosingDownHost(Throwable cause) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.errorClosingDownHost$str(), new Object[0]), cause);
        HostControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String failedProfileOperationsRetrieval$str() {
        return "WFLYHC0056: Failed to retrieve profile operations from domain controller";
    }

    @Override
    public final String failedProfileOperationsRetrieval() {
        return String.format(this.getLoggingLocale(), this.failedProfileOperationsRetrieval$str(), new Object[0]);
    }

    protected String failedToGetFileFromRemoteRepository$str() {
        return "WFLYHC0057: Failed to get file from remote repository";
    }

    @Override
    public final RuntimeException failedToGetFileFromRemoteRepository(Throwable cause) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.failedToGetFileFromRemoteRepository$str(), new Object[0]), cause);
        HostControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String failedToGetServerStatus$str() {
        return "WFLYHC0058: Failed to get server status";
    }

    @Override
    public final String failedToGetServerStatus() {
        return String.format(this.getLoggingLocale(), this.failedToGetServerStatus$str(), new Object[0]);
    }

    protected String failedToReadAuthenticationKey$str() {
        return "WFLYHC0059: Failed to read authentication key: %s";
    }

    @Override
    public final String failedToReadAuthenticationKey(Throwable cause) {
        return String.format(this.getLoggingLocale(), this.failedToReadAuthenticationKey$str(), cause);
    }

    protected String insufficientInformationToGenerateHash$str() {
        return "WFLYHC0061: Insufficient information to generate hash.";
    }

    @Override
    public final SaslException insufficientInformationToGenerateHash() {
        SaslException result = new SaslException(String.format(this.getLoggingLocale(), this.insufficientInformationToGenerateHash$str(), new Object[0]));
        HostControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidOption$str() {
        return "WFLYHC0062: Invalid option '%s'. %s";
    }

    @Override
    public final String invalidOption(String option, String usageNote) {
        return String.format(this.getLoggingLocale(), this.invalidOption$str(), option, usageNote);
    }

    protected String invalidRootId$str() {
        return "WFLYHC0063: Invalid root id [%d]";
    }

    @Override
    public final RequestProcessingException invalidRootId(int rootId) {
        RequestProcessingException result = new RequestProcessingException(String.format(this.getLoggingLocale(), this.invalidRootId$str(), rootId));
        HostControllerLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String invalidValue$str() {
        return "WFLYHC0064: Value for %s is not an %s -- %s. %s";
    }

    @Override
    public final String invalidValue(String name, String type, Object value, String usageNote) {
        return String.format(this.getLoggingLocale(), this.invalidValue$str(), name, type, value, usageNote);
    }

    protected String invocationNotAllowedAfterBoot$str() {
        return "WFLYHC0065: Invocations of %s after HostController boot are not allowed";
    }

    @Override
    public final IllegalStateException invocationNotAllowedAfterBoot(String name) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.invocationNotAllowedAfterBoot$str(), name));
        HostControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final String invocationNotAllowedAfterBoot(ModelNode operation) {
        return String.format(this.getLoggingLocale(), this.invocationNotAllowedAfterBoot$str(), operation);
    }

    protected String malformedUrl$str() {
        return "WFLYHC0066: Malformed URL provided for option %s. %s";
    }

    @Override
    public final String malformedUrl(String option, String usageNote) {
        return String.format(this.getLoggingLocale(), this.malformedUrl$str(), option, usageNote);
    }

    protected String mustInvokeBeforeCheckingSlaveStatus$str() {
        return "WFLYHC0067: Must call %s before checking for slave status";
    }

    @Override
    public final IllegalStateException mustInvokeBeforeCheckingSlaveStatus(String methodName) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.mustInvokeBeforeCheckingSlaveStatus$str(), methodName));
        HostControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String mustInvokeBeforePersisting$str() {
        return "WFLYHC0068: Must call %s before persisting the domain model";
    }

    @Override
    public final IllegalStateException mustInvokeBeforePersisting(String methodName) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.mustInvokeBeforePersisting$str(), methodName));
        HostControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String noServerInventory$str() {
        return "WFLYHC0071: No server inventory";
    }

    @Override
    public final IllegalStateException noServerInventory() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.noServerInventory$str(), new Object[0]));
        HostControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String serverNameAlreadyRegistered$str() {
        return "WFLYHC0077: There is already a registered server named '%s'";
    }

    @Override
    public final IllegalArgumentException serverNameAlreadyRegistered(String serverName) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.serverNameAlreadyRegistered$str(), serverName));
        HostControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String serverStillRunning$str() {
        return "WFLYHC0078: Server (%s) still running";
    }

    @Override
    public final String serverStillRunning(String name) {
        return String.format(this.getLoggingLocale(), this.serverStillRunning$str(), name);
    }

    protected String unableToGenerateHash$str() {
        return "WFLYHC0079: Unable to generate hash";
    }

    @Override
    public final SaslException unableToGenerateHash(Throwable cause) {
        SaslException result = new SaslException(String.format(this.getLoggingLocale(), this.unableToGenerateHash$str(), new Object[0]), cause);
        HostControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unableToLoadProperties$str() {
        return "WFLYHC0080: Unable to load properties from URL %s. %s";
    }

    @Override
    public final String unableToLoadProperties(URL url, String usageNote) {
        return String.format(this.getLoggingLocale(), this.unableToLoadProperties$str(), url, usageNote);
    }

    protected String undefinedSocketBinding$str() {
        return "WFLYHC0081: Undefined socket binding group for server %s";
    }

    @Override
    public final IllegalArgumentException undefinedSocketBinding(String serverName) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.undefinedSocketBinding$str(), serverName));
        HostControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String undefinedSocketBindingGroup$str() {
        return "WFLYHC0082: Included socket binding group %s is not defined";
    }

    @Override
    public final IllegalStateException undefinedSocketBindingGroup(String name) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.undefinedSocketBindingGroup$str(), name));
        HostControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unknown$str() {
        return "WFLYHC0084: Unknown %s %s";
    }

    @Override
    public final IllegalArgumentException unknown(String name, Object value) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.unknown$str(), name, value));
        HostControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unknownHostValue$str() {
        return "WFLYHC0085: Value for %s is not a known host -- %s. %s";
    }

    @Override
    public final String unknownHostValue(String name, Object value, String usageNote) {
        return String.format(this.getLoggingLocale(), this.unknownHostValue$str(), name, value, usageNote);
    }

    protected String hostAlreadyShutdown$str() {
        return "WFLYHC0087: Host-Controller is already shutdown.";
    }

    @Override
    public final IllegalStateException hostAlreadyShutdown() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.hostAlreadyShutdown$str(), new Object[0]));
        HostControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String hostControllerSystemPropertyUpdateNotSupported$str() {
        return "WFLYHC0090: HostControllerEnvironment does not support system property updates";
    }

    @Override
    public final UnsupportedOperationException hostControllerSystemPropertyUpdateNotSupported() {
        UnsupportedOperationException result = new UnsupportedOperationException(String.format(this.getLoggingLocale(), this.hostControllerSystemPropertyUpdateNotSupported$str(), new Object[0]));
        HostControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotIgnoreTypeHost$str() {
        return "WFLYHC0091: Resources of type %s cannot be ignored";
    }

    @Override
    public final OperationFailedException cannotIgnoreTypeHost(String type) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.cannotIgnoreTypeHost$str(), type));
        HostControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String duplicateIgnoredResourceType$str() {
        return "WFLYHC0092: An '%s' element whose 'type' attribute is '%s' has already been found";
    }

    @Override
    public final XMLStreamException duplicateIgnoredResourceType(String element, String value, Location location) {
        XMLStreamException result = new XMLStreamException(String.format(this.getLoggingLocale(), this.duplicateIgnoredResourceType$str(), element, value), location);
        HostControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotAccessJvmInputArgument$str() {
        return "WFLYHC0093: The JVM input arguments cannot be accessed so system properties passed directly to this Host Controller JVM will not be passed through to server processes. Cause of the problem: %s";
    }

    @Override
    public final String cannotAccessJvmInputArgument(Exception cause) {
        return String.format(this.getLoggingLocale(), this.cannotAccessJvmInputArgument$str(), cause);
    }

    protected String missingHomeDirConfiguration$str() {
        return "WFLYHC0094: Missing configuration value for: %s";
    }

    @Override
    public final IllegalStateException missingHomeDirConfiguration(String propertyName) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.missingHomeDirConfiguration$str(), propertyName));
        HostControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String homeDirectoryDoesNotExist$str() {
        return "WFLYHC0095: Home directory does not exist: %s";
    }

    @Override
    public final IllegalStateException homeDirectoryDoesNotExist(File f) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.homeDirectoryDoesNotExist$str(), f));
        HostControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String domainBaseDirectoryDoesNotExist$str() {
        return "WFLYHC0097: Domain base directory does not exist: %s";
    }

    @Override
    public final IllegalStateException domainBaseDirectoryDoesNotExist(File f) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.domainBaseDirectoryDoesNotExist$str(), f));
        HostControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String domainBaseDirectoryIsNotADirectory$str() {
        return "WFLYHC0098: Domain base directory is not a directory: %s";
    }

    @Override
    public final IllegalStateException domainBaseDirectoryIsNotADirectory(File file) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.domainBaseDirectoryIsNotADirectory$str(), file));
        HostControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String configDirectoryDoesNotExist$str() {
        return "WFLYHC0099: Configuration directory does not exist: %s";
    }

    @Override
    public final IllegalStateException configDirectoryDoesNotExist(File f) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.configDirectoryDoesNotExist$str(), f));
        HostControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String domainDataDirectoryIsNotDirectory$str() {
        return "WFLYHC0100: Domain data directory is not a directory: %s";
    }

    @Override
    public final IllegalStateException domainDataDirectoryIsNotDirectory(File file) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.domainDataDirectoryIsNotDirectory$str(), file));
        HostControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String couldNotCreateDomainDataDirectory$str() {
        return "WFLYHC0101: Could not create domain data directory: %s";
    }

    @Override
    public final IllegalStateException couldNotCreateDomainDataDirectory(File file) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.couldNotCreateDomainDataDirectory$str(), file));
        HostControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String domainContentDirectoryIsNotDirectory$str() {
        return "WFLYHC0102: Domain content directory is not a directory: %s";
    }

    @Override
    public final IllegalStateException domainContentDirectoryIsNotDirectory(File file) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.domainContentDirectoryIsNotDirectory$str(), file));
        HostControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String couldNotCreateDomainContentDirectory$str() {
        return "WFLYHC0103: Could not create domain content directory: %s";
    }

    @Override
    public final IllegalStateException couldNotCreateDomainContentDirectory(File file) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.couldNotCreateDomainContentDirectory$str(), file));
        HostControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String logDirectoryIsNotADirectory$str() {
        return "WFLYHC0104: Log directory is not a directory: %s";
    }

    @Override
    public final IllegalStateException logDirectoryIsNotADirectory(File f) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.logDirectoryIsNotADirectory$str(), f));
        HostControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String couldNotCreateLogDirectory$str() {
        return "WFLYHC0105: Could not create log directory: %s";
    }

    @Override
    public final IllegalStateException couldNotCreateLogDirectory(File f) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.couldNotCreateLogDirectory$str(), f));
        HostControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String serversDirectoryIsNotADirectory$str() {
        return "WFLYHC0106: Servers directory is not a directory: %s";
    }

    @Override
    public final IllegalStateException serversDirectoryIsNotADirectory(File f) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.serversDirectoryIsNotADirectory$str(), f));
        HostControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String couldNotCreateServersDirectory$str() {
        return "WFLYHC0107: Could not create servers directory: %s";
    }

    @Override
    public final IllegalStateException couldNotCreateServersDirectory(File f) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.couldNotCreateServersDirectory$str(), f));
        HostControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String domainTempDirectoryIsNotADirectory$str() {
        return "WFLYHC0108: Domain temp directory does not exist: %s";
    }

    @Override
    public final IllegalStateException domainTempDirectoryIsNotADirectory(File file) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.domainTempDirectoryIsNotADirectory$str(), file));
        HostControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String couldNotCreateDomainTempDirectory$str() {
        return "WFLYHC0109: Could not create domain temp directory: %s";
    }

    @Override
    public final IllegalStateException couldNotCreateDomainTempDirectory(File file) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.couldNotCreateDomainTempDirectory$str(), file));
        HostControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String sslFailureUnableToConnect$str() {
        return "WFLYHC0110: Unable to connect due to SSL failure.";
    }

    @Override
    public final IllegalStateException sslFailureUnableToConnect(Throwable cause) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.sslFailureUnableToConnect$str(), new Object[0]), cause);
        HostControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String jvmOptionAlreadyExists$str() {
        return "WFLYHC0111: Option '%s' already exists";
    }

    @Override
    public final IllegalStateException jvmOptionAlreadyExists(String option) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.jvmOptionAlreadyExists$str(), option));
        HostControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unsupportedManagementVersionForHost$str() {
        return "WFLYHC0113: Host controller management version %s.%s is too old, Only %s.%s or higher are supported";
    }

    @Override
    public final OperationFailedException unsupportedManagementVersionForHost(int major, int minor, int minMajor, int minMinor) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.unsupportedManagementVersionForHost$str(), major, minor, minMajor, minMinor));
        HostControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String failedToAddExtensions$str() {
        return "WFLYHC0114: Failed to add extensions used by the domain. Failure description: %s";
    }

    @Override
    public final IllegalStateException failedToAddExtensions(ModelNode failureDescription) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.failedToAddExtensions$str(), failureDescription));
        HostControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String argumentHasNoValue$str() {
        return "WFLYHC0115: Argument %s has no value. %s";
    }

    @Override
    public final String argumentHasNoValue(String argument, String usageNote) {
        return String.format(this.getLoggingLocale(), this.argumentHasNoValue$str(), argument, usageNote);
    }

    protected String usageNote$str() {
        return "Use %s --help for information on valid command line arguments and their syntax.";
    }

    @Override
    public final String usageNote(String command) {
        return String.format(this.getLoggingLocale(), this.usageNote$str(), command);
    }

    protected String cannotAccessS3File$str() {
        return "WFLYHC0116: Cannot access S3 file: %s";
    }

    @Override
    public final IllegalStateException cannotAccessS3File(String message) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.cannotAccessS3File$str(), message));
        HostControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String failedMarshallingDomainControllerData$str() {
        return "WFLYHC0117: Failed to obtain domain controller data from S3 file";
    }

    @Override
    public final IllegalStateException failedMarshallingDomainControllerData() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.failedMarshallingDomainControllerData$str(), new Object[0]));
        HostControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotWriteToS3File$str() {
        return "WFLYHC0118: Cannot write domain controller data to S3 file: %s";
    }

    @Override
    public final IOException cannotWriteToS3File(String message) {
        IOException result = new IOException(String.format(this.getLoggingLocale(), this.cannotWriteToS3File$str(), message));
        HostControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotAccessS3Bucket$str() {
        return "WFLYHC0119: Cannot access S3 bucket '%s': %s";
    }

    @Override
    public final IllegalStateException cannotAccessS3Bucket(String location, String message) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.cannotAccessS3Bucket$str(), location, message));
        HostControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String discoveryOptionsFailureUnableToConnect$str() {
        return "WFLYHC0120: Tried all domain controller discovery option(s) but unable to connect";
    }

    @Override
    public final IllegalStateException discoveryOptionsFailureUnableToConnect(Throwable cause) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.discoveryOptionsFailureUnableToConnect$str(), new Object[0]), cause);
        HostControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String preSignedUrlsMustHaveSamePath$str() {
        return "WFLYHC0121: pre_signed_put_url and pre_signed_delete_url must have the same path";
    }

    @Override
    public final IllegalStateException preSignedUrlsMustHaveSamePath() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.preSignedUrlsMustHaveSamePath$str(), new Object[0]));
        HostControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String preSignedUrlsMustBeSetOrUnset$str() {
        return "WFLYHC0122: pre_signed_put_url and pre_signed_delete_url must both be set or both unset";
    }

    @Override
    public final IllegalStateException preSignedUrlsMustBeSetOrUnset() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.preSignedUrlsMustBeSetOrUnset$str(), new Object[0]));
        HostControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String preSignedUrlMustPointToFile$str() {
        return "WFLYHC0123: pre-signed url %s must point to a file within a bucket";
    }

    @Override
    public final IllegalStateException preSignedUrlMustPointToFile(String preSignedUrl) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.preSignedUrlMustPointToFile$str(), preSignedUrl));
        HostControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidPreSignedUrl$str() {
        return "WFLYHC0124: pre-signed url %s is not a valid url";
    }

    @Override
    public final IllegalStateException invalidPreSignedUrl(String preSignedUrl) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.invalidPreSignedUrl$str(), preSignedUrl));
        HostControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidPreSignedUrlLength$str() {
        return "WFLYHC0125: pre-signed url %s may only have a subdirectory under a bucket";
    }

    @Override
    public final IllegalStateException invalidPreSignedUrlLength(String preSignedUrl) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.invalidPreSignedUrlLength$str(), preSignedUrl));
        HostControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String creatingBucketWithUnsupportedCallingFormat$str() {
        return "WFLYHC0126: Creating location-constrained bucket with unsupported calling-format";
    }

    @Override
    public final IllegalArgumentException creatingBucketWithUnsupportedCallingFormat() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.creatingBucketWithUnsupportedCallingFormat$str(), new Object[0]));
        HostControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidS3Location$str() {
        return "WFLYHC0127: Invalid location: %s";
    }

    @Override
    public final IllegalArgumentException invalidS3Location(String location) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidS3Location$str(), location));
        HostControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidS3Bucket$str() {
        return "WFLYHC0128: Invalid bucket name: %s";
    }

    @Override
    public final IllegalArgumentException invalidS3Bucket(String bucket) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidS3Bucket$str(), bucket));
        HostControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String bucketAuthenticationFailure$str() {
        return "WFLYHC0129: bucket '%s' could not be accessed (rsp=%d (%s)). Maybe the bucket is owned by somebody else or the authentication failed";
    }

    @Override
    public final IOException bucketAuthenticationFailure(String bucket, int httpCode, String responseMessage) {
        IOException result = new IOException(String.format(this.getLoggingLocale(), this.bucketAuthenticationFailure$str(), bucket, httpCode, responseMessage));
        HostControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unexpectedResponse$str() {
        return "WFLYHC0130: Unexpected response: %s";
    }

    @Override
    public final IOException unexpectedResponse(String message) {
        IOException result = new IOException(String.format(this.getLoggingLocale(), this.unexpectedResponse$str(), message));
        HostControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String httpRedirectSupportRequired$str() {
        return "WFLYHC0131: HTTP redirect support required";
    }

    @Override
    public final RuntimeException httpRedirectSupportRequired() {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.httpRedirectSupportRequired$str(), new Object[0]));
        HostControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String errorParsingBucketListings$str() {
        return "WFLYHC0132: Unexpected error parsing bucket listing(s)";
    }

    @Override
    public final RuntimeException errorParsingBucketListings(Throwable cause) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.errorParsingBucketListings$str(), new Object[0]), cause);
        HostControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotInitializeSaxDriver$str() {
        return "WFLYHC0133: Couldn't initialize a SAX driver for the XMLReader";
    }

    @Override
    public final RuntimeException cannotInitializeSaxDriver() {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.cannotInitializeSaxDriver$str(), new Object[0]));
        HostControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotInstantiateDiscoveryOptionClass$str() {
        return "WFLYHC0134: Cannot instantiate discovery option class '%s': %s";
    }

    @Override
    public final IllegalStateException cannotInstantiateDiscoveryOptionClass(String className, String message) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.cannotInstantiateDiscoveryOptionClass$str(), className, message));
        HostControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void cannotWriteDomainControllerData(Exception e) {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.cannotWriteDomainControllerData$str(), (Object)e);
    }

    protected String cannotWriteDomainControllerData$str() {
        return "WFLYHC0137: Could not write domain controller data to S3 file. Error was: %s";
    }

    @Override
    public final void cannotRemoveS3File(Exception e) {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.cannotRemoveS3File$str(), (Object)e);
    }

    protected String cannotRemoveS3File$str() {
        return "WFLYHC0138: Could not remove S3 file. Error was: %s";
    }

    protected String cannotExecuteTransactionalOperationFromSlave$str() {
        return "WFLYHC0140: Can't execute transactional operation '%s' from slave controller";
    }

    @Override
    public final IllegalStateException cannotExecuteTransactionalOperationFromSlave(String operationName) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.cannotExecuteTransactionalOperationFromSlave$str(), operationName));
        HostControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void failedToApplyDomainConfig(Exception e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.failedToApplyDomainConfig0$str(), new Object[0]);
    }

    protected String failedToApplyDomainConfig0$str() {
        return "WFLYHC0142: Failed to apply domain-wide configuration from master host controller";
    }

    @Override
    public final void failedToApplyDomainConfig(String outcome, ModelNode failureDescription) {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.failedToApplyDomainConfig2$str(), (Object)outcome, (Object)failureDescription);
    }

    protected String failedToApplyDomainConfig2$str() {
        return "WFLYHC0143: Failed to apply domain-wide configuration from master host controller. Operation outcome: %s. Failure description %s";
    }

    @Override
    public final void fetchConfigFromDomainMasterFailed(RunningMode currentRunningMode, String policyAttribute, AdminOnlyDomainConfigPolicy policy, String cachedDcCmdLineArg) {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.fetchConfigFromDomainMasterFailed$str(), new Object[]{currentRunningMode, policyAttribute, policy, cachedDcCmdLineArg});
    }

    protected String fetchConfigFromDomainMasterFailed$str() {
        return "WFLYHC0144: The host cannot start because it was started in running mode '%s' with no access to a local copy of the domain wide configuration policy, the '%s' attribute was set to '%s' and the domain wide configuration policy could not be obtained from the Domain Controller host. Startup will be aborted. Use the '%s' command line argument to start if you need to start without connecting to a domain controller connection.";
    }

    @Override
    public final void noAccessControlConfigurationAvailable(RunningMode currentRunningMode, String policyAttribute, AdminOnlyDomainConfigPolicy policy, String cachedDcCmdLineArg, RunningMode desiredRunningMode) {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.noAccessControlConfigurationAvailable$str(), new Object[]{currentRunningMode, policyAttribute, policy, cachedDcCmdLineArg, desiredRunningMode});
    }

    protected String noAccessControlConfigurationAvailable$str() {
        return "WFLYHC0145: The host cannot start because it was started in running mode '%s' with no access to a local copy of the domain wide configuration policy, and the '%s' attribute was set to '%s'. Startup will be aborted. Use the '%s' command line argument to start in running mode '%s'.";
    }

    @Override
    public final void failedDiscoveringMaster(DiscoveryOption option, Exception e) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.failedDiscoveringMaster$str(), (Object)option, (Object)e);
    }

    protected String failedDiscoveringMaster$str() {
        return "WFLYHC0146: Could not discover master using discovery option %s. Error was: %s";
    }

    @Override
    public final void noDiscoveryOptionsLeft() {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.noDiscoveryOptionsLeft$str(), new Object[0]);
    }

    protected String noDiscoveryOptionsLeft$str() {
        return "WFLYHC0147: No domain controller discovery options remain.";
    }

    @Override
    public final void connectedToMaster(URI uri) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.connectedToMaster$str(), (Object)uri);
    }

    protected String connectedToMaster$str() {
        return "WFLYHC0148: Connected to master host controller at %s";
    }

    @Override
    public final void usingCachedDC(String configOption, String cachedXmlFile) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.usingCachedDC$str(), (Object)configOption, (Object)cachedXmlFile);
    }

    protected String usingCachedDC$str() {
        return "WFLYHC0149: Option %s was set; obtaining domain-wide configuration from %s";
    }

    @Override
    public final void reconnectingToMaster() {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.reconnectingToMaster$str(), new Object[0]);
    }

    protected String reconnectingToMaster$str() {
        return "WFLYHC0150: Trying to reconnect to master host controller.";
    }

    @Override
    public final void noDomainControllerConfigurationProvidedForAdminOnly(String policyAttribute, AdminOnlyDomainConfigPolicy policy, String cachedDcCmdLineArg, RunningMode desiredRunningMode) {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.noDomainControllerConfigurationProvidedForAdminOnly$str(), new Object[]{policyAttribute, policy, cachedDcCmdLineArg, desiredRunningMode});
    }

    protected String noDomainControllerConfigurationProvidedForAdminOnly$str() {
        return "WFLYHC0151: No domain controller discovery configuration was provided and the '%s' attribute was set to '%s'. Startup will be aborted. Use the %s command line argument to start in %s mode if you need to start without a domain controller connection and then use the management tools to configure one.";
    }

    @Override
    public final void serverLaunchCommandPrefix(String serverName, String launchCommandPrefix) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.serverLaunchCommandPrefix$str(), (Object)serverName, (Object)launchCommandPrefix);
    }

    protected String serverLaunchCommandPrefix$str() {
        return "WFLYHC0152: Server %s will be started with JVM launch command prefix '%s'";
    }

    protected String channelClosed$str() {
        return "WFLYHC0153: Channel closed";
    }

    @Override
    public final IOException channelClosed() {
        IOException result = new IOException(String.format(this.getLoggingLocale(), this.channelClosed$str(), new Object[0]));
        HostControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String couldNotCreateDomainAutoStartDirectory$str() {
        return "WFLYHC0157: Could not create domain auto-start directory: %s";
    }

    @Override
    public final IllegalStateException couldNotCreateDomainAutoStartDirectory(Path file, Throwable cause) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.couldNotCreateDomainAutoStartDirectory$str(), file), cause);
        HostControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void couldNotPersistAutoStartServerStatus(Throwable cause) {
        this.log.logf(FQCN, Logger.Level.INFO, cause, this.couldNotPersistAutoStartServerStatus$str(), new Object[0]);
    }

    protected String couldNotPersistAutoStartServerStatus$str() {
        return "WFLYHC0158: Error persisting server autostart status";
    }

    protected String invalidDiscoveryType$str() {
        return "WFLYHC0159: Invalid discovery type %s";
    }

    @Override
    public final String invalidDiscoveryType(String type) {
        return String.format(this.getLoggingLocale(), this.invalidDiscoveryType$str(), type);
    }

    protected String couldNotObtainDomainUuid$str() {
        return "WFLYHC0160: Could not read or create the domain UUID in file: %s";
    }

    @Override
    public final IllegalStateException couldNotObtainDomainUuid(Throwable cause, Path file) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.couldNotObtainDomainUuid$str(), file), cause);
        HostControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String bindingNameNotUnique$str() {
        return "WFLYHC0162: The binding name '%s' in socket binding group '%s' is not unique. Names must be unique across socket-binding, local-destination-outbound-socket-binding and remote-destination-outbound-socket-binding";
    }

    @Override
    public final OperationFailedException bindingNameNotUnique(String name, String groupName) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.bindingNameNotUnique$str(), name, groupName));
        HostControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String profileInvolvedInACycle$str() {
        return "WFLYHC0163: Profile '%s' is involved in a cycle";
    }

    @Override
    public final OperationFailedException profileInvolvedInACycle(String profile) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.profileInvolvedInACycle$str(), profile));
        HostControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String profileAttemptingToOverrideSubsystem$str() {
        return "WFLYHC0164: Profile '%s' defines subsystem '%s' which is also defined in its ancestor profile '%s'. Overriding subsystems is not supported";
    }

    @Override
    public final OperationFailedException profileAttemptingToOverrideSubsystem(String existingSubsystemProfile, String subsystem, String profileName) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.profileAttemptingToOverrideSubsystem$str(), existingSubsystemProfile, subsystem, profileName));
        HostControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String socketBindingGroupInvolvedInACycle$str() {
        return "WFLYHC0165: Socket binding group '%s' is involved in a cycle";
    }

    @Override
    public final OperationFailedException socketBindingGroupInvolvedInACycle(String include) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.socketBindingGroupInvolvedInACycle$str(), include));
        HostControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String socketBindingGroupAttemptingToOverrideSocketBinding$str() {
        return "WFLYHC0166: Socket binding group '%s' defines socket binding '%s' which is also defined in its ancestor socket binding group '%s'. Overriding socket bindings is not supported";
    }

    @Override
    public final OperationFailedException socketBindingGroupAttemptingToOverrideSocketBinding(String existingSubsystemProfile, String child, String resourceName) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.socketBindingGroupAttemptingToOverrideSocketBinding$str(), existingSubsystemProfile, child, resourceName));
        HostControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String profileIncludesSameSubsystem$str() {
        return "WFLYHC0167: Profile '%s' includes profile '%s' and profile '%s'. Both these profiles define subsystem '%s', which is not supported";
    }

    @Override
    public final OperationFailedException profileIncludesSameSubsystem(String profile, String include1, String include2, String child) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.profileIncludesSameSubsystem$str(), profile, include1, include2, child));
        HostControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String socketBindingGroupIncludesSameSocketBinding$str() {
        return "WFLYHC0168: Socket binding group '%s' includes socket binding group '%s' and socket binding group '%s'. Both these socket binding groups define socket binding '%s', which is not supported";
    }

    @Override
    public final OperationFailedException socketBindingGroupIncludesSameSocketBinding(String socketBindingGroup, String include1, String include2, String child) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.socketBindingGroupIncludesSameSocketBinding$str(), socketBindingGroup, include1, include2, child));
        HostControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String embeddedHostControllerRestartMustProvideAdminOnlyTrue$str() {
        return "WFLYHC0169: Reload into running mode is not supported with embedded host controller, admin-only=true must be specified.";
    }

    @Override
    public final OperationFailedException embeddedHostControllerRestartMustProvideAdminOnlyTrue() {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.embeddedHostControllerRestartMustProvideAdminOnlyTrue$str(), new Object[0]));
        HostControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String hostRegistrationCannotReleaseSharedLock$str() {
        return "WFLYHC0170: Error releasing shared lock after host registration for operationID: %s";
    }

    @Override
    public final String hostRegistrationCannotReleaseSharedLock(int operationID) {
        return String.format(this.getLoggingLocale(), this.hostRegistrationCannotReleaseSharedLock$str(), operationID);
    }

    @Override
    public final void suspendListenerFailed(ExecutionException cause, String serverName) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)cause, this.suspendListenerFailed$str(), (Object)serverName);
    }

    protected String suspendListenerFailed$str() {
        return "WFLYHC0171: Failed getting the response from the suspend listener for server: %s";
    }

    @Override
    public final void suspendExecutionFailed(IOException cause, String serverName) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)cause, this.suspendExecutionFailed$str(), (Object)serverName);
    }

    protected String suspendExecutionFailed$str() {
        return "WFLYHC0172: Failed executing the suspend operation for server: %s";
    }

    protected String cannotBothHaveFalseUseCurrentHostConfigAndHostConfig$str() {
        return "WFLYHC0173: It is not possible to use use-current-host-config=false while specifying a host-config";
    }

    @Override
    public final OperationFailedException cannotBothHaveFalseUseCurrentHostConfigAndHostConfig() {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.cannotBothHaveFalseUseCurrentHostConfigAndHostConfig$str(), new Object[0]));
        HostControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotBothHaveFalseUseCurrentDomainConfigAndDomainConfig$str() {
        return "WFLYHC0174: It is not possible to use use-current-domain-config=false while specifying a domain-config";
    }

    @Override
    public final OperationFailedException cannotBothHaveFalseUseCurrentDomainConfigAndDomainConfig() {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.cannotBothHaveFalseUseCurrentDomainConfigAndDomainConfig$str(), new Object[0]));
        HostControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String domainConfigForReloadNotFound$str() {
        return "WFLYHC0175: domain-config '%s' specified for reload could not be found";
    }

    @Override
    public final OperationFailedException domainConfigForReloadNotFound(String serverConfig) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.domainConfigForReloadNotFound$str(), serverConfig));
        HostControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void nativeManagementInterfaceIsUnsecured() {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.nativeManagementInterfaceIsUnsecured$str(), new Object[0]);
    }

    protected String nativeManagementInterfaceIsUnsecured$str() {
        return "WFLYHC0177: No security realm defined for native management service; all access will be unrestricted.";
    }

    @Override
    public final void aborting(int code) {
        this.log.logf(FQCN, Logger.Level.FATAL, null, this.aborting$str(), (Object)code);
    }

    protected String aborting$str() {
        return "WFLYHC0178: Aborting with exit code %d";
    }

    @Override
    public final void shuttingDownInResponseToProcessControllerSignal() {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.shuttingDownInResponseToProcessControllerSignal$str(), new Object[0]);
    }

    protected String shuttingDownInResponseToProcessControllerSignal$str() {
        return "WFLYHC0179: ProcessController has signalled to shut down; shutting down";
    }

    @Override
    public final void shuttingDownInResponseToManagementRequest(String op) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.shuttingDownInResponseToManagementRequest$str(), (Object)op);
    }

    protected String shuttingDownInResponseToManagementRequest$str() {
        return "WFLYHC0180: Shutting down in response to management operation '%s'";
    }

    @Override
    public final void shutdownHookInvoked() {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.shutdownHookInvoked$str(), new Object[0]);
    }

    protected String shutdownHookInvoked$str() {
        return "WFLYHC0181: Host Controller shutdown has been requested via an OS signal";
    }

    @Override
    public final void timedOutAwaitingSuspendResponse(int blockingTimeout, String serverName) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.timedOutAwaitingSuspendResponse$str(), (Object)blockingTimeout, (Object)serverName);
    }

    protected String timedOutAwaitingSuspendResponse$str() {
        return "WFLYHC0182: Timed out after %d ms awaiting server suspend response(s) for server: %s";
    }

    protected String timedOutAwaitingSuspendResponseMsg$str() {
        return "WFLYHC0183: Timed out after %d ms awaiting server suspend response(s) for server: %s";
    }

    @Override
    public final String timedOutAwaitingSuspendResponseMsg(int blockingTimeout, String serverName) {
        return String.format(this.getLoggingLocale(), this.timedOutAwaitingSuspendResponseMsg$str(), blockingTimeout, serverName);
    }

    @Override
    public final void interruptedAwaitingSuspendResponse(InterruptedException cause, String serverName) {
        this.log.logf(FQCN, Logger.Level.INFO, (Throwable)cause, this.interruptedAwaitingSuspendResponse$str(), (Object)serverName);
    }

    protected String interruptedAwaitingSuspendResponse$str() {
        return "WFLYHC0184: %s interrupted awaiting server suspend response(s)";
    }

    protected String interruptedAwaitingSuspendResponseMsg$str() {
        return "WFLYHC0185: %s interrupted awaiting server suspend response(s)";
    }

    @Override
    public final String interruptedAwaitingSuspendResponseMsg(String serverName) {
        return String.format(this.getLoggingLocale(), this.interruptedAwaitingSuspendResponseMsg$str(), serverName);
    }

    protected String suspendExecutionFailedMsg$str() {
        return "WFLYHC0186: Failed executing the suspend operation for server: %s";
    }

    @Override
    public final String suspendExecutionFailedMsg(String serverName) {
        return String.format(this.getLoggingLocale(), this.suspendExecutionFailedMsg$str(), serverName);
    }

    protected String suspendListenerFailedMsg$str() {
        return "WFLYHC0187: Failed getting the response from the suspend listener for server: %s";
    }

    @Override
    public final String suspendListenerFailedMsg(String serverName) {
        return String.format(this.getLoggingLocale(), this.suspendListenerFailedMsg$str(), serverName);
    }

    @Override
    public final void timedOutAwaitingResumeResponse(int blockingTimeout, String serverName) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.timedOutAwaitingResumeResponse$str(), (Object)blockingTimeout, (Object)serverName);
    }

    protected String timedOutAwaitingResumeResponse$str() {
        return "WFLYHC0188: Timed out after %d ms awaiting server resume response(s) for server: %s";
    }

    protected String timedOutAwaitingResumeResponseMsg$str() {
        return "WFLYHC0189: Timed out after %d ms awaiting server resume response(s) for server: %s";
    }

    @Override
    public final String timedOutAwaitingResumeResponseMsg(int blockingTimeout, String serverName) {
        return String.format(this.getLoggingLocale(), this.timedOutAwaitingResumeResponseMsg$str(), blockingTimeout, serverName);
    }

    @Override
    public final void interruptedAwaitingResumeResponse(InterruptedException cause, String serverName) {
        this.log.logf(FQCN, Logger.Level.INFO, (Throwable)cause, this.interruptedAwaitingResumeResponse$str(), (Object)serverName);
    }

    protected String interruptedAwaitingResumeResponse$str() {
        return "WFLYHC0190: %s interrupted awaiting server resume response(s)";
    }

    protected String interruptedAwaitingResumeResponseMsg$str() {
        return "WFLYHC0191: %s interrupted awaiting server resume response(s)";
    }

    @Override
    public final String interruptedAwaitingResumeResponseMsg(String serverName) {
        return String.format(this.getLoggingLocale(), this.interruptedAwaitingResumeResponseMsg$str(), serverName);
    }

    protected String resumeExecutionFailedMsg$str() {
        return "WFLYHC0192: Failed executing the resume operation for server: %s";
    }

    @Override
    public final String resumeExecutionFailedMsg(String serverName) {
        return String.format(this.getLoggingLocale(), this.resumeExecutionFailedMsg$str(), serverName);
    }

    protected String resumeListenerFailedMsg$str() {
        return "WFLYHC0193: Failed getting the response from the resume listener for server: %s";
    }

    @Override
    public final String resumeListenerFailedMsg(String serverName) {
        return String.format(this.getLoggingLocale(), this.resumeListenerFailedMsg$str(), serverName);
    }

    @Override
    public final void resumeExecutionFailed(IOException cause, String serverName) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)cause, this.resumeExecutionFailed$str(), (Object)serverName);
    }

    protected String resumeExecutionFailed$str() {
        return "WFLYHC0194: Failed executing the resume operation for server: %s";
    }

    @Override
    public final void resumeListenerFailed(ExecutionException cause, String serverName) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)cause, this.resumeListenerFailed$str(), (Object)serverName);
    }

    protected String resumeListenerFailed$str() {
        return "WFLYHC0195: Failed getting the response from the resume listener for server: %s";
    }

    @Override
    public final void cannotRenameCachedDomainXmlOnBoot(String tmpFilename, String destFilename, String reason) {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.cannotRenameCachedDomainXmlOnBoot$str(), (Object)tmpFilename, (Object)destFilename, (Object)reason);
    }

    protected String cannotRenameCachedDomainXmlOnBoot$str() {
        return "WFLYHC0196: Cannot move the file %s to %s, unable to persist domain configuration changes: %s ";
    }

    protected String attributeRequiresSSLContext$str() {
        return "WFLYHC0197: If attribute %s is defined one of ssl-context or security-realm must also be defined";
    }

    @Override
    public final OperationFailedException attributeRequiresSSLContext(String attribute) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.attributeRequiresSSLContext$str(), attribute));
        HostControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void managedServerUnstable(String serverName) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.managedServerUnstable1$str(), (Object)serverName);
    }

    protected String managedServerUnstable1$str() {
        return "WFLYHC0198: Server '%s' is unstable and should be stopped or restarted. An unstable server may not stop normally, so the 'kill' operation may be required to terminate the server process.";
    }

    @Override
    public final void managedServerUnstable(String serverName, String hostName) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.managedServerUnstable2$str(), (Object)serverName, (Object)hostName);
    }

    protected String managedServerUnstable2$str() {
        return "WFLYHC0198: Server '%s' (managed by host '%s') is unstable and should be stopped or restarted. An unstable server may not stop normally, so the 'kill' operation may be required to terminate the server process.";
    }

    @Override
    public final void serverSuspected(String serverName, String hostName) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.serverSuspected$str(), (Object)serverName, (Object)hostName);
    }

    protected String serverSuspected$str() {
        return "WFLYHC0199: Server '%s' (managed by host '%s') has not responded to an operation request within the configured timeout. This may mean the server has become unstable.";
    }

    @Override
    public final void failedReportingServerInstabilityToMaster(Exception e, String serverName) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.failedReportingServerInstabilityToMaster$str(), (Object)serverName);
    }

    protected String failedReportingServerInstabilityToMaster$str() {
        return "WFLYHC0200: Reporting instability of server '%s' to Domain Controller failed.";
    }

    protected String hostDomainSynchronizationError$str() {
        return "WFLYHC0201: Error synchronizing the host model with the domain controller model with failure : %s.";
    }

    @Override
    public final String hostDomainSynchronizationError(String failureDescription) {
        return String.format(this.getLoggingLocale(), this.hostDomainSynchronizationError$str(), failureDescription);
    }

    @Override
    public final void domainModelAppliedButReloadIsRequired() {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.domainModelAppliedButReloadIsRequired$str(), new Object[0]);
    }

    protected String domainModelAppliedButReloadIsRequired$str() {
        return "WFLYHC0202: The domain configuration was successfully applied, but reload is required before changes become active.";
    }

    @Override
    public final void domainModelAppliedButRestartIsRequired() {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.domainModelAppliedButRestartIsRequired$str(), new Object[0]);
    }

    protected String domainModelAppliedButRestartIsRequired$str() {
        return "WFLYHC0203: The domain configuration was successfully applied, but restart is required before changes become active.";
    }

    @Override
    public final void serverLoggingConfigurationFileNotFound(String serverName) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.serverLoggingConfigurationFileNotFound$str(), (Object)serverName);
    }

    protected String serverLoggingConfigurationFileNotFound$str() {
        return "WFLYHC0204: No logging configuration file could be found for the servers initial boot. Logging will not be configured until the logging subsystem is activated for the server %s";
    }

    @Override
    public final void failedToSetLoggingConfiguration(Throwable cause, String serverName, File path) {
        this.log.logf(FQCN, Logger.Level.ERROR, cause, this.failedToSetLoggingConfiguration$str(), (Object)serverName, (Object)path);
    }

    protected String failedToSetLoggingConfiguration$str() {
        return "WFLYHC0205: An error occurred setting the -Dlogging.configuration property for server %s. Configuration path %s";
    }

    protected String cannotOverwriteDomainXmlWithEmpty$str() {
        return "WFLYHC0206: File %s already exists, you must use --remove-existing-domain-config to overwrite existing files.";
    }

    @Override
    public final IllegalStateException cannotOverwriteDomainXmlWithEmpty(String filename) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.cannotOverwriteDomainXmlWithEmpty$str(), filename));
        HostControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotOverwriteHostXmlWithEmpty$str() {
        return "WFLYHC0207: File %s already exists, you must use --remove-existing-host-config to overwrite existing files.";
    }

    @Override
    public final IllegalStateException cannotOverwriteHostXmlWithEmpty(String filename) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.cannotOverwriteHostXmlWithEmpty$str(), filename));
        HostControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotAddHostAlreadyRegistered$str() {
        return "WFLYHC0208: A host (%s) has already been registered. You must shutdown this host before adding a new one.";
    }

    @Override
    public final OperationFailedException cannotAddHostAlreadyRegistered(String existingName) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.cannotAddHostAlreadyRegistered$str(), existingName));
        HostControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String nullHostName$str() {
        return "WFLYHC0209: Host name may not be null.";
    }

    @Override
    public final OperationFailedException nullHostName() {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.nullHostName$str(), new Object[0]));
        HostControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotAddSlaveHostAfterBoot$str() {
        return "WFLYHC0210: A slave host controller may not be added using add(). Please add a host, omitting this parameter, and configure the remote domain controller using write-attribute.";
    }

    @Override
    public final OperationFailedException cannotAddSlaveHostAfterBoot() {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.cannotAddSlaveHostAfterBoot$str(), new Object[0]));
        HostControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String bootConfigValidationFailed$str() {
        return "WFLYHC0211: Boot configuration validation failed";
    }

    @Override
    public final OperationFailedException bootConfigValidationFailed(ModelNode failureDescription) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.bootConfigValidationFailed$str(), new Object[0]), failureDescription);
        HostControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String fetchOfMissingConfigurationFailed$str() {
        return "WFLYHC0212: Fetch of missing configuration from the master Host Controller failed without explanation. Fetch operation outcome was %s";
    }

    @Override
    public final OperationFailedException fetchOfMissingConfigurationFailed(String failedOutcome) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.fetchOfMissingConfigurationFailed$str(), failedOutcome));
        HostControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidJavaHome$str() {
        return "WFLYHC0213: Java home '%s' does not exist.";
    }

    @Override
    public final IllegalStateException invalidJavaHome(String dir) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.invalidJavaHome$str(), dir));
        HostControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidJavaHomeBin$str() {
        return "WFLYHC0214: Java home's bin '%s' does not exist. The home directory was determined to be %s.";
    }

    @Override
    public final IllegalStateException invalidJavaHomeBin(String binDir, String javaHomeDir) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.invalidJavaHomeBin$str(), binDir, javaHomeDir));
        HostControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotFindJavaExe$str() {
        return "WFLYHC0215: Could not find java executable under %s.";
    }

    @Override
    public final IllegalStateException cannotFindJavaExe(String binDir) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.cannotFindJavaExe$str(), binDir));
        HostControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String moduleOptionNotAllowed$str() {
        return "WFLYHC0216: The module option %s is not allowed.";
    }

    @Override
    public final OperationFailedException moduleOptionNotAllowed(String option) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.moduleOptionNotAllowed$str(), option));
        HostControllerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }
}

