/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.parsing;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.HashUtil;
import org.jboss.as.controller.extension.ExtensionRegistry;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.parsing.Attribute;
import org.jboss.as.controller.parsing.Element;
import org.jboss.as.controller.parsing.ExtensionXml;
import org.jboss.as.controller.parsing.Namespace;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.parsing.ProfileParsingCompletionHandler;
import org.jboss.as.controller.persistence.ModelMarshallingContext;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.as.controller.resource.SocketBindingGroupResourceDefinition;
import org.jboss.as.domain.controller.logging.DomainControllerLogger;
import org.jboss.as.domain.controller.resources.DomainRootDefinition;
import org.jboss.as.domain.controller.resources.ServerGroupResourceDefinition;
import org.jboss.as.domain.management.access.AccessAuthorizationResourceDefinition;
import org.jboss.as.domain.management.parsing.ManagementXml;
import org.jboss.as.host.controller.parsing.JvmXml;
import org.jboss.as.server.controller.resources.DeploymentAttributes;
import org.jboss.as.server.parsing.CommonXml;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;
import org.jboss.modules.ModuleLoader;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public class DomainXml
extends CommonXml {
    private final ExtensionXml extensionXml;
    private final ExtensionRegistry extensionRegistry;

    public DomainXml(ModuleLoader loader, ExecutorService executorService, ExtensionRegistry extensionRegistry) {
        this.extensionXml = new ExtensionXml(loader, executorService, extensionRegistry);
        this.extensionRegistry = extensionRegistry;
    }

    public void readElement(XMLExtendedStreamReader reader, List<ModelNode> nodes) throws XMLStreamException {
        if (Element.forName((String)reader.getLocalName()) != Element.DOMAIN) {
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        Namespace readerNS = Namespace.forUri((String)reader.getNamespaceURI());
        switch (readerNS) {
            case DOMAIN_1_0: {
                this.readDomainElement1_0(reader, new ModelNode(), readerNS, nodes);
                break;
            }
            case DOMAIN_1_1: 
            case DOMAIN_1_2: {
                this.readDomainElement1_1(reader, new ModelNode(), readerNS, nodes);
                break;
            }
            case DOMAIN_1_3: {
                this.readDomainElement1_3(reader, new ModelNode(), readerNS, nodes);
                break;
            }
            case DOMAIN_1_4: {
                this.readDomainElement1_4(reader, new ModelNode(), readerNS, nodes);
                break;
            }
            default: {
                for (Namespace current : Namespace.domainValues()) {
                    if (!readerNS.equals((Object)current)) continue;
                    this.readDomainElement2_0(reader, new ModelNode(), readerNS, nodes);
                    return;
                }
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
        }
    }

    public void writeContent(XMLExtendedStreamWriter writer, ModelMarshallingContext context) throws XMLStreamException {
        ModelNode modelNode = context.getModelNode();
        writer.writeStartDocument();
        writer.writeStartElement(Element.DOMAIN.getLocalName());
        writer.writeDefaultNamespace(Namespace.CURRENT.getUriString());
        this.writeNamespaces(writer, modelNode);
        this.writeSchemaLocation(writer, modelNode);
        DomainRootDefinition.NAME.marshallAsAttribute(modelNode, false, (XMLStreamWriter)writer);
        DomainXml.writeNewLine((XMLExtendedStreamWriter)writer);
        if (modelNode.hasDefined("extension")) {
            this.extensionXml.writeExtensions(writer, modelNode.get("extension"));
            DomainXml.writeNewLine((XMLExtendedStreamWriter)writer);
        }
        if (modelNode.hasDefined("system-property")) {
            this.writeProperties(writer, modelNode.get("system-property"), Element.SYSTEM_PROPERTIES, false);
            DomainXml.writeNewLine((XMLExtendedStreamWriter)writer);
        }
        if (modelNode.hasDefined("path")) {
            this.writePaths(writer, modelNode.get("path"), true);
            DomainXml.writeNewLine((XMLExtendedStreamWriter)writer);
        }
        if (modelNode.hasDefined("core-service") && modelNode.get("core-service").hasDefined("management")) {
            ManagementXml managementXml = new ManagementXml((ManagementXml.Delegate)new ManagementXmlDelegate());
            managementXml.writeManagement(writer, modelNode.get(new String[]{"core-service", "management"}), true);
            DomainXml.writeNewLine((XMLExtendedStreamWriter)writer);
        }
        if (modelNode.hasDefined("profile")) {
            writer.writeStartElement(Element.PROFILES.getLocalName());
            for (Property profile : modelNode.get("profile").asPropertyList()) {
                this.writeProfile(writer, profile.getName(), profile.getValue(), context);
            }
            writer.writeEndElement();
            DomainXml.writeNewLine((XMLExtendedStreamWriter)writer);
        }
        if (modelNode.hasDefined("interface")) {
            this.writeInterfaces(writer, modelNode.get("interface"));
            DomainXml.writeNewLine((XMLExtendedStreamWriter)writer);
        }
        if (modelNode.hasDefined("socket-binding-group")) {
            writer.writeStartElement(Element.SOCKET_BINDING_GROUPS.getLocalName());
            for (Property property : modelNode.get("socket-binding-group").asPropertyList()) {
                this.writeSocketBindingGroup(writer, property.getValue(), false);
            }
            writer.writeEndElement();
            DomainXml.writeNewLine((XMLExtendedStreamWriter)writer);
        }
        if (modelNode.hasDefined("deployment")) {
            this.writeDomainDeployments(writer, modelNode.get("deployment"));
            DomainXml.writeNewLine((XMLExtendedStreamWriter)writer);
        }
        if (modelNode.hasDefined("deployment-overlay")) {
            this.writeDeploymentOverlays(writer, modelNode.get("deployment-overlay"));
            DomainXml.writeNewLine((XMLExtendedStreamWriter)writer);
        }
        if (modelNode.hasDefined("server-group")) {
            writer.writeStartElement(Element.SERVER_GROUPS.getLocalName());
            for (Property property : modelNode.get("server-group").asPropertyList()) {
                this.writeServerGroup(writer, property.getName(), property.getValue());
            }
            writer.writeEndElement();
            DomainXml.writeNewLine((XMLExtendedStreamWriter)writer);
        }
        if (modelNode.hasDefined("management-client-content")) {
            this.writeManagementClientContent(writer, modelNode.get("management-client-content"));
            DomainXml.writeNewLine((XMLExtendedStreamWriter)writer);
        }
        writer.writeEndElement();
        DomainXml.writeNewLine((XMLExtendedStreamWriter)writer);
        writer.writeEndDocument();
    }

    void readDomainElement1_0(XMLExtendedStreamReader reader, ModelNode address, Namespace expectedNs, List<ModelNode> list) throws XMLStreamException {
        this.parseNamespaces(reader, address, list);
        this.readDomainElementAttributes_1_0(reader, address, list);
        Element element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
        if (element == Element.EXTENSIONS) {
            this.extensionXml.parseExtensions(reader, address, expectedNs, list);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
        }
        if (element == Element.SYSTEM_PROPERTIES) {
            this.parseSystemProperties(reader, address, expectedNs, list, false);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
        }
        if (element == Element.PATHS) {
            this.parsePaths(reader, address, expectedNs, list, false);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
        }
        if (element == Element.PROFILES) {
            this.parseProfiles(reader, address, expectedNs, list);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
        }
        HashSet<String> interfaceNames = new HashSet<String>();
        if (element == Element.INTERFACES) {
            this.parseInterfaces(reader, interfaceNames, address, expectedNs, list, false);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
        }
        if (element == Element.SOCKET_BINDING_GROUPS) {
            this.parseDomainSocketBindingGroups(reader, address, expectedNs, list, interfaceNames);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
        }
        if (element == Element.DEPLOYMENTS) {
            this.parseDeployments(reader, address, expectedNs, list, EnumSet.of(Attribute.NAME, Attribute.RUNTIME_NAME), EnumSet.of(Element.CONTENT, Element.FS_ARCHIVE, Element.FS_EXPLODED), false);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
        }
        if (element == Element.SERVER_GROUPS) {
            this.parseServerGroups(reader, address, expectedNs, list);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
        }
        if (element != null) {
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        this.initializeRolloutPlans(address, list);
    }

    void readDomainElement1_1(XMLExtendedStreamReader reader, ModelNode address, Namespace expectedNs, List<ModelNode> list) throws XMLStreamException {
        this.parseNamespaces(reader, address, list);
        this.readDomainElementAttributes_1_1(reader, address, list);
        Element element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
        if (element == Element.EXTENSIONS) {
            this.extensionXml.parseExtensions(reader, address, expectedNs, list);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
        }
        if (element == Element.SYSTEM_PROPERTIES) {
            this.parseSystemProperties(reader, address, expectedNs, list, false);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
        }
        if (element == Element.PATHS) {
            this.parsePaths(reader, address, expectedNs, list, false);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
        }
        if (element == Element.PROFILES) {
            this.parseProfiles(reader, address, expectedNs, list);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
        }
        HashSet<String> interfaceNames = new HashSet<String>();
        if (element == Element.INTERFACES) {
            this.parseInterfaces(reader, interfaceNames, address, expectedNs, list, false);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
        }
        if (element == Element.SOCKET_BINDING_GROUPS) {
            this.parseDomainSocketBindingGroups(reader, address, expectedNs, list, interfaceNames);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
        }
        if (element == Element.DEPLOYMENTS) {
            this.parseDeployments(reader, address, expectedNs, list, EnumSet.of(Attribute.NAME, Attribute.RUNTIME_NAME), EnumSet.of(Element.CONTENT, Element.FS_ARCHIVE, Element.FS_EXPLODED), false);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
        }
        if (element == Element.SERVER_GROUPS) {
            this.parseServerGroups(reader, address, expectedNs, list);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
        }
        if (element == Element.MANAGEMENT_CLIENT_CONTENT) {
            this.parseManagementClientContent(reader, address, expectedNs, list);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
        } else if (element == null) {
            this.initializeRolloutPlans(address, list);
        } else {
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    void readDomainElement1_3(XMLExtendedStreamReader reader, ModelNode address, Namespace expectedNs, List<ModelNode> list) throws XMLStreamException {
        this.parseNamespaces(reader, address, list);
        this.readDomainElementAttributes_1_3(reader, expectedNs, address, list);
        Element element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
        if (element == Element.EXTENSIONS) {
            this.extensionXml.parseExtensions(reader, address, expectedNs, list);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
        }
        if (element == Element.SYSTEM_PROPERTIES) {
            this.parseSystemProperties(reader, address, expectedNs, list, false);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
        }
        if (element == Element.PATHS) {
            this.parsePaths(reader, address, expectedNs, list, false);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
        }
        if (element == Element.PROFILES) {
            this.parseProfiles(reader, address, expectedNs, list);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
        }
        HashSet<String> interfaceNames = new HashSet<String>();
        if (element == Element.INTERFACES) {
            this.parseInterfaces(reader, interfaceNames, address, expectedNs, list, false);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
        }
        if (element == Element.SOCKET_BINDING_GROUPS) {
            this.parseDomainSocketBindingGroups(reader, address, expectedNs, list, interfaceNames);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
        }
        if (element == Element.DEPLOYMENTS) {
            this.parseDeployments(reader, address, expectedNs, list, EnumSet.of(Attribute.NAME, Attribute.RUNTIME_NAME), EnumSet.of(Element.CONTENT, Element.FS_ARCHIVE, Element.FS_EXPLODED), false);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
        }
        if (element == Element.SERVER_GROUPS) {
            this.parseServerGroups(reader, address, expectedNs, list);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
        }
        if (element == Element.MANAGEMENT_CLIENT_CONTENT) {
            this.parseManagementClientContent(reader, address, expectedNs, list);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
        } else if (element == null) {
            this.initializeRolloutPlans(address, list);
        } else {
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    void readDomainElement1_4(XMLExtendedStreamReader reader, ModelNode address, Namespace expectedNs, List<ModelNode> list) throws XMLStreamException {
        this.parseNamespaces(reader, address, list);
        this.readDomainElementAttributes_1_3(reader, expectedNs, address, list);
        Element element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
        if (element == Element.EXTENSIONS) {
            this.extensionXml.parseExtensions(reader, address, expectedNs, list);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
        }
        if (element == Element.SYSTEM_PROPERTIES) {
            this.parseSystemProperties(reader, address, expectedNs, list, false);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
        }
        if (element == Element.PATHS) {
            this.parsePaths(reader, address, expectedNs, list, false);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
        }
        if (element == Element.PROFILES) {
            this.parseProfiles(reader, address, expectedNs, list);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
        }
        HashSet<String> interfaceNames = new HashSet<String>();
        if (element == Element.INTERFACES) {
            this.parseInterfaces(reader, interfaceNames, address, expectedNs, list, false);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
        }
        if (element == Element.SOCKET_BINDING_GROUPS) {
            this.parseDomainSocketBindingGroups(reader, address, expectedNs, list, interfaceNames);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
        }
        if (element == Element.DEPLOYMENTS) {
            this.parseDeployments(reader, address, expectedNs, list, EnumSet.of(Attribute.NAME, Attribute.RUNTIME_NAME), EnumSet.of(Element.CONTENT, Element.FS_ARCHIVE, Element.FS_EXPLODED), false);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
        }
        if (element == Element.DEPLOYMENT_OVERLAYS) {
            this.parseDeploymentOverlays(reader, expectedNs, new ModelNode(), list, true, false);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
        }
        if (element == Element.SERVER_GROUPS) {
            this.parseServerGroups(reader, address, expectedNs, list);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
        }
        if (element == Element.MANAGEMENT_CLIENT_CONTENT) {
            this.parseManagementClientContent(reader, address, expectedNs, list);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
        } else if (element == null) {
            this.initializeRolloutPlans(address, list);
        } else {
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    void readDomainElement2_0(XMLExtendedStreamReader reader, ModelNode address, Namespace expectedNs, List<ModelNode> list) throws XMLStreamException {
        this.parseNamespaces(reader, address, list);
        this.readDomainElementAttributes_1_3(reader, expectedNs, address, list);
        Element element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
        if (element == Element.EXTENSIONS) {
            this.extensionXml.parseExtensions(reader, address, expectedNs, list);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
        }
        if (element == Element.SYSTEM_PROPERTIES) {
            this.parseSystemProperties(reader, address, expectedNs, list, false);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
        }
        if (element == Element.PATHS) {
            this.parsePaths(reader, address, expectedNs, list, false);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
        }
        if (element == Element.MANAGEMENT) {
            ManagementXml managementXml = new ManagementXml((ManagementXml.Delegate)new ManagementXmlDelegate());
            managementXml.parseManagement(reader, address, expectedNs, list, false);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
        }
        if (element == Element.PROFILES) {
            this.parseProfiles(reader, address, expectedNs, list);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
        }
        HashSet<String> interfaceNames = new HashSet<String>();
        if (element == Element.INTERFACES) {
            this.parseInterfaces(reader, interfaceNames, address, expectedNs, list, false);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
        }
        if (element == Element.SOCKET_BINDING_GROUPS) {
            this.parseDomainSocketBindingGroups(reader, address, expectedNs, list, interfaceNames);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
        }
        if (element == Element.DEPLOYMENTS) {
            this.parseDeployments(reader, address, expectedNs, list, EnumSet.of(Attribute.NAME, Attribute.RUNTIME_NAME), EnumSet.of(Element.CONTENT, Element.FS_ARCHIVE, Element.FS_EXPLODED), false);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
        }
        if (element == Element.DEPLOYMENT_OVERLAYS) {
            this.parseDeploymentOverlays(reader, expectedNs, new ModelNode(), list, true, false);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
        }
        if (element == Element.SERVER_GROUPS) {
            this.parseServerGroups(reader, address, expectedNs, list);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
        }
        if (element == Element.MANAGEMENT_CLIENT_CONTENT) {
            this.parseManagementClientContent(reader, address, expectedNs, list);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
        } else if (element == null) {
            this.initializeRolloutPlans(address, list);
        } else {
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    protected void readDomainElementAttributes_1_0(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
        int count = reader.getAttributeCount();
        block7: for (int i = 0; i < count; ++i) {
            switch (Namespace.forUri((String)reader.getAttributeNamespace(i))) {
                case XML_SCHEMA_INSTANCE: {
                    switch (Attribute.forName((String)reader.getAttributeLocalName(i))) {
                        case SCHEMA_LOCATION: {
                            this.parseSchemaLocations(reader, address, list, i);
                            continue block7;
                        }
                        case NO_NAMESPACE_SCHEMA_LOCATION: {
                            continue block7;
                        }
                    }
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
    }

    protected void readDomainElementAttributes_1_1(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
        this.readDomainElementAttributes_1_0(reader, address, list);
    }

    protected void readDomainElementAttributes_1_3(XMLExtendedStreamReader reader, Namespace expectedNs, ModelNode address, List<ModelNode> list) throws XMLStreamException {
        int count = reader.getAttributeCount();
        block10: for (int i = 0; i < count; ++i) {
            Namespace ns = Namespace.forUri((String)reader.getAttributeNamespace(i));
            switch (ns) {
                case XML_SCHEMA_INSTANCE: {
                    switch (Attribute.forName((String)reader.getAttributeLocalName(i))) {
                        case SCHEMA_LOCATION: {
                            this.parseSchemaLocations(reader, address, list, i);
                            continue block10;
                        }
                        case NO_NAMESPACE_SCHEMA_LOCATION: {
                            continue block10;
                        }
                    }
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
                default: {
                    switch (Attribute.forName((String)reader.getAttributeLocalName(i))) {
                        case NAME: {
                            ModelNode op = new ModelNode();
                            op.get("operation").set("write-attribute");
                            op.get("name").set("name");
                            op.get("value").set(ParseUtils.parsePossibleExpression((String)reader.getAttributeValue(i)));
                            list.add(op);
                            continue block10;
                        }
                    }
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
    }

    void parseDomainSocketBindingGroups(XMLExtendedStreamReader reader, ModelNode address, Namespace expectedNs, List<ModelNode> list, Set<String> interfaces) throws XMLStreamException {
        block6: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case SOCKET_BINDING_GROUP: {
                    switch (expectedNs) {
                        case DOMAIN_1_0: {
                            this.parseSocketBindingGroup_1_0(reader, interfaces, address, expectedNs, list);
                            continue block6;
                        }
                    }
                    this.parseSocketBindingGroup_1_1(reader, interfaces, address, expectedNs, list);
                    continue block6;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    void parseSocketBindingGroup_1_0(XMLExtendedStreamReader reader, Set<String> interfaces, ModelNode address, Namespace expectedNs, List<ModelNode> updates) throws XMLStreamException {
        HashSet includedGroups = new HashSet();
        HashSet<String> uniqueBindingNames = new HashSet<String>();
        String[] attrValues = ParseUtils.requireAttributes((XMLExtendedStreamReader)reader, (String[])new String[]{Attribute.NAME.getLocalName(), Attribute.DEFAULT_INTERFACE.getLocalName()});
        String socketBindingGroupName = attrValues[0];
        String defaultInterface = attrValues[1];
        ModelNode groupAddress = new ModelNode().set(address);
        groupAddress.add("socket-binding-group", socketBindingGroupName);
        ModelNode bindingGroupUpdate = new ModelNode();
        bindingGroupUpdate.get("address").set(groupAddress);
        bindingGroupUpdate.get("operation").set("add");
        SocketBindingGroupResourceDefinition.DEFAULT_INTERFACE.parseAndSetParameter(defaultInterface, bindingGroupUpdate, (XMLStreamReader)reader);
        if (bindingGroupUpdate.get(SocketBindingGroupResourceDefinition.DEFAULT_INTERFACE.getName()).getType() != ModelType.EXPRESSION && !interfaces.contains(defaultInterface)) {
            throw ControllerLogger.ROOT_LOGGER.unknownInterface(defaultInterface, Attribute.DEFAULT_INTERFACE.getLocalName(), Element.INTERFACES.getLocalName(), reader.getLocation());
        }
        ModelNode includes = bindingGroupUpdate.get("includes");
        includes.setEmptyList();
        updates.add(bindingGroupUpdate);
        block4: while (reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case INCLUDE: {
                    DomainControllerLogger.ROOT_LOGGER.warnIgnoringSocketBindingGroupInclude(reader.getLocation());
                    continue block4;
                }
                case SOCKET_BINDING: {
                    String bindingName = this.parseSocketBinding(reader, interfaces, groupAddress, updates);
                    if (uniqueBindingNames.add(bindingName)) continue block4;
                    throw ControllerLogger.ROOT_LOGGER.alreadyDeclared(Element.SOCKET_BINDING.getLocalName(), bindingName, Element.SOCKET_BINDING_GROUP.getLocalName(), socketBindingGroupName, reader.getLocation());
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    void parseSocketBindingGroup_1_1(XMLExtendedStreamReader reader, Set<String> interfaces, ModelNode address, Namespace expectedNs, List<ModelNode> updates) throws XMLStreamException {
        HashSet includedGroups = new HashSet();
        HashSet<String> uniqueBindingNames = new HashSet<String>();
        String[] attrValues = ParseUtils.requireAttributes((XMLExtendedStreamReader)reader, (String[])new String[]{Attribute.NAME.getLocalName(), Attribute.DEFAULT_INTERFACE.getLocalName()});
        String socketBindingGroupName = attrValues[0];
        String defaultInterface = attrValues[1];
        ModelNode groupAddress = new ModelNode().set(address);
        groupAddress.add("socket-binding-group", socketBindingGroupName);
        ModelNode bindingGroupUpdate = new ModelNode();
        bindingGroupUpdate.get("address").set(groupAddress);
        bindingGroupUpdate.get("operation").set("add");
        SocketBindingGroupResourceDefinition.DEFAULT_INTERFACE.parseAndSetParameter(defaultInterface, bindingGroupUpdate, (XMLStreamReader)reader);
        if (bindingGroupUpdate.get(SocketBindingGroupResourceDefinition.DEFAULT_INTERFACE.getName()).getType() != ModelType.EXPRESSION && !interfaces.contains(defaultInterface)) {
            throw ControllerLogger.ROOT_LOGGER.unknownInterface(defaultInterface, Attribute.DEFAULT_INTERFACE.getLocalName(), Element.INTERFACES.getLocalName(), reader.getLocation());
        }
        updates.add(bindingGroupUpdate);
        block4: while (reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case SOCKET_BINDING: {
                    String bindingName = this.parseSocketBinding(reader, interfaces, groupAddress, updates);
                    if (uniqueBindingNames.add(bindingName)) continue block4;
                    throw ControllerLogger.ROOT_LOGGER.alreadyDeclared(Element.SOCKET_BINDING.getLocalName(), Element.OUTBOUND_SOCKET_BINDING.getLocalName(), bindingName, Element.SOCKET_BINDING_GROUP.getLocalName(), socketBindingGroupName, reader.getLocation());
                }
                case OUTBOUND_SOCKET_BINDING: {
                    String bindingName = this.parseOutboundSocketBinding(reader, interfaces, groupAddress, updates);
                    if (uniqueBindingNames.add(bindingName)) continue block4;
                    throw ControllerLogger.ROOT_LOGGER.alreadyDeclared(Element.SOCKET_BINDING.getLocalName(), Element.OUTBOUND_SOCKET_BINDING.getLocalName(), bindingName, Element.SOCKET_BINDING_GROUP.getLocalName(), socketBindingGroupName, reader.getLocation());
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    void parseServerGroups(XMLExtendedStreamReader reader, ModelNode address, Namespace expectedNs, List<ModelNode> list) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        HashSet<String> names = new HashSet<String>();
        while (reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
            Element serverGroup = Element.forName((String)reader.getLocalName());
            if (Element.SERVER_GROUP != serverGroup) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            ModelNode groupAddOp = new ModelNode();
            groupAddOp.get("operation").set("add");
            groupAddOp.get("address");
            String name = null;
            EnumSet<Attribute> required = EnumSet.of(Attribute.NAME, Attribute.PROFILE);
            int count = reader.getAttributeCount();
            block13: for (int i = 0; i < count; ++i) {
                String value = reader.getAttributeValue(i);
                if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
                Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
                required.remove(attribute);
                switch (attribute) {
                    case NAME: {
                        if (!names.add(value)) {
                            throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, (String)value);
                        }
                        name = value;
                        continue block13;
                    }
                    case PROFILE: {
                        ServerGroupResourceDefinition.PROFILE.parseAndSetParameter(value, groupAddOp, (XMLStreamReader)reader);
                        continue block13;
                    }
                    case MANAGEMENT_SUBSYSTEM_ENDPOINT: {
                        ServerGroupResourceDefinition.MANAGEMENT_SUBSYSTEM_ENDPOINT.parseAndSetParameter(value, groupAddOp, (XMLStreamReader)reader);
                        continue block13;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
            if (!required.isEmpty()) {
                throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
            }
            ModelNode groupAddress = new ModelNode().set(address);
            groupAddress.add("server-group", name);
            groupAddOp.get("address").set(groupAddress);
            list.add(groupAddOp);
            boolean sawDeployments = false;
            block14: while (reader.hasNext() && reader.nextTag() != 2) {
                ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
                Element element = Element.forName((String)reader.getLocalName());
                switch (element) {
                    case JVM: {
                        JvmXml.parseJvm(reader, groupAddress, expectedNs, list, new HashSet<String>(), false);
                        continue block14;
                    }
                    case SOCKET_BINDING_GROUP: {
                        if (expectedNs.compareTo((Enum)Namespace.DOMAIN_3_0) >= 0) {
                            this.parseSocketBindingGroupRef(reader, groupAddOp, ServerGroupResourceDefinition.SOCKET_BINDING_GROUP, ServerGroupResourceDefinition.SOCKET_BINDING_PORT_OFFSET, ServerGroupResourceDefinition.SOCKET_BINDING_DEFAULT_INTERFACE);
                            continue block14;
                        }
                        this.parseSocketBindingGroupRef(reader, groupAddOp, ServerGroupResourceDefinition.SOCKET_BINDING_GROUP, ServerGroupResourceDefinition.SOCKET_BINDING_PORT_OFFSET, null);
                        continue block14;
                    }
                    case DEPLOYMENTS: {
                        if (sawDeployments) {
                            throw ControllerLogger.ROOT_LOGGER.alreadyDefined(element.getLocalName(), reader.getLocation());
                        }
                        sawDeployments = true;
                        ArrayList deployments = new ArrayList();
                        this.parseDeployments(reader, groupAddress, expectedNs, deployments, EnumSet.of(Attribute.NAME, Attribute.RUNTIME_NAME, Attribute.ENABLED), Collections.emptySet(), true);
                        list.addAll(deployments);
                        continue block14;
                    }
                    case DEPLOYMENT_OVERLAYS: {
                        this.parseDeploymentOverlays(reader, expectedNs, groupAddress, list, false, true);
                        continue block14;
                    }
                    case SYSTEM_PROPERTIES: {
                        this.parseSystemProperties(reader, groupAddress, expectedNs, list, false);
                        continue block14;
                    }
                }
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
        }
    }

    void parseProfiles(XMLExtendedStreamReader reader, ModelNode address, Namespace expectedNs, List<ModelNode> list) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        HashSet<String> names = new HashSet<String>();
        while (reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
            Element element = Element.forName((String)reader.getLocalName());
            if (Element.PROFILE != element) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            ParseUtils.requireSingleAttribute((XMLExtendedStreamReader)reader, (String)Attribute.NAME.getLocalName());
            String name = reader.getAttributeValue(0);
            if (!names.add(name)) {
                throw ControllerLogger.ROOT_LOGGER.duplicateDeclaration("profile", name, reader.getLocation());
            }
            LinkedHashMap profileOps = new LinkedHashMap();
            block5: while (reader.nextTag() != 2) {
                Namespace ns = Namespace.forUri((String)reader.getNamespaceURI());
                switch (ns) {
                    case UNKNOWN: {
                        if (Element.forName((String)reader.getLocalName()) != Element.SUBSYSTEM) {
                            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                        }
                        String namespace = reader.getNamespaceURI();
                        if (profileOps.containsKey(namespace)) {
                            throw ControllerLogger.ROOT_LOGGER.duplicateDeclaration("subsystem", name, reader.getLocation());
                        }
                        ArrayList subsystems = new ArrayList();
                        reader.handleAny(subsystems);
                        profileOps.put(namespace, subsystems);
                        continue block5;
                    }
                    case DOMAIN_1_0: 
                    case DOMAIN_1_1: 
                    case DOMAIN_1_2: 
                    case DOMAIN_1_3: {
                        ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
                        if (profileOps.size() > 0) {
                            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                        }
                        if (Element.forName((String)reader.getLocalName()) != Element.INCLUDE) {
                            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                        }
                        if (ns == Namespace.DOMAIN_1_0) {
                            DomainControllerLogger.ROOT_LOGGER.warnIgnoringProfileInclude(reader.getLocation());
                        }
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                }
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            Set completionHandlers = this.extensionRegistry.getProfileParsingCompletionHandlers();
            for (ProfileParsingCompletionHandler completionHandler : completionHandlers) {
                completionHandler.handleProfileParsingCompletion(profileOps, list);
            }
            ModelNode profile = new ModelNode();
            profile.get("operation").set("add");
            profile.get("address").set(address).add("profile", name);
            list.add(profile);
            for (List subsystems : profileOps.values()) {
                for (ModelNode update : subsystems) {
                    ModelNode subsystemAddress = address.clone().set(address).add("profile", name);
                    for (Property path : update.get("address").asPropertyList()) {
                        subsystemAddress.add(path.getName(), path.getValue().asString());
                    }
                    update.get("address").set(subsystemAddress);
                    list.add(update);
                }
            }
        }
    }

    private void parseManagementClientContent(XMLExtendedStreamReader reader, ModelNode address, Namespace expectedNs, List<ModelNode> list) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        boolean rolloutPlansAdded = false;
        block3: while (reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case ROLLOUT_PLANS: {
                    this.parseRolloutPlans(reader, address, list);
                    rolloutPlansAdded = true;
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        if (!rolloutPlansAdded) {
            this.initializeRolloutPlans(address, list);
        }
    }

    private void parseRolloutPlans(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
        String hash = ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)Attribute.SHA1.getLocalName());
        ModelNode addAddress = address.clone().add("management-client-content", "rollout-plans");
        ModelNode addOp = Util.getEmptyOperation((String)"add", (ModelNode)addAddress);
        try {
            addOp.get("hash").set(HashUtil.hexStringToByteArray((String)hash));
        }
        catch (Exception e) {
            throw ControllerLogger.ROOT_LOGGER.invalidSha1Value((Throwable)e, hash, Attribute.SHA1.getLocalName(), reader.getLocation());
        }
        list.add(addOp);
    }

    private void initializeRolloutPlans(ModelNode address, List<ModelNode> list) {
        ModelNode addAddress = address.clone().add("management-client-content", "rollout-plans");
        ModelNode addOp = Util.getEmptyOperation((String)"add", (ModelNode)addAddress);
        list.add(addOp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeProfile(XMLExtendedStreamWriter writer, String profileName, ModelNode profileNode, ModelMarshallingContext context) throws XMLStreamException {
        Set subsystemNames;
        writer.writeStartElement(Element.PROFILE.getLocalName());
        writer.writeAttribute(Attribute.NAME.getLocalName(), profileName);
        if (profileNode.hasDefined("includes")) {
            for (ModelNode include : profileNode.get("includes").asList()) {
                writer.writeEmptyElement("include");
                writer.writeAttribute("profile", include.asString());
            }
        }
        if (profileNode.hasDefined("subsystem") && (subsystemNames = profileNode.get("subsystem").keys()).size() > 0) {
            String defaultNamespace = writer.getNamespaceContext().getNamespaceURI("");
            for (String subsystemName : subsystemNames) {
                try {
                    ModelNode subsystem = profileNode.get(new String[]{"subsystem", subsystemName});
                    XMLElementWriter subsystemWriter = context.getSubsystemWriter(subsystemName);
                    if (subsystemWriter == null) continue;
                    subsystemWriter.writeContent(writer, (Object)new SubsystemMarshallingContext(subsystem, writer));
                }
                finally {
                    writer.setDefaultNamespace(defaultNamespace);
                }
            }
        }
        writer.writeEndElement();
    }

    private void writeDomainDeployments(XMLExtendedStreamWriter writer, ModelNode modelNode) throws XMLStreamException {
        Set deploymentNames = modelNode.keys();
        if (deploymentNames.size() > 0) {
            writer.writeStartElement(Element.DEPLOYMENTS.getLocalName());
            for (String uniqueName : deploymentNames) {
                ModelNode deployment = modelNode.get(uniqueName);
                writer.writeStartElement(Element.DEPLOYMENT.getLocalName());
                DomainXml.writeAttribute((XMLExtendedStreamWriter)writer, (Attribute)Attribute.NAME, (String)uniqueName);
                DeploymentAttributes.RUNTIME_NAME.marshallAsAttribute(deployment, (XMLStreamWriter)writer);
                List contentItems = deployment.require("content").asList();
                for (ModelNode contentItem : contentItems) {
                    DomainXml.writeContentItem((XMLExtendedStreamWriter)writer, (ModelNode)contentItem);
                }
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
    }

    private void writeServerGroupDeployments(XMLExtendedStreamWriter writer, ModelNode modelNode) throws XMLStreamException {
        Set deploymentNames = modelNode.keys();
        if (deploymentNames.size() > 0) {
            writer.writeStartElement(Element.DEPLOYMENTS.getLocalName());
            for (String uniqueName : deploymentNames) {
                ModelNode deployment = modelNode.get(uniqueName);
                writer.writeStartElement(Element.DEPLOYMENT.getLocalName());
                DomainXml.writeAttribute((XMLExtendedStreamWriter)writer, (Attribute)Attribute.NAME, (String)uniqueName);
                DeploymentAttributes.RUNTIME_NAME.marshallAsAttribute(deployment, (XMLStreamWriter)writer);
                DeploymentAttributes.ENABLED.marshallAsAttribute(deployment, (XMLStreamWriter)writer);
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
    }

    private void writeServerGroup(XMLExtendedStreamWriter writer, String groupName, ModelNode group) throws XMLStreamException {
        Iterator i$;
        writer.writeStartElement(Element.SERVER_GROUP.getLocalName());
        writer.writeAttribute(Attribute.NAME.getLocalName(), groupName);
        ServerGroupResourceDefinition.PROFILE.marshallAsAttribute(group, (XMLStreamWriter)writer);
        ServerGroupResourceDefinition.MANAGEMENT_SUBSYSTEM_ENDPOINT.marshallAsAttribute(group, (XMLStreamWriter)writer);
        if (group.hasDefined("jvm") && (i$ = group.get("jvm").asPropertyList().iterator()).hasNext()) {
            Property jvm = (Property)i$.next();
            JvmXml.writeJVMElement(writer, jvm.getName(), jvm.getValue());
        }
        if (group.hasDefined("socket-binding-group") || group.hasDefined("socket-binding-port-offset")) {
            writer.writeStartElement(Element.SOCKET_BINDING_GROUP.getLocalName());
            ServerGroupResourceDefinition.SOCKET_BINDING_GROUP.marshallAsAttribute(group, (XMLStreamWriter)writer);
            ServerGroupResourceDefinition.SOCKET_BINDING_PORT_OFFSET.marshallAsAttribute(group, (XMLStreamWriter)writer);
            ServerGroupResourceDefinition.SOCKET_BINDING_DEFAULT_INTERFACE.marshallAsAttribute(group, (XMLStreamWriter)writer);
            writer.writeEndElement();
        }
        if (group.hasDefined("deployment")) {
            this.writeServerGroupDeployments(writer, group.get("deployment"));
        }
        if (group.hasDefined("deployment-overlay")) {
            this.writeDeploymentOverlays(writer, group.get("deployment-overlay"));
            DomainXml.writeNewLine((XMLExtendedStreamWriter)writer);
        }
        if (group.hasDefined("system-property")) {
            this.writeProperties(writer, group.get("system-property"), Element.SYSTEM_PROPERTIES, false);
        }
        writer.writeEndElement();
    }

    private void writeManagementClientContent(XMLExtendedStreamWriter writer, ModelNode modelNode) throws XMLStreamException {
        boolean hasRolloutPlans = modelNode.hasDefined("rollout-plans") && modelNode.get("rollout-plans").hasDefined("hash");
        boolean mustWrite = hasRolloutPlans;
        if (mustWrite) {
            writer.writeStartElement(Element.MANAGEMENT_CLIENT_CONTENT.getLocalName());
            if (hasRolloutPlans) {
                writer.writeEmptyElement(Element.ROLLOUT_PLANS.getLocalName());
                writer.writeAttribute(Attribute.SHA1.getLocalName(), HashUtil.bytesToHexString((byte[])modelNode.get("rollout-plans").get("hash").asBytes()));
            }
            writer.writeEndElement();
        }
    }

    private class ManagementXmlDelegate
    extends ManagementXml.Delegate {
        private ManagementXmlDelegate() {
        }

        public void parseSecurityRealms(XMLExtendedStreamReader reader, ModelNode address, Namespace expectedNs, List<ModelNode> list) throws XMLStreamException {
            throw new UnsupportedOperationException();
        }

        public void parseOutboundConnections(XMLExtendedStreamReader reader, ModelNode address, Namespace expectedNs, List<ModelNode> list) throws XMLStreamException {
            throw new UnsupportedOperationException();
        }

        public void parseAccessControl(XMLExtendedStreamReader reader, ModelNode address, Namespace expectedNs, List<ModelNode> list) throws XMLStreamException {
            ModelNode accAuthzAddr = address.clone().add("access", "authorization");
            int count = reader.getAttributeCount();
            for (int i = 0; i < count; ++i) {
                ModelNode op;
                ModelNode provider;
                String value = reader.getAttributeValue(i);
                if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
                Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
                if (attribute == Attribute.PROVIDER) {
                    provider = AccessAuthorizationResourceDefinition.PROVIDER.parse(value, (XMLStreamReader)reader);
                    op = Util.getWriteAttributeOperation((ModelNode)accAuthzAddr, (String)AccessAuthorizationResourceDefinition.PROVIDER.getName(), (ModelNode)provider);
                    list.add(op);
                    continue;
                }
                if (attribute == Attribute.PERMISSION_COMBINATION_POLICY) {
                    provider = AccessAuthorizationResourceDefinition.PERMISSION_COMBINATION_POLICY.parse(value, (XMLStreamReader)reader);
                    op = Util.getWriteAttributeOperation((ModelNode)accAuthzAddr, (String)AccessAuthorizationResourceDefinition.PERMISSION_COMBINATION_POLICY.getName(), (ModelNode)provider);
                    list.add(op);
                    continue;
                }
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            block7: while (reader.hasNext() && reader.nextTag() != 2) {
                ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
                Element element = Element.forName((String)reader.getLocalName());
                switch (element) {
                    case ROLE_MAPPING: {
                        ManagementXml.parseAccessControlRoleMapping((XMLExtendedStreamReader)reader, (ModelNode)accAuthzAddr, (Namespace)expectedNs, list);
                        continue block7;
                    }
                    case SERVER_GROUP_SCOPED_ROLES: {
                        ManagementXml.parseServerGroupScopedRoles((XMLExtendedStreamReader)reader, (ModelNode)accAuthzAddr, (Namespace)expectedNs, list);
                        continue block7;
                    }
                    case HOST_SCOPED_ROLES: {
                        ManagementXml.parseHostScopedRoles((XMLExtendedStreamReader)reader, (ModelNode)accAuthzAddr, (Namespace)expectedNs, list);
                        continue block7;
                    }
                    case CONSTRAINTS: {
                        ManagementXml.parseAccessControlConstraints((XMLExtendedStreamReader)reader, (ModelNode)accAuthzAddr, (Namespace)expectedNs, list);
                        continue block7;
                    }
                }
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
        }
    }
}

