/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.mgmt;

import java.io.Closeable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.Executor;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.HashUtil;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ProxyController;
import org.jboss.as.controller.client.Operation;
import org.jboss.as.controller.client.OperationBuilder;
import org.jboss.as.controller.client.OperationMessageHandler;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.domain.controller.DomainController;
import org.jboss.as.host.controller.ManagedServerOperationsFactory;
import org.jboss.as.host.controller.ServerInventory;
import org.jboss.as.host.controller.logging.HostControllerLogger;
import org.jboss.as.process.protocol.ProtocolUtils;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.as.protocol.mgmt.ActiveOperation;
import org.jboss.as.protocol.mgmt.FlushableDataOutput;
import org.jboss.as.protocol.mgmt.ManagementChannelHandler;
import org.jboss.as.protocol.mgmt.ManagementProtocolHeader;
import org.jboss.as.protocol.mgmt.ManagementRequestContext;
import org.jboss.as.protocol.mgmt.ManagementRequestHandler;
import org.jboss.as.protocol.mgmt.ManagementRequestHandlerFactory;
import org.jboss.as.protocol.mgmt.ManagementRequestHeader;
import org.jboss.as.protocol.mgmt.ManagementResponseHeader;
import org.jboss.as.protocol.mgmt.RequestProcessingException;
import org.jboss.as.repository.ContentReference;
import org.jboss.as.repository.DeploymentFileRepository;
import org.jboss.as.repository.RemoteFileRequestAndHandler;
import org.jboss.as.server.mgmt.domain.ServerToHostRemoteFileRequestAndHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.remoting3.Channel;
import org.jboss.remoting3.MessageOutputStream;

public class ServerToHostProtocolHandler
implements ManagementRequestHandlerFactory {
    static final Operation EMPTY_OP;
    private final ServerInventory serverInventory;
    private final OperationExecutor operationExecutor;
    private final DomainController domainController;
    private final ManagementChannelHandler channelHandler;
    private final DeploymentFileRepository deploymentFileRepository;
    private final Executor registrations;
    private final ExpressionResolver expressionResolver;
    private volatile String serverProcessName;

    ServerToHostProtocolHandler(ServerInventory serverInventory, OperationExecutor operationExecutor, DomainController domainController, ManagementChannelHandler channelHandler, Executor registrations, ExpressionResolver expressionResolver) {
        this.serverInventory = serverInventory;
        this.operationExecutor = operationExecutor;
        this.domainController = domainController;
        this.channelHandler = channelHandler;
        this.registrations = registrations;
        this.deploymentFileRepository = domainController.getLocalFileRepository();
        this.expressionResolver = expressionResolver;
    }

    public ManagementRequestHandler<?, ?> resolveHandler(ManagementRequestHandlerFactory.RequestHandlerChain handlers, ManagementRequestHeader header) {
        byte operationId = header.getOperationId();
        switch (operationId) {
            case 0: {
                handlers.registerActiveOperation(Integer.valueOf(header.getBatchId()), null);
                return new ServerRegistrationRequestHandler();
            }
            case 3: {
                handlers.registerActiveOperation(Integer.valueOf(header.getBatchId()), null);
                return new ServerReconnectRequestHandler();
            }
            case 36: {
                handlers.registerActiveOperation(Integer.valueOf(header.getBatchId()), null);
                return new GetFileOperation();
            }
            case 2: {
                handlers.registerActiveOperation(Integer.valueOf(header.getBatchId()), (Object)this.serverInventory);
                return new ServerStartedHandler(this.serverProcessName);
            }
        }
        return handlers.resolveNext();
    }

    protected static void safeWriteResponse(ManagementRequestContext<?> context, Exception error) {
        ServerToHostProtocolHandler.safeWriteResponse(context.getChannel(), context.getRequestHeader(), error);
    }

    protected static void safeWriteResponse(Channel channel, ManagementProtocolHeader header, Exception error) {
        if (header.getType() == 2) {
            try {
                ServerToHostProtocolHandler.writeResponse(channel, (ManagementRequestHeader)header, error);
            }
            catch (IOException ioe) {
                HostControllerLogger.CONTROLLER_MANAGEMENT_LOGGER.tracef(ioe, "failed to write error response for %s on channel: %s", header, channel);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void writeResponse(Channel channel, ManagementRequestHeader header, Exception error) throws IOException {
        ManagementResponseHeader response = ManagementResponseHeader.create((ManagementRequestHeader)header, (Exception)error);
        MessageOutputStream output = channel.writeMessage();
        try {
            ServerToHostProtocolHandler.writeHeader((ManagementProtocolHeader)response, (OutputStream)output);
            output.write(36);
            output.close();
        }
        finally {
            StreamUtils.safeClose((Closeable)output);
        }
    }

    protected static void safeWriteResponse(Channel channel, ManagementProtocolHeader header, byte param) {
        if (header.getType() == 2) {
            try {
                ServerToHostProtocolHandler.writeResponse(channel, (ManagementRequestHeader)header, param);
            }
            catch (IOException ioe) {
                HostControllerLogger.CONTROLLER_MANAGEMENT_LOGGER.tracef(ioe, "failed to write error response for %s on channel: %s", header, channel);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void writeResponse(Channel channel, ManagementRequestHeader header, byte param) throws IOException {
        ManagementResponseHeader response = ManagementResponseHeader.create((ManagementRequestHeader)header);
        MessageOutputStream output = channel.writeMessage();
        try {
            ServerToHostProtocolHandler.writeHeader((ManagementProtocolHeader)response, (OutputStream)output);
            output.write((int)param);
            output.write(36);
            output.close();
        }
        finally {
            StreamUtils.safeClose((Closeable)output);
        }
    }

    protected static void writeHeader(ManagementProtocolHeader header, OutputStream os) throws IOException {
        FlushableDataOutput output = org.jboss.as.protocol.mgmt.ProtocolUtils.wrapAsDataOutput((OutputStream)os);
        header.write((DataOutput)output);
    }

    static {
        ModelNode mn = new ModelNode();
        mn.get("operation").set("register-server");
        mn.get("address").setEmptyList();
        mn.protect();
        EMPTY_OP = OperationBuilder.create((ModelNode)mn).build();
    }

    private class ServerStartedHandler
    implements ManagementRequestHandler<Void, ServerInventory> {
        private final String serverProcessName;

        private ServerStartedHandler(String serverProcessName) {
            this.serverProcessName = serverProcessName;
        }

        public void handleRequest(DataInput input, final ActiveOperation.ResultHandler<Void> resultHandler, final ManagementRequestContext<ServerInventory> context) throws IOException {
            final byte param = input.readByte();
            String message = input.readUTF();
            context.executeAsync((ManagementRequestContext.AsyncTask)new ManagementRequestContext.AsyncTask<ServerInventory>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void execute(ManagementRequestContext<ServerInventory> serverInventoryManagementRequestContext) throws Exception {
                    try {
                        ServerInventory inventory = (ServerInventory)context.getAttachment();
                        if (param == 33) {
                            inventory.serverStarted(ServerStartedHandler.this.serverProcessName);
                        } else {
                            inventory.serverStartFailed(ServerStartedHandler.this.serverProcessName);
                        }
                    }
                    finally {
                        resultHandler.done(null);
                    }
                }
            });
        }
    }

    private class GetFileOperation
    implements ManagementRequestHandler<ModelNode, Void> {
        private GetFileOperation() {
        }

        public void handleRequest(DataInput input, ActiveOperation.ResultHandler<ModelNode> resultHandler, ManagementRequestContext<Void> context) throws IOException {
            RemoteFileRequestAndHandler.RootFileReader reader = new RemoteFileRequestAndHandler.RootFileReader(){

                public File readRootFile(byte rootId, String filePath) throws RequestProcessingException {
                    byte[] hash = HashUtil.hexStringToByteArray((String)filePath);
                    return ServerToHostProtocolHandler.this.deploymentFileRepository.getDeploymentRoot(new ContentReference(filePath, hash));
                }
            };
            ServerToHostRemoteFileRequestAndHandler.INSTANCE.handleRequest(input, reader, context);
        }
    }

    class ServerReconnectRequestHandler
    implements ManagementRequestHandler<Void, Void> {
        ServerReconnectRequestHandler() {
        }

        public void handleRequest(DataInput input, final ActiveOperation.ResultHandler<Void> resultHandler, final ManagementRequestContext<Void> context) throws IOException {
            ProtocolUtils.expectHeader((DataInput)input, (int)1);
            final String serverName = input.readUTF();
            final Channel channel = context.getChannel();
            HostControllerLogger.CONTROLLER_MANAGEMENT_LOGGER.serverConnected(serverName, channel);
            context.executeAsync((ManagementRequestContext.AsyncTask)new ManagementRequestContext.AsyncTask<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void execute(final ManagementRequestContext<Void> requestContext) throws Exception {
                    OperationStepHandler stepHandler = new OperationStepHandler(){

                        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                            context.acquireControllerLock();
                            byte param = ServerToHostProtocolHandler.this.serverInventory.serverReconnected(serverName, ServerToHostProtocolHandler.this.channelHandler) ? (byte)33 : 34;
                            ServerToHostProtocolHandler.safeWriteResponse(channel, requestContext.getRequestHeader(), param);
                            context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
                        }
                    };
                    try {
                        ModelNode result = ServerToHostProtocolHandler.this.operationExecutor.execute(EMPTY_OP, OperationMessageHandler.DISCARD, ModelController.OperationTransactionControl.COMMIT, stepHandler);
                        if (!"success".equals(result.get("outcome").asString())) {
                            ServerToHostProtocolHandler.safeWriteResponse(context.getChannel(), context.getRequestHeader(), (byte)34);
                        }
                    }
                    catch (Exception e) {
                        ServerToHostProtocolHandler.safeWriteResponse(context, e);
                    }
                    finally {
                        resultHandler.done(null);
                    }
                }
            });
        }
    }

    class ServerRegistrationStepHandler
    implements OperationStepHandler {
        private String serverName;
        private String serverProcessName;
        private ManagementRequestContext<Void> comm;

        ServerRegistrationStepHandler(String serverName, ManagementRequestContext<Void> comm) {
            this.serverProcessName = serverName;
            this.serverName = ServerToHostProtocolHandler.this.serverInventory.getProcessServerName(this.serverProcessName);
            this.comm = comm;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            context.acquireControllerLock();
            ModelNode domainModel = Resource.Tools.readModel((Resource)context.readResourceFromRoot(PathAddress.EMPTY_ADDRESS, true));
            String hostControllerName = ServerToHostProtocolHandler.this.domainController.getLocalHostInfo().getLocalHostName();
            ModelNode hostModel = domainModel.require("host").require(hostControllerName);
            ModelNode updates = ManagedServerOperationsFactory.createBootUpdates(this.serverName, domainModel, hostModel, ServerToHostProtocolHandler.this.domainController, ServerToHostProtocolHandler.this.expressionResolver);
            final ProxyController controller = ServerToHostProtocolHandler.this.serverInventory.serverCommunicationRegistered(this.serverProcessName, ServerToHostProtocolHandler.this.channelHandler);
            try {
                FlushableDataOutput output = this.comm.writeMessage((ManagementProtocolHeader)ManagementResponseHeader.create((ManagementProtocolHeader)this.comm.getRequestHeader()));
                try {
                    output.write(33);
                    updates.writeExternal((DataOutput)output);
                    output.close();
                }
                finally {
                    StreamUtils.safeClose((Closeable)output);
                }
            }
            catch (IOException e) {
                context.getFailureDescription().set(e.getMessage());
                return;
            }
            context.completeStep(new OperationContext.ResultHandler(){

                public void handleResult(OperationContext.ResultAction resultAction, OperationContext context, ModelNode operation) {
                    if (resultAction == OperationContext.ResultAction.KEEP) {
                        ServerToHostProtocolHandler.this.domainController.registerRunningServer(controller);
                    }
                }
            });
        }
    }

    class ServerRegistrationRequestHandler
    implements ManagementRequestHandler<Void, Void> {
        ServerRegistrationRequestHandler() {
        }

        public void handleRequest(DataInput input, final ActiveOperation.ResultHandler<Void> resultHandler, ManagementRequestContext<Void> context) throws IOException {
            final String serverName = input.readUTF();
            final int operationId = input.readInt();
            ServerToHostProtocolHandler.this.serverProcessName = serverName;
            HostControllerLogger.CONTROLLER_MANAGEMENT_LOGGER.serverConnected(serverName, context.getChannel());
            context.executeAsync((ManagementRequestContext.AsyncTask)new ManagementRequestContext.AsyncTask<Void>(){

                public void execute(ManagementRequestContext<Void> context) throws Exception {
                    try {
                        ServerRegistrationStepHandler stepHandler = new ServerRegistrationStepHandler(serverName, context);
                        ModelNode result = ServerToHostProtocolHandler.this.operationExecutor.joinActiveOperation(EMPTY_OP.getOperation(), OperationMessageHandler.DISCARD, ModelController.OperationTransactionControl.COMMIT, stepHandler, operationId);
                        if (!"success".equals(result.get("outcome").asString())) {
                            ServerToHostProtocolHandler.safeWriteResponse(context.getChannel(), context.getRequestHeader(), (byte)34);
                        }
                    }
                    catch (Exception e) {
                        ServerToHostProtocolHandler.safeWriteResponse(context, e);
                    }
                    resultHandler.done(null);
                }
            }, ServerToHostProtocolHandler.this.registrations);
        }
    }

    public static interface OperationExecutor {
        public ModelNode execute(Operation var1, OperationMessageHandler var2, ModelController.OperationTransactionControl var3, OperationStepHandler var4);

        public ModelNode joinActiveOperation(ModelNode var1, OperationMessageHandler var2, ModelController.OperationTransactionControl var3, OperationStepHandler var4, int var5);
    }
}

