/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.logging;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.util.Arrays;
import javax.security.sasl.SaslException;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.RunningMode;
import org.jboss.as.controller.client.helpers.domain.ServerStatus;
import org.jboss.as.host.controller.discovery.DiscoveryOption;
import org.jboss.as.host.controller.logging.HostControllerLogger;
import org.jboss.as.host.controller.model.host.AdminOnlyDomainConfigPolicy;
import org.jboss.as.host.controller.model.jvm.JvmType;
import org.jboss.as.protocol.mgmt.RequestProcessingException;
import org.jboss.as.server.ServerState;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;
import org.jboss.remoting3.Channel;

public class HostControllerLogger_$logger
extends DelegatingBasicLogger
implements HostControllerLogger,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = HostControllerLogger_$logger.class.getName();
    private static final String cannotConnect = "WFLYHC0001: Could not connect to remote domain controller %s -- %s";
    private static final String cannotConnectToMaster = "WFLYHC0002: Could not connect to master. Aborting. Error was: %s";
    private static final String creatingHttpManagementService = "WFLYHC0003: Creating http management service using network interface (%s) port (%d) securePort (%d)";
    private static final String errorRetrievingDomainModel = "WFLYHC0004: Error retrieving domain model from remote domain controller %s:%d: %s";
    private static final String existingServerWithState = "WFLYHC0005: Existing server [%s] with status: %s";
    private static final String failedToCreateServerProcess = "WFLYHC0006: Failed to create server process %s";
    private static final String failedToSendReconnect = "WFLYHC0007: Failed to send reconnect message to server %s";
    private static final String failedToStartServer = "WFLYHC0008: Failed to start server (%s)";
    private static final String failedToStopServer = "WFLYHC0009: Failed to stop server (%s)";
    private static final String gracefulShutdownNotSupported = "WFLYHC0010: Graceful shutdown of server %s was requested but is not presently supported. Falling back to rapid shutdown.";
    private static final String ignoringPermGen = "WFLYHC0011: Ignoring <permgen> for jvm '%s' type jvm: %s";
    private static final String noDomainControllerConfigurationProvided = "WFLYHC0012: No <domain-controller> configuration was provided and the current running mode ('%s') requires access to the Domain Controller host. Startup will be aborted. Use the %s command line argument to start in %s mode if you need to start without a domain controller connection and then use the management tools to configure one.";
    private static final String noSecurityRealmDefined = "WFLYHC0013: No security realm defined for http management service, all access will be unrestricted.";
    private static final String noServerAvailable = "WFLYHC0014: No server called %s available";
    private static final String lostRemoteDomainConnection = "WFLYHC0015: Connection to remote host-controller closed. Trying to reconnect.";
    private static final String optionAlreadySet = "WFLYHC0016: Ignoring <option value=\"%s\" for jvm '%s' since '%s' was set";
    private static final String reconnectingServer = "WFLYHC0018: Reconnecting server %s";
    private static final String registeredRemoteSlaveHost = "WFLYHC0019: Registered remote slave host \"%s\", %s";
    private static final String registeringServer = "WFLYHC0020: Registering server %s";
    private static final String serverConnected = "WFLYHC0021: Server [%s] connected using connection [%s]";
    private static final String serviceShutdownIncomplete = "WFLYHC0022: Graceful shutdown of the handler used for messages from other Host Controllers did not cleanly complete but shutdown of the underlying communication channel is proceeding";
    private static final String startingServer = "WFLYHC0023: Starting server %s";
    private static final String stoppingServer = "WFLYHC0024: Stopping server %s";
    private static final String unexpectedServerState = "WFLYHC0025: Server %s is not in the expected %s state: %s";
    private static final String unregisteredRemoteSlaveHost = "WFLYHC0026: Unregistered remote slave host \"%s\"";
    private static final String unregisteringServer = "WFLYHC0027: Unregistering server %s";
    private static final String registeredAtRemoteHostController = "WFLYHC0028: Registered at domain controller";
    private static final String unregisteredAtRemoteHostController = "WFLYHC0029: Unregistered at domain controller";
    private static final String lostConnectionToRemoteHost = "WFLYHC0030: Connection to remote host \"%s\" closed unexpectedly";
    private static final String invalidRemoteBackupPersisterState = "WFLYHC0031: Cannot load the domain model using using --backup";
    private static final String invalidCachedPersisterState = "WFLYHC0032: Cannot store the domain model using using --cached-dc";
    private static final String caughtExceptionDuringBoot = "WFLYHC0033: Caught exception during boot";
    private static final String unsuccessfulBoot = "WFLYHC0034: Host Controller boot has failed in an unrecoverable manner; exiting. See previous messages for details.";
    private static final String reportAdminOnlyDomainXmlFailure = "WFLYHC0035: Installation of the domain-wide configuration has failed. Because the running mode of this Host Controller is ADMIN_ONLY boot has been allowed to proceed. If ADMIN_ONLY mode were not in effect the process would be terminated due to a critical boot failure.";
    private static final String gracefulManagementChannelHandlerShutdownTimedOut = "WFLYHC0036: Graceful shutdown of the handler used for messages from other Host Controllers did not complete within [%d] ms but shutdown of the underlying communication channel is proceeding";
    private static final String masterHostControllerChanged = "WFLYHC0037: The master host controller has been restarted. Re-registering this slave host controller with the new master.";
    private static final String masterHostControllerUnreachable = "WFLYHC0038: The master host controller could not be reached in the last [%d] milliseconds. Re-connecting.";
    private static final String slaveHostControllerChanged = "WFLYHC0039: The slave host controller \"%s\" has been restarted or is attempting to reconnect. Unregistering the current connection to this slave.";
    private static final String slaveHostControllerUnreachable = "WFLYHC0040: The slave host controller \"%s\"  could not be reached in the last [%d] milliseconds. Unregistering.";
    private static final String argumentExpected = "WFLYHC0041: Argument expected for option %s. %s";
    private static final String attemptingToSet = "WFLYHC0042: Attempting to set '%s' when '%s' was already set";
    private static final String authenticationFailureUnableToConnect = "WFLYHC0043: Unable to connect due to authentication failure.";
    private static final String cannotAccessRemoteFileRepository = "WFLYHC0044: Cannot access a remote file repository from the master domain controller";
    private static final String cannotCreateLocalDirectory = "WFLYHC0045: Unable to create local directory: %s";
    private static final String cannotObtainValidDefaultAddress = "WFLYHC0046: Cannot obtain a valid default address for communicating with the ProcessController using either %s or InetAddress.getLocalHost(). Please check your system's network configuration or use the %s command line switch to configure a valid address";
    private static final String cannotRestartServer = "WFLYHC0047: Cannot restart server %s as it is not currently started; it is %s";
    private static final String cannotStartServersInvalidMode = "WFLYHC0048: Cannot start servers when the Host Controller running mode is %s";
    private static final String closeShouldBeManagedByService = "WFLYHC0049: Close should be managed by the service";
    private static final String configurationPersisterAlreadyInitialized = "WFLYHC0050: Configuration persister for domain model is already initialized";
    private static final String connectionToMasterInterrupted = "WFLYHC0051: Interrupted while trying to connect to master";
    private static final String connectionToMasterTimeout = "WFLYHC0052: Could not connect to master in %d attempts within %s ms";
    private static final String couldNotGetServerInventory = "WFLYHC0053: Could not get the server inventory in %d %s";
    private static final String didNotReadEntireFile = "WFLYHC0054: Did not read the entire file. Missing: %d";
    private static final String errorClosingDownHost = "WFLYHC0055: Error closing down host";
    private static final String failedProfileOperationsRetrieval = "WFLYHC0056: Failed to retrieve profile operations from domain controller";
    private static final String failedToGetFileFromRemoteRepository = "WFLYHC0057: Failed to get file from remote repository";
    private static final String failedToGetServerStatus = "WFLYHC0058: Failed to get server status";
    private static final String failedToReadAuthenticationKey = "WFLYHC0059: Failed to read authentication key: %s";
    private static final String hostNameAlreadyConnected = "WFLYHC0060: Already have a connection for host %s";
    private static final String insufficientInformationToGenerateHash = "WFLYHC0061: Insufficient information to generate hash.";
    private static final String invalidOption = "WFLYHC0062: Invalid option '%s'. %s";
    private static final String invalidRootId = "WFLYHC0063: Invalid root id [%d]";
    private static final String invalidValue = "WFLYHC0064: Value for %s is not an %s -- %s. %s";
    private static final String invocationNotAllowedAfterBoot = "WFLYHC0065: Invocations of %s after HostController boot are not allowed";
    private static final String malformedUrl = "WFLYHC0066: Malformed URL provided for option %s. %s";
    private static final String mustInvokeBeforeCheckingSlaveStatus = "WFLYHC0067: Must call %s before checking for slave status";
    private static final String mustInvokeBeforePersisting = "WFLYHC0068: Must call %s before persisting the domain model";
    private static final String noChannelForHost = "WFLYHC0069: No channel for host %s";
    private static final String noNameAttributeOnHost = "WFLYHC0070: A host connecting to a remote domain controller must have its name attribute set";
    private static final String noServerInventory = "WFLYHC0071: No server inventory";
    private static final String propertyAlreadyExists = "WFLYHC0072: Property %s already exists";
    private static final String propertyNotFound = "WFLYHC0073: Property %s does not exist";
    private static final String propertyValueNull = "WFLYHC0074: Value for property %s is null";
    private static final String propertyValueHasNullValue = "WFLYHC0075: Property %s has a null value";
    private static final String nullVar = "WFLYHC0076: %s is null";
    private static final String serverNameAlreadyRegistered = "WFLYHC0077: There is already a registered server named '%s'";
    private static final String serverStillRunning = "WFLYHC0078: Server (%s) still running";
    private static final String unableToGenerateHash = "WFLYHC0079: Unable to generate hash";
    private static final String unableToLoadProperties = "WFLYHC0080: Unable to load properties from URL %s. %s";
    private static final String undefinedSocketBinding = "WFLYHC0081: Undefined socket binding group for server %s";
    private static final String undefinedSocketBindingGroup = "WFLYHC0082: Included socket binding group %s is not defined";
    private static final String unexpectedState = "WFLYHC0083: Unexpected state %s";
    private static final String unknown = "WFLYHC0084: Unknown %s %s";
    private static final String unknownHostValue = "WFLYHC0085: Value for %s is not a known host -- %s. %s";
    private static final String unrecognizedType = "WFLYHC0086: unrecognized type %s";
    private static final String hostAlreadyShutdown = "WFLYHC0087: Host-Controller is already shutdown.";
    private static final String noServerGroupCalled = "WFLYHC0088: No server-group called: %s";
    private static final String noSocketBindingGroupCalled = "WFLYHC0089: No socket-binding-group called: %s";
    private static final String hostControllerSystemPropertyUpdateNotSupported = "WFLYHC0090: HostControllerEnvironment does not support system property updates";
    private static final String cannotIgnoreTypeHost = "WFLYHC0091: Resources of type %s cannot be ignored";
    private static final String duplicateIgnoredResourceType = "WFLYHC0092: An '%s' element whose '%s' attribute is has already been found";
    private static final String cannotAccessJvmInputArgument = "WFLYHC0093: The JVM input arguments cannot be accessed so system properties passed directly to this Host Controller JVM will not be passed through to server processes. Cause of the problem: %s";
    private static final String missingHomeDirConfiguration = "WFLYHC0094: Missing configuration value for: %s";
    private static final String homeDirectoryDoesNotExist = "WFLYHC0095: Home directory does not exist: %s";
    private static final String modulesDirectoryDoesNotExist = "WFLYHC0096: Determined modules directory does not exist: %s";
    private static final String domainBaseDirectoryDoesNotExist = "WFLYHC0097: Domain base directory does not exist: %s";
    private static final String domainBaseDirectoryIsNotADirectory = "WFLYHC0098: Domain base directory is not a directory: %s";
    private static final String configDirectoryDoesNotExist = "WFLYHC0099: Configuration directory does not exist: %s";
    private static final String domainDataDirectoryIsNotDirectory = "WFLYHC0100: Domain data directory is not a directory: %s";
    private static final String couldNotCreateDomainDataDirectory = "WFLYHC0101: Could not create domain data directory: %s";
    private static final String domainContentDirectoryIsNotDirectory = "WFLYHC0102: Domain content directory is not a directory: %s";
    private static final String couldNotCreateDomainContentDirectory = "WFLYHC0103: Could not create domain content directory: %s";
    private static final String logDirectoryIsNotADirectory = "WFLYHC0104: Log directory is not a directory: %s";
    private static final String couldNotCreateLogDirectory = "WFLYHC0105: Could not create log directory: %s";
    private static final String serversDirectoryIsNotADirectory = "WFLYHC0106: Servers directory is not a directory: %s";
    private static final String couldNotCreateServersDirectory = "WFLYHC0107: Could not create servers directory: %s";
    private static final String domainTempDirectoryIsNotADirectory = "WFLYHC0108: Domain temp directory does not exist: %s";
    private static final String couldNotCreateDomainTempDirectory = "WFLYHC0109: Could not create domain temp directory: %s";
    private static final String sslFailureUnableToConnect = "WFLYHC0110: Unable to connect due to SSL failure.";
    private static final String jvmOptionAlreadyExists = "WFLYHC0111: Option '%s' already exists";
    private static final String envVariableAlreadyExists = "WFLYHC0112: Environment variable '%s' already exists";
    private static final String unsupportedManagementVersionForHost = "WFLYHC0113: Host controller management version %s.%s is too old, Only %s.%s or higher are supported";
    private static final String failedToAddExtensions = "WFLYHC0114: Failed to add extensions used by the domain. Failure description: %s";
    private static final String argumentHasNoValue = "WFLYHC0115: Argument %s has no value. %s";
    private static final String usageNote = "Use %s --help for information on valid command line arguments and their syntax.";
    private static final String cannotAccessS3File = "WFLYHC0116: Cannot access S3 file: %s";
    private static final String failedMarshallingDomainControllerData = "WFLYHC0117: Failed to obtain domain controller data from S3 file";
    private static final String cannotWriteToS3File = "WFLYHC0118: Cannot write domain controller data to S3 file: %s";
    private static final String cannotAccessS3Bucket = "WFLYHC0119: Cannot access S3 bucket '%s': %s";
    private static final String discoveryOptionsFailureUnableToConnect = "WFLYHC0120: Tried all domain controller discovery option(s) but unable to connect";
    private static final String preSignedUrlsMustHaveSamePath = "WFLYHC0121: pre_signed_put_url and pre_signed_delete_url must have the same path";
    private static final String preSignedUrlsMustBeSetOrUnset = "WFLYHC0122: pre_signed_put_url and pre_signed_delete_url must both be set or both unset";
    private static final String preSignedUrlMustPointToFile = "WFLYHC0123: pre-signed url %s must point to a file within a bucket";
    private static final String invalidPreSignedUrl = "WFLYHC0124: pre-signed url %s is not a valid url";
    private static final String invalidPreSignedUrlLength = "WFLYHC0125: pre-signed url %s may only have a subdirectory under a bucket";
    private static final String creatingBucketWithUnsupportedCallingFormat = "WFLYHC0126: Creating location-constrained bucket with unsupported calling-format";
    private static final String invalidS3Location = "WFLYHC0127: Invalid location: %s";
    private static final String invalidS3Bucket = "WFLYHC0128: Invalid bucket name: %s";
    private static final String bucketAuthenticationFailure = "WFLYHC0129: bucket '%s' could not be accessed (rsp=%d (%s)). Maybe the bucket is owned by somebody else or the authentication failed";
    private static final String unexpectedResponse = "WFLYHC0130: Unexpected response: %s";
    private static final String httpRedirectSupportRequired = "WFLYHC0131: HTTP redirect support required";
    private static final String errorParsingBucketListings = "WFLYHC0132: Unexpected error parsing bucket listing(s)";
    private static final String cannotInitializeSaxDriver = "WFLYHC0133: Couldn't initialize a SAX driver for the XMLReader";
    private static final String cannotInstantiateDiscoveryOptionClass = "WFLYHC0134: Cannot instantiate discovery option class '%s': %s";
    private static final String cannotWriteDomainControllerData = "WFLYHC0137: Could not write domain controller data to S3 file. Error was: %s";
    private static final String cannotRemoveS3File = "WFLYHC0138: Could not remove S3 file. Error was: %s";
    private static final String invalidDiscoveryOptionsOrdering = "WFLYHC0139: Invalid value for %s. Must only contain all of the existing discovery options";
    private static final String cannotExecuteTransactionalOperationFromSlave = "WFLYHC0140: Can't execute transactional operation '%s' from slave controller";
    private static final String noResourceFor = "WFLYHC0141: There is no resource called %s";
    private static final String failedToApplyDomainConfig0 = "WFLYHC0142: Failed to apply domain-wide configuration from master host controller";
    private static final String failedToApplyDomainConfig2 = "WFLYHC0143: Failed to apply domain-wide configuration from master host controller. Operation outcome: %s. Failure description %s";
    private static final String fetchConfigFromDomainMasterFailed = "WFLYHC0144: The host cannot start because it was started in running mode '%s' with no access to a local copy of the domain wide configuration policy, the '%s' attribute was set to '%s' and the domain wide configuration policy could not be obtained from the Domain Controller host. Startup will be aborted. Use the '%s' command line argument to start if you need to start without connecting to a domain controller connection.";
    private static final String noAccessControlConfigurationAvailable = "WFLYHC0145: The host cannot start because it was started in running mode '%s' with no access to a local copy of the domain wide configuration policy, and the '%s' attribute was set to '%s'. Startup will be aborted. Use the '%s' command line argument to start in running mode '%s'.";
    private static final String failedDiscoveringMaster = "WFLYHC0146: Could not discover master using discovery option %s. Error was: %s";
    private static final String noDiscoveryOptionsLeft = "WFLYHC0147: No domain controller discovery options remain.";
    private static final String connectedToMaster = "WFLYHC0148: Connected to master host controller at %s";
    private static final String usingCachedDC = "WFLYHC0149: Option %s was set; obtaining domain-wide configuration from %s";
    private static final String reconnectingToMaster = "WFLYHC0150: Trying to reconnect to master host controller.";
    private static final String noDomainControllerConfigurationProvidedForAdminOnly = "WFLYHC0151: No domain controller discovery configuration was provided and the '%s' attribute was set to '%s'. Startup will be aborted. Use the %s command line argument to start in %s mode if you need to start without a domain controller connection and then use the management tools to configure one.";
    private static final String serverLaunchCommandPrefix = "WFLYHC0152: Server %s will be started with JVM launch command prefix '%s'";
    private static final String channelClosed = "WFLYHC0153: Channel closed";
    private static final String noSecurityRealmForSsl = "WFLYHC0154: For a secure port to be enabled for the HTTP management interface a security realm to supply the SSLContext must be specified.";
    private static final String jvmVersionUnknown = "WFLYHC0155: JVM version '%s' unknown, unpredicted behavior may occur";
    private static final String failedToResolveInterface = "WFLYHC0156: failed to resolve interface %s";
    private static final String couldNotCreateDomainAutoStartDirectory = "WFLYHC0157: Could not create domain auto-start directory: %s";
    private static final String couldNotPersistAutoStartServerStatus = "WFLYHC0158: Error persisting server autostart status";
    private static final String invalidDiscoveryType = "WFLYHC0159: Invalid discovery type %s";

    public HostControllerLogger_$logger(Logger log) {
        super(log);
    }

    @Override
    public final void cannotConnect(URI uri, Exception cause) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.cannotConnect$str(), (Object)uri, (Object)cause);
    }

    protected String cannotConnect$str() {
        return cannotConnect;
    }

    @Override
    public final void cannotConnectToMaster(Exception e) {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.cannotConnectToMaster$str(), (Object)e);
    }

    protected String cannotConnectToMaster$str() {
        return cannotConnectToMaster;
    }

    @Override
    public final void creatingHttpManagementService(String interfaceName, int port, int securePort) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.creatingHttpManagementService$str(), (Object)interfaceName, (Object)port, (Object)securePort);
    }

    protected String creatingHttpManagementService$str() {
        return creatingHttpManagementService;
    }

    @Override
    public final void errorRetrievingDomainModel(String hostName, int port, String errorMessage) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.errorRetrievingDomainModel$str(), (Object)hostName, (Object)port, (Object)errorMessage);
    }

    protected String errorRetrievingDomainModel$str() {
        return errorRetrievingDomainModel;
    }

    @Override
    public final void existingServerWithState(String serverName, ServerStatus state) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.existingServerWithState$str(), (Object)serverName, (Object)state);
    }

    protected String existingServerWithState$str() {
        return existingServerWithState;
    }

    @Override
    public final void failedToCreateServerProcess(Throwable cause, String serverName) {
        this.log.logf(FQCN, Logger.Level.ERROR, cause, this.failedToCreateServerProcess$str(), (Object)serverName);
    }

    protected String failedToCreateServerProcess$str() {
        return failedToCreateServerProcess;
    }

    @Override
    public final void failedToSendReconnect(Throwable cause, String serverName) {
        this.log.logf(FQCN, Logger.Level.ERROR, cause, this.failedToSendReconnect$str(), (Object)serverName);
    }

    protected String failedToSendReconnect$str() {
        return failedToSendReconnect;
    }

    @Override
    public final void failedToStartServer(Throwable cause, String serverName) {
        this.log.logf(FQCN, Logger.Level.ERROR, cause, this.failedToStartServer$str(), (Object)serverName);
    }

    protected String failedToStartServer$str() {
        return failedToStartServer;
    }

    @Override
    public final void failedToStopServer(Throwable cause, String serverName) {
        this.log.logf(FQCN, Logger.Level.ERROR, cause, this.failedToStopServer$str(), (Object)serverName);
    }

    protected String failedToStopServer$str() {
        return failedToStopServer;
    }

    @Override
    public final void gracefulShutdownNotSupported(String serverName) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.gracefulShutdownNotSupported$str(), (Object)serverName);
    }

    protected String gracefulShutdownNotSupported$str() {
        return gracefulShutdownNotSupported;
    }

    @Override
    public final void ignoringPermGen(JvmType type, String jvm) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.ignoringPermGen$str(), (Object)type, (Object)jvm);
    }

    protected String ignoringPermGen$str() {
        return ignoringPermGen;
    }

    @Override
    public final void noDomainControllerConfigurationProvided(RunningMode currentRunningMode, String adminOnlyCmdLineArg, RunningMode validRunningMode) {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.noDomainControllerConfigurationProvided$str(), (Object)currentRunningMode, (Object)adminOnlyCmdLineArg, (Object)validRunningMode);
    }

    protected String noDomainControllerConfigurationProvided$str() {
        return noDomainControllerConfigurationProvided;
    }

    @Override
    public final void noSecurityRealmDefined() {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.noSecurityRealmDefined$str(), new Object[0]);
    }

    protected String noSecurityRealmDefined$str() {
        return noSecurityRealmDefined;
    }

    @Override
    public final void noServerAvailable(String serverName) {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.noServerAvailable$str(), (Object)serverName);
    }

    protected String noServerAvailable$str() {
        return noServerAvailable;
    }

    @Override
    public final void lostRemoteDomainConnection() {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.lostRemoteDomainConnection$str(), new Object[0]);
    }

    protected String lostRemoteDomainConnection$str() {
        return lostRemoteDomainConnection;
    }

    @Override
    public final void optionAlreadySet(String option, String jvm, String element) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.optionAlreadySet$str(), (Object)option, (Object)jvm, (Object)element);
    }

    protected String optionAlreadySet$str() {
        return optionAlreadySet;
    }

    @Override
    public final void reconnectingServer(String serverName) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.reconnectingServer$str(), (Object)serverName);
    }

    protected String reconnectingServer$str() {
        return reconnectingServer;
    }

    @Override
    public final void registeredRemoteSlaveHost(String hostName, String productName) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.registeredRemoteSlaveHost$str(), (Object)hostName, (Object)productName);
    }

    protected String registeredRemoteSlaveHost$str() {
        return registeredRemoteSlaveHost;
    }

    @Override
    public final void registeringServer(String name) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.registeringServer$str(), (Object)name);
    }

    protected String registeringServer$str() {
        return registeringServer;
    }

    @Override
    public final void serverConnected(String name, Channel channel) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.serverConnected$str(), (Object)name, (Object)channel);
    }

    protected String serverConnected$str() {
        return serverConnected;
    }

    @Override
    public final void serviceShutdownIncomplete(Throwable cause) {
        this.log.logf(FQCN, Logger.Level.WARN, cause, this.serviceShutdownIncomplete$str(), new Object[0]);
    }

    protected String serviceShutdownIncomplete$str() {
        return serviceShutdownIncomplete;
    }

    @Override
    public final void startingServer(String serverName) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.startingServer$str(), (Object)serverName);
    }

    protected String startingServer$str() {
        return startingServer;
    }

    @Override
    public final void stoppingServer(String serverName) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.stoppingServer$str(), (Object)serverName);
    }

    protected String stoppingServer$str() {
        return stoppingServer;
    }

    @Override
    public final void unexpectedServerState(String serverName, ServerState expected, ServerState current) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.unexpectedServerState$str(), (Object)serverName, (Object)expected, (Object)current);
    }

    protected String unexpectedServerState$str() {
        return unexpectedServerState;
    }

    @Override
    public final void unregisteredRemoteSlaveHost(String host) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.unregisteredRemoteSlaveHost$str(), (Object)host);
    }

    protected String unregisteredRemoteSlaveHost$str() {
        return unregisteredRemoteSlaveHost;
    }

    @Override
    public final void unregisteringServer(String name) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.unregisteringServer$str(), (Object)name);
    }

    protected String unregisteringServer$str() {
        return unregisteringServer;
    }

    @Override
    public final void registeredAtRemoteHostController() {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.registeredAtRemoteHostController$str(), new Object[0]);
    }

    protected String registeredAtRemoteHostController$str() {
        return registeredAtRemoteHostController;
    }

    @Override
    public final void unregisteredAtRemoteHostController() {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.unregisteredAtRemoteHostController$str(), new Object[0]);
    }

    protected String unregisteredAtRemoteHostController$str() {
        return unregisteredAtRemoteHostController;
    }

    @Override
    public final void lostConnectionToRemoteHost(String hostId) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.lostConnectionToRemoteHost$str(), (Object)hostId);
    }

    protected String lostConnectionToRemoteHost$str() {
        return lostConnectionToRemoteHost;
    }

    @Override
    public final void invalidRemoteBackupPersisterState() {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.invalidRemoteBackupPersisterState$str(), new Object[0]);
    }

    protected String invalidRemoteBackupPersisterState$str() {
        return invalidRemoteBackupPersisterState;
    }

    @Override
    public final void invalidCachedPersisterState() {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.invalidCachedPersisterState$str(), new Object[0]);
    }

    protected String invalidCachedPersisterState$str() {
        return invalidCachedPersisterState;
    }

    @Override
    public final void caughtExceptionDuringBoot(Exception e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.caughtExceptionDuringBoot$str(), new Object[0]);
    }

    protected String caughtExceptionDuringBoot$str() {
        return caughtExceptionDuringBoot;
    }

    @Override
    public final void unsuccessfulBoot() {
        this.log.logf(FQCN, Logger.Level.FATAL, null, this.unsuccessfulBoot$str(), new Object[0]);
    }

    protected String unsuccessfulBoot$str() {
        return unsuccessfulBoot;
    }

    @Override
    public final void reportAdminOnlyDomainXmlFailure() {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.reportAdminOnlyDomainXmlFailure$str(), new Object[0]);
    }

    protected String reportAdminOnlyDomainXmlFailure$str() {
        return reportAdminOnlyDomainXmlFailure;
    }

    @Override
    public final void gracefulManagementChannelHandlerShutdownTimedOut(int timeout) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.gracefulManagementChannelHandlerShutdownTimedOut$str(), (Object)timeout);
    }

    protected String gracefulManagementChannelHandlerShutdownTimedOut$str() {
        return gracefulManagementChannelHandlerShutdownTimedOut;
    }

    @Override
    public final void masterHostControllerChanged() {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.masterHostControllerChanged$str(), new Object[0]);
    }

    protected String masterHostControllerChanged$str() {
        return masterHostControllerChanged;
    }

    @Override
    public final void masterHostControllerUnreachable(long timeout) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.masterHostControllerUnreachable$str(), (Object)timeout);
    }

    protected String masterHostControllerUnreachable$str() {
        return masterHostControllerUnreachable;
    }

    @Override
    public final void slaveHostControllerChanged(String hostName) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.slaveHostControllerChanged$str(), (Object)hostName);
    }

    protected String slaveHostControllerChanged$str() {
        return slaveHostControllerChanged;
    }

    @Override
    public final void slaveHostControllerUnreachable(String hostName, long timeout) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.slaveHostControllerUnreachable$str(), (Object)hostName, (Object)timeout);
    }

    protected String slaveHostControllerUnreachable$str() {
        return slaveHostControllerUnreachable;
    }

    protected String argumentExpected$str() {
        return argumentExpected;
    }

    @Override
    public final String argumentExpected(String option, String usageNote) {
        return String.format(this.argumentExpected$str(), option, usageNote);
    }

    protected String attemptingToSet$str() {
        return attemptingToSet;
    }

    @Override
    public final IllegalArgumentException attemptingToSet(String attributeToSet, String attributeAlreadySet) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.attemptingToSet$str(), attributeToSet, attributeAlreadySet));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String authenticationFailureUnableToConnect$str() {
        return authenticationFailureUnableToConnect;
    }

    @Override
    public final IllegalStateException authenticationFailureUnableToConnect(Throwable cause) {
        IllegalStateException result = new IllegalStateException(String.format(this.authenticationFailureUnableToConnect$str(), new Object[0]), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotAccessRemoteFileRepository$str() {
        return cannotAccessRemoteFileRepository;
    }

    @Override
    public final IllegalStateException cannotAccessRemoteFileRepository() {
        IllegalStateException result = new IllegalStateException(String.format(this.cannotAccessRemoteFileRepository$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotCreateLocalDirectory$str() {
        return cannotCreateLocalDirectory;
    }

    @Override
    public final IOException cannotCreateLocalDirectory(File path) {
        IOException result = new IOException(String.format(this.cannotCreateLocalDirectory$str(), path));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotObtainValidDefaultAddress$str() {
        return cannotObtainValidDefaultAddress;
    }

    @Override
    public final RuntimeException cannotObtainValidDefaultAddress(Throwable cause, String defaultAddress, String option) {
        RuntimeException result = new RuntimeException(String.format(this.cannotObtainValidDefaultAddress$str(), defaultAddress, option), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotRestartServer$str() {
        return cannotRestartServer;
    }

    @Override
    public final String cannotRestartServer(String serverName, ServerStatus status) {
        return String.format(this.cannotRestartServer$str(), serverName, status);
    }

    protected String cannotStartServersInvalidMode$str() {
        return cannotStartServersInvalidMode;
    }

    @Override
    public final String cannotStartServersInvalidMode(RunningMode mode) {
        return String.format(this.cannotStartServersInvalidMode$str(), mode);
    }

    protected String closeShouldBeManagedByService$str() {
        return closeShouldBeManagedByService;
    }

    @Override
    public final UnsupportedOperationException closeShouldBeManagedByService() {
        UnsupportedOperationException result = new UnsupportedOperationException(String.format(this.closeShouldBeManagedByService$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String configurationPersisterAlreadyInitialized$str() {
        return configurationPersisterAlreadyInitialized;
    }

    @Override
    public final IllegalStateException configurationPersisterAlreadyInitialized() {
        IllegalStateException result = new IllegalStateException(String.format(this.configurationPersisterAlreadyInitialized$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String connectionToMasterInterrupted$str() {
        return connectionToMasterInterrupted;
    }

    @Override
    public final IllegalStateException connectionToMasterInterrupted() {
        IllegalStateException result = new IllegalStateException(String.format(this.connectionToMasterInterrupted$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String connectionToMasterTimeout$str() {
        return connectionToMasterTimeout;
    }

    @Override
    public final IllegalStateException connectionToMasterTimeout(Throwable cause, int retries, long timeout) {
        IllegalStateException result = new IllegalStateException(String.format(this.connectionToMasterTimeout$str(), retries, timeout), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String couldNotGetServerInventory$str() {
        return couldNotGetServerInventory;
    }

    @Override
    public final RuntimeException couldNotGetServerInventory(long time, String timeUnit) {
        RuntimeException result = new RuntimeException(String.format(this.couldNotGetServerInventory$str(), time, timeUnit));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String didNotReadEntireFile$str() {
        return didNotReadEntireFile;
    }

    @Override
    public final IOException didNotReadEntireFile(long missing) {
        IOException result = new IOException(String.format(this.didNotReadEntireFile$str(), missing));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String errorClosingDownHost$str() {
        return errorClosingDownHost;
    }

    @Override
    public final RuntimeException errorClosingDownHost(Throwable cause) {
        RuntimeException result = new RuntimeException(String.format(this.errorClosingDownHost$str(), new Object[0]), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String failedProfileOperationsRetrieval$str() {
        return failedProfileOperationsRetrieval;
    }

    @Override
    public final String failedProfileOperationsRetrieval() {
        return String.format(this.failedProfileOperationsRetrieval$str(), new Object[0]);
    }

    protected String failedToGetFileFromRemoteRepository$str() {
        return failedToGetFileFromRemoteRepository;
    }

    @Override
    public final RuntimeException failedToGetFileFromRemoteRepository(Throwable cause) {
        RuntimeException result = new RuntimeException(String.format(this.failedToGetFileFromRemoteRepository$str(), new Object[0]), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String failedToGetServerStatus$str() {
        return failedToGetServerStatus;
    }

    @Override
    public final String failedToGetServerStatus() {
        return String.format(this.failedToGetServerStatus$str(), new Object[0]);
    }

    protected String failedToReadAuthenticationKey$str() {
        return failedToReadAuthenticationKey;
    }

    @Override
    public final String failedToReadAuthenticationKey(Throwable cause) {
        return String.format(this.failedToReadAuthenticationKey$str(), cause);
    }

    protected String hostNameAlreadyConnected$str() {
        return hostNameAlreadyConnected;
    }

    @Override
    public final IllegalArgumentException hostNameAlreadyConnected(String hostName) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.hostNameAlreadyConnected$str(), hostName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String insufficientInformationToGenerateHash$str() {
        return insufficientInformationToGenerateHash;
    }

    @Override
    public final SaslException insufficientInformationToGenerateHash() {
        SaslException result = new SaslException(String.format(this.insufficientInformationToGenerateHash$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidOption$str() {
        return invalidOption;
    }

    @Override
    public final String invalidOption(String option, String usageNote) {
        return String.format(this.invalidOption$str(), option, usageNote);
    }

    protected String invalidRootId$str() {
        return invalidRootId;
    }

    @Override
    public final RequestProcessingException invalidRootId(int rootId) {
        RequestProcessingException result = new RequestProcessingException(String.format(this.invalidRootId$str(), rootId));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidValue$str() {
        return invalidValue;
    }

    @Override
    public final String invalidValue(String name, String type, Object value, String usageNote) {
        return String.format(this.invalidValue$str(), name, type, value, usageNote);
    }

    protected String invocationNotAllowedAfterBoot$str() {
        return invocationNotAllowedAfterBoot;
    }

    @Override
    public final IllegalStateException invocationNotAllowedAfterBoot(String name) {
        IllegalStateException result = new IllegalStateException(String.format(this.invocationNotAllowedAfterBoot$str(), name));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final String invocationNotAllowedAfterBoot(ModelNode operation) {
        return String.format(this.invocationNotAllowedAfterBoot$str(), operation);
    }

    protected String malformedUrl$str() {
        return malformedUrl;
    }

    @Override
    public final String malformedUrl(String option, String usageNote) {
        return String.format(this.malformedUrl$str(), option, usageNote);
    }

    protected String mustInvokeBeforeCheckingSlaveStatus$str() {
        return mustInvokeBeforeCheckingSlaveStatus;
    }

    @Override
    public final IllegalStateException mustInvokeBeforeCheckingSlaveStatus(String methodName) {
        IllegalStateException result = new IllegalStateException(String.format(this.mustInvokeBeforeCheckingSlaveStatus$str(), methodName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mustInvokeBeforePersisting$str() {
        return mustInvokeBeforePersisting;
    }

    @Override
    public final IllegalStateException mustInvokeBeforePersisting(String methodName) {
        IllegalStateException result = new IllegalStateException(String.format(this.mustInvokeBeforePersisting$str(), methodName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noChannelForHost$str() {
        return noChannelForHost;
    }

    @Override
    public final IllegalArgumentException noChannelForHost(String hostName) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.noChannelForHost$str(), hostName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noNameAttributeOnHost$str() {
        return noNameAttributeOnHost;
    }

    @Override
    public final IllegalArgumentException noNameAttributeOnHost() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.noNameAttributeOnHost$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noServerInventory$str() {
        return noServerInventory;
    }

    @Override
    public final IllegalStateException noServerInventory() {
        IllegalStateException result = new IllegalStateException(String.format(this.noServerInventory$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String propertyAlreadyExists$str() {
        return propertyAlreadyExists;
    }

    @Override
    public final IllegalArgumentException propertyAlreadyExists(String name) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.propertyAlreadyExists$str(), name));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String propertyNotFound$str() {
        return propertyNotFound;
    }

    @Override
    public final IllegalArgumentException propertyNotFound(String name) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.propertyNotFound$str(), name));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String propertyValueNull$str() {
        return propertyValueNull;
    }

    @Override
    public final IllegalArgumentException propertyValueNull(String name) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.propertyValueNull$str(), name));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String propertyValueHasNullValue$str() {
        return propertyValueHasNullValue;
    }

    @Override
    public final IllegalStateException propertyValueHasNullValue(String name) {
        IllegalStateException result = new IllegalStateException(String.format(this.propertyValueHasNullValue$str(), name));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String nullVar$str() {
        return nullVar;
    }

    @Override
    public final IllegalArgumentException nullVar(String name) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.nullVar$str(), name));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String serverNameAlreadyRegistered$str() {
        return serverNameAlreadyRegistered;
    }

    @Override
    public final IllegalArgumentException serverNameAlreadyRegistered(String serverName) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.serverNameAlreadyRegistered$str(), serverName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String serverStillRunning$str() {
        return serverStillRunning;
    }

    @Override
    public final String serverStillRunning(String name) {
        return String.format(this.serverStillRunning$str(), name);
    }

    protected String unableToGenerateHash$str() {
        return unableToGenerateHash;
    }

    @Override
    public final SaslException unableToGenerateHash(Throwable cause) {
        SaslException result = new SaslException(String.format(this.unableToGenerateHash$str(), new Object[0]), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToLoadProperties$str() {
        return unableToLoadProperties;
    }

    @Override
    public final String unableToLoadProperties(URL url, String usageNote) {
        return String.format(this.unableToLoadProperties$str(), url, usageNote);
    }

    protected String undefinedSocketBinding$str() {
        return undefinedSocketBinding;
    }

    @Override
    public final IllegalArgumentException undefinedSocketBinding(String serverName) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.undefinedSocketBinding$str(), serverName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String undefinedSocketBindingGroup$str() {
        return undefinedSocketBindingGroup;
    }

    @Override
    public final IllegalStateException undefinedSocketBindingGroup(String name) {
        IllegalStateException result = new IllegalStateException(String.format(this.undefinedSocketBindingGroup$str(), name));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unexpectedState$str() {
        return unexpectedState;
    }

    @Override
    public final IllegalStateException unexpectedState(ServerState state) {
        IllegalStateException result = new IllegalStateException(String.format(this.unexpectedState$str(), state));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unknown$str() {
        return unknown;
    }

    @Override
    public final IllegalArgumentException unknown(String name, Object value) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.unknown$str(), name, value));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unknownHostValue$str() {
        return unknownHostValue;
    }

    @Override
    public final String unknownHostValue(String name, Object value, String usageNote) {
        return String.format(this.unknownHostValue$str(), name, value, usageNote);
    }

    protected String unrecognizedType$str() {
        return unrecognizedType;
    }

    @Override
    public final IOException unrecognizedType(byte type) {
        IOException result = new IOException(String.format(this.unrecognizedType$str(), type));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String hostAlreadyShutdown$str() {
        return hostAlreadyShutdown;
    }

    @Override
    public final IllegalStateException hostAlreadyShutdown() {
        IllegalStateException result = new IllegalStateException(String.format(this.hostAlreadyShutdown$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noServerGroupCalled$str() {
        return noServerGroupCalled;
    }

    @Override
    public final OperationFailedException noServerGroupCalled(String groupName) {
        OperationFailedException result = new OperationFailedException(String.format(this.noServerGroupCalled$str(), groupName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noSocketBindingGroupCalled$str() {
        return noSocketBindingGroupCalled;
    }

    @Override
    public final OperationFailedException noSocketBindingGroupCalled(String groupName) {
        OperationFailedException result = new OperationFailedException(String.format(this.noSocketBindingGroupCalled$str(), groupName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String hostControllerSystemPropertyUpdateNotSupported$str() {
        return hostControllerSystemPropertyUpdateNotSupported;
    }

    @Override
    public final UnsupportedOperationException hostControllerSystemPropertyUpdateNotSupported() {
        UnsupportedOperationException result = new UnsupportedOperationException(String.format(this.hostControllerSystemPropertyUpdateNotSupported$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotIgnoreTypeHost$str() {
        return cannotIgnoreTypeHost;
    }

    @Override
    public final OperationFailedException cannotIgnoreTypeHost(String type) {
        OperationFailedException result = new OperationFailedException(String.format(this.cannotIgnoreTypeHost$str(), type));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String duplicateIgnoredResourceType$str() {
        return duplicateIgnoredResourceType;
    }

    @Override
    public final XMLStreamException duplicateIgnoredResourceType(String element, String value, Location location) {
        XMLStreamException result = new XMLStreamException(String.format(this.duplicateIgnoredResourceType$str(), element, value), location);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotAccessJvmInputArgument$str() {
        return cannotAccessJvmInputArgument;
    }

    @Override
    public final String cannotAccessJvmInputArgument(Exception cause) {
        return String.format(this.cannotAccessJvmInputArgument$str(), cause);
    }

    protected String missingHomeDirConfiguration$str() {
        return missingHomeDirConfiguration;
    }

    @Override
    public final IllegalStateException missingHomeDirConfiguration(String propertyName) {
        IllegalStateException result = new IllegalStateException(String.format(this.missingHomeDirConfiguration$str(), propertyName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String homeDirectoryDoesNotExist$str() {
        return homeDirectoryDoesNotExist;
    }

    @Override
    public final IllegalStateException homeDirectoryDoesNotExist(File f) {
        IllegalStateException result = new IllegalStateException(String.format(this.homeDirectoryDoesNotExist$str(), f));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String modulesDirectoryDoesNotExist$str() {
        return modulesDirectoryDoesNotExist;
    }

    @Override
    public final IllegalStateException modulesDirectoryDoesNotExist(File f) {
        IllegalStateException result = new IllegalStateException(String.format(this.modulesDirectoryDoesNotExist$str(), f));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String domainBaseDirectoryDoesNotExist$str() {
        return domainBaseDirectoryDoesNotExist;
    }

    @Override
    public final IllegalStateException domainBaseDirectoryDoesNotExist(File f) {
        IllegalStateException result = new IllegalStateException(String.format(this.domainBaseDirectoryDoesNotExist$str(), f));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String domainBaseDirectoryIsNotADirectory$str() {
        return domainBaseDirectoryIsNotADirectory;
    }

    @Override
    public final IllegalStateException domainBaseDirectoryIsNotADirectory(File file) {
        IllegalStateException result = new IllegalStateException(String.format(this.domainBaseDirectoryIsNotADirectory$str(), file));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String configDirectoryDoesNotExist$str() {
        return configDirectoryDoesNotExist;
    }

    @Override
    public final IllegalStateException configDirectoryDoesNotExist(File f) {
        IllegalStateException result = new IllegalStateException(String.format(this.configDirectoryDoesNotExist$str(), f));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String domainDataDirectoryIsNotDirectory$str() {
        return domainDataDirectoryIsNotDirectory;
    }

    @Override
    public final IllegalStateException domainDataDirectoryIsNotDirectory(File file) {
        IllegalStateException result = new IllegalStateException(String.format(this.domainDataDirectoryIsNotDirectory$str(), file));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String couldNotCreateDomainDataDirectory$str() {
        return couldNotCreateDomainDataDirectory;
    }

    @Override
    public final IllegalStateException couldNotCreateDomainDataDirectory(File file) {
        IllegalStateException result = new IllegalStateException(String.format(this.couldNotCreateDomainDataDirectory$str(), file));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String domainContentDirectoryIsNotDirectory$str() {
        return domainContentDirectoryIsNotDirectory;
    }

    @Override
    public final IllegalStateException domainContentDirectoryIsNotDirectory(File file) {
        IllegalStateException result = new IllegalStateException(String.format(this.domainContentDirectoryIsNotDirectory$str(), file));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String couldNotCreateDomainContentDirectory$str() {
        return couldNotCreateDomainContentDirectory;
    }

    @Override
    public final IllegalStateException couldNotCreateDomainContentDirectory(File file) {
        IllegalStateException result = new IllegalStateException(String.format(this.couldNotCreateDomainContentDirectory$str(), file));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String logDirectoryIsNotADirectory$str() {
        return logDirectoryIsNotADirectory;
    }

    @Override
    public final IllegalStateException logDirectoryIsNotADirectory(File f) {
        IllegalStateException result = new IllegalStateException(String.format(this.logDirectoryIsNotADirectory$str(), f));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String couldNotCreateLogDirectory$str() {
        return couldNotCreateLogDirectory;
    }

    @Override
    public final IllegalStateException couldNotCreateLogDirectory(File f) {
        IllegalStateException result = new IllegalStateException(String.format(this.couldNotCreateLogDirectory$str(), f));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String serversDirectoryIsNotADirectory$str() {
        return serversDirectoryIsNotADirectory;
    }

    @Override
    public final IllegalStateException serversDirectoryIsNotADirectory(File f) {
        IllegalStateException result = new IllegalStateException(String.format(this.serversDirectoryIsNotADirectory$str(), f));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String couldNotCreateServersDirectory$str() {
        return couldNotCreateServersDirectory;
    }

    @Override
    public final IllegalStateException couldNotCreateServersDirectory(File f) {
        IllegalStateException result = new IllegalStateException(String.format(this.couldNotCreateServersDirectory$str(), f));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String domainTempDirectoryIsNotADirectory$str() {
        return domainTempDirectoryIsNotADirectory;
    }

    @Override
    public final IllegalStateException domainTempDirectoryIsNotADirectory(File file) {
        IllegalStateException result = new IllegalStateException(String.format(this.domainTempDirectoryIsNotADirectory$str(), file));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String couldNotCreateDomainTempDirectory$str() {
        return couldNotCreateDomainTempDirectory;
    }

    @Override
    public final IllegalStateException couldNotCreateDomainTempDirectory(File file) {
        IllegalStateException result = new IllegalStateException(String.format(this.couldNotCreateDomainTempDirectory$str(), file));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String sslFailureUnableToConnect$str() {
        return sslFailureUnableToConnect;
    }

    @Override
    public final IllegalStateException sslFailureUnableToConnect(Throwable cause) {
        IllegalStateException result = new IllegalStateException(String.format(this.sslFailureUnableToConnect$str(), new Object[0]), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String jvmOptionAlreadyExists$str() {
        return jvmOptionAlreadyExists;
    }

    @Override
    public final IllegalStateException jvmOptionAlreadyExists(String option) {
        IllegalStateException result = new IllegalStateException(String.format(this.jvmOptionAlreadyExists$str(), option));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String envVariableAlreadyExists$str() {
        return envVariableAlreadyExists;
    }

    @Override
    public final IllegalStateException envVariableAlreadyExists(String var) {
        IllegalStateException result = new IllegalStateException(String.format(this.envVariableAlreadyExists$str(), var));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unsupportedManagementVersionForHost$str() {
        return unsupportedManagementVersionForHost;
    }

    @Override
    public final OperationFailedException unsupportedManagementVersionForHost(int major, int minor, int minMajor, int minMinor) {
        OperationFailedException result = new OperationFailedException(String.format(this.unsupportedManagementVersionForHost$str(), major, minor, minMajor, minMinor));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String failedToAddExtensions$str() {
        return failedToAddExtensions;
    }

    @Override
    public final IllegalStateException failedToAddExtensions(ModelNode failureDescription) {
        IllegalStateException result = new IllegalStateException(String.format(this.failedToAddExtensions$str(), failureDescription));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String argumentHasNoValue$str() {
        return argumentHasNoValue;
    }

    @Override
    public final String argumentHasNoValue(String argument, String usageNote) {
        return String.format(this.argumentHasNoValue$str(), argument, usageNote);
    }

    protected String usageNote$str() {
        return usageNote;
    }

    @Override
    public final String usageNote(String command) {
        return String.format(this.usageNote$str(), command);
    }

    protected String cannotAccessS3File$str() {
        return cannotAccessS3File;
    }

    @Override
    public final IllegalStateException cannotAccessS3File(String message) {
        IllegalStateException result = new IllegalStateException(String.format(this.cannotAccessS3File$str(), message));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String failedMarshallingDomainControllerData$str() {
        return failedMarshallingDomainControllerData;
    }

    @Override
    public final IllegalStateException failedMarshallingDomainControllerData() {
        IllegalStateException result = new IllegalStateException(String.format(this.failedMarshallingDomainControllerData$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotWriteToS3File$str() {
        return cannotWriteToS3File;
    }

    @Override
    public final IOException cannotWriteToS3File(String message) {
        IOException result = new IOException(String.format(this.cannotWriteToS3File$str(), message));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotAccessS3Bucket$str() {
        return cannotAccessS3Bucket;
    }

    @Override
    public final IllegalStateException cannotAccessS3Bucket(String location, String message) {
        IllegalStateException result = new IllegalStateException(String.format(this.cannotAccessS3Bucket$str(), location, message));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String discoveryOptionsFailureUnableToConnect$str() {
        return discoveryOptionsFailureUnableToConnect;
    }

    @Override
    public final IllegalStateException discoveryOptionsFailureUnableToConnect(Throwable cause) {
        IllegalStateException result = new IllegalStateException(String.format(this.discoveryOptionsFailureUnableToConnect$str(), new Object[0]), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String preSignedUrlsMustHaveSamePath$str() {
        return preSignedUrlsMustHaveSamePath;
    }

    @Override
    public final IllegalStateException preSignedUrlsMustHaveSamePath() {
        IllegalStateException result = new IllegalStateException(String.format(this.preSignedUrlsMustHaveSamePath$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String preSignedUrlsMustBeSetOrUnset$str() {
        return preSignedUrlsMustBeSetOrUnset;
    }

    @Override
    public final IllegalStateException preSignedUrlsMustBeSetOrUnset() {
        IllegalStateException result = new IllegalStateException(String.format(this.preSignedUrlsMustBeSetOrUnset$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String preSignedUrlMustPointToFile$str() {
        return preSignedUrlMustPointToFile;
    }

    @Override
    public final IllegalStateException preSignedUrlMustPointToFile(String preSignedUrl) {
        IllegalStateException result = new IllegalStateException(String.format(this.preSignedUrlMustPointToFile$str(), preSignedUrl));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidPreSignedUrl$str() {
        return invalidPreSignedUrl;
    }

    @Override
    public final IllegalStateException invalidPreSignedUrl(String preSignedUrl) {
        IllegalStateException result = new IllegalStateException(String.format(this.invalidPreSignedUrl$str(), preSignedUrl));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidPreSignedUrlLength$str() {
        return invalidPreSignedUrlLength;
    }

    @Override
    public final IllegalStateException invalidPreSignedUrlLength(String preSignedUrl) {
        IllegalStateException result = new IllegalStateException(String.format(this.invalidPreSignedUrlLength$str(), preSignedUrl));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String creatingBucketWithUnsupportedCallingFormat$str() {
        return creatingBucketWithUnsupportedCallingFormat;
    }

    @Override
    public final IllegalArgumentException creatingBucketWithUnsupportedCallingFormat() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.creatingBucketWithUnsupportedCallingFormat$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidS3Location$str() {
        return invalidS3Location;
    }

    @Override
    public final IllegalArgumentException invalidS3Location(String location) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.invalidS3Location$str(), location));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidS3Bucket$str() {
        return invalidS3Bucket;
    }

    @Override
    public final IllegalArgumentException invalidS3Bucket(String bucket) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.invalidS3Bucket$str(), bucket));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String bucketAuthenticationFailure$str() {
        return bucketAuthenticationFailure;
    }

    @Override
    public final IOException bucketAuthenticationFailure(String bucket, int httpCode, String responseMessage) {
        IOException result = new IOException(String.format(this.bucketAuthenticationFailure$str(), bucket, httpCode, responseMessage));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unexpectedResponse$str() {
        return unexpectedResponse;
    }

    @Override
    public final IOException unexpectedResponse(String message) {
        IOException result = new IOException(String.format(this.unexpectedResponse$str(), message));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String httpRedirectSupportRequired$str() {
        return httpRedirectSupportRequired;
    }

    @Override
    public final RuntimeException httpRedirectSupportRequired() {
        RuntimeException result = new RuntimeException(String.format(this.httpRedirectSupportRequired$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String errorParsingBucketListings$str() {
        return errorParsingBucketListings;
    }

    @Override
    public final RuntimeException errorParsingBucketListings(Throwable cause) {
        RuntimeException result = new RuntimeException(String.format(this.errorParsingBucketListings$str(), new Object[0]), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotInitializeSaxDriver$str() {
        return cannotInitializeSaxDriver;
    }

    @Override
    public final RuntimeException cannotInitializeSaxDriver() {
        RuntimeException result = new RuntimeException(String.format(this.cannotInitializeSaxDriver$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotInstantiateDiscoveryOptionClass$str() {
        return cannotInstantiateDiscoveryOptionClass;
    }

    @Override
    public final IllegalStateException cannotInstantiateDiscoveryOptionClass(String className, String message) {
        IllegalStateException result = new IllegalStateException(String.format(this.cannotInstantiateDiscoveryOptionClass$str(), className, message));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void cannotWriteDomainControllerData(Exception e) {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.cannotWriteDomainControllerData$str(), (Object)e);
    }

    protected String cannotWriteDomainControllerData$str() {
        return cannotWriteDomainControllerData;
    }

    @Override
    public final void cannotRemoveS3File(Exception e) {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.cannotRemoveS3File$str(), (Object)e);
    }

    protected String cannotRemoveS3File$str() {
        return cannotRemoveS3File;
    }

    protected String invalidDiscoveryOptionsOrdering$str() {
        return invalidDiscoveryOptionsOrdering;
    }

    @Override
    public final OperationFailedException invalidDiscoveryOptionsOrdering(String name) {
        OperationFailedException result = new OperationFailedException(String.format(this.invalidDiscoveryOptionsOrdering$str(), name));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotExecuteTransactionalOperationFromSlave$str() {
        return cannotExecuteTransactionalOperationFromSlave;
    }

    @Override
    public final IllegalStateException cannotExecuteTransactionalOperationFromSlave(String operationName) {
        IllegalStateException result = new IllegalStateException(String.format(this.cannotExecuteTransactionalOperationFromSlave$str(), operationName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noResourceFor$str() {
        return noResourceFor;
    }

    @Override
    public final OperationFailedException noResourceFor(PathAddress address) {
        OperationFailedException result = new OperationFailedException(String.format(this.noResourceFor$str(), address));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void failedToApplyDomainConfig(Exception e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.failedToApplyDomainConfig0$str(), new Object[0]);
    }

    protected String failedToApplyDomainConfig0$str() {
        return failedToApplyDomainConfig0;
    }

    @Override
    public final void failedToApplyDomainConfig(String outcome, ModelNode failureDescription) {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.failedToApplyDomainConfig2$str(), (Object)outcome, (Object)failureDescription);
    }

    protected String failedToApplyDomainConfig2$str() {
        return failedToApplyDomainConfig2;
    }

    @Override
    public final void fetchConfigFromDomainMasterFailed(RunningMode currentRunningMode, String policyAttribute, AdminOnlyDomainConfigPolicy policy, String cachedDcCmdLineArg) {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.fetchConfigFromDomainMasterFailed$str(), new Object[]{currentRunningMode, policyAttribute, policy, cachedDcCmdLineArg});
    }

    protected String fetchConfigFromDomainMasterFailed$str() {
        return fetchConfigFromDomainMasterFailed;
    }

    @Override
    public final void noAccessControlConfigurationAvailable(RunningMode currentRunningMode, String policyAttribute, AdminOnlyDomainConfigPolicy policy, String cachedDcCmdLineArg, RunningMode desiredRunningMode) {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.noAccessControlConfigurationAvailable$str(), new Object[]{currentRunningMode, policyAttribute, policy, cachedDcCmdLineArg, desiredRunningMode});
    }

    protected String noAccessControlConfigurationAvailable$str() {
        return noAccessControlConfigurationAvailable;
    }

    @Override
    public final void failedDiscoveringMaster(DiscoveryOption option, Exception e) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.failedDiscoveringMaster$str(), (Object)option, (Object)e);
    }

    protected String failedDiscoveringMaster$str() {
        return failedDiscoveringMaster;
    }

    @Override
    public final void noDiscoveryOptionsLeft() {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.noDiscoveryOptionsLeft$str(), new Object[0]);
    }

    protected String noDiscoveryOptionsLeft$str() {
        return noDiscoveryOptionsLeft;
    }

    @Override
    public final void connectedToMaster(URI uri) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.connectedToMaster$str(), (Object)uri);
    }

    protected String connectedToMaster$str() {
        return connectedToMaster;
    }

    @Override
    public final void usingCachedDC(String configOption, String cachedXmlFile) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.usingCachedDC$str(), (Object)configOption, (Object)cachedXmlFile);
    }

    protected String usingCachedDC$str() {
        return usingCachedDC;
    }

    @Override
    public final void reconnectingToMaster() {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.reconnectingToMaster$str(), new Object[0]);
    }

    protected String reconnectingToMaster$str() {
        return reconnectingToMaster;
    }

    @Override
    public final void noDomainControllerConfigurationProvidedForAdminOnly(String policyAttribute, AdminOnlyDomainConfigPolicy policy, String cachedDcCmdLineArg, RunningMode desiredRunningMode) {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.noDomainControllerConfigurationProvidedForAdminOnly$str(), new Object[]{policyAttribute, policy, cachedDcCmdLineArg, desiredRunningMode});
    }

    protected String noDomainControllerConfigurationProvidedForAdminOnly$str() {
        return noDomainControllerConfigurationProvidedForAdminOnly;
    }

    @Override
    public final void serverLaunchCommandPrefix(String serverName, String launchCommandPrefix) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.serverLaunchCommandPrefix$str(), (Object)serverName, (Object)launchCommandPrefix);
    }

    protected String serverLaunchCommandPrefix$str() {
        return serverLaunchCommandPrefix;
    }

    protected String channelClosed$str() {
        return channelClosed;
    }

    @Override
    public final IOException channelClosed() {
        IOException result = new IOException(String.format(this.channelClosed$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noSecurityRealmForSsl$str() {
        return noSecurityRealmForSsl;
    }

    @Override
    public final OperationFailedException noSecurityRealmForSsl() {
        OperationFailedException result = new OperationFailedException(String.format(this.noSecurityRealmForSsl$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void jvmVersionUnknown(String jvmVersion) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.jvmVersionUnknown$str(), (Object)jvmVersion);
    }

    protected String jvmVersionUnknown$str() {
        return jvmVersionUnknown;
    }

    protected String failedToResolveInterface$str() {
        return failedToResolveInterface;
    }

    @Override
    public final OperationFailedException failedToResolveInterface(String name) {
        OperationFailedException result = new OperationFailedException(String.format(this.failedToResolveInterface$str(), name));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String couldNotCreateDomainAutoStartDirectory$str() {
        return couldNotCreateDomainAutoStartDirectory;
    }

    @Override
    public final IllegalStateException couldNotCreateDomainAutoStartDirectory(Path file, Throwable cause) {
        IllegalStateException result = new IllegalStateException(String.format(this.couldNotCreateDomainAutoStartDirectory$str(), file), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void couldNotPersistAutoStartServerStatus(Throwable cause) {
        this.log.logf(FQCN, Logger.Level.INFO, cause, this.couldNotPersistAutoStartServerStatus$str(), new Object[0]);
    }

    protected String couldNotPersistAutoStartServerStatus$str() {
        return couldNotPersistAutoStartServerStatus;
    }

    protected String invalidDiscoveryType$str() {
        return invalidDiscoveryType;
    }

    @Override
    public final String invalidDiscoveryType(String type) {
        return String.format(this.invalidDiscoveryType$str(), type);
    }
}

