/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.discovery;

import io.undertow.util.NetworkUtils;
import java.util.List;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.host.controller.discovery.DiscoveryOption;
import org.jboss.as.host.controller.discovery.DomainControllerManagementInterface;
import org.jboss.as.host.controller.discovery.StaticDiscoveryResourceDefinition;
import org.jboss.dmr.ModelNode;

public class StaticDiscovery
implements DiscoveryOption {
    private final String remoteDcHost;
    private final int remoteDcPort;
    private final String remoteDcProtocol;

    public StaticDiscovery(String protocol, String host, int port) {
        assert (protocol != null) : "protocol is null";
        assert (host != null) : "host is null";
        this.remoteDcHost = NetworkUtils.formatPossibleIpv6Address((String)host);
        this.remoteDcPort = port;
        this.remoteDcProtocol = protocol;
    }

    @Override
    public void allowDiscovery(List<DomainControllerManagementInterface> interfaces) {
    }

    @Override
    public void discover() {
        try {
            StaticDiscoveryResourceDefinition.HOST.getValidator().validateParameter(StaticDiscoveryResourceDefinition.HOST.getName(), new ModelNode(this.remoteDcHost));
            StaticDiscoveryResourceDefinition.PORT.getValidator().validateParameter(StaticDiscoveryResourceDefinition.PORT.getName(), new ModelNode(this.remoteDcPort));
            StaticDiscoveryResourceDefinition.PROTOCOL.getValidator().validateParameter(StaticDiscoveryResourceDefinition.PROTOCOL.getName(), new ModelNode(this.remoteDcProtocol));
        }
        catch (OperationFailedException e) {
            throw new IllegalStateException(e.getFailureDescription().asString());
        }
    }

    @Override
    public void cleanUp() {
    }

    @Override
    public String getRemoteDomainControllerHost() {
        return this.remoteDcHost;
    }

    @Override
    public int getRemoteDomainControllerPort() {
        return this.remoteDcPort;
    }

    @Override
    public String getRemoteDomainControllerProtocol() {
        return this.remoteDcProtocol;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{protocol=" + this.remoteDcProtocol + ",host=" + this.remoteDcHost + ",port=" + this.remoteDcPort + '}';
    }
}

