/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.model.jvm;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.access.management.SensitiveTargetAccessConstraintDefinition;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.host.controller.descriptions.HostResolver;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

final class JVMOptionRemoveHandler
implements OperationStepHandler {
    static final String OPERATION_NAME = "remove-jvm-option";
    static final JVMOptionRemoveHandler INSTANCE = new JVMOptionRemoveHandler();
    static final SimpleAttributeDefinition JVM_OPTION = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"jvm-option", (ModelType)ModelType.STRING, (boolean)false).setValidator((ParameterValidator)new StringLengthValidator(1, false, true))).setAllowExpression(true)).build();
    public static final OperationDefinition DEFINITION = new SimpleOperationDefinitionBuilder("remove-jvm-option", HostResolver.getResolver("jvm")).addParameter((AttributeDefinition)JVM_OPTION).addAccessConstraint((AccessConstraintDefinition)SensitiveTargetAccessConstraintDefinition.JVM).build();

    JVMOptionRemoveHandler() {
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        Resource resource = context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS);
        ModelNode model = resource.getModel();
        ModelNode option = JVM_OPTION.validateOperation(operation);
        if (model.hasDefined("jvm-options")) {
            ModelNode values = model.get("jvm-options").clone();
            model.get("jvm-options").setEmptyList();
            for (ModelNode value : values.asList()) {
                if (value.equals(option)) continue;
                model.get("jvm-options").add(value);
            }
        }
        context.stepCompleted();
    }
}

