/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.operations;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.host.controller.discovery.DiscoveryOption;
import org.jboss.as.host.controller.discovery.DiscoveryOptionResourceDefinition;
import org.jboss.as.host.controller.logging.HostControllerLogger;
import org.jboss.as.host.controller.operations.AbstractDiscoveryOptionAddHandler;
import org.jboss.as.host.controller.operations.LocalHostControllerInfoImpl;
import org.jboss.dmr.ModelNode;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.msc.service.ServiceController;

public class DiscoveryOptionAddHandler
extends AbstractDiscoveryOptionAddHandler {
    private final LocalHostControllerInfoImpl hostControllerInfo;

    public DiscoveryOptionAddHandler(LocalHostControllerInfoImpl hostControllerInfo) {
        this.hostControllerInfo = hostControllerInfo;
    }

    protected boolean requiresRuntime(OperationContext context) {
        return true;
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        if (context.isBooting()) {
            this.populateHostControllerInfo(this.hostControllerInfo, context, operation, model);
        } else {
            context.reloadRequired();
        }
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
    }

    protected void populateModel(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        ModelNode model = resource.getModel();
        for (AttributeDefinition attribute : DiscoveryOptionResourceDefinition.DISCOVERY_ATTRIBUTES) {
            attribute.validateAndSet(operation, model);
        }
        this.updateDiscoveryOptionsOrdering(context, operation, "discovery-option");
    }

    protected void populateHostControllerInfo(LocalHostControllerInfoImpl hostControllerInfo, OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        ModelNode codeNode = DiscoveryOptionResourceDefinition.CODE.resolveModelAttribute(context, model);
        String discoveryOptionClassName = codeNode.isDefined() ? codeNode.asString() : null;
        ModelNode moduleNode = DiscoveryOptionResourceDefinition.MODULE.resolveModelAttribute(context, model);
        String moduleName = moduleNode.isDefined() ? moduleNode.asString() : null;
        HashMap discoveryOptionProperties = new HashMap();
        if (operation.hasDefined(DiscoveryOptionResourceDefinition.PROPERTIES.getName())) {
            for (Map.Entry discoveryOptionProperty : DiscoveryOptionResourceDefinition.PROPERTIES.unwrap(context, model).entrySet()) {
                discoveryOptionProperties.put(discoveryOptionProperty.getKey(), new ModelNode((String)discoveryOptionProperty.getValue()));
            }
        }
        try {
            ModuleIdentifier moduleID = ModuleIdentifier.fromString((String)moduleName);
            Class<DiscoveryOption> discoveryOptionClass = Module.loadClassFromCallerModuleLoader((ModuleIdentifier)moduleID, (String)discoveryOptionClassName).asSubclass(DiscoveryOption.class);
            Constructor<DiscoveryOption> constructor = discoveryOptionClass.getConstructor(Map.class);
            DiscoveryOption discoveryOption = constructor.newInstance(discoveryOptionProperties);
            hostControllerInfo.addRemoteDomainControllerDiscoveryOption(discoveryOption);
        }
        catch (Exception e) {
            throw HostControllerLogger.ROOT_LOGGER.cannotInstantiateDiscoveryOptionClass(discoveryOptionClassName, e.getLocalizedMessage());
        }
    }
}

