/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.operations;

import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.host.controller.HostControllerEnvironment;
import org.jboss.as.host.controller.operations.HttpManagementAddHandler;
import org.jboss.as.host.controller.operations.LocalHostControllerInfoImpl;
import org.jboss.as.host.controller.resources.HttpManagementResourceDefinition;
import org.jboss.as.remoting.RemotingHttpUpgradeService;
import org.jboss.as.remoting.RemotingServices;
import org.jboss.as.server.mgmt.UndertowHttpManagementService;
import org.jboss.dmr.ModelNode;

public class HttpManagementRemoveHandler
extends AbstractRemoveStepHandler {
    private final LocalHostControllerInfoImpl hostControllerInfo;
    private final HostControllerEnvironment environment;

    public HttpManagementRemoveHandler(LocalHostControllerInfoImpl hostControllerInfo, HostControllerEnvironment environment) {
        this.hostControllerInfo = hostControllerInfo;
        this.environment = environment;
    }

    protected boolean requiresRuntime(OperationContext context) {
        return true;
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        context.removeService(UndertowHttpManagementService.SERVICE_NAME);
        context.removeService(UndertowHttpManagementService.SERVICE_NAME.append(new String[]{"requests"}));
        context.removeService(UndertowHttpManagementService.SERVICE_NAME.append(new String[]{"shutdown"}));
        RemotingServices.removeConnectorServices((OperationContext)context, (String)"http-management");
        context.removeService(RemotingHttpUpgradeService.UPGRADE_SERVICE_NAME.append(new String[]{"http-management"}));
        HttpManagementRemoveHandler.clearHostControllerInfo(this.hostControllerInfo);
    }

    protected void recoverServices(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        HttpManagementAddHandler.populateHostControllerInfo(this.hostControllerInfo, context, model);
        boolean httpUpgrade = HttpManagementResourceDefinition.HTTP_UPGRADE_ENABLED.resolveModelAttribute(context, model).asBoolean();
        HttpManagementAddHandler.installHttpManagementServices(context.getRunningMode(), context.getServiceTarget(), this.hostControllerInfo, this.environment, null, false, httpUpgrade, context.getServiceRegistry(false), null);
    }

    static void clearHostControllerInfo(LocalHostControllerInfoImpl hostControllerInfo) {
        hostControllerInfo.setHttpManagementInterface(null);
        hostControllerInfo.setHttpManagementPort(0);
        hostControllerInfo.setHttpManagementSecureInterface(null);
        hostControllerInfo.setHttpManagementSecurePort(0);
        hostControllerInfo.setHttpManagementSecurityRealm(null);
    }
}

