/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller;

import java.io.File;
import java.util.AbstractList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.operations.common.NamespaceAddHandler;
import org.jboss.as.controller.operations.common.SchemaLocationAddHandler;
import org.jboss.as.controller.operations.common.SocketBindingAddHandler;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.parsing.Attribute;
import org.jboss.as.controller.resource.InterfaceDefinition;
import org.jboss.as.controller.services.path.PathAddHandler;
import org.jboss.as.domain.controller.DomainController;
import org.jboss.as.domain.controller.LocalHostControllerInfo;
import org.jboss.as.domain.management.access.SensitivityResourceDefinition;
import org.jboss.as.domain.management.audit.AuditLogLoggerResourceDefinition;
import org.jboss.as.domain.management.audit.FileAuditLogHandlerResourceDefinition;
import org.jboss.as.domain.management.audit.JsonAuditLogFormatterResourceDefinition;
import org.jboss.as.domain.management.audit.SyslogAuditLogHandlerResourceDefinition;
import org.jboss.as.host.controller.ManagedServerBootCmdFactory;
import org.jboss.as.host.controller.logging.HostControllerLogger;
import org.jboss.as.repository.ContentReference;
import org.jboss.as.repository.HostFileRepository;
import org.jboss.as.server.controller.resources.SystemPropertyResourceDefinition;
import org.jboss.as.server.deployment.ModelContentReference;
import org.jboss.as.server.services.net.BindingGroupAddHandler;
import org.jboss.as.server.services.net.LocalDestinationOutboundSocketBindingResourceDefinition;
import org.jboss.as.server.services.net.RemoteDestinationOutboundSocketBindingResourceDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;

public final class ManagedServerOperationsFactory {
    private static final ModelNode EMPTY = new ModelNode();
    private final String serverName;
    private final ModelNode domainModel;
    private final ModelNode hostModel;
    private final ModelNode serverModel;
    private final ModelNode serverGroup;
    private final String serverGroupName;
    private final String profileName;
    private final DomainController domainController;

    public static ModelNode createBootUpdates(String serverName, ModelNode domainModel, ModelNode hostModel, DomainController domainController, ExpressionResolver expressionResolver) {
        ManagedServerOperationsFactory factory = new ManagedServerOperationsFactory(serverName, domainModel, hostModel, domainController, expressionResolver);
        return factory.getBootUpdates();
    }

    ManagedServerOperationsFactory(String serverName, ModelNode domainModel, ModelNode hostModel, DomainController domainController, ExpressionResolver expressionResolver) {
        this.serverName = serverName;
        this.domainModel = domainModel;
        this.hostModel = hostModel;
        this.domainController = domainController;
        this.serverModel = ManagedServerBootCmdFactory.resolveExpressions(hostModel.require("server-config").require(serverName), expressionResolver, true);
        this.serverGroupName = this.serverModel.require("group").asString();
        this.serverGroup = ManagedServerBootCmdFactory.resolveExpressions(domainModel.require("server-group").require(this.serverGroupName), expressionResolver, true);
        this.profileName = this.serverGroup.require("profile").asString();
    }

    ModelNode getBootUpdates() {
        int portOffSet = 0;
        String socketBindingRef = null;
        String defaultInterface = null;
        if (this.serverGroup.hasDefined("socket-binding-group")) {
            socketBindingRef = this.serverGroup.get("socket-binding-group").asString();
        }
        if (this.serverModel.hasDefined("socket-binding-group")) {
            socketBindingRef = this.serverModel.get("socket-binding-group").asString();
        }
        if (this.serverGroup.hasDefined("socket-binding-port-offset")) {
            portOffSet = this.serverGroup.get("socket-binding-port-offset").asInt();
        }
        if (this.serverModel.hasDefined("socket-binding-port-offset")) {
            portOffSet = this.serverModel.get("socket-binding-port-offset").asInt();
        }
        if (this.serverGroup.hasDefined("socket-binding-default-interface")) {
            defaultInterface = this.serverGroup.get("socket-binding-default-interface").asString();
        }
        if (this.serverModel.hasDefined("socket-binding-default-interface")) {
            defaultInterface = this.serverModel.get("socket-binding-default-interface").asString();
        }
        if (socketBindingRef == null) {
            throw HostControllerLogger.ROOT_LOGGER.undefinedSocketBinding(this.serverName);
        }
        ModelNodeList updates = new ModelNodeList();
        this.setServerGroupHost(updates);
        this.addNamespaces(updates);
        this.addProfileName(updates);
        this.addSchemaLocations(updates);
        this.addExtensions(updates);
        this.addPaths(updates);
        this.addSystemProperties(updates);
        this.addVault(updates);
        this.addManagementSecurityRealms(updates);
        this.addAuditLog(updates);
        this.addManagementConnections(updates);
        this.addManagementAuthorization(updates);
        this.addInterfaces(updates);
        this.addSocketBindings((List<ModelNode>)updates, portOffSet, socketBindingRef, defaultInterface);
        this.addSubsystems(updates);
        this.addDeployments(updates);
        this.addDeploymentOverlays(updates);
        return updates.model;
    }

    private void setServerGroupHost(ModelNodeList updates) {
        ModelNode op = Util.createEmptyOperation((String)"set-server-group-host", null);
        op.get("server-group").set(this.serverGroupName);
        LocalHostControllerInfo lhci = this.domainController.getLocalHostInfo();
        op.get("host").set(lhci.getLocalHostName());
        updates.add(op);
    }

    private void addNamespaces(List<ModelNode> updates) {
        LinkedHashMap<String, ModelNode> map = new LinkedHashMap<String, ModelNode>();
        this.addNamespaces(map, this.domainModel.get("namespaces"));
        this.addNamespaces(map, this.hostModel.get("namespaces"));
        updates.addAll(map.values());
    }

    private void addNamespaces(Map<String, ModelNode> map, ModelNode namespaces) {
        if (namespaces.isDefined()) {
            for (Property prop : namespaces.asPropertyList()) {
                map.put(prop.getName(), NamespaceAddHandler.getAddNamespaceOperation((ModelNode)EMPTY, (String)prop.getName(), (String)prop.getValue().asString()));
            }
        }
    }

    private void addProfileName(List<ModelNode> updates) {
        updates.add(Util.getWriteAttributeOperation((ModelNode)EMPTY, (String)"profile-name", (String)this.profileName));
    }

    private void addSchemaLocations(List<ModelNode> updates) {
        LinkedHashMap<String, ModelNode> map = new LinkedHashMap<String, ModelNode>();
        this.addSchemaLocations(map, this.domainModel.get("schema-locations"));
        this.addSchemaLocations(map, this.hostModel.get("schema-locations"));
        updates.addAll(map.values());
    }

    private void addSchemaLocations(Map<String, ModelNode> map, ModelNode namespaces) {
        if (namespaces.isDefined()) {
            for (Property prop : namespaces.asPropertyList()) {
                map.put(prop.getName(), SchemaLocationAddHandler.getAddSchemaLocationOperation((ModelNode)EMPTY, (String)prop.getName(), (String)prop.getValue().asString()));
            }
        }
    }

    private void addExtensions(List<ModelNode> updates) {
        LinkedHashSet<String> extensionNames = new LinkedHashSet<String>();
        this.addExtensions(extensionNames, this.domainModel.get("extension"));
        this.addExtensions(extensionNames, this.hostModel.get("extension"));
        for (String name : extensionNames) {
            updates.add(Util.createAddOperation((PathAddress)PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"extension", (String)name)})));
        }
    }

    private void addExtensions(Set<String> extensionNames, ModelNode extensions) {
        if (extensions.isDefined()) {
            extensionNames.addAll(extensions.keys());
        }
    }

    private void addPaths(List<ModelNode> updates) {
        LinkedHashMap<String, ModelNode> paths = new LinkedHashMap<String, ModelNode>();
        this.addPaths(paths, this.domainModel.get("path"));
        this.addPaths(paths, this.hostModel.get("path"));
        this.addPaths(paths, this.serverModel.get("path"));
        for (Map.Entry entry : paths.entrySet()) {
            updates.add(PathAddHandler.getAddPathOperation((PathAddress)PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"path", (String)((String)entry.getKey()))}), (ModelNode)((ModelNode)entry.getValue()).get("path"), (ModelNode)((ModelNode)entry.getValue()).get("relative-to")));
        }
    }

    private void addPaths(Map<String, ModelNode> map, ModelNode path) {
        if (path.isDefined()) {
            for (Property prop : path.asPropertyList()) {
                map.put(prop.getName(), prop.getValue());
            }
        }
    }

    private void addSystemProperties(List<ModelNode> updates) {
        Map<String, String> props = this.getAllSystemProperties(false);
        for (Map.Entry<String, String> entry : props.entrySet()) {
            ModelNode address = new ModelNode();
            address.add("system-property", entry.getKey());
            ModelNode op = Util.getEmptyOperation((String)"add", (ModelNode)address);
            if (entry.getValue() != null) {
                op.get("value").set(entry.getValue());
            }
            updates.add(op);
        }
    }

    private Map<String, String> getAllSystemProperties(boolean boottimeOnly) {
        LinkedHashMap<String, String> props = new LinkedHashMap<String, String>();
        this.addSystemProperties(this.domainModel, props, boottimeOnly);
        this.addSystemProperties(this.serverGroup, props, boottimeOnly);
        this.addSystemProperties(this.hostModel, props, boottimeOnly);
        this.addSystemProperties(this.serverModel, props, boottimeOnly);
        return props;
    }

    private void addSystemProperties(ModelNode source, Map<String, String> props, boolean boottimeOnly) {
        if (source.hasDefined("system-property")) {
            for (Property prop : source.get("system-property").asPropertyList()) {
                ModelNode propResource = prop.getValue();
                try {
                    if (boottimeOnly && !SystemPropertyResourceDefinition.BOOT_TIME.resolveModelAttribute(this.domainController.getExpressionResolver(), propResource).asBoolean()) {
                        continue;
                    }
                }
                catch (OperationFailedException e) {
                    throw new IllegalStateException(e);
                }
                String val = propResource.hasDefined("value") ? propResource.get("value").asString() : null;
                props.put(prop.getName(), val);
            }
        }
    }

    private void addVault(List<ModelNode> updates) {
        if (this.hostModel.get("core-service").isDefined()) {
            this.addVault(updates, this.hostModel.get("core-service").get("vault"));
        }
    }

    private void addVault(List<ModelNode> updates, ModelNode vaultNode) {
        if (vaultNode.isDefined()) {
            ModelNode vault = new ModelNode();
            ModelNode codeNode = vaultNode.get(Attribute.CODE.getLocalName());
            if (codeNode.isDefined()) {
                vault.get(Attribute.CODE.getLocalName()).set(codeNode.asString());
            }
            ModelNode vaultAddress = new ModelNode();
            vaultAddress.add("core-service", "vault");
            this.addAddNameAndAddress(vault, vaultAddress);
            ModelNode optionsNode = vaultNode.get("vault-options");
            if (optionsNode.isDefined()) {
                vault.get("vault-options").set(optionsNode);
            }
            updates.add(vault);
        }
    }

    private void addManagementSecurityRealms(List<ModelNode> updates) {
        if (this.hostModel.get(new String[]{"core-service", "management", "security-realm"}).isDefined()) {
            ModelNode securityRealms = this.hostModel.get(new String[]{"core-service", "management", "security-realm"});
            Set keys = securityRealms.keys();
            for (String current : keys) {
                ModelNode addOp = new ModelNode();
                ModelNode realmAddress = new ModelNode();
                realmAddress.add("core-service", "management").add("security-realm", current);
                this.addAddNameAndAddress(addOp, realmAddress);
                updates.add(addOp);
                ModelNode currentRealm = securityRealms.get(current);
                if (currentRealm.hasDefined("server-identity")) {
                    this.addManagementComponentComponent(currentRealm, realmAddress, "server-identity", updates);
                }
                if (currentRealm.hasDefined("authentication")) {
                    this.addManagementComponentComponent(currentRealm, realmAddress, "authentication", updates);
                }
                if (!currentRealm.hasDefined("authorization")) continue;
                ModelNode authorization = currentRealm.require("authorization");
                if (authorization.hasDefined("properties")) {
                    this.addManagementComponentComponent(currentRealm, realmAddress, "authorization", updates);
                    continue;
                }
                if (!authorization.hasDefined("ldap")) continue;
                ModelNode ldap = authorization.require("ldap");
                ModelNode addLdap = new ModelNode();
                ModelNode ldapAddr = realmAddress.clone().add("authorization", "ldap");
                this.addAddNameAndAddress(addLdap, ldapAddr);
                addLdap.get("connection").set(ldap.get("connection"));
                updates.add(addLdap);
                if (ldap.hasDefined("username-to-dn")) {
                    ModelNode usernameToDn = ldap.require("username-to-dn");
                    if (usernameToDn.hasDefined("username-is-dn")) {
                        this.addLdapChild(usernameToDn.require("username-is-dn"), ldapAddr, "username-to-dn", "username-is-dn", updates);
                    } else if (usernameToDn.hasDefined("username-filter")) {
                        this.addLdapChild(usernameToDn.require("username-filter"), ldapAddr, "username-to-dn", "username-filter", updates);
                    } else if (usernameToDn.hasDefined("advanced-filter")) {
                        this.addLdapChild(usernameToDn.require("advanced-filter"), ldapAddr, "username-to-dn", "advanced-filter", updates);
                    }
                }
                if (!ldap.hasDefined("group-search")) continue;
                ModelNode groupSearch = ldap.require("group-search");
                if (groupSearch.hasDefined("group-to-principal")) {
                    this.addLdapChild(groupSearch.require("group-to-principal"), ldapAddr, "group-search", "group-to-principal", updates);
                    continue;
                }
                if (!groupSearch.hasDefined("principal-to-group")) continue;
                this.addLdapChild(groupSearch.require("principal-to-group"), ldapAddr, "group-search", "principal-to-group", updates);
            }
        }
    }

    private void addLdapChild(ModelNode child, ModelNode parentAddress, String key, String value, List<ModelNode> updates) {
        ModelNode add = new ModelNode();
        ManagedServerOperationsFactory.convertAttributesToParams(child, add);
        this.addAddNameAndAddress(add, parentAddress.clone().add(key, value));
        updates.add(add);
    }

    private void addManagementComponentComponent(ModelNode parent, ModelNode parentAddress, String key, List<ModelNode> updates) {
        for (String currentComponent : parent.get(key).keys()) {
            ModelNode addComponent = new ModelNode();
            addComponent.set(parent.get(new String[]{key, currentComponent}));
            ModelNode identityAddress = parentAddress.clone().add(key, currentComponent);
            this.addAddNameAndAddress(addComponent, identityAddress);
            updates.add(addComponent);
        }
    }

    private void addAuditLog(ModelNodeList updates) {
        ModelNode auditLogModel = this.hostModel.get(new String[]{"core-service", "management", "access", "audit"});
        if (auditLogModel.isDefined()) {
            PathAddress auditLogAddr = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"core-service", (String)"management"), PathElement.pathElement((String)"access", (String)"audit")});
            updates.add(Util.createAddOperation((PathAddress)auditLogAddr));
            if (auditLogModel.get("json-formatter").isDefined()) {
                for (Property formatterProp : auditLogModel.get("json-formatter").asPropertyList()) {
                    PathAddress formatterAddress = auditLogAddr.append(new PathElement[]{PathElement.pathElement((String)"json-formatter", (String)formatterProp.getName())});
                    updates.add(JsonAuditLogFormatterResourceDefinition.createServerAddOperation((PathAddress)formatterAddress, (ModelNode)formatterProp.getValue()));
                }
            }
            if (auditLogModel.get("file-handler").isDefined()) {
                for (Property fileProp : auditLogModel.get("file-handler").asPropertyList()) {
                    PathAddress fileHandlerAddress = auditLogAddr.append(new PathElement[]{PathElement.pathElement((String)"file-handler", (String)fileProp.getName())});
                    updates.add(FileAuditLogHandlerResourceDefinition.createServerAddOperation((PathAddress)fileHandlerAddress, (ModelNode)fileProp.getValue()));
                }
            }
            if (auditLogModel.get("syslog-handler").isDefined()) {
                for (Property syslogProp : auditLogModel.get("syslog-handler").asPropertyList()) {
                    PathAddress syslogHandlerAddress = auditLogAddr.append("syslog-handler", syslogProp.getName());
                    SyslogAuditLogHandlerResourceDefinition.createServerAddOperations((List)updates, (PathAddress)syslogHandlerAddress, (ModelNode)syslogProp.getValue());
                }
            }
            if (auditLogModel.get(new String[]{"server-logger", "audit-log"}).isDefined()) {
                PathAddress loggerAddress = auditLogAddr.append("logger", "audit-log");
                AuditLogLoggerResourceDefinition.createServerAddOperations((List)updates, (PathAddress)loggerAddress, (ModelNode)auditLogModel.get(new String[]{"server-logger", "audit-log"}));
            }
        }
    }

    private void addManagementConnections(List<ModelNode> updates) {
        if (this.hostModel.get(new String[]{"core-service", "management", "ldap-connection"}).isDefined()) {
            ModelNode baseAddress = new ModelNode();
            baseAddress.add("core-service", "management");
            ModelNode connections = this.hostModel.get(new String[]{"core-service", "management", "ldap-connection"});
            for (String connectionName : connections.keys()) {
                ModelNode addConnection = new ModelNode();
                addConnection.set(connections.get(connectionName));
                ModelNode identityAddress = baseAddress.clone().add("ldap-connection", connectionName);
                this.addAddNameAndAddress(addConnection, identityAddress);
                updates.add(addConnection);
            }
        }
    }

    private void addManagementAuthorization(ModelNodeList updates) {
        ModelNode domainConfig = this.domainModel.get(new String[]{"core-service", "management", "access", "authorization"});
        if (domainConfig.isDefined()) {
            ModelNode baseAddress = new ModelNode();
            baseAddress.add("core-service", "management");
            baseAddress.add("access", "authorization");
            if (domainConfig.hasDefined("provider")) {
                ModelNode providerOp = Util.getWriteAttributeOperation((ModelNode)baseAddress, (String)"provider", (ModelNode)domainConfig.get("provider"));
                updates.add(providerOp);
            }
            this.addRoleMappings(domainConfig, baseAddress, updates);
            ManagedServerOperationsFactory.convertSimpleResources(domainConfig, "server-group-scoped-role", baseAddress, updates);
            ManagedServerOperationsFactory.convertSimpleResources(domainConfig, "host-scoped-role", baseAddress, updates);
            if (domainConfig.hasDefined("constraint")) {
                ModelNode constraints = domainConfig.get("constraint");
                if (constraints.hasDefined("application-classification")) {
                    ManagedServerOperationsFactory.convertSimpleResources(constraints.get("application-classification"), "application-classification", baseAddress, updates);
                }
                if (constraints.hasDefined("sensitivity-classification")) {
                    ManagedServerOperationsFactory.convertSimpleResources(constraints.get("sensitivity-classification"), "sensitivity-classification", baseAddress, updates);
                }
                if (constraints.hasDefined("vault-expression")) {
                    ModelNode address = baseAddress.clone().add("constraint", "vault-expression");
                    ModelNode ve = constraints.get("vault-expression");
                    for (AttributeDefinition ad : SensitivityResourceDefinition.getWritableVaultAttributeDefinitions()) {
                        String attr = ad.getName();
                        if (!ve.hasDefined(attr)) continue;
                        updates.add(Util.getWriteAttributeOperation((ModelNode)address, (String)attr, (ModelNode)ve.get(attr)));
                    }
                }
            }
        }
    }

    private void addRoleMappings(ModelNode accessControl, ModelNode baseAddress, ModelNodeList updates) {
        if (accessControl.hasDefined("role-mapping")) {
            for (Property roleProp : accessControl.get("role-mapping").asPropertyList()) {
                ModelNode roleAddress = baseAddress.clone().add("role-mapping", roleProp.getName());
                updates.add(Util.getEmptyOperation((String)"add", (ModelNode)roleAddress));
                ModelNode roleMapping = roleProp.getValue();
                ManagedServerOperationsFactory.convertSimpleResources(roleMapping, "include", roleAddress, updates);
                ManagedServerOperationsFactory.convertSimpleResources(roleMapping, "exclude", roleAddress, updates);
            }
        }
    }

    private void addInterfaces(List<ModelNode> updates) {
        LinkedHashMap<String, ModelNode> interfaces = new LinkedHashMap<String, ModelNode>();
        this.addInterfaces(interfaces, this.domainModel.get("interface"));
        this.addInterfaces(interfaces, this.hostModel.get("interface"));
        this.addInterfaces(interfaces, this.hostModel.get(new String[]{"server-config", this.serverName, "interface"}));
        for (Map.Entry entry : interfaces.entrySet()) {
            updates.add(ManagedServerOperationsFactory.getAddInterfaceOperation(PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"interface", (String)((String)entry.getKey()))}), (ModelNode)entry.getValue()));
        }
    }

    private static ModelNode getAddInterfaceOperation(PathAddress address, ModelNode criteria) {
        ModelNode op = Util.createAddOperation((PathAddress)address);
        for (AttributeDefinition def : InterfaceDefinition.ROOT_ATTRIBUTES) {
            if (!criteria.hasDefined(def.getName())) continue;
            op.get(def.getName()).set(criteria.get(def.getName()));
        }
        return op;
    }

    private void addInterfaces(Map<String, ModelNode> map, ModelNode iface) {
        if (iface.isDefined()) {
            for (Property prop : iface.asPropertyList()) {
                map.put(prop.getName(), prop.getValue());
            }
        }
    }

    private void addSocketBindings(List<ModelNode> updates, int portOffSet, String bindingRef, String defaultInterface) {
        ModelNode group;
        HashSet<String> processed = new HashSet<String>();
        LinkedHashMap<String, ModelNode> groups = new LinkedHashMap<String, ModelNode>();
        if (this.domainModel.hasDefined("socket-binding-group")) {
            for (Property prop : this.domainModel.get("socket-binding-group").asPropertyList()) {
                ModelNode node = prop.getValue().clone();
                if (portOffSet > 0) {
                    node.get("port-offset").set(portOffSet);
                }
                groups.put(prop.getName(), node);
            }
        }
        if ((group = (ModelNode)groups.get(bindingRef)) == null) {
            throw HostControllerLogger.ROOT_LOGGER.undefinedSocketBindingGroup(bindingRef);
        }
        PathAddress groupAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"socket-binding-group", (String)bindingRef)});
        ModelNode groupAdd = BindingGroupAddHandler.getOperation((PathAddress)groupAddress, (ModelNode)group);
        groupAdd.get("port-offset").set(portOffSet);
        if (defaultInterface != null) {
            groupAdd.get("default-interface").set(defaultInterface);
        }
        updates.add(groupAdd);
        this.mergeBindingGroups(updates, groups, bindingRef, group, processed);
    }

    private void mergeBindingGroups(List<ModelNode> updates, Map<String, ModelNode> groups, String groupName, ModelNode group, Set<String> processed) {
        this.addSocketBindings(updates, group, groupName, group.get("default-interface"));
        if (group.has("includes") && group.get("includes").isDefined()) {
            for (ModelNode include : group.get("includes").asList()) {
                String ref = include.asString();
                if (!processed.add(ref)) continue;
                ModelNode includedGroup = groups.get(ref);
                if (includedGroup == null) {
                    throw HostControllerLogger.ROOT_LOGGER.undefinedSocketBindingGroup(ref);
                }
                this.mergeBindingGroups(updates, groups, groupName, includedGroup, processed);
            }
        }
    }

    private void addSocketBindings(List<ModelNode> updates, ModelNode group, String groupName, ModelNode defaultInterface) {
        String outboundSocketBindingName;
        ModelNode binding;
        if (group.hasDefined("socket-binding")) {
            for (Property socketBinding : group.get("socket-binding").asPropertyList()) {
                String name = socketBinding.getName();
                binding = socketBinding.getValue();
                if (!binding.isDefined()) continue;
                if (!binding.get("default-interface").isDefined()) {
                    binding.get("default-interface").set(defaultInterface);
                }
                updates.add(SocketBindingAddHandler.getOperation((PathAddress)PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"socket-binding-group", (String)groupName), PathElement.pathElement((String)"socket-binding", (String)name)}), (ModelNode)binding));
            }
        }
        if (group.hasDefined("local-destination-outbound-socket-binding")) {
            for (Property localDestinationOutboundSocketBindings : group.get("local-destination-outbound-socket-binding").asPropertyList()) {
                outboundSocketBindingName = localDestinationOutboundSocketBindings.getName();
                binding = localDestinationOutboundSocketBindings.getValue();
                if (!binding.isDefined()) continue;
                updates.add(ManagedServerOperationsFactory.getLocalSocketBindingAddOperation(PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"socket-binding-group", (String)groupName), PathElement.pathElement((String)"local-destination-outbound-socket-binding", (String)outboundSocketBindingName)}), binding));
            }
        }
        if (group.hasDefined("remote-destination-outbound-socket-binding")) {
            for (Property remoteDestinationOutboundSocketBindings : group.get("remote-destination-outbound-socket-binding").asPropertyList()) {
                outboundSocketBindingName = remoteDestinationOutboundSocketBindings.getName();
                binding = remoteDestinationOutboundSocketBindings.getValue();
                if (!binding.isDefined()) continue;
                updates.add(ManagedServerOperationsFactory.getRemoteSocketBindingAddOperation(PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"socket-binding-group", (String)groupName), PathElement.pathElement((String)"remote-destination-outbound-socket-binding", (String)outboundSocketBindingName)}), binding));
            }
        }
    }

    public static ModelNode getLocalSocketBindingAddOperation(PathAddress address, ModelNode localDestinationOutboundSocketBinding) {
        ModelNode addOperation = Util.createAddOperation((PathAddress)address);
        for (SimpleAttributeDefinition ad : LocalDestinationOutboundSocketBindingResourceDefinition.ATTRIBUTES) {
            if (!localDestinationOutboundSocketBinding.get(ad.getName()).isDefined()) continue;
            addOperation.get(ad.getName()).set(localDestinationOutboundSocketBinding.get(ad.getName()));
        }
        return addOperation;
    }

    public static ModelNode getRemoteSocketBindingAddOperation(PathAddress address, ModelNode remoteDestinationOutboundSocketBinding) {
        ModelNode addOperation = Util.createAddOperation((PathAddress)address);
        for (SimpleAttributeDefinition ad : RemoteDestinationOutboundSocketBindingResourceDefinition.ATTRIBUTES) {
            if (!remoteDestinationOutboundSocketBinding.get(ad.getName()).isDefined()) continue;
            addOperation.get(ad.getName()).set(remoteDestinationOutboundSocketBinding.get(ad.getName()));
        }
        return addOperation;
    }

    private void addSubsystems(List<ModelNode> updates) {
        ModelNode node = this.domainController.getProfileOperations(this.profileName);
        updates.addAll(node.asList());
    }

    private void addDeployments(List<ModelNode> updates) {
        if (this.serverGroup.hasDefined("deployment")) {
            HostFileRepository remoteRepository = null;
            if (!this.domainController.getLocalHostInfo().isMasterDomainController()) {
                remoteRepository = this.domainController.getRemoteFileRepository();
            }
            for (Property deployment : this.serverGroup.get("deployment").asPropertyList()) {
                String name = deployment.getName();
                ModelNode details = deployment.getValue();
                ModelNode domainDeployment = this.domainModel.require("deployment").require(name);
                ModelNode deploymentContent = domainDeployment.require("content").clone();
                PathAddress addr = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"deployment", (String)name)});
                if (remoteRepository != null) {
                    for (ModelNode content : deploymentContent.asList()) {
                        if (!content.hasDefined("hash")) continue;
                        byte[] hash = content.require("hash").asBytes();
                        ContentReference reference = ModelContentReference.fromModelAddress((PathAddress)addr, (byte[])hash);
                        File[] files = this.domainController.getLocalFileRepository().getDeploymentFiles(reference);
                        if (files != null && files.length != 0) continue;
                        remoteRepository.getDeploymentFiles(reference);
                    }
                }
                ModelNode addOp = Util.getEmptyOperation((String)"add", (ModelNode)addr.toModelNode());
                addOp.get("runtime-name").set(details.get("runtime-name"));
                addOp.get("content").set(deploymentContent);
                if (!details.hasDefined("enabled")) {
                    addOp.get("enabled").set(true);
                } else {
                    addOp.get("enabled").set(details.get("enabled"));
                }
                updates.add(addOp);
            }
        }
    }

    public void addDeploymentOverlays(List<ModelNode> updates) {
        if (this.domainModel.hasDefined("deployment-overlay")) {
            HostFileRepository remoteRepository = null;
            if (!this.domainController.getLocalHostInfo().isMasterDomainController()) {
                remoteRepository = this.domainController.getRemoteFileRepository();
            }
            for (Property deploymentOverlay : this.domainModel.get("deployment-overlay").asPropertyList()) {
                ModelNode deploymentsNode;
                ModelNode groupOverlay;
                String name = deploymentOverlay.getName();
                ModelNode details = deploymentOverlay.getValue();
                PathAddress addr = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"deployment-overlay", (String)name)});
                ModelNode addOp = Util.getEmptyOperation((String)"add", (ModelNode)addr.toModelNode());
                updates.add(addOp);
                if (details.hasDefined("content")) {
                    for (Property content : details.get("content").asPropertyList()) {
                        String contentName = content.getName();
                        ModelNode contentDetails = content.getValue();
                        byte[] hash = contentDetails.require("content").asBytes();
                        ContentReference reference = ModelContentReference.fromModelAddress((PathAddress)addr, (byte[])hash);
                        File[] files = this.domainController.getLocalFileRepository().getDeploymentFiles(reference);
                        if ((files == null || files.length == 0) && remoteRepository != null) {
                            remoteRepository.getDeploymentFiles(reference);
                        }
                        addr = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"deployment-overlay", (String)name), PathElement.pathElement((String)"content", (String)contentName)});
                        addOp = Util.getEmptyOperation((String)"add", (ModelNode)addr.toModelNode());
                        addOp.get("content").get("hash").set(contentDetails.get("content"));
                        updates.add(addOp);
                    }
                }
                if (!this.serverGroup.hasDefined("deployment-overlay") || !(groupOverlay = this.serverGroup.get("deployment-overlay").asObject()).has(name) || !(deploymentsNode = groupOverlay.get(name)).has("deployment")) continue;
                for (Property content : deploymentsNode.get("deployment").asPropertyList()) {
                    String deploymentName = content.getName();
                    addr = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"deployment-overlay", (String)name), PathElement.pathElement((String)"deployment", (String)deploymentName)});
                    addOp = Util.getEmptyOperation((String)"add", (ModelNode)addr.toModelNode());
                    updates.add(addOp);
                }
            }
        }
    }

    private ModelNode addAddNameAndAddress(ModelNode op, PathAddress address) {
        return this.addAddNameAndAddress(op, address.toModelNode());
    }

    private ModelNode addAddNameAndAddress(ModelNode op, ModelNode address) {
        op.get("operation").set("add");
        op.get("address").set(address);
        return op;
    }

    private static void convertSimpleResources(ModelNode model, String type, ModelNode baseAddress, ModelNodeList updates) {
        if (model.hasDefined(type)) {
            for (Property prop : model.get(type).asPropertyList()) {
                ModelNode address = baseAddress.clone().add(type, prop.getName());
                ModelNode addOp = Util.getEmptyOperation((String)"add", (ModelNode)address);
                ManagedServerOperationsFactory.convertAttributesToParams(prop.getValue(), addOp);
                updates.add(addOp);
            }
        }
    }

    private static void convertAttributesToParams(ModelNode value, ModelNode addOp) {
        if (value.isDefined()) {
            for (Property prop : value.asPropertyList()) {
                ModelNode attrVal = prop.getValue();
                if (!attrVal.isDefined()) continue;
                addOp.get(prop.getName()).set(attrVal);
            }
        }
    }

    static {
        EMPTY.setEmptyList();
        EMPTY.protect();
    }

    private class ModelNodeList
    extends AbstractList<ModelNode>
    implements List<ModelNode> {
        private final ModelNode model = new ModelNode().setEmptyList();

        private ModelNodeList() {
        }

        @Override
        public boolean add(ModelNode modelNode) {
            this.model.add(modelNode);
            return true;
        }

        @Override
        public ModelNode get(int index) {
            return this.model.get(index);
        }

        @Override
        public int size() {
            return this.model.asInt();
        }
    }
}

