/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.operations.deployment;

import java.io.IOException;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.HashUtil;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.RunningMode;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.domain.controller.logging.DomainControllerLogger;
import org.jboss.as.domain.controller.operations.deployment.DeploymentUploadUtil;
import org.jboss.as.repository.ContentRepository;
import org.jboss.as.repository.HostFileRepository;
import org.jboss.as.server.controller.resources.DeploymentAttributes;
import org.jboss.as.server.deployment.DeploymentHandlerUtils;
import org.jboss.as.server.deployment.ModelContentReference;
import org.jboss.dmr.ModelNode;

public class DeploymentAddHandler
implements OperationStepHandler {
    public static final String OPERATION_NAME = "add";
    private final ContentRepository contentRepository;
    private final HostFileRepository fileRepository;

    public DeploymentAddHandler(HostFileRepository fileRepository) {
        this.contentRepository = null;
        this.fileRepository = fileRepository;
    }

    public DeploymentAddHandler(ContentRepository contentRepository) {
        this.contentRepository = contentRepository;
        this.fileRepository = null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        Resource resource = context.createResource(PathAddress.EMPTY_ADDRESS);
        ModelNode newModel = resource.getModel();
        ModelNode correctedOperation = operation.clone();
        for (AttributeDefinition def : DeploymentAttributes.DOMAIN_ADD_ATTRIBUTES) {
            def.validateAndSet(correctedOperation, newModel);
            correctedOperation.get(def.getName()).set(newModel.get(def.getName()));
        }
        ModelNode content = newModel.require(DeploymentAttributes.CONTENT_ALL.getName());
        ModelNode contentItemNode = content.require(0);
        ModelNode opAddr = correctedOperation.get("address");
        final PathAddress address = PathAddress.pathAddress((ModelNode)opAddr);
        String name = address.getLastElement().getValue();
        if (!newModel.hasDefined(DeploymentAttributes.RUNTIME_NAME.getName())) {
            newModel.get(DeploymentAttributes.RUNTIME_NAME.getName()).set(name);
        }
        byte[] hash = null;
        if (contentItemNode.hasDefined(DeploymentAttributes.CONTENT_HASH.getName())) {
            hash = contentItemNode.require(DeploymentAttributes.CONTENT_HASH.getName()).asBytes();
            if (this.contentRepository != null && !this.contentRepository.hasContent(hash)) {
                if (!context.isBooting()) throw DeploymentAddHandler.createFailureException(DomainControllerLogger.ROOT_LOGGER.noDeploymentContentWithHash(HashUtil.bytesToHexString((byte[])hash)));
                if (context.getRunningMode() != RunningMode.ADMIN_ONLY) throw DeploymentAddHandler.createFailureException(DomainControllerLogger.ROOT_LOGGER.noDeploymentContentWithHashAtBoot(HashUtil.bytesToHexString((byte[])hash), name));
                DomainControllerLogger.HOST_CONTROLLER_LOGGER.reportAdminOnlyMissingDeploymentContent(HashUtil.bytesToHexString((byte[])hash), name);
            } else if (this.fileRepository != null) {
                this.fileRepository.getDeploymentFiles(ModelContentReference.fromModelAddress((PathAddress)address, (byte[])hash));
            }
        } else if (DeploymentHandlerUtils.hasValidContentAdditionParameterDefined((ModelNode)contentItemNode)) {
            if (this.contentRepository == null) {
                throw DeploymentAddHandler.createFailureException(DomainControllerLogger.ROOT_LOGGER.slaveCannotAcceptUploads());
            }
            try {
                hash = DeploymentUploadUtil.storeContentAndTransformOperation(context, correctedOperation, this.contentRepository);
            }
            catch (IOException e) {
                throw DeploymentAddHandler.createFailureException(e.toString());
            }
            contentItemNode = new ModelNode();
            contentItemNode.get(DeploymentAttributes.CONTENT_HASH.getName()).set(hash);
            content = new ModelNode();
            content.add(contentItemNode);
            newModel.get(DeploymentAttributes.CONTENT_ALL.getName()).set(content);
        }
        if (this.contentRepository != null && hash != null) {
            final byte[] contentHash = hash;
            context.completeStep(new OperationContext.ResultHandler(){

                public void handleResult(OperationContext.ResultAction resultAction, OperationContext context, ModelNode operation) {
                    if (resultAction == OperationContext.ResultAction.KEEP) {
                        DeploymentAddHandler.this.contentRepository.addContentReference(ModelContentReference.fromModelAddress((PathAddress)address, (byte[])contentHash));
                    }
                }
            });
            return;
        } else {
            context.stepCompleted();
        }
    }

    private static OperationFailedException createFailureException(String msg) {
        return new OperationFailedException(msg);
    }
}

