/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.operations;

import java.util.Collections;
import java.util.List;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.ReloadRequiredWriteAttributeHandler;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.host.controller.discovery.DiscoveryOptionsResourceDefinition;
import org.jboss.as.host.controller.logging.HostControllerLogger;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;

public class DiscoveryOptionsWriteAttributeHandler
extends ReloadRequiredWriteAttributeHandler {
    public DiscoveryOptionsWriteAttributeHandler() {
        super(new AttributeDefinition[]{DiscoveryOptionsResourceDefinition.DISCOVERY_OPTIONS});
    }

    protected void finishModelStage(OperationContext context, ModelNode operation, String attributeName, ModelNode newValue, ModelNode oldValue, Resource resource) throws OperationFailedException {
        List unorderedDiscoveryOptionsList;
        ModelNode model = Resource.Tools.readModel((Resource)resource);
        ModelNode unorderedDiscoveryOptions = new ModelNode();
        if (model.hasDefined("discovery-option")) {
            ModelNode discoveryOptions = model.get("discovery-option");
            for (Property prop : discoveryOptions.asPropertyList()) {
                unorderedDiscoveryOptions.add("discovery-option", prop.getName());
            }
        }
        if (model.hasDefined("static-discovery")) {
            ModelNode staticDiscoveryOptions = model.get("static-discovery");
            for (Property prop : staticDiscoveryOptions.asPropertyList()) {
                unorderedDiscoveryOptions.add("static-discovery", prop.getName());
            }
        }
        List newValueList = newValue.isDefined() ? newValue.asList() : Collections.emptyList();
        List list = unorderedDiscoveryOptionsList = unorderedDiscoveryOptions.isDefined() ? unorderedDiscoveryOptions.asList() : Collections.emptyList();
        if (newValueList.size() != unorderedDiscoveryOptionsList.size() || !newValueList.containsAll(unorderedDiscoveryOptionsList)) {
            throw HostControllerLogger.ROOT_LOGGER.invalidDiscoveryOptionsOrdering("discovery-options");
        }
    }

    protected boolean requiresRuntime(OperationContext context) {
        return !context.isBooting();
    }
}

