/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.domain.controller.resources.ServerGroupResourceDefinition;
import org.jboss.as.host.controller.DirectoryGrouping;
import org.jboss.as.host.controller.HostControllerEnvironment;
import org.jboss.as.host.controller.ManagedServer;
import org.jboss.as.host.controller.ManagedServerBootConfiguration;
import org.jboss.as.host.controller.logging.HostControllerLogger;
import org.jboss.as.host.controller.model.host.HostResourceDefinition;
import org.jboss.as.host.controller.model.jvm.JvmElement;
import org.jboss.as.host.controller.model.jvm.JvmOptionsBuilderFactory;
import org.jboss.as.process.DefaultJvmUtils;
import org.jboss.as.server.controller.resources.SystemPropertyResourceDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.wildfly.security.manager.WildFlySecurityManager;

public class ManagedServerBootCmdFactory
implements ManagedServerBootConfiguration {
    private static final String HOST_CONTROLLER_PROCESS_NAME_PROP = "[Host Controller]";
    private static final ModelNode EMPTY = new ModelNode();
    private final String serverName;
    private final ModelNode domainModel;
    private final ModelNode hostModel;
    private final ModelNode serverModel;
    private final ModelNode serverGroup;
    private final JvmElement jvmElement;
    private final HostControllerEnvironment environment;
    private final boolean managementSubsystemEndpoint;
    private final ModelNode endpointConfig = new ModelNode();
    private final ExpressionResolver expressionResolver;
    private final DirectoryGrouping directoryGrouping;

    public ManagedServerBootCmdFactory(String serverName, ModelNode domainModel, ModelNode hostModel, HostControllerEnvironment environment, ExpressionResolver expressionResolver) {
        String profileName;
        ModelNode profile;
        Iterator i$;
        Iterator i$2;
        this.serverName = serverName;
        this.domainModel = domainModel;
        this.hostModel = hostModel;
        this.environment = environment;
        this.expressionResolver = expressionResolver;
        this.serverModel = this.resolveExpressions(hostModel.require("server-config").require(serverName));
        this.directoryGrouping = ManagedServerBootCmdFactory.resolveDirectoryGrouping(hostModel, expressionResolver);
        String serverGroupName = this.serverModel.require("group").asString();
        this.serverGroup = this.resolveExpressions(domainModel.require("server-group").require(serverGroupName));
        String serverVMName = null;
        ModelNode serverVM = null;
        if (this.serverModel.hasDefined("jvm") && (i$2 = this.serverModel.get("jvm").keys().iterator()).hasNext()) {
            String jvm;
            serverVMName = jvm = (String)i$2.next();
            serverVM = this.serverModel.get(new String[]{"jvm", jvm});
        }
        String groupVMName = null;
        ModelNode groupVM = null;
        if (this.serverGroup.hasDefined("jvm") && (i$ = this.serverGroup.get("jvm").keys().iterator()).hasNext()) {
            String jvm;
            groupVMName = jvm = (String)i$.next();
            groupVM = this.serverGroup.get(new String[]{"jvm", jvm});
        }
        this.managementSubsystemEndpoint = this.serverGroup.get(ServerGroupResourceDefinition.MANAGEMENT_SUBSYSTEM_ENDPOINT.getName()).asBoolean(false);
        if (this.managementSubsystemEndpoint && (profile = domainModel.get(new String[]{"profile", profileName = this.serverGroup.get("profile").asString()})).hasDefined("subsystem") && profile.hasDefined("remoting")) {
            this.endpointConfig.set(profile.get(new String[]{"subsystem", "remoting"}));
        }
        String jvmName = serverVMName != null ? serverVMName : groupVMName;
        ModelNode hostVM = jvmName != null ? hostModel.get(new String[]{"jvm", jvmName}) : null;
        this.jvmElement = new JvmElement(jvmName, this.resolveExpressions(hostVM), this.resolveExpressions(groupVM), this.resolveExpressions(serverVM));
    }

    private ModelNode resolveExpressions(ModelNode unresolved) {
        if (unresolved == null) {
            return null;
        }
        try {
            return this.expressionResolver.resolveExpressions(unresolved.clone());
        }
        catch (OperationFailedException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    private static DirectoryGrouping resolveDirectoryGrouping(ModelNode model, ExpressionResolver expressionResolver) {
        try {
            return DirectoryGrouping.forName(HostResourceDefinition.DIRECTORY_GROUPING.resolveModelAttribute(expressionResolver, model).asString());
        }
        catch (OperationFailedException e) {
            throw new IllegalStateException(e);
        }
    }

    public ManagedServerBootConfiguration createConfiguration() {
        return this;
    }

    @Override
    public HostControllerEnvironment getHostControllerEnvironment() {
        return this.environment;
    }

    @Override
    public List<String> getServerLaunchCommand() {
        String path;
        ArrayList<String> commandPrefix;
        ArrayList<String> command = new ArrayList<String>();
        if (this.jvmElement.getLaunchCommand() != null && (commandPrefix = this.getLaunchPrefixCommands()) != null) {
            command.addAll(commandPrefix);
        }
        command.add(this.getJavaCommand());
        command.add("-D[" + ManagedServer.getServerProcessName(this.serverName) + "]");
        JvmOptionsBuilderFactory.getInstance().addOptions(this.jvmElement, command);
        Map<String, String> bootTimeProperties = this.getAllSystemProperties(true);
        for (Map.Entry<String, String> hostProp : this.environment.getHostSystemProperties().entrySet()) {
            if (bootTimeProperties.containsKey(hostProp.getKey())) continue;
            bootTimeProperties.put(hostProp.getKey(), hostProp.getValue());
        }
        for (Map.Entry<String, String> entry : bootTimeProperties.entrySet()) {
            String property = entry.getKey();
            String value = entry.getValue();
            if ("org.jboss.boot.log.file".equals(property) || "logging.configuration".equals(property) || HOST_CONTROLLER_PROCESS_NAME_PROP.equals(property)) continue;
            StringBuilder sb = new StringBuilder("-D");
            sb.append(property);
            if (value != null) {
                sb.append('=');
                sb.append(value);
            }
            command.add(sb.toString());
        }
        String serverDirProp = bootTimeProperties.get("jboss.server.base.dir");
        File serverDir = serverDirProp == null ? new File(this.environment.getDomainServersDir(), this.serverName) : new File(serverDirProp);
        String logDir = this.addPathProperty(command, "log", "jboss.server.log.dir", bootTimeProperties, this.directoryGrouping, this.environment.getDomainLogDir(), serverDir);
        this.addPathProperty(command, "tmp", "jboss.server.temp.dir", bootTimeProperties, this.directoryGrouping, this.environment.getDomainTempDir(), serverDir);
        String dataDir = this.addPathProperty(command, "data", "jboss.server.data.dir", bootTimeProperties, this.directoryGrouping, this.environment.getDomainDataDir(), serverDir);
        File loggingConfig = new File(dataDir, "logging.properties");
        if (loggingConfig.exists()) {
            path = "file:" + loggingConfig.getAbsolutePath();
        } else {
            command.add("-Dorg.jboss.boot.log.file=" + ManagedServerBootCmdFactory.getAbsolutePath(new File(logDir), "server.log"));
            String domainConfigFile = "file:" + ManagedServerBootCmdFactory.getAbsolutePath(this.environment.getDomainConfigurationDir(), "logging.properties");
            String systemPropConfigFile = WildFlySecurityManager.getPropertyPrivileged((String)"logging.configuration", null);
            File defaultConfigFile = ManagedServerBootCmdFactory.getAbsoluteFile(this.environment.getDomainConfigurationDir(), "default-server-logging.properties");
            path = domainConfigFile.equals(systemPropConfigFile) && defaultConfigFile.exists() ? "file:" + defaultConfigFile.getAbsolutePath() : (systemPropConfigFile != null ? systemPropConfigFile : domainConfigFile);
        }
        command.add(String.format("-Dlogging.configuration=%s", path));
        command.add("-jar");
        command.add(ManagedServerBootCmdFactory.getAbsolutePath(this.environment.getHomeDir(), "jboss-modules.jar"));
        command.add("-mp");
        command.add(this.environment.getModulePath());
        if (this.environment.isSecurityManagerEnabled()) {
            command.add("-secmgr");
        }
        command.add("org.jboss.as.server");
        return command;
    }

    @Override
    public boolean isManagementSubsystemEndpoint() {
        return this.managementSubsystemEndpoint;
    }

    @Override
    public ModelNode getSubsystemEndpointConfiguration() {
        return this.endpointConfig;
    }

    private String getJavaCommand() {
        String javaHome = this.jvmElement.getJavaHome();
        if (javaHome == null) {
            String defaultJvm;
            if (this.environment.getDefaultJVM() != null && (!(defaultJvm = this.environment.getDefaultJVM().getAbsolutePath()).equals("java") || defaultJvm.equals("java") && System.getenv("JAVA_HOME") != null)) {
                return defaultJvm;
            }
            javaHome = DefaultJvmUtils.getCurrentJvmHome();
        }
        return DefaultJvmUtils.findJavaExecutable((String)javaHome);
    }

    private ArrayList<String> getLaunchPrefixCommands() {
        String launchCommand = this.jvmElement.getLaunchCommand();
        ArrayList<String> commands = null;
        if (launchCommand.length() > 0) {
            commands = new ArrayList<String>(Arrays.asList(launchCommand.split("\\s* \\s*")));
        }
        HostControllerLogger.ROOT_LOGGER.serverLaunchCommandPrefix(this.serverName, launchCommand);
        return commands;
    }

    @Override
    public Map<String, String> getServerLaunchEnvironment() {
        HashMap<String, String> env = new HashMap<String, String>();
        for (Map.Entry<String, String> property : this.jvmElement.getEnvironmentVariables().entrySet()) {
            env.put(property.getKey(), property.getValue());
        }
        return env;
    }

    private Map<String, String> getAllSystemProperties(boolean boottimeOnly) {
        TreeMap<String, String> props = new TreeMap<String, String>();
        this.addSystemProperties(this.domainModel, props, boottimeOnly);
        this.addSystemProperties(this.serverGroup, props, boottimeOnly);
        this.addSystemProperties(this.hostModel, props, boottimeOnly);
        this.addSystemProperties(this.serverModel, props, boottimeOnly);
        return props;
    }

    private void addSystemProperties(ModelNode source, Map<String, String> props, boolean boottimeOnly) {
        if (source.hasDefined("system-property")) {
            for (Property prop : source.get("system-property").asPropertyList()) {
                ModelNode propResource = prop.getValue();
                try {
                    if (boottimeOnly && !SystemPropertyResourceDefinition.BOOT_TIME.resolveModelAttribute(this.expressionResolver, propResource).asBoolean()) {
                        continue;
                    }
                }
                catch (OperationFailedException e) {
                    throw new IllegalStateException(e);
                }
                String val = propResource.hasDefined("value") ? propResource.get("value").asString() : null;
                props.put(prop.getName(), val);
            }
        }
    }

    private String addPathProperty(List<String> command, String typeName, String propertyName, Map<String, String> properties, DirectoryGrouping directoryGrouping, File typeDir, File serverDir) {
        String result;
        String value = properties.get(propertyName);
        if (value == null) {
            switch (directoryGrouping) {
                case BY_TYPE: {
                    result = ManagedServerBootCmdFactory.getAbsolutePath(typeDir, "servers", this.serverName);
                    break;
                }
                default: {
                    result = ManagedServerBootCmdFactory.getAbsolutePath(serverDir, typeName);
                }
            }
            properties.put(propertyName, result);
        } else {
            File dir = new File(value);
            switch (directoryGrouping) {
                case BY_TYPE: {
                    result = ManagedServerBootCmdFactory.getAbsolutePath(dir, "servers", this.serverName);
                    break;
                }
                default: {
                    result = dir.getAbsolutePath();
                }
            }
        }
        command.add(String.format("-D%s=%s", propertyName, result));
        return result;
    }

    static String getAbsolutePath(File root, String ... paths) {
        return ManagedServerBootCmdFactory.getAbsoluteFile(root, paths).getAbsolutePath();
    }

    static File getAbsoluteFile(File root, String ... paths) {
        File path = root;
        for (String segment : paths) {
            path = new File(path, segment);
        }
        return path.getAbsoluteFile();
    }

    static {
        EMPTY.setEmptyList();
        EMPTY.protect();
    }
}

