/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.operations;

import java.util.HashMap;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.host.controller.discovery.StaticDiscovery;
import org.jboss.as.host.controller.discovery.StaticDiscoveryResourceDefinition;
import org.jboss.as.host.controller.operations.AbstractDiscoveryOptionAddHandler;
import org.jboss.as.host.controller.operations.LocalHostControllerInfoImpl;
import org.jboss.dmr.ModelNode;

public class StaticDiscoveryAddHandler
extends AbstractDiscoveryOptionAddHandler {
    private final LocalHostControllerInfoImpl hostControllerInfo;

    public StaticDiscoveryAddHandler(LocalHostControllerInfoImpl hostControllerInfo) {
        this.hostControllerInfo = hostControllerInfo;
    }

    protected boolean requiresRuntime(OperationContext context) {
        return true;
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        if (context.isBooting()) {
            this.populateHostControllerInfo(this.hostControllerInfo, context, model);
        } else {
            context.reloadRequired();
        }
    }

    protected void populateModel(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        ModelNode model = resource.getModel();
        for (SimpleAttributeDefinition attribute : StaticDiscoveryResourceDefinition.STATIC_DISCOVERY_ATTRIBUTES) {
            attribute.validateAndSet(operation, model);
        }
        StaticDiscoveryAddHandler.updateDiscoveryOptionsOrdering(context, operation, "static-discovery");
    }

    protected void populateHostControllerInfo(LocalHostControllerInfoImpl hostControllerInfo, OperationContext context, ModelNode model) throws OperationFailedException {
        ModelNode hostNode = StaticDiscoveryResourceDefinition.HOST.resolveModelAttribute(context, model);
        ModelNode portNode = StaticDiscoveryResourceDefinition.PORT.resolveModelAttribute(context, model);
        HashMap<String, ModelNode> properties = new HashMap<String, ModelNode>();
        properties.put("host", hostNode);
        properties.put("port", portNode);
        StaticDiscovery staticDiscoveryOption = new StaticDiscovery(properties);
        hostControllerInfo.addRemoteDomainControllerDiscoveryOption(staticDiscoveryOption);
    }
}

