/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller;

import java.io.IOException;
import org.jboss.as.controller.client.OperationAttachments;
import org.jboss.as.controller.client.OperationMessageHandler;
import org.jboss.as.controller.remote.TransactionalProtocolClient;
import org.jboss.as.controller.remote.TransactionalProtocolHandlers;
import org.jboss.as.host.controller.ManagedServer;
import org.jboss.as.protocol.logging.ProtocolLogger;
import org.jboss.dmr.ModelNode;
import org.jboss.threads.AsyncFuture;

class ManagedServerProxy
implements TransactionalProtocolClient {
    private static final TransactionalProtocolClient DISCONNECTED = new DisconnectedProtocolClient();
    private final ManagedServer server;
    private volatile TransactionalProtocolClient remoteClient;

    ManagedServerProxy(ManagedServer server) {
        this.server = server;
        this.remoteClient = DISCONNECTED;
    }

    synchronized void connected(TransactionalProtocolClient remoteClient) {
        this.remoteClient = remoteClient;
    }

    synchronized boolean disconnected(TransactionalProtocolClient old) {
        if (this.remoteClient == old) {
            this.remoteClient = DISCONNECTED;
            return true;
        }
        return false;
    }

    public AsyncFuture<ModelNode> execute(TransactionalProtocolClient.TransactionalOperationListener<TransactionalProtocolClient.Operation> listener, ModelNode operation, OperationMessageHandler messageHandler, OperationAttachments attachments) throws IOException {
        return this.execute(listener, TransactionalProtocolHandlers.wrap((ModelNode)operation, (OperationMessageHandler)messageHandler, (OperationAttachments)attachments));
    }

    public <T extends TransactionalProtocolClient.Operation> AsyncFuture<ModelNode> execute(TransactionalProtocolClient.TransactionalOperationListener<T> listener, T operation) throws IOException {
        String operationName;
        TransactionalProtocolClient remoteClient = this.remoteClient;
        ModelNode op = operation.getOperation();
        if (remoteClient == DISCONNECTED && "server-set-restart-required".equals(operationName = op.get("operation").asString())) {
            this.server.requireReload();
        }
        return remoteClient.execute(listener, operation);
    }

    static final class DisconnectedProtocolClient
    implements TransactionalProtocolClient {
        DisconnectedProtocolClient() {
        }

        public AsyncFuture<ModelNode> execute(TransactionalProtocolClient.TransactionalOperationListener<TransactionalProtocolClient.Operation> listener, ModelNode operation, OperationMessageHandler messageHandler, OperationAttachments attachments) throws IOException {
            return this.execute(listener, TransactionalProtocolHandlers.wrap((ModelNode)operation, (OperationMessageHandler)messageHandler, (OperationAttachments)attachments));
        }

        public <T extends TransactionalProtocolClient.Operation> AsyncFuture<ModelNode> execute(TransactionalProtocolClient.TransactionalOperationListener<T> listener, T operation) throws IOException {
            throw ProtocolLogger.ROOT_LOGGER.channelClosed();
        }
    }
}

