/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.operations.deployment;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.domain.controller.logging.DomainControllerLogger;
import org.jboss.as.domain.controller.operations.deployment.AbstractDeploymentUploadHandler;
import org.jboss.as.repository.ContentRepository;
import org.jboss.as.server.controller.resources.DeploymentAttributes;
import org.jboss.dmr.ModelNode;

public class DeploymentUploadURLHandler
extends AbstractDeploymentUploadHandler {
    public static final String OPERATION_NAME = "upload-deployment-url";

    private DeploymentUploadURLHandler(ContentRepository repository) {
        super(repository, DeploymentAttributes.URL_NOT_NULL);
    }

    public static void registerMaster(ManagementResourceRegistration registration, ContentRepository repository) {
        new DeploymentUploadURLHandler(repository).register(registration);
    }

    public static void registerSlave(ManagementResourceRegistration registration) {
        new DeploymentUploadURLHandler(null).register(registration);
    }

    private void register(ManagementResourceRegistration registration) {
        registration.registerOperationHandler(DeploymentAttributes.DOMAIN_UPLOAD_URL_DEFINITION, (OperationStepHandler)this);
    }

    @Override
    protected InputStream getContentInputStream(OperationContext operationContext, ModelNode operation) throws OperationFailedException {
        String urlSpec = operation.get("url").asString();
        try {
            URL url = new URL(urlSpec);
            return url.openStream();
        }
        catch (MalformedURLException e) {
            throw new OperationFailedException(new ModelNode().set(DomainControllerLogger.ROOT_LOGGER.invalidUrl(urlSpec, e.toString())));
        }
        catch (IOException e) {
            throw new OperationFailedException(new ModelNode().set(DomainControllerLogger.ROOT_LOGGER.errorObtainingUrlStream(urlSpec, e.toString())));
        }
    }
}

