/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.core.embedded;

import java.security.AccessController;
import java.security.PrivilegedAction;

final class SecurityActions {
    SecurityActions() {
    }

    static String getPropertyPrivileged(final String name, final String def) {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return System.getProperty(name, def);
        }
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(name, def);
            }
        });
    }

    static void setPropertyPrivileged(final String name, final String value) {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            System.setProperty(name, value);
        } else {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    System.setProperty(name, value);
                    return null;
                }
            });
        }
    }
}

