/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.core.embedded;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import java.util.Properties;
import java.util.logging.LogManager;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.log.JDKModuleLogger;
import org.jboss.modules.log.ModuleLogger;
import org.wildfly.core.embedded.EmbeddedManagedProcessImpl;
import org.wildfly.core.embedded.HostController;
import org.wildfly.core.embedded.SecurityActions;
import org.wildfly.core.embedded.StandaloneServer;
import org.wildfly.core.embedded.logging.EmbeddedLogger;

public class EmbeddedProcessFactory {
    private static final String MODULE_ID_EMBEDDED = "org.wildfly.embedded";
    private static final String MODULE_ID_LOGMANAGER = "org.jboss.logmanager";
    private static final String MODULE_ID_VFS = "org.jboss.vfs";
    private static final String SYSPROP_KEY_CLASS_PATH = "java.class.path";
    private static final String SYSPROP_KEY_MODULE_PATH = "module.path";
    private static final String SYSPROP_KEY_LOGMANAGER = "java.util.logging.manager";
    private static final String SYSPROP_KEY_JBOSS_HOME_DIR = "jboss.home.dir";
    private static final String SYSPROP_KEY_JBOSS_PREV_HOME_DIR = "jboss.prev.home.dir";
    private static final String SYSPROP_KEY_JBOSS_MODULES_DIR = "jboss.modules.dir";
    private static final String SYSPROP_VALUE_JBOSS_LOGMANAGER = "org.jboss.logmanager.LogManager";
    private static final String SYSPROP_KEY_JBOSS_SERVER_BASE_DIR = "jboss.server.base.dir";
    private static final String SYSPROP_KEY_JBOSS_SERVER_CONFIG_DIR = "jboss.server.config.dir";
    private static final String SYSPROP_KEY_JBOSS_SERVER_DEPLOY_DIR = "jboss.server.deploy.dir";
    private static final String SYSPROP_KEY_JBOSS_SERVER_TEMP_DIR = "jboss.server.temp.dir";
    private static final String SYSPROP_KEY_JBOSS_SERVER_LOG_DIR = "jboss.server.log.dir";
    private static final String SYSPROP_KEY_JBOSS_SERVER_DATA_DIR = "jboss.server.data.dir";
    private static final String SYSPROP_KEY_JBOSS_DOMAIN_BASE_DIR = "jboss.domain.base.dir";
    private static final String SYSPROP_KEY_JBOSS_DOMAIN_CONFIG_DIR = "jboss.domain.config.dir";
    private static final String SYSPROP_KEY_JBOSS_DOMAIN_DEPLOYMENT_DIR = "jboss.domain.deployment.dir";
    private static final String SYSPROP_KEY_JBOSS_DOMAIN_TEMP_DIR = "jboss.domain.temp.dir";
    private static final String SYSPROP_KEY_JBOSS_DOMAIN_LOG_DIR = "jboss.domain.log.dir";
    private static final String SYSPROP_KEY_JBOSS_DOMAIN_DATA_DIR = "jboss.domain.data.dir";
    private static final String SYSPROP_KEY_JBOSS_CONTROLLER_BASE_DIR = "jboss.server.controller.base.dir";
    static final String[] STANDALONE_KEYS = new String[]{"jboss.server.base.dir", "jboss.server.config.dir", "jboss.server.deploy.dir", "jboss.server.temp.dir", "jboss.server.log.dir", "jboss.server.data.dir"};
    static final String[] DOMAIN_KEYS = new String[]{"jboss.domain.base.dir", "jboss.domain.config.dir", "jboss.domain.deployment.dir", "jboss.domain.temp.dir", "jboss.domain.log.dir", "jboss.domain.config.dir"};
    private static final String JBOSS_MODULES_DIR_NAME = "modules";
    private static final String HOST_FACTORY = "org.wildfly.core.embedded.EmbeddedHostControllerFactory";
    private static final String SERVER_FACTORY = "org.wildfly.core.embedded.EmbeddedStandaloneServerFactory";

    EmbeddedProcessFactory() {
    }

    public static StandaloneServer createStandaloneServer(String jbossHomePath, String modulePath, String ... systemPackages) {
        return EmbeddedProcessFactory.createStandaloneServer(jbossHomePath, modulePath, systemPackages, null);
    }

    public static StandaloneServer createStandaloneServer(String jbossHomePath, String modulePath, String[] systemPackages, String[] cmdargs) {
        if (jbossHomePath == null || jbossHomePath.isEmpty()) {
            throw EmbeddedLogger.ROOT_LOGGER.invalidJBossHome(jbossHomePath);
        }
        File jbossHomeDir = new File(jbossHomePath);
        if (!jbossHomeDir.isDirectory()) {
            throw EmbeddedLogger.ROOT_LOGGER.invalidJBossHome(jbossHomePath);
        }
        if (modulePath == null) {
            modulePath = SecurityActions.getPropertyPrivileged(SYSPROP_KEY_MODULE_PATH, jbossHomeDir.getAbsolutePath() + File.separator + JBOSS_MODULES_DIR_NAME);
        }
        return EmbeddedProcessFactory.createStandaloneServer(EmbeddedProcessFactory.setupModuleLoader(modulePath, systemPackages), jbossHomeDir, cmdargs);
    }

    public static StandaloneServer createStandaloneServer(ModuleLoader moduleLoader, File jbossHomeDir, String ... cmdargs) {
        Method createServerMethod;
        Class standaloneServerClass;
        Class embeddedServerFactoryClass;
        Module embeddedModule;
        EmbeddedProcessFactory.resetEmbeddedServerProperties(jbossHomeDir.getAbsolutePath(), ProcessType.STANDALONE_SERVER);
        EmbeddedProcessFactory.setupVfsModule(moduleLoader);
        EmbeddedProcessFactory.setupLoggingSystem(moduleLoader);
        try {
            embeddedModule = moduleLoader.loadModule(ModuleIdentifier.create((String)MODULE_ID_EMBEDDED));
        }
        catch (ModuleLoadException mle) {
            throw EmbeddedLogger.ROOT_LOGGER.moduleLoaderError(mle, MODULE_ID_EMBEDDED, moduleLoader);
        }
        ModuleClassLoader embeddedModuleCL = embeddedModule.getClassLoader();
        try {
            embeddedServerFactoryClass = embeddedModuleCL.loadClass(SERVER_FACTORY);
            standaloneServerClass = embeddedModuleCL.loadClass(StandaloneServer.class.getName());
        }
        catch (ClassNotFoundException cnfe) {
            throw EmbeddedLogger.ROOT_LOGGER.cannotLoadEmbeddedServerFactory(cnfe, SERVER_FACTORY);
        }
        try {
            createServerMethod = embeddedServerFactoryClass.getMethod("create", File.class, ModuleLoader.class, Properties.class, Map.class, String[].class);
        }
        catch (NoSuchMethodException nsme) {
            throw EmbeddedLogger.ROOT_LOGGER.cannotGetReflectiveMethod(nsme, "create", embeddedServerFactoryClass.getName());
        }
        Object standaloneServerImpl = EmbeddedProcessFactory.createManagedProcess(ProcessType.STANDALONE_SERVER, createServerMethod, moduleLoader, jbossHomeDir, cmdargs);
        return new EmbeddedManagedProcessImpl(standaloneServerClass, standaloneServerImpl);
    }

    public static HostController createHostController(String jbossHomePath, String modulePath, String[] systemPackages, String[] cmdargs) {
        if (jbossHomePath == null || jbossHomePath.isEmpty()) {
            throw EmbeddedLogger.ROOT_LOGGER.invalidJBossHome(jbossHomePath);
        }
        File jbossHomeDir = new File(jbossHomePath);
        if (!jbossHomeDir.isDirectory()) {
            throw EmbeddedLogger.ROOT_LOGGER.invalidJBossHome(jbossHomePath);
        }
        if (modulePath == null) {
            modulePath = SecurityActions.getPropertyPrivileged(SYSPROP_KEY_MODULE_PATH, jbossHomeDir.getAbsolutePath() + File.separator + JBOSS_MODULES_DIR_NAME);
        }
        return EmbeddedProcessFactory.createHostController(EmbeddedProcessFactory.setupModuleLoader(modulePath, systemPackages), jbossHomeDir, cmdargs);
    }

    public static HostController createHostController(ModuleLoader moduleLoader, File jbossHomeDir, String[] cmdargs) {
        Method createServerMethod;
        Class hostControllerClass;
        Class embeddedHostControllerFactoryClass;
        Module embeddedModule;
        EmbeddedProcessFactory.resetEmbeddedServerProperties(jbossHomeDir.getAbsolutePath(), ProcessType.HOST_CONTROLLER);
        EmbeddedProcessFactory.setupVfsModule(moduleLoader);
        EmbeddedProcessFactory.setupLoggingSystem(moduleLoader);
        try {
            embeddedModule = moduleLoader.loadModule(ModuleIdentifier.create((String)MODULE_ID_EMBEDDED));
        }
        catch (ModuleLoadException mle) {
            throw EmbeddedLogger.ROOT_LOGGER.moduleLoaderError(mle, MODULE_ID_EMBEDDED, moduleLoader);
        }
        ModuleClassLoader embeddedModuleCL = embeddedModule.getClassLoader();
        try {
            embeddedHostControllerFactoryClass = embeddedModuleCL.loadClass(HOST_FACTORY);
            hostControllerClass = embeddedModuleCL.loadClass(HostController.class.getName());
        }
        catch (ClassNotFoundException cnfe) {
            throw EmbeddedLogger.ROOT_LOGGER.cannotLoadEmbeddedServerFactory(cnfe, HOST_FACTORY);
        }
        try {
            createServerMethod = embeddedHostControllerFactoryClass.getMethod("create", File.class, ModuleLoader.class, Properties.class, Map.class, String[].class);
        }
        catch (NoSuchMethodException nsme) {
            throw EmbeddedLogger.ROOT_LOGGER.cannotGetReflectiveMethod(nsme, "create", embeddedHostControllerFactoryClass.getName());
        }
        Object hostControllerImpl = EmbeddedProcessFactory.createManagedProcess(ProcessType.HOST_CONTROLLER, createServerMethod, moduleLoader, jbossHomeDir, cmdargs);
        return new EmbeddedManagedProcessImpl(hostControllerClass, hostControllerImpl);
    }

    private static String trimPathToModulesDir(String modulePath) {
        int index = modulePath.indexOf(File.pathSeparator);
        return index == -1 ? modulePath : modulePath.substring(0, index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ModuleLoader setupModuleLoader(String modulePath, String ... systemPackages) {
        assert (modulePath != null) : "modulePath not null";
        File moduleDir = new File(EmbeddedProcessFactory.trimPathToModulesDir(modulePath));
        if (!moduleDir.exists() || !moduleDir.isDirectory()) {
            throw new RuntimeException("The first directory of the specified module path " + modulePath + " is invalid or does not exist.");
        }
        SecurityActions.setPropertyPrivileged(SYSPROP_KEY_JBOSS_MODULES_DIR, moduleDir.getPath());
        String classPath = SecurityActions.getPropertyPrivileged(SYSPROP_KEY_CLASS_PATH, null);
        try {
            EmbeddedProcessFactory.clearPropertyPrivileged(SYSPROP_KEY_CLASS_PATH);
            SecurityActions.setPropertyPrivileged(SYSPROP_KEY_MODULE_PATH, modulePath);
            StringBuilder packages = new StringBuilder("org.jboss.modules,org.jboss.msc,org.jboss.dmr,org.jboss.threads,org.jboss.as.controller.client");
            if (systemPackages != null) {
                for (ModuleLoader packageName : systemPackages) {
                    packages.append(",");
                    packages.append((String)packageName);
                }
            }
            SecurityActions.setPropertyPrivileged("jboss.modules.system.pkgs", packages.toString());
            ModuleLoader moduleLoader = Module.getBootModuleLoader();
            return moduleLoader;
        }
        finally {
            SecurityActions.setPropertyPrivileged(SYSPROP_KEY_CLASS_PATH, classPath);
        }
    }

    private static void setupVfsModule(ModuleLoader moduleLoader) {
        Module vfsModule;
        ModuleIdentifier vfsModuleID = ModuleIdentifier.create((String)MODULE_ID_VFS);
        try {
            vfsModule = moduleLoader.loadModule(vfsModuleID);
        }
        catch (ModuleLoadException mle) {
            throw EmbeddedLogger.ROOT_LOGGER.moduleLoaderError(mle, MODULE_ID_VFS, moduleLoader);
        }
        Module.registerURLStreamHandlerFactoryModule((Module)vfsModule);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setupLoggingSystem(ModuleLoader moduleLoader) {
        Module logModule;
        ModuleIdentifier logModuleId = ModuleIdentifier.create((String)MODULE_ID_LOGMANAGER);
        try {
            logModule = moduleLoader.loadModule(logModuleId);
        }
        catch (ModuleLoadException mle) {
            throw EmbeddedLogger.ROOT_LOGGER.moduleLoaderError(mle, MODULE_ID_LOGMANAGER, moduleLoader);
        }
        ModuleClassLoader logModuleClassLoader = logModule.getClassLoader();
        ClassLoader tccl = EmbeddedProcessFactory.getCurrentContextClassLoaderPrivileged();
        try {
            EmbeddedProcessFactory.setCurrentContextClassLoaderPrivileged((ClassLoader)logModuleClassLoader);
            SecurityActions.setPropertyPrivileged(SYSPROP_KEY_LOGMANAGER, SYSPROP_VALUE_JBOSS_LOGMANAGER);
            Class<?> actualLogManagerClass = LogManager.getLogManager().getClass();
            if (actualLogManagerClass == LogManager.class) {
                System.err.println("Cannot not load JBoss LogManager. The LogManager has likely been accessed prior to this initialization.");
            } else {
                Module.setModuleLogger((ModuleLogger)new JDKModuleLogger());
            }
        }
        finally {
            EmbeddedProcessFactory.setCurrentContextClassLoaderPrivileged(tccl);
        }
    }

    private static Object createManagedProcess(ProcessType embeddedType, Method createServerMethod, ModuleLoader moduleLoader, File jbossHomeDir, String[] cmdargs) {
        Object serverImpl;
        try {
            Properties sysprops = EmbeddedProcessFactory.getSystemPropertiesPrivileged();
            Map<String, String> sysenv = EmbeddedProcessFactory.getSystemEnvironmentPrivileged();
            String[] args = cmdargs != null ? cmdargs : new String[]{};
            serverImpl = createServerMethod.invoke(null, jbossHomeDir, moduleLoader, sysprops, sysenv, args);
        }
        catch (InvocationTargetException ite) {
            if (embeddedType == ProcessType.HOST_CONTROLLER) {
                throw EmbeddedLogger.ROOT_LOGGER.cannotCreateHostController(ite.getCause(), createServerMethod);
            }
            throw EmbeddedLogger.ROOT_LOGGER.cannotCreateStandaloneServer(ite.getCause(), createServerMethod);
        }
        catch (IllegalAccessException iae) {
            if (embeddedType == ProcessType.HOST_CONTROLLER) {
                throw EmbeddedLogger.ROOT_LOGGER.cannotCreateHostController(iae, createServerMethod);
            }
            throw EmbeddedLogger.ROOT_LOGGER.cannotCreateStandaloneServer(iae, createServerMethod);
        }
        return serverImpl;
    }

    private static void resetEmbeddedServerProperties(String jbossHomeDir, ProcessType embeddedServerType) {
        assert (jbossHomeDir != null);
        String oldJbossHomeDir = SecurityActions.getPropertyPrivileged(SYSPROP_KEY_JBOSS_PREV_HOME_DIR, null);
        boolean shouldReset = oldJbossHomeDir != null && !jbossHomeDir.equals(oldJbossHomeDir);
        SecurityActions.setPropertyPrivileged(SYSPROP_KEY_JBOSS_HOME_DIR, jbossHomeDir);
        SecurityActions.setPropertyPrivileged(SYSPROP_KEY_JBOSS_PREV_HOME_DIR, jbossHomeDir);
        if (shouldReset) {
            EmbeddedLogger.ROOT_LOGGER.warn("JBOSS_HOME has been changed, all configuration system properties will be set to the default directories below this new JBOSS_HOME");
            EmbeddedProcessFactory.resetProperties(embeddedServerType, jbossHomeDir);
        }
    }

    private static void resetProperties(ProcessType embeddedServerType, String jbossHomeDir) {
        assert (jbossHomeDir != null);
        switch (embeddedServerType) {
            case STANDALONE_SERVER: {
                String jbossBaseDir = jbossHomeDir + File.separator + "standalone";
                EmbeddedProcessFactory.resetEmbeddedServerProperty(SYSPROP_KEY_JBOSS_SERVER_BASE_DIR, jbossBaseDir);
                EmbeddedProcessFactory.resetEmbeddedServerProperty(SYSPROP_KEY_JBOSS_SERVER_CONFIG_DIR, jbossBaseDir + File.separator + "configuration");
                EmbeddedProcessFactory.resetEmbeddedServerProperty(SYSPROP_KEY_JBOSS_SERVER_DATA_DIR, jbossBaseDir + File.separator + "data");
                EmbeddedProcessFactory.resetEmbeddedServerProperty(SYSPROP_KEY_JBOSS_SERVER_DEPLOY_DIR, jbossBaseDir + File.separator + "data" + File.separator + "content");
                EmbeddedProcessFactory.resetEmbeddedServerProperty(SYSPROP_KEY_JBOSS_SERVER_TEMP_DIR, jbossBaseDir + File.separator + "data" + File.separator + "tmp");
                EmbeddedProcessFactory.resetEmbeddedServerProperty(SYSPROP_KEY_JBOSS_SERVER_LOG_DIR, jbossBaseDir + File.separator + "log");
                break;
            }
            case HOST_CONTROLLER: {
                String jbossBaseDir = jbossHomeDir + File.separator + "domain";
                EmbeddedProcessFactory.resetEmbeddedServerProperty(SYSPROP_KEY_JBOSS_DOMAIN_BASE_DIR, jbossBaseDir);
                EmbeddedProcessFactory.resetEmbeddedServerProperty(SYSPROP_KEY_JBOSS_DOMAIN_CONFIG_DIR, jbossBaseDir + File.separator + "configuration");
                EmbeddedProcessFactory.resetEmbeddedServerProperty(SYSPROP_KEY_JBOSS_DOMAIN_DATA_DIR, jbossBaseDir + File.separator + "data");
                EmbeddedProcessFactory.resetEmbeddedServerProperty(SYSPROP_KEY_JBOSS_DOMAIN_DEPLOYMENT_DIR, jbossBaseDir + File.separator + "data" + File.separator + "content");
                EmbeddedProcessFactory.resetEmbeddedServerProperty(SYSPROP_KEY_JBOSS_DOMAIN_TEMP_DIR, jbossBaseDir + File.separator + "data" + File.separator + "tmp");
                EmbeddedProcessFactory.resetEmbeddedServerProperty(SYSPROP_KEY_JBOSS_DOMAIN_LOG_DIR, jbossBaseDir + File.separator + "log");
                break;
            }
            default: {
                throw new RuntimeException("Unknown embedded server type: " + (Object)((Object)embeddedServerType));
            }
        }
    }

    private static void resetEmbeddedServerProperty(String propertyName, String value) {
        SecurityActions.setPropertyPrivileged(propertyName, value);
    }

    private static void clearPropertyPrivileged(final String name) {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            System.clearProperty(name);
        } else {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    System.clearProperty(name);
                    return null;
                }
            });
        }
    }

    private static ClassLoader getCurrentContextClassLoaderPrivileged() {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    private static void setCurrentContextClassLoaderPrivileged(final ClassLoader newClassLoader) {
        SecurityManager sm = System.getSecurityManager();
        final Thread thread = Thread.currentThread();
        if (sm == null) {
            thread.setContextClassLoader(newClassLoader);
        } else {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    thread.setContextClassLoader(newClassLoader);
                    return null;
                }
            });
        }
    }

    private static Properties getSystemPropertiesPrivileged() {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return System.getProperties();
        }
        return AccessController.doPrivileged(System::getProperties);
    }

    private static Map<String, String> getSystemEnvironmentPrivileged() {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return System.getenv();
        }
        return AccessController.doPrivileged(System::getenv);
    }

    private static enum ProcessType {
        STANDALONE_SERVER,
        HOST_CONTROLLER;

    }
}

