/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.core.embedded;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import org.jboss.modules.ModuleLoader;
import org.wildfly.core.embedded.AbstractEmbeddedManagedProcess;
import org.wildfly.core.embedded.HostController;
import org.wildfly.core.embedded.logging.EmbeddedLogger;
import org.wildfly.core.embedded.spi.EmbeddedProcessBootstrap;
import org.wildfly.core.embedded.spi.EmbeddedProcessBootstrapConfiguration;

public class EmbeddedHostControllerFactory {
    public static final String JBOSS_EMBEDDED_ROOT = "jboss.embedded.root";
    private static final String DOMAIN_BASE_DIR = "jboss.domain.base.dir";
    private static final String DOMAIN_CONFIG_DIR = "jboss.domain.config.dir";
    private static final String DOMAIN_DATA_DIR = "jboss.domain.data.dir";

    private EmbeddedHostControllerFactory() {
    }

    public static HostController create(File jbossHomeDir, ModuleLoader moduleLoader, Properties systemProps, Map<String, String> systemEnv, String[] cmdargs, ClassLoader embeddedModuleCL) {
        if (jbossHomeDir == null) {
            throw EmbeddedLogger.ROOT_LOGGER.nullVar("jbossHomeDir");
        }
        if (moduleLoader == null) {
            throw EmbeddedLogger.ROOT_LOGGER.nullVar("moduleLoader");
        }
        if (systemProps == null) {
            throw EmbeddedLogger.ROOT_LOGGER.nullVar("systemProps");
        }
        if (systemEnv == null) {
            throw EmbeddedLogger.ROOT_LOGGER.nullVar("systemEnv");
        }
        if (cmdargs == null) {
            throw EmbeddedLogger.ROOT_LOGGER.nullVar("cmdargs");
        }
        EmbeddedHostControllerFactory.setupCleanDirectories(jbossHomeDir, systemProps);
        return new HostControllerImpl(jbossHomeDir, cmdargs, systemProps, systemEnv, embeddedModuleCL);
    }

    static void setupCleanDirectories(File jbossHomeDir, Properties props) {
        File tempRoot = EmbeddedHostControllerFactory.getTempRoot(props);
        if (tempRoot == null) {
            return;
        }
        File originalConfigDir = EmbeddedHostControllerFactory.getFileUnderAsRoot(jbossHomeDir, props, DOMAIN_CONFIG_DIR, "configuration", true);
        File originalDataDir = EmbeddedHostControllerFactory.getFileUnderAsRoot(jbossHomeDir, props, DOMAIN_DATA_DIR, "data", false);
        try {
            File configDir = new File(tempRoot, "config");
            Files.createDirectory(configDir.toPath(), new FileAttribute[0]);
            File dataDir = new File(tempRoot, "data");
            Files.createDirectory(dataDir.toPath(), new FileAttribute[0]);
            File deploymentsDir = new File(tempRoot, "deployments");
            Files.createDirectory(deploymentsDir.toPath(), new FileAttribute[0]);
            EmbeddedHostControllerFactory.copyDirectory(originalConfigDir, configDir);
            if (originalDataDir.exists()) {
                EmbeddedHostControllerFactory.copyDirectory(originalDataDir, dataDir);
            }
            props.put(DOMAIN_BASE_DIR, tempRoot.getAbsolutePath());
            props.put(DOMAIN_CONFIG_DIR, configDir.getAbsolutePath());
            props.put(DOMAIN_DATA_DIR, dataDir.getAbsolutePath());
        }
        catch (IOException e) {
            throw EmbeddedLogger.ROOT_LOGGER.cannotSetupEmbeddedServer(e);
        }
    }

    private static File getFileUnderAsRoot(File jbossHomeDir, Properties props, String propName, String relativeLocation, boolean mustExist) {
        String prop = props.getProperty(propName, null);
        if (prop == null) {
            prop = props.getProperty(DOMAIN_BASE_DIR, null);
            if (prop == null) {
                File dir = new File(jbossHomeDir, "domain" + File.separator + relativeLocation);
                if (!(!mustExist || dir.exists() && dir.isDirectory())) {
                    throw EmbeddedLogger.ROOT_LOGGER.embeddedServerDirectoryNotFound("domain" + File.separator + relativeLocation, jbossHomeDir.getAbsolutePath());
                }
                return dir;
            }
            File server = new File(prop);
            EmbeddedHostControllerFactory.validateDirectory(DOMAIN_BASE_DIR, server);
            return new File(server, relativeLocation);
        }
        File dir = new File(prop);
        EmbeddedHostControllerFactory.validateDirectory(DOMAIN_BASE_DIR, dir);
        return dir;
    }

    private static File getTempRoot(Properties props) {
        String tempRoot = props.getProperty(JBOSS_EMBEDDED_ROOT, null);
        if (tempRoot == null) {
            return null;
        }
        try {
            File root = new File(tempRoot);
            if (!root.exists()) {
                Files.createDirectories(root.toPath(), new FileAttribute[0]);
            }
            EmbeddedHostControllerFactory.validateDirectory("jboss.test.clean.root", root);
            root = new File(root, "configs");
            Files.createDirectories(root.toPath(), new FileAttribute[0]);
            SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmssSSS");
            root = new File(root, format.format(new Date()));
            Files.createDirectory(root.toPath(), new FileAttribute[0]);
            return root;
        }
        catch (IOException e) {
            throw EmbeddedLogger.ROOT_LOGGER.cannotSetupEmbeddedServer(e);
        }
    }

    private static void validateDirectory(String property, File file) {
        if (!file.exists()) {
            throw EmbeddedLogger.ROOT_LOGGER.propertySpecifiedFileDoesNotExist(property, file.getAbsolutePath());
        }
        if (!file.isDirectory()) {
            throw EmbeddedLogger.ROOT_LOGGER.propertySpecifiedFileIsNotADirectory(property, file.getAbsolutePath());
        }
    }

    private static void copyDirectory(File src, File dest) {
        if (src.list() != null) {
            for (String current : src.list()) {
                File srcFile = new File(src, current);
                File destFile = new File(dest, current);
                try {
                    Files.copy(srcFile.toPath(), destFile.toPath(), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
                    if (!srcFile.isDirectory()) continue;
                    EmbeddedHostControllerFactory.copyDirectory(srcFile, destFile);
                }
                catch (IOException e) {
                    throw EmbeddedLogger.ROOT_LOGGER.errorCopyingFile(srcFile.getAbsolutePath(), destFile.getAbsolutePath(), e);
                }
            }
        }
    }

    private static class HostControllerImpl
    extends AbstractEmbeddedManagedProcess
    implements HostController {
        private final File jbossHomeDir;
        private final Properties systemProps;
        private final Map<String, String> systemEnv;

        public HostControllerImpl(File jbossHomeDir, String[] cmdargs, Properties systemProps, Map<String, String> systemEnv, ClassLoader embeddedModuleCL) {
            super(EmbeddedProcessBootstrap.Type.HOST_CONTROLLER, cmdargs, embeddedModuleCL);
            this.jbossHomeDir = jbossHomeDir;
            this.systemProps = systemProps;
            this.systemEnv = systemEnv;
        }

        @Override
        EmbeddedProcessBootstrapConfiguration getBootstrapConfiguration() {
            EmbeddedProcessBootstrapConfiguration configuration = super.getBootstrapConfiguration();
            configuration.setJBossHome(this.jbossHomeDir);
            return configuration;
        }
    }
}

