/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.core.embedded;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Properties;
import java.util.logging.LogManager;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.log.JDKModuleLogger;
import org.jboss.modules.log.ModuleLogger;
import org.wildfly.core.embedded.EmbeddedHostControllerFactory;
import org.wildfly.core.embedded.EmbeddedServerReference;
import org.wildfly.core.embedded.EmbeddedStandaloneServerFactory;
import org.wildfly.core.embedded.HostController;
import org.wildfly.core.embedded.StandaloneServer;
import org.wildfly.core.embedded.logging.EmbeddedLogger;
import org.wildfly.security.manager.WildFlySecurityManager;

public class EmbeddedServerFactory {
    private static final String MODULE_ID_EMBEDDED = "org.wildfly.embedded";
    private static final String MODULE_ID_LOGMANAGER = "org.jboss.logmanager";
    private static final String MODULE_ID_VFS = "org.jboss.vfs";
    private static final String SYSPROP_KEY_CLASS_PATH = "java.class.path";
    private static final String SYSPROP_KEY_MODULE_PATH = "module.path";
    private static final String SYSPROP_KEY_LOGMANAGER = "java.util.logging.manager";
    private static final String SYSPROP_KEY_JBOSS_HOME_DIR = "jboss.home.dir";
    private static final String SYSPROP_KEY_JBOSS_MODULES_DIR = "jboss.modules.dir";
    private static final String SYSPROP_VALUE_JBOSS_LOGMANAGER = "org.jboss.logmanager.LogManager";
    private static final String SYSPROP_KEY_JBOSS_SERVER_BASE_DIR = "jboss.server.base.dir";
    private static final String SYSPROP_KEY_JBOSS_SERVER_CONFIG_DIR = "jboss.server.config.dir";
    private static final String SYSPROP_KEY_JBOSS_SERVER_DEPLOY_DIR = "jboss.server.deploy.dir";
    private static final String SYSPROP_KEY_JBOSS_SERVER_TEMP_DIR = "jboss.server.temp.dir";
    private static final String SYSPROP_KEY_JBOSS_SERVER_LOG_DIR = "jboss.server.log.dir";
    private static final String SYSPROP_KEY_JBOSS_SERVER_DATA_DIR = "jboss.server.data.dir";
    private static final String SYSPROP_KEY_JBOSS_DOMAIN_BASE_DIR = "jboss.domain.base.dir";
    private static final String SYSPROP_KEY_JBOSS_DOMAIN_CONFIG_DIR = "jboss.domain.config.dir";
    private static final String SYSPROP_KEY_JBOSS_DOMAIN_DEPLOY_DIR = "jboss.domain.deploy.dir";
    private static final String SYSPROP_KEY_JBOSS_DOMAIN_TEMP_DIR = "jboss.domain.temp.dir";
    private static final String SYSPROP_KEY_JBOSS_DOMAIN_LOG_DIR = "jboss.domain.log.dir";
    private static final String SYSPROP_KEY_JBOSS_DOMAIN_DATA_DIR = "jboss.domain.data.dir";
    private static final String JBOSS_MODULES_DIR_NAME = "modules";

    private EmbeddedServerFactory() {
    }

    public static StandaloneServer create(String jbossHomePath, String modulePath, String ... systemPackages) {
        return EmbeddedServerFactory.create(jbossHomePath, modulePath, systemPackages, null);
    }

    public static StandaloneServer create(String jbossHomePath, String modulePath, String[] systemPackages, String[] cmdargs) {
        if (jbossHomePath == null || jbossHomePath.isEmpty()) {
            throw EmbeddedLogger.ROOT_LOGGER.invalidJBossHome(jbossHomePath);
        }
        File jbossHomeDir = new File(jbossHomePath);
        if (!jbossHomeDir.isDirectory()) {
            throw EmbeddedLogger.ROOT_LOGGER.invalidJBossHome(jbossHomePath);
        }
        if (modulePath == null) {
            modulePath = jbossHomeDir.getAbsolutePath() + File.separator + JBOSS_MODULES_DIR_NAME;
        }
        return EmbeddedServerFactory.create(EmbeddedServerFactory.setupModuleLoader(modulePath, systemPackages), jbossHomeDir, cmdargs);
    }

    public static EmbeddedServerReference createStandalone(String jbossHomePath, String modulePath, String[] systemPackages, String[] cmdargs) {
        return (EmbeddedServerReference)EmbeddedServerFactory.create(jbossHomePath, modulePath, systemPackages, cmdargs);
    }

    public static StandaloneServer create(ModuleLoader moduleLoader, File jbossHomeDir) {
        return EmbeddedServerFactory.create(moduleLoader, jbossHomeDir, new String[0]);
    }

    public static StandaloneServer create(ModuleLoader moduleLoader, File jbossHomeDir, String[] cmdargs) {
        Method createServerMethod;
        Class standaloneServerClass;
        Class embeddedServerFactoryClass;
        Module embeddedModule;
        EmbeddedServerFactory.resetEmbeddedServerProperties(jbossHomeDir.getAbsolutePath(), EmbeddedServerType.STANDALONE);
        EmbeddedServerFactory.setupVfsModule(moduleLoader);
        EmbeddedServerFactory.setupLoggingSystem(moduleLoader);
        try {
            embeddedModule = moduleLoader.loadModule(ModuleIdentifier.create((String)MODULE_ID_EMBEDDED));
        }
        catch (ModuleLoadException mle) {
            throw EmbeddedLogger.ROOT_LOGGER.moduleLoaderError(mle, MODULE_ID_EMBEDDED, moduleLoader);
        }
        ModuleClassLoader embeddedModuleCL = embeddedModule.getClassLoader();
        try {
            embeddedServerFactoryClass = embeddedModuleCL.loadClass(EmbeddedStandaloneServerFactory.class.getName());
            standaloneServerClass = embeddedModuleCL.loadClass(StandaloneServer.class.getName());
        }
        catch (ClassNotFoundException cnfe) {
            throw EmbeddedLogger.ROOT_LOGGER.cannotLoadEmbeddedServerFactory(cnfe, EmbeddedStandaloneServerFactory.class.getName());
        }
        try {
            createServerMethod = embeddedServerFactoryClass.getMethod("create", File.class, ModuleLoader.class, Properties.class, Map.class, String[].class);
        }
        catch (NoSuchMethodException nsme) {
            throw EmbeddedLogger.ROOT_LOGGER.cannotGetReflectiveMethod(nsme, "create", embeddedServerFactoryClass.getName());
        }
        Object standaloneServerImpl = EmbeddedServerFactory.createServer(EmbeddedServerType.STANDALONE, createServerMethod, moduleLoader, jbossHomeDir, cmdargs);
        return new EmbeddedServerReference(standaloneServerClass, standaloneServerImpl);
    }

    public static EmbeddedServerReference createStandalone(ModuleLoader moduleLoader, File jbossHomeDir, String[] cmdargs) {
        return (EmbeddedServerReference)EmbeddedServerFactory.create(moduleLoader, jbossHomeDir, cmdargs);
    }

    public static EmbeddedServerReference createHostController(String jbossHomePath, String modulePath, String[] systemPackages, String[] cmdargs) {
        if (jbossHomePath == null || jbossHomePath.isEmpty()) {
            throw EmbeddedLogger.ROOT_LOGGER.invalidJBossHome(jbossHomePath);
        }
        File jbossHomeDir = new File(jbossHomePath);
        if (!jbossHomeDir.isDirectory()) {
            throw EmbeddedLogger.ROOT_LOGGER.invalidJBossHome(jbossHomePath);
        }
        if (modulePath == null) {
            modulePath = jbossHomeDir.getAbsolutePath() + File.separator + JBOSS_MODULES_DIR_NAME;
        }
        return EmbeddedServerFactory.createHostController(EmbeddedServerFactory.setupModuleLoader(modulePath, systemPackages), jbossHomeDir, cmdargs);
    }

    public static EmbeddedServerReference createHostController(ModuleLoader moduleLoader, File jbossHomeDir, String[] cmdargs) {
        Method createServerMethod;
        Class hostControllerClass;
        Class embeddedHostControllerFactoryClass;
        Module embeddedModule;
        EmbeddedServerFactory.resetEmbeddedServerProperties(jbossHomeDir.getAbsolutePath(), EmbeddedServerType.HOST_CONTROLLER);
        EmbeddedServerFactory.setupVfsModule(moduleLoader);
        EmbeddedServerFactory.setupLoggingSystem(moduleLoader);
        try {
            embeddedModule = moduleLoader.loadModule(ModuleIdentifier.create((String)MODULE_ID_EMBEDDED));
        }
        catch (ModuleLoadException mle) {
            throw EmbeddedLogger.ROOT_LOGGER.moduleLoaderError(mle, MODULE_ID_EMBEDDED, moduleLoader);
        }
        ModuleClassLoader embeddedModuleCL = embeddedModule.getClassLoader();
        try {
            embeddedHostControllerFactoryClass = embeddedModuleCL.loadClass(EmbeddedHostControllerFactory.class.getName());
            hostControllerClass = embeddedModuleCL.loadClass(HostController.class.getName());
        }
        catch (ClassNotFoundException cnfe) {
            throw EmbeddedLogger.ROOT_LOGGER.cannotLoadEmbeddedServerFactory(cnfe, EmbeddedHostControllerFactory.class.getName());
        }
        try {
            createServerMethod = embeddedHostControllerFactoryClass.getMethod("create", File.class, ModuleLoader.class, Properties.class, Map.class, String[].class);
        }
        catch (NoSuchMethodException nsme) {
            throw EmbeddedLogger.ROOT_LOGGER.cannotGetReflectiveMethod(nsme, "create", embeddedHostControllerFactoryClass.getName());
        }
        Object hostControllerImpl = EmbeddedServerFactory.createServer(EmbeddedServerType.HOST_CONTROLLER, createServerMethod, moduleLoader, jbossHomeDir, cmdargs);
        return new EmbeddedServerReference(hostControllerClass, hostControllerImpl);
    }

    private static String trimPathToModulesDir(String modulePath) {
        int index = modulePath.indexOf(File.pathSeparator);
        return index == -1 ? modulePath : modulePath.substring(0, index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ModuleLoader setupModuleLoader(String modulePath, String ... systemPackages) {
        assert (modulePath != null) : "modulePath not null";
        File moduleDir = new File(modulePath);
        if (!moduleDir.exists() || !moduleDir.isDirectory()) {
            throw new RuntimeException("The specified module directory " + modulePath + " is invalid or does not exist.");
        }
        WildFlySecurityManager.setPropertyPrivileged((String)SYSPROP_KEY_JBOSS_MODULES_DIR, (String)EmbeddedServerFactory.trimPathToModulesDir(modulePath));
        String classPath = WildFlySecurityManager.getPropertyPrivileged((String)SYSPROP_KEY_CLASS_PATH, null);
        try {
            WildFlySecurityManager.clearPropertyPrivileged((String)SYSPROP_KEY_CLASS_PATH);
            WildFlySecurityManager.setPropertyPrivileged((String)SYSPROP_KEY_MODULE_PATH, (String)modulePath);
            StringBuilder packages = new StringBuilder("org.jboss.modules,org.jboss.msc,org.jboss.dmr,org.jboss.threads,org.jboss.as.controller.client");
            if (systemPackages != null) {
                for (ModuleLoader packageName : systemPackages) {
                    packages.append(",");
                    packages.append((String)packageName);
                }
            }
            WildFlySecurityManager.setPropertyPrivileged((String)"jboss.modules.system.pkgs", (String)packages.toString());
            ModuleLoader moduleLoader = Module.getBootModuleLoader();
            return moduleLoader;
        }
        finally {
            WildFlySecurityManager.setPropertyPrivileged((String)SYSPROP_KEY_CLASS_PATH, (String)classPath);
        }
    }

    private static void setupVfsModule(ModuleLoader moduleLoader) {
        Module vfsModule;
        ModuleIdentifier vfsModuleID = ModuleIdentifier.create((String)MODULE_ID_VFS);
        try {
            vfsModule = moduleLoader.loadModule(vfsModuleID);
        }
        catch (ModuleLoadException mle) {
            throw EmbeddedLogger.ROOT_LOGGER.moduleLoaderError(mle, MODULE_ID_VFS, moduleLoader);
        }
        Module.registerURLStreamHandlerFactoryModule((Module)vfsModule);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setupLoggingSystem(ModuleLoader moduleLoader) {
        Module logModule;
        ModuleIdentifier logModuleId = ModuleIdentifier.create((String)MODULE_ID_LOGMANAGER);
        try {
            logModule = moduleLoader.loadModule(logModuleId);
        }
        catch (ModuleLoadException mle) {
            throw EmbeddedLogger.ROOT_LOGGER.moduleLoaderError(mle, MODULE_ID_LOGMANAGER, moduleLoader);
        }
        ModuleClassLoader logModuleClassLoader = logModule.getClassLoader();
        ClassLoader tccl = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
        try {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)logModuleClassLoader);
            WildFlySecurityManager.setPropertyPrivileged((String)SYSPROP_KEY_LOGMANAGER, (String)SYSPROP_VALUE_JBOSS_LOGMANAGER);
            Class<?> actualLogManagerClass = LogManager.getLogManager().getClass();
            if (actualLogManagerClass == LogManager.class) {
                System.err.println("Cannot not load JBoss LogManager. The LogManager has likely been accessed prior to this initialization.");
            } else {
                Module.setModuleLogger((ModuleLogger)new JDKModuleLogger());
            }
        }
        finally {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)tccl);
        }
    }

    private static Object createServer(EmbeddedServerType embeddedType, Method createServerMethod, ModuleLoader moduleLoader, File jbossHomeDir, String[] cmdargs) {
        Object serverImpl;
        try {
            Properties sysprops = WildFlySecurityManager.getSystemPropertiesPrivileged();
            Map sysenv = WildFlySecurityManager.getSystemEnvironmentPrivileged();
            String[] args = cmdargs != null ? cmdargs : new String[]{};
            serverImpl = createServerMethod.invoke(null, jbossHomeDir, moduleLoader, sysprops, sysenv, args);
        }
        catch (InvocationTargetException ite) {
            if (embeddedType == EmbeddedServerType.HOST_CONTROLLER) {
                throw EmbeddedLogger.ROOT_LOGGER.cannotCreateHostController(ite.getCause(), createServerMethod);
            }
            throw EmbeddedLogger.ROOT_LOGGER.cannotCreateStandaloneServer(ite.getCause(), createServerMethod);
        }
        catch (IllegalAccessException iae) {
            if (embeddedType == EmbeddedServerType.HOST_CONTROLLER) {
                throw EmbeddedLogger.ROOT_LOGGER.cannotCreateHostController(iae, createServerMethod);
            }
            throw EmbeddedLogger.ROOT_LOGGER.cannotCreateStandaloneServer(iae, createServerMethod);
        }
        return serverImpl;
    }

    private static void resetEmbeddedServerProperties(String jbossHomeDir, EmbeddedServerType embeddedServerType) {
        assert (jbossHomeDir != null);
        WildFlySecurityManager.setPropertyPrivileged((String)SYSPROP_KEY_JBOSS_HOME_DIR, (String)jbossHomeDir);
        switch (embeddedServerType) {
            case STANDALONE: {
                String jbossBaseDir = jbossHomeDir + File.separator + "standalone";
                WildFlySecurityManager.setPropertyPrivileged((String)SYSPROP_KEY_JBOSS_SERVER_CONFIG_DIR, (String)(jbossBaseDir + File.separator + "configuration"));
                WildFlySecurityManager.setPropertyPrivileged((String)SYSPROP_KEY_JBOSS_SERVER_DEPLOY_DIR, (String)(jbossBaseDir + File.separator + "data" + File.separator + "content"));
                WildFlySecurityManager.setPropertyPrivileged((String)SYSPROP_KEY_JBOSS_SERVER_TEMP_DIR, (String)(jbossBaseDir + File.separator + "data" + File.separator + "tmp"));
                WildFlySecurityManager.setPropertyPrivileged((String)SYSPROP_KEY_JBOSS_SERVER_LOG_DIR, (String)(jbossBaseDir + File.separator + "log"));
                WildFlySecurityManager.setPropertyPrivileged((String)SYSPROP_KEY_JBOSS_SERVER_DATA_DIR, (String)(jbossBaseDir + File.separator + "data"));
                WildFlySecurityManager.setPropertyPrivileged((String)SYSPROP_KEY_JBOSS_SERVER_BASE_DIR, (String)jbossBaseDir);
                break;
            }
            case HOST_CONTROLLER: {
                String jbossBaseDir = jbossHomeDir + File.separator + "domain";
                WildFlySecurityManager.setPropertyPrivileged((String)SYSPROP_KEY_JBOSS_DOMAIN_CONFIG_DIR, (String)(jbossBaseDir + File.separator + "configuration"));
                WildFlySecurityManager.setPropertyPrivileged((String)SYSPROP_KEY_JBOSS_DOMAIN_DEPLOY_DIR, (String)(jbossBaseDir + File.separator + "data" + File.separator + "content"));
                WildFlySecurityManager.setPropertyPrivileged((String)SYSPROP_KEY_JBOSS_DOMAIN_TEMP_DIR, (String)(jbossBaseDir + File.separator + "data" + File.separator + "tmp"));
                WildFlySecurityManager.setPropertyPrivileged((String)SYSPROP_KEY_JBOSS_DOMAIN_LOG_DIR, (String)(jbossBaseDir + File.separator + "log"));
                WildFlySecurityManager.setPropertyPrivileged((String)SYSPROP_KEY_JBOSS_DOMAIN_DATA_DIR, (String)(jbossBaseDir + File.separator + "data"));
                WildFlySecurityManager.setPropertyPrivileged((String)SYSPROP_KEY_JBOSS_DOMAIN_BASE_DIR, (String)jbossBaseDir);
                break;
            }
            default: {
                throw new RuntimeException("Unknown embedded server type: " + (Object)((Object)embeddedServerType));
            }
        }
    }

    private static enum EmbeddedServerType {
        STANDALONE,
        HOST_CONTROLLER;

    }
}

