/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ServiceLoader;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AbstractWriteAttributeHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ObjectTypeAttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.StringListAttributeDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.StandardResourceDescriptionResolver;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.StringAllowedValuesValidator;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.security.CredentialReference;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.common.function.ExceptionSupplier;
import org.wildfly.extension.elytron.AcmeAccountService;
import org.wildfly.extension.elytron.BaseAddHandler;
import org.wildfly.extension.elytron.Capabilities;
import org.wildfly.extension.elytron.ElytronDefinition;
import org.wildfly.extension.elytron.ElytronExtension;
import org.wildfly.extension.elytron.ElytronReloadRequiredWriteAttributeHandler;
import org.wildfly.extension.elytron.ElytronRuntimeOnlyHandler;
import org.wildfly.extension.elytron.ModifiableKeyStoreService;
import org.wildfly.extension.elytron.TrivialCapabilityServiceRemoveHandler;
import org.wildfly.extension.elytron._private.ElytronSubsystemMessages;
import org.wildfly.security.x500.cert.acme.AcmeAccount;
import org.wildfly.security.x500.cert.acme.AcmeClientSpi;
import org.wildfly.security.x500.cert.acme.AcmeException;
import org.wildfly.security.x500.cert.acme.AcmeMetadata;

class CertificateAuthorityAccountDefinition
extends SimpleResourceDefinition {
    static final StringListAttributeDefinition CONTACT_URLS = ((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)new StringListAttributeDefinition.Builder("contact-urls").setRequired(false)).setAllowExpression(true)).setMinSize(1)).setRestartAllServices()).build();
    static final SimpleAttributeDefinition CERTIFICATE_AUTHORITY = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("certificate-authority", ModelType.STRING, true).setDefaultValue(new ModelNode(CertificateAuthority.LETS_ENCRYPT.getName()))).setValidator((ParameterValidator)new StringAllowedValuesValidator(new String[]{CertificateAuthority.LETS_ENCRYPT.getName()}))).setAllowExpression(true)).setRestartAllServices()).build();
    static final SimpleAttributeDefinition KEY_STORE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("key-store", ModelType.STRING, false).setAttributeGroup("account-key")).setMinSize(1)).setRestartAllServices()).setCapabilityReference("org.wildfly.security.key-store", "org.wildfly.security.certificate-authority-account", true)).build();
    static final SimpleAttributeDefinition ALIAS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("alias", ModelType.STRING, false).setAttributeGroup("account-key")).setMinSize(1)).setAllowExpression(true)).setRestartAllServices()).build();
    static final ObjectTypeAttributeDefinition CREDENTIAL_REFERENCE = ((ObjectTypeAttributeDefinition.Builder)CredentialReference.getAttributeBuilder((boolean)true, (boolean)true).setAttributeGroup("account-key")).build();
    private static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{CERTIFICATE_AUTHORITY, CONTACT_URLS, KEY_STORE, ALIAS, CREDENTIAL_REFERENCE};
    static final SimpleAttributeDefinition AGREE_TO_TERMS_OF_SERVICE = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("agree-to-terms-of-service", ModelType.BOOLEAN, false).setAllowExpression(true)).build();
    static final SimpleAttributeDefinition STAGING = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("staging", ModelType.BOOLEAN, true).setAllowExpression(true)).setDefaultValue(new ModelNode(false))).build();
    private static final AcmeClientSpi acmeClient = CertificateAuthorityAccountDefinition.loadAcmeClient();
    private static final AbstractAddStepHandler ADD = new CertificateAuthorityAccountAddHandler();
    private static final OperationStepHandler REMOVE = new TrivialCapabilityServiceRemoveHandler(ADD, Capabilities.CERTIFICATE_AUTHORITY_ACCOUNT_RUNTIME_CAPABILITY);
    private static final AbstractWriteAttributeHandler WRITE = new ElytronReloadRequiredWriteAttributeHandler(ATTRIBUTES);

    private static AcmeClientSpi loadAcmeClient() {
        Iterator<AcmeClientSpi> iterator = ServiceLoader.load(AcmeClientSpi.class, ElytronSubsystemMessages.class.getClassLoader()).iterator();
        if (iterator.hasNext()) {
            AcmeClientSpi acmeClient = iterator.next();
            return acmeClient;
        }
        throw ElytronSubsystemMessages.ROOT_LOGGER.unableToInstatiateAcmeClientSpiImplementation();
    }

    CertificateAuthorityAccountDefinition() {
        super(new SimpleResourceDefinition.Parameters(PathElement.pathElement((String)"certificate-authority-account"), (ResourceDescriptionResolver)ElytronExtension.getResourceDescriptionResolver("certificate-authority-account")).setAddHandler((OperationStepHandler)ADD).setRemoveHandler(REMOVE).setAddRestartLevel(OperationEntry.Flag.RESTART_RESOURCE_SERVICES).setRemoveRestartLevel(OperationEntry.Flag.RESTART_RESOURCE_SERVICES).setCapabilities(new RuntimeCapability[]{Capabilities.CERTIFICATE_AUTHORITY_ACCOUNT_RUNTIME_CAPABILITY}));
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        for (AttributeDefinition current : ATTRIBUTES) {
            resourceRegistration.registerReadWriteAttribute(current, null, (OperationStepHandler)WRITE);
        }
    }

    public void registerOperations(ManagementResourceRegistration resourceRegistration) {
        super.registerOperations(resourceRegistration);
        StandardResourceDescriptionResolver resolver = ElytronExtension.getResourceDescriptionResolver("certificate-authority-account");
        if (ElytronExtension.isServerOrHostController((ImmutableManagementResourceRegistration)resourceRegistration)) {
            CreateAccountHandler.register(resourceRegistration, (ResourceDescriptionResolver)resolver);
            UpdateAccountHandler.register(resourceRegistration, (ResourceDescriptionResolver)resolver);
            ChangeAccountKeyHandler.register(resourceRegistration, (ResourceDescriptionResolver)resolver);
            DeactivateAccountHandler.register(resourceRegistration, (ResourceDescriptionResolver)resolver);
            GetMetadataHandler.register(resourceRegistration, (ResourceDescriptionResolver)resolver);
        }
    }

    static ModifiableKeyStoreService getModifiableKeyStoreService(OperationContext context, String keyStoreName) throws OperationFailedException {
        ServiceRegistry serviceRegistry = context.getServiceRegistry(true);
        return CertificateAuthorityAccountDefinition.getModifiableKeyStoreService(serviceRegistry, keyStoreName);
    }

    static ModifiableKeyStoreService getModifiableKeyStoreService(ServiceRegistry serviceRegistry, String keyStoreName) throws OperationFailedException {
        RuntimeCapability runtimeCapability = Capabilities.KEY_STORE_RUNTIME_CAPABILITY.fromBaseCapability(keyStoreName);
        ServiceName serviceName = runtimeCapability.getCapabilityServiceName();
        ServiceController<KeyStore> serviceContainer = ElytronExtension.getRequiredService(serviceRegistry, serviceName, KeyStore.class);
        ServiceController.State serviceState = serviceContainer.getState();
        if (serviceState != ServiceController.State.UP) {
            throw ElytronSubsystemMessages.ROOT_LOGGER.requiredServiceNotUp(serviceName, serviceState);
        }
        return (ModifiableKeyStoreService)serviceContainer.getService();
    }

    private static AcmeAccountService getAcmeAccountService(OperationContext context) throws OperationFailedException {
        PathAddress currentAddress;
        RuntimeCapability runtimeCapability;
        ServiceName serviceName;
        ServiceRegistry serviceRegistry = context.getServiceRegistry(true);
        ServiceController<AcmeAccount> serviceContainer = ElytronExtension.getRequiredService(serviceRegistry, serviceName = (runtimeCapability = Capabilities.CERTIFICATE_AUTHORITY_ACCOUNT_RUNTIME_CAPABILITY.fromBaseCapability((currentAddress = context.getCurrentAddress()).getLastElement().getValue())).getCapabilityServiceName(), AcmeAccount.class);
        ServiceController.State serviceState = serviceContainer.getState();
        if (serviceState != ServiceController.State.UP) {
            throw ElytronSubsystemMessages.ROOT_LOGGER.requiredServiceNotUp(serviceName, serviceState);
        }
        return (AcmeAccountService)serviceContainer.getService();
    }

    static class GetMetadataHandler
    extends ElytronRuntimeOnlyHandler {
        GetMetadataHandler() {
        }

        static void register(ManagementResourceRegistration resourceRegistration, ResourceDescriptionResolver descriptionResolver) {
            resourceRegistration.registerOperationHandler((OperationDefinition)new SimpleOperationDefinitionBuilder("get-metadata", descriptionResolver).setParameters(new AttributeDefinition[]{STAGING}).setRuntimeOnly().build(), (OperationStepHandler)new GetMetadataHandler());
        }

        protected void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
            AcmeAccountService acmeAccountService = CertificateAuthorityAccountDefinition.getAcmeAccountService(context);
            AcmeAccount acmeAccount = acmeAccountService.getValue();
            boolean staging = STAGING.resolveModelAttribute(context, operation).asBoolean();
            try {
                AcmeMetadata metadata = acmeClient.getMetadata(acmeAccount, staging);
                if (metadata != null) {
                    ModelNode result = context.getResult();
                    if (metadata.getTermsOfServiceUrl() != null) {
                        result.get("terms-of-service").set(new ModelNode(metadata.getTermsOfServiceUrl()));
                    }
                    if (metadata.getWebsiteUrl() != null) {
                        result.get("website").set(new ModelNode(metadata.getWebsiteUrl()));
                    }
                    String[] caaIdentitiesArray = metadata.getCAAIdentities();
                    ModelNode caaIdentities = new ModelNode();
                    if (caaIdentitiesArray != null && caaIdentitiesArray.length != 0) {
                        for (int i = 0; i < caaIdentitiesArray.length; ++i) {
                            caaIdentities.add(caaIdentitiesArray[i]);
                        }
                        result.get("caa-identities").set(caaIdentities);
                    }
                    result.get("external-account-required").set(metadata.isExternalAccountRequired());
                }
            }
            catch (AcmeException e) {
                throw ElytronSubsystemMessages.ROOT_LOGGER.unableToGetCertificateAuthorityMetadata((Exception)((Object)e), e.getLocalizedMessage());
            }
        }
    }

    static class DeactivateAccountHandler
    extends ElytronRuntimeOnlyHandler {
        DeactivateAccountHandler() {
        }

        static void register(ManagementResourceRegistration resourceRegistration, ResourceDescriptionResolver descriptionResolver) {
            resourceRegistration.registerOperationHandler((OperationDefinition)new SimpleOperationDefinitionBuilder("deactivate-account", descriptionResolver).setParameters(new AttributeDefinition[]{STAGING}).setRuntimeOnly().build(), (OperationStepHandler)new DeactivateAccountHandler());
        }

        protected void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
            AcmeAccountService acmeAccountService = CertificateAuthorityAccountDefinition.getAcmeAccountService(context);
            AcmeAccount acmeAccount = acmeAccountService.getValue();
            boolean staging = STAGING.resolveModelAttribute(context, operation).asBoolean();
            try {
                acmeClient.deactivateAccount(acmeAccount, staging);
            }
            catch (AcmeException e) {
                throw ElytronSubsystemMessages.ROOT_LOGGER.unableToDeactivateAccountWithCertificateAuthority((Exception)((Object)e), e.getLocalizedMessage());
            }
        }
    }

    static class ChangeAccountKeyHandler
    extends ElytronRuntimeOnlyHandler {
        ChangeAccountKeyHandler() {
        }

        static void register(ManagementResourceRegistration resourceRegistration, ResourceDescriptionResolver descriptionResolver) {
            resourceRegistration.registerOperationHandler((OperationDefinition)new SimpleOperationDefinitionBuilder("change-account-key", descriptionResolver).setParameters(new AttributeDefinition[]{STAGING}).setRuntimeOnly().build(), (OperationStepHandler)new ChangeAccountKeyHandler());
        }

        protected void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
            AcmeAccountService acmeAccountService = CertificateAuthorityAccountDefinition.getAcmeAccountService(context);
            AcmeAccount acmeAccount = acmeAccountService.getValue();
            boolean staging = STAGING.resolveModelAttribute(context, operation).asBoolean();
            try {
                acmeClient.changeAccountKey(acmeAccount, staging);
                acmeAccountService.saveCertificateAuthorityAccountKey(context);
            }
            catch (AcmeException e) {
                throw ElytronSubsystemMessages.ROOT_LOGGER.unableToChangeAccountKeyWithCertificateAuthority((Exception)((Object)e), e.getLocalizedMessage());
            }
        }
    }

    static class UpdateAccountHandler
    extends ElytronRuntimeOnlyHandler {
        static final SimpleAttributeDefinition UPDATE_AGREE_TO_TERMS_OF_SERVICE = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("agree-to-terms-of-service", ModelType.BOOLEAN, true).setAllowExpression(true)).build();

        UpdateAccountHandler() {
        }

        static void register(ManagementResourceRegistration resourceRegistration, ResourceDescriptionResolver descriptionResolver) {
            resourceRegistration.registerOperationHandler((OperationDefinition)new SimpleOperationDefinitionBuilder("update-account", descriptionResolver).setParameters(new AttributeDefinition[]{AGREE_TO_TERMS_OF_SERVICE, STAGING}).setRuntimeOnly().build(), (OperationStepHandler)new UpdateAccountHandler());
        }

        protected void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
            AcmeAccount acmeAccount = CertificateAuthorityAccountDefinition.getAcmeAccountService(context).getValue();
            Boolean agreeToTermsOfService = UPDATE_AGREE_TO_TERMS_OF_SERVICE.resolveModelAttribute(context, operation).asBooleanOrNull();
            boolean staging = STAGING.resolveModelAttribute(context, operation).asBoolean();
            try {
                if (agreeToTermsOfService != null) {
                    acmeClient.updateAccount(acmeAccount, staging, agreeToTermsOfService.booleanValue(), acmeAccount.getContactUrls());
                } else {
                    acmeClient.updateAccount(acmeAccount, staging, acmeAccount.getContactUrls());
                }
            }
            catch (AcmeException e) {
                throw ElytronSubsystemMessages.ROOT_LOGGER.unableToUpdateAccountWithCertificateAuthority((Exception)((Object)e), e.getLocalizedMessage());
            }
        }
    }

    static class CreateAccountHandler
    extends ElytronRuntimeOnlyHandler {
        CreateAccountHandler() {
        }

        static void register(ManagementResourceRegistration resourceRegistration, ResourceDescriptionResolver descriptionResolver) {
            resourceRegistration.registerOperationHandler((OperationDefinition)new SimpleOperationDefinitionBuilder("create-account", descriptionResolver).setParameters(new AttributeDefinition[]{AGREE_TO_TERMS_OF_SERVICE, STAGING}).setRuntimeOnly().build(), (OperationStepHandler)new CreateAccountHandler());
        }

        protected void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
            AcmeAccount acmeAccount = CertificateAuthorityAccountDefinition.getAcmeAccountService(context).getValue();
            boolean agreeToTermsOfService = AGREE_TO_TERMS_OF_SERVICE.resolveModelAttribute(context, operation).asBoolean();
            boolean staging = STAGING.resolveModelAttribute(context, operation).asBoolean();
            try {
                acmeAccount.setTermsOfServiceAgreed(agreeToTermsOfService);
                acmeClient.createAccount(acmeAccount, staging);
            }
            catch (AcmeException e) {
                throw ElytronSubsystemMessages.ROOT_LOGGER.unableToCreateAccountWithCertificateAuthority((Exception)((Object)e), e.getLocalizedMessage());
            }
        }
    }

    private static class CertificateAuthorityAccountAddHandler
    extends BaseAddHandler {
        private CertificateAuthorityAccountAddHandler() {
            super(Capabilities.CERTIFICATE_AUTHORITY_ACCOUNT_RUNTIME_CAPABILITY, ATTRIBUTES);
        }

        protected void performRuntime(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
            ModelNode model = resource.getModel();
            CertificateAuthority certificateAuthority = CertificateAuthority.fromName(CERTIFICATE_AUTHORITY.resolveModelAttribute(context, model).asString().toUpperCase(Locale.ENGLISH));
            String alias = ALIAS.resolveModelAttribute(context, model).asString();
            String keyStoreName = KEY_STORE.resolveModelAttribute(context, model).asString();
            ExceptionSupplier credentialSourceSupplier = null;
            if (CREDENTIAL_REFERENCE.resolveModelAttribute(context, operation).isDefined()) {
                credentialSourceSupplier = CredentialReference.getCredentialSourceSupplier((OperationContext)context, (ObjectTypeAttributeDefinition)CREDENTIAL_REFERENCE, (ModelNode)operation, null);
            }
            List contactUrls = CONTACT_URLS.resolveModelAttribute(context, model).asListOrEmpty();
            ArrayList<String> contactUrlsList = new ArrayList<String>(contactUrls.size());
            for (ModelNode contactUrl : contactUrls) {
                contactUrlsList.add(contactUrl.asString());
            }
            AcmeAccountService acmeAccountService = new AcmeAccountService(certificateAuthority, contactUrlsList, alias, keyStoreName);
            ServiceTarget serviceTarget = context.getServiceTarget();
            RuntimeCapability certificateAuthorityAccountRuntimeCapability = Capabilities.CERTIFICATE_AUTHORITY_ACCOUNT_RUNTIME_CAPABILITY.fromBaseCapability(context.getCurrentAddressValue());
            ServiceName acmeAccountServiceName = certificateAuthorityAccountRuntimeCapability.getCapabilityServiceName(AcmeAccount.class);
            ServiceBuilder acmeAccountServiceBuilder = serviceTarget.addService(acmeAccountServiceName, (Service)acmeAccountService).setInitialMode(ServiceController.Mode.ACTIVE);
            acmeAccountService.getCredentialSourceSupplierInjector().inject((Object)credentialSourceSupplier);
            String keyStoreCapabilityName = RuntimeCapability.buildDynamicCapabilityName((String)"org.wildfly.security.key-store", (String)keyStoreName);
            acmeAccountServiceBuilder.addDependency(context.getCapabilityServiceName(keyStoreCapabilityName, KeyStore.class), KeyStore.class, acmeAccountService.getKeyStoreInjector());
            ElytronDefinition.commonDependencies(acmeAccountServiceBuilder).install();
        }
    }

    static enum CertificateAuthority {
        LETS_ENCRYPT("LetsEncrypt", "https://acme-v02.api.letsencrypt.org/directory", "https://acme-staging.api.letsencrypt.org/directory");

        private final String name;
        private final String url;
        private final String stagingUrl;

        private CertificateAuthority(String name, String url, String stagingUrl) {
            this.name = name;
            this.url = url;
            this.stagingUrl = stagingUrl;
        }

        public String getName() {
            return this.name;
        }

        public String getUrl() {
            return this.url;
        }

        public String getStagingUrl() {
            return this.stagingUrl;
        }

        public static CertificateAuthority fromName(String name) {
            switch (name.toUpperCase(Locale.ENGLISH)) {
                case "LETSENCRYPT": {
                    return LETS_ENCRYPT;
                }
            }
            throw new IllegalArgumentException(name);
        }
    }
}

