/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.transform.ExtensionTransformerRegistration;
import org.jboss.as.controller.transform.SubsystemTransformerRegistration;
import org.jboss.as.controller.transform.TransformationContext;
import org.jboss.as.controller.transform.description.AttributeConverter;
import org.jboss.as.controller.transform.description.AttributeTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.ChainedTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.DiscardAttributeChecker;
import org.jboss.as.controller.transform.description.RejectAttributeChecker;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.TransformationDescriptionBuilder;
import org.jboss.dmr.ModelNode;
import org.wildfly.extension.elytron.ElytronExtension;
import org.wildfly.extension.elytron.KerberosSecurityFactoryDefinition;

public final class ElytronSubsystemTransformers
implements ExtensionTransformerRegistration {
    private static final AttributeConverter MAPPING_PERMISSION_SET_CONVERTER = new AttributeConverter.DefaultAttributeConverter(){

        protected void convertAttribute(PathAddress address, String attributeName, ModelNode attributeValue, TransformationContext context) {
            if (attributeValue.isDefined()) {
                for (ModelNode permissionMapping : attributeValue.asList()) {
                    if (!permissionMapping.hasDefined("permission-sets")) continue;
                    ModelNode permissionSets = permissionMapping.get("permission-sets");
                    for (ModelNode permissionSet : permissionSets.asList()) {
                        ModelNode permissionSetName = permissionSet.get("permission-set");
                        PathAddress permissionSetAddress = address.getParent().append("permission-set", permissionSetName.asString());
                        ModelNode permissions = context.readResourceFromRoot(permissionSetAddress).getModel().get("permissions");
                        for (ModelNode permission : permissions.asList()) {
                            permissionMapping.get("permissions").add(permission);
                        }
                    }
                    permissionMapping.remove("permission-sets");
                }
            }
        }
    };
    private static final AttributeConverter CONSTANT_PERMISSION_SET_CONVERTER = new AttributeConverter.DefaultAttributeConverter(){

        protected void convertAttribute(PathAddress address, String attributeName, ModelNode attributeValue, TransformationContext context) {
            if (attributeValue.isDefined()) {
                ModelNode allPermissions = new ModelNode();
                for (ModelNode permissionSet : attributeValue.asList()) {
                    ModelNode permissionSetName = permissionSet.get("permission-set");
                    PathAddress permissionSetAddress = address.getParent().append("permission-set", permissionSetName.asString());
                    ModelNode permissions = context.readResourceFromRoot(permissionSetAddress).getModel().get("permissions");
                    for (ModelNode permission : permissions.asList()) {
                        allPermissions.add(permission);
                    }
                }
                attributeValue.set(allPermissions);
            }
        }
    };

    public String getSubsystemName() {
        return "elytron";
    }

    public void registerTransformers(SubsystemTransformerRegistration registration) {
        ChainedTransformationDescriptionBuilder chainedBuilder = TransformationDescriptionBuilder.Factory.createChainedSubystemInstance((ModelVersion)registration.getCurrentSubsystemVersion());
        ElytronSubsystemTransformers.from3(chainedBuilder);
        ElytronSubsystemTransformers.from2(chainedBuilder);
        chainedBuilder.buildAndRegister(registration, (ModelVersion[][])new ModelVersion[][]{{ElytronExtension.ELYTRON_2_0_0, ElytronExtension.ELYTRON_1_2_0}});
    }

    private static void from3(ChainedTransformationDescriptionBuilder chainedBuilder) {
        ResourceTransformationDescriptionBuilder builder = chainedBuilder.createBuilder(ElytronExtension.ELYTRON_3_0_0, ElytronExtension.ELYTRON_2_0_0);
        builder.discardChildResource(PathElement.pathElement((String)"permission-set"));
        ((AttributeTransformationDescriptionBuilder)builder.addChildResource(PathElement.pathElement((String)"simple-permission-mapper")).getAttributeBuilder().setValueConverter(MAPPING_PERMISSION_SET_CONVERTER, new String[]{"permission-mappings"})).end();
        ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)builder.addChildResource(PathElement.pathElement((String)"constant-permission-mapper")).getAttributeBuilder().addRename("permission-sets", "permissions")).setValueConverter(CONSTANT_PERMISSION_SET_CONVERTER, new String[]{"permission-sets"})).end();
    }

    private static void from2(ChainedTransformationDescriptionBuilder chainedBuilder) {
        ResourceTransformationDescriptionBuilder builder = chainedBuilder.createBuilder(ElytronExtension.ELYTRON_2_0_0, ElytronExtension.ELYTRON_1_2_0);
        ((AttributeTransformationDescriptionBuilder)builder.addChildResource(PathElement.pathElement((String)"kerberos-security-factory")).getAttributeBuilder().setDiscard((DiscardAttributeChecker)new DiscardAttributeChecker.DiscardAttributeValueChecker(new ModelNode[]{new ModelNode(0)}), new AttributeDefinition[]{KerberosSecurityFactoryDefinition.FAIL_CACHE})).addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{KerberosSecurityFactoryDefinition.FAIL_CACHE});
    }
}

