/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.AttributeMarshallers;
import org.jboss.as.controller.AttributeParsers;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.StringListAttributeDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.extension.elytron.AggregateComponentDefinition;
import org.wildfly.extension.elytron.BaseAddHandler;
import org.wildfly.extension.elytron.Capabilities;
import org.wildfly.extension.elytron.ElytronDefinition;
import org.wildfly.extension.elytron.ElytronExtension;
import org.wildfly.extension.elytron.ElytronReloadRequiredWriteAttributeHandler;
import org.wildfly.extension.elytron.TrivialCapabilityServiceRemoveHandler;
import org.wildfly.extension.elytron.TrivialService;
import org.wildfly.extension.elytron._private.ElytronSubsystemMessages;
import org.wildfly.extension.elytron.capabilities.PrincipalTransformer;
import org.wildfly.security.asn1.OidsUtil;
import org.wildfly.security.auth.server.PrincipalDecoder;
import org.wildfly.security.x500.X500AttributePrincipalDecoder;

class PrincipalDecoderDefinitions {
    static final SimpleAttributeDefinition OID = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("oid", ModelType.STRING, false).setAllowExpression(true)).setMinSize(1)).setAlternatives(new String[]{"attribute-name"})).setRestartAllServices()).build();
    static final SimpleAttributeDefinition ATTRIBUTE_NAME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("attribute-name", ModelType.STRING, false).setAllowExpression(true)).setMinSize(1)).setAlternatives(new String[]{"oid"})).setRestartAllServices()).build();
    static final SimpleAttributeDefinition JOINER = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("joiner", ModelType.STRING, true).setAllowExpression(true)).setMinSize(0)).setDefaultValue(new ModelNode("."))).setRestartAllServices()).build();
    static final SimpleAttributeDefinition START_SEGMENT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("start-segment", ModelType.INT, true).setAllowExpression(true)).setDefaultValue(new ModelNode(0))).setRestartAllServices()).build();
    static final SimpleAttributeDefinition MAXIMUM_SEGMENTS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("maximum-segments", ModelType.INT, true).setAllowExpression(true)).setDefaultValue(new ModelNode(Integer.MAX_VALUE))).setRestartAllServices()).build();
    static final SimpleAttributeDefinition REVERSE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("reverse", ModelType.BOOLEAN, true).setAllowExpression(true)).setDefaultValue(new ModelNode(false))).setRestartAllServices()).build();
    static final SimpleAttributeDefinition CONVERT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("convert", ModelType.BOOLEAN, true).setAllowExpression(true)).setDefaultValue(new ModelNode(false))).setRestartAllServices()).build();
    static final StringListAttributeDefinition REQUIRED_OIDS = ((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)new StringListAttributeDefinition.Builder("required-oids").setRequired(false)).setAllowExpression(true)).setMinSize(1)).setRestartAllServices()).build();
    static final StringListAttributeDefinition REQUIRED_ATTRIBUTES = ((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)new StringListAttributeDefinition.Builder("required-attributes").setRequired(false)).setMinSize(1)).setRestartAllServices()).build();
    static final SimpleAttributeDefinition CONSTANT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("constant", ModelType.STRING, false).setAllowExpression(true)).setMinSize(1)).setRestartAllServices()).build();
    static final StringListAttributeDefinition PRINCIPAL_DECODERS = ((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)new StringListAttributeDefinition.Builder("principal-decoders").setMinSize(2)).setRequired(true)).setCapabilityReference(Capabilities.PRINCIPAL_DECODER_RUNTIME_CAPABILITY.getName(), Capabilities.PRINCIPAL_DECODER_RUNTIME_CAPABILITY.getName(), true)).setAttributeParser(AttributeParsers.STRING_LIST_NAMED_ELEMENT)).setAttributeMarshaller(AttributeMarshallers.STRING_LIST_NAMED_ELEMENT)).setXmlName("principal-decoder")).setRestartAllServices()).build();
    private static final AggregateComponentDefinition<PrincipalDecoder> AGGREGATE_PRINCIPAL_DECODER = AggregateComponentDefinition.create(PrincipalDecoder.class, "aggregate-principal-decoder", "principal-decoders", Capabilities.PRINCIPAL_DECODER_RUNTIME_CAPABILITY, PrincipalDecoder::aggregate);

    PrincipalDecoderDefinitions() {
    }

    static AggregateComponentDefinition<PrincipalDecoder> getAggregatePrincipalDecoderDefinition() {
        return AGGREGATE_PRINCIPAL_DECODER;
    }

    static ResourceDefinition getConstantPrincipalDecoder() {
        AttributeDefinition[] attributes = new AttributeDefinition[]{CONSTANT};
        PrincipalDecoderAddHandler add = new PrincipalDecoderAddHandler(attributes){

            @Override
            protected TrivialService.ValueSupplier<PrincipalDecoder> getValueSupplier(ServiceBuilder<?> serviceBuilder, OperationContext context, ModelNode model) throws OperationFailedException {
                String constant = CONSTANT.resolveModelAttribute(context, model).asString();
                return () -> PrincipalDecoder.constant((String)constant);
            }
        };
        return new PrincipalDecoderResourceDefinition("constant-principal-decoder", add, attributes);
    }

    static ResourceDefinition getX500AttributePrincipalDecoder() {
        AttributeDefinition[] attributes = new AttributeDefinition[]{OID, ATTRIBUTE_NAME, JOINER, START_SEGMENT, MAXIMUM_SEGMENTS, REVERSE, CONVERT, REQUIRED_OIDS, REQUIRED_ATTRIBUTES};
        PrincipalDecoderAddHandler add = new PrincipalDecoderAddHandler(attributes){

            @Override
            protected TrivialService.ValueSupplier<PrincipalDecoder> getValueSupplier(ServiceBuilder<?> serviceBuilder, OperationContext context, ModelNode model) throws OperationFailedException {
                String oid;
                ModelNode oidNode = OID.resolveModelAttribute(context, model);
                ModelNode attributeNode = ATTRIBUTE_NAME.resolveModelAttribute(context, model);
                if (oidNode.isDefined()) {
                    oid = oidNode.asString();
                } else if (attributeNode.isDefined()) {
                    oid = OidsUtil.attributeNameToOid((OidsUtil.Category)OidsUtil.Category.RDN, (String)attributeNode.asString());
                    if (oid == null) {
                        throw ElytronSubsystemMessages.ROOT_LOGGER.unableToObtainOidForX500Attribute(attributeNode.asString());
                    }
                } else {
                    throw ElytronSubsystemMessages.ROOT_LOGGER.x500AttributeMustBeDefined();
                }
                String joiner = JOINER.resolveModelAttribute(context, model).asString();
                int startSegment = START_SEGMENT.resolveModelAttribute(context, model).asInt();
                int maximumSegments = MAXIMUM_SEGMENTS.resolveModelAttribute(context, model).asInt();
                boolean reverse = REVERSE.resolveModelAttribute(context, model).asBoolean();
                boolean convert = CONVERT.resolveModelAttribute(context, model).asBoolean();
                List requiredOids = REQUIRED_OIDS.unwrap((ExpressionResolver)context, model);
                ArrayList<String> list = new ArrayList<String>();
                for (String name : REQUIRED_ATTRIBUTES.unwrap((ExpressionResolver)context, model)) {
                    String s = OidsUtil.attributeNameToOid((OidsUtil.Category)OidsUtil.Category.RDN, (String)name);
                    list.add(s);
                }
                requiredOids.addAll(list);
                return () -> new X500AttributePrincipalDecoder(oid, joiner, startSegment, maximumSegments, reverse, convert, requiredOids.toArray(new String[requiredOids.size()]));
            }
        };
        return new PrincipalDecoderResourceDefinition("x500-attribute-principal-decoder", add, attributes);
    }

    static ResourceDefinition getConcatenatingPrincipalDecoder() {
        AttributeDefinition[] attributes = new AttributeDefinition[]{JOINER, PRINCIPAL_DECODERS};
        PrincipalDecoderAddHandler add = new PrincipalDecoderAddHandler(attributes){

            @Override
            protected TrivialService.ValueSupplier<PrincipalDecoder> getValueSupplier(ServiceBuilder<?> serviceBuilder, OperationContext context, ModelNode model) throws OperationFailedException {
                String joiner = JOINER.resolveModelAttribute(context, model).asString();
                List decoders = PRINCIPAL_DECODERS.unwrap((ExpressionResolver)context, model);
                ArrayList<InjectedValue> principalDecoderInjectors = new ArrayList<InjectedValue>();
                String baseCapabilityName = Capabilities.PRINCIPAL_DECODER_RUNTIME_CAPABILITY.getName();
                for (String decoder : decoders) {
                    InjectedValue principalDecoderInjector = new InjectedValue();
                    String runtimeCapabilityName = RuntimeCapability.buildDynamicCapabilityName((String)baseCapabilityName, (String)decoder);
                    ServiceName decoderServiceName = context.getCapabilityServiceName(runtimeCapabilityName, PrincipalDecoder.class);
                    serviceBuilder.addDependency(decoderServiceName, PrincipalDecoder.class, (Injector)principalDecoderInjector);
                    principalDecoderInjectors.add(principalDecoderInjector);
                }
                return () -> {
                    ArrayList<Object> principalDecoders = new ArrayList<Object>(principalDecoderInjectors.size());
                    for (InjectedValue current : principalDecoderInjectors) {
                        principalDecoders.add(current.getValue());
                    }
                    return PrincipalDecoder.concatenating((String)joiner, (PrincipalDecoder[])principalDecoders.toArray(new PrincipalDecoder[principalDecoders.size()]));
                };
            }
        };
        return new PrincipalDecoderResourceDefinition("concatenating-principal-decoder", add, attributes);
    }

    private static class PrincipalDecoderAddHandler
    extends BaseAddHandler {
        private static final Set<RuntimeCapability> CAPABILITIES;

        private PrincipalDecoderAddHandler(AttributeDefinition ... attributes) {
            super(CAPABILITIES, attributes);
        }

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            RuntimeCapability decoderRuntimeCapability = Capabilities.PRINCIPAL_DECODER_RUNTIME_CAPABILITY.fromBaseCapability(context.getCurrentAddressValue());
            ServiceName decoderName = decoderRuntimeCapability.getCapabilityServiceName(PrincipalDecoder.class);
            ServiceTarget serviceTarget = context.getServiceTarget();
            TrivialService<PrincipalDecoder> principalDecoderService = new TrivialService<PrincipalDecoder>();
            ServiceBuilder decoderBuilder = serviceTarget.addService(decoderName, principalDecoderService);
            principalDecoderService.setValueSupplier(this.getValueSupplier(decoderBuilder, context, model));
            ElytronDefinition.commonDependencies(decoderBuilder).setInitialMode(ServiceController.Mode.LAZY).install();
            InjectedValue injectedDecoder = new InjectedValue();
            TrivialService<PrincipalTransformer> transformerService = new TrivialService<PrincipalTransformer>(() -> PrincipalTransformer.from(((PrincipalDecoder)injectedDecoder.getValue()).asPrincipalRewriter()));
            RuntimeCapability transformerRuntimeCapability = Capabilities.PRINCIPAL_TRANSFORMER_RUNTIME_CAPABILITY.fromBaseCapability(context.getCurrentAddressValue());
            ServiceName transformerName = transformerRuntimeCapability.getCapabilityServiceName(PrincipalTransformer.class);
            serviceTarget.addService(transformerName, transformerService).addDependency(decoderName, PrincipalDecoder.class, (Injector)injectedDecoder).setInitialMode(ServiceController.Mode.LAZY).install();
        }

        protected TrivialService.ValueSupplier<PrincipalDecoder> getValueSupplier(ServiceBuilder<?> serviceBuilder, OperationContext context, ModelNode model) throws OperationFailedException {
            return () -> null;
        }

        static {
            HashSet<RuntimeCapability> capabilities = new HashSet<RuntimeCapability>(2);
            capabilities.add(Capabilities.PRINCIPAL_DECODER_RUNTIME_CAPABILITY);
            capabilities.add(Capabilities.PRINCIPAL_TRANSFORMER_RUNTIME_CAPABILITY);
            CAPABILITIES = capabilities;
        }
    }

    private static class PrincipalDecoderResourceDefinition
    extends SimpleResourceDefinition {
        private final String pathKey;
        private final AttributeDefinition[] attributes;

        PrincipalDecoderResourceDefinition(String pathKey, AbstractAddStepHandler add, AttributeDefinition ... attributes) {
            super(new SimpleResourceDefinition.Parameters(PathElement.pathElement((String)pathKey), (ResourceDescriptionResolver)ElytronExtension.getResourceDescriptionResolver(pathKey)).setAddHandler((OperationStepHandler)add).setRemoveHandler((OperationStepHandler)new TrivialCapabilityServiceRemoveHandler(add, Capabilities.PRINCIPAL_DECODER_RUNTIME_CAPABILITY, Capabilities.PRINCIPAL_TRANSFORMER_RUNTIME_CAPABILITY)).setAddRestartLevel(OperationEntry.Flag.RESTART_RESOURCE_SERVICES).setRemoveRestartLevel(OperationEntry.Flag.RESTART_RESOURCE_SERVICES).setCapabilities(new RuntimeCapability[]{Capabilities.PRINCIPAL_DECODER_RUNTIME_CAPABILITY, Capabilities.PRINCIPAL_TRANSFORMER_RUNTIME_CAPABILITY}));
            this.pathKey = pathKey;
            this.attributes = attributes;
        }

        public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
            if (this.attributes != null && this.attributes.length > 0) {
                ElytronReloadRequiredWriteAttributeHandler write = new ElytronReloadRequiredWriteAttributeHandler(this.attributes);
                for (AttributeDefinition current : this.attributes) {
                    resourceRegistration.registerReadWriteAttribute(current, null, (OperationStepHandler)write);
                }
            }
        }
    }
}

