/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ObjectTypeAttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleMapAttributeDefinition;
import org.jboss.as.controller.SimpleOperationDefinition;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.StandardResourceDescriptionResolver;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.security.CredentialReference;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.as.controller.services.path.PathManagerService;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartException;
import org.wildfly.extension.elytron.BaseAddHandler;
import org.wildfly.extension.elytron.Capabilities;
import org.wildfly.extension.elytron.CredentialStoreService;
import org.wildfly.extension.elytron.ElytronDefinition;
import org.wildfly.extension.elytron.ElytronExtension;
import org.wildfly.extension.elytron.ElytronReloadRequiredWriteAttributeHandler;
import org.wildfly.extension.elytron.ElytronRuntimeOnlyHandler;
import org.wildfly.extension.elytron.FileAttributeDefinitions;
import org.wildfly.extension.elytron.ServiceStateDefinition;
import org.wildfly.extension.elytron.ServiceUtil;
import org.wildfly.extension.elytron.TrivialCapabilityServiceRemoveHandler;
import org.wildfly.extension.elytron._private.ElytronSubsystemMessages;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.credential.store.CredentialStore;
import org.wildfly.security.credential.store.CredentialStoreException;
import org.wildfly.security.credential.store.UnsupportedCredentialTypeException;
import org.wildfly.security.password.PasswordFactory;
import org.wildfly.security.password.spec.ClearPasswordSpec;

final class CredentialStoreResourceDefinition
extends SimpleResourceDefinition {
    static final ServiceUtil<CredentialStore> CREDENTIAL_STORE_UTIL = ServiceUtil.newInstance(Capabilities.CREDENTIAL_STORE_RUNTIME_CAPABILITY, "credential-store", CredentialStore.class);
    static final SimpleAttributeDefinition LOCATION = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("location", ModelType.STRING, true).setAttributeGroup("implementation")).setAllowExpression(true)).setMinSize(1)).setRestartAllServices()).build();
    static final SimpleAttributeDefinition MODIFIABLE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("modifiable", ModelType.BOOLEAN, true).setAttributeGroup("implementation")).setDefaultValue(new ModelNode(true))).setAllowExpression(false)).setRestartAllServices()).build();
    static final SimpleAttributeDefinition CREATE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("create", ModelType.BOOLEAN, true).setAttributeGroup("implementation")).setAllowExpression(false)).setDefaultValue(new ModelNode(false))).setRestartAllServices()).build();
    static final SimpleMapAttributeDefinition IMPLEMENTATION_PROPERTIES = ((SimpleMapAttributeDefinition.Builder)((SimpleMapAttributeDefinition.Builder)((SimpleMapAttributeDefinition.Builder)new SimpleMapAttributeDefinition.Builder("implementation-properties", ModelType.STRING, true).setAttributeGroup("implementation")).setAllowExpression(true)).setRestartAllServices()).build();
    static final ObjectTypeAttributeDefinition CREDENTIAL_REFERENCE = CredentialReference.getAttributeDefinition((boolean)true);
    static final SimpleAttributeDefinition TYPE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("type", ModelType.STRING, true).setAttributeGroup("implementation")).setAllowExpression(true)).setMinSize(1)).setRestartAllServices()).build();
    static final SimpleAttributeDefinition PROVIDER_NAME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("provider-name", ModelType.STRING, true).setAttributeGroup("implementation")).setAllowExpression(true)).setMinSize(1)).setRestartAllServices()).build();
    static final SimpleAttributeDefinition PROVIDERS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("providers", ModelType.STRING, true).setAttributeGroup("implementation")).setAllowExpression(false)).setMinSize(1)).setRestartAllServices()).setCapabilityReference("org.wildfly.security.providers", "org.wildfly.security.credential-store", true)).build();
    static final SimpleAttributeDefinition OTHER_PROVIDERS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("other-providers", ModelType.STRING, true).setAttributeGroup("implementation")).setAllowExpression(false)).setMinSize(1)).setRestartAllServices()).setCapabilityReference("org.wildfly.security.providers", "org.wildfly.security.credential-store", true)).build();
    static final SimpleAttributeDefinition RELATIVE_TO = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("relative-to", ModelType.STRING, true).setAllowExpression(false)).setMinSize(1)).setAttributeGroup("file")).setRestartAllServices()).build();
    private static final StandardResourceDescriptionResolver RESOURCE_RESOLVER = ElytronExtension.getResourceDescriptionResolver("credential-store");
    static final SimpleAttributeDefinition ALIAS = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("alias", ModelType.STRING, false).setMinSize(1)).build();
    private static final Class<?>[] SUPPORTED_CREDENTIAL_TYPES = new Class[]{PasswordCredential.class};
    static final SimpleAttributeDefinition ENTRY_TYPE;
    static final SimpleAttributeDefinition SECRET_VALUE;
    private static final SimpleOperationDefinition RELOAD;
    private static final SimpleOperationDefinition READ_ALIASES;
    private static final SimpleOperationDefinition ADD_ALIAS;
    private static final SimpleOperationDefinition REMOVE_ALIAS;
    private static final SimpleOperationDefinition SET_SECRET;
    private static final AttributeDefinition[] CONFIG_ATTRIBUTES;
    private static final CredentialStoreAddHandler ADD;
    private static final OperationStepHandler REMOVE;

    CredentialStoreResourceDefinition() {
        super(new SimpleResourceDefinition.Parameters(PathElement.pathElement((String)"credential-store"), (ResourceDescriptionResolver)RESOURCE_RESOLVER).setAddHandler((OperationStepHandler)ADD).setRemoveHandler(REMOVE).setAddRestartLevel(OperationEntry.Flag.RESTART_NONE).setRemoveRestartLevel(OperationEntry.Flag.RESTART_NONE).setCapabilities(new RuntimeCapability[]{Capabilities.CREDENTIAL_STORE_RUNTIME_CAPABILITY}));
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        ElytronReloadRequiredWriteAttributeHandler write = new ElytronReloadRequiredWriteAttributeHandler(CONFIG_ATTRIBUTES);
        for (AttributeDefinition current : CONFIG_ATTRIBUTES) {
            resourceRegistration.registerReadWriteAttribute(current, null, (OperationStepHandler)write);
        }
        if (ElytronExtension.isServerOrHostController((ImmutableManagementResourceRegistration)resourceRegistration)) {
            resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)ServiceStateDefinition.STATE, (OperationStepHandler)new ElytronRuntimeOnlyHandler(){

                protected void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
                    ServiceName credentialStoreClientServiceName = CREDENTIAL_STORE_UTIL.serviceName(operation);
                    ServiceController serviceController = context.getServiceRegistry(false).getRequiredService(credentialStoreClientServiceName);
                    ServiceStateDefinition.populateResponse(context.getResult(), serviceController);
                }
            });
        }
    }

    public void registerOperations(ManagementResourceRegistration resourceRegistration) {
        super.registerOperations(resourceRegistration);
        resourceRegistration.registerOperationHandler((OperationDefinition)RELOAD, (OperationStepHandler)CredentialStoreHandler.INSTANCE);
        resourceRegistration.registerOperationHandler((OperationDefinition)READ_ALIASES, (OperationStepHandler)CredentialStoreReadAliasesHandler.INSTANCE);
        if (ElytronExtension.isServerOrHostController((ImmutableManagementResourceRegistration)resourceRegistration)) {
            resourceRegistration.registerOperationHandler((OperationDefinition)ADD_ALIAS, (OperationStepHandler)CredentialStoreHandler.INSTANCE);
            resourceRegistration.registerOperationHandler((OperationDefinition)REMOVE_ALIAS, (OperationStepHandler)CredentialStoreHandler.INSTANCE);
            resourceRegistration.registerOperationHandler((OperationDefinition)SET_SECRET, (OperationStepHandler)CredentialStoreHandler.INSTANCE);
        }
    }

    static String credentialStoreName(ModelNode operation) {
        String credentialStoreName = null;
        PathAddress pa = PathAddress.pathAddress((ModelNode)operation.require("address"));
        for (int i = pa.size() - 1; i > 0; --i) {
            PathElement pe = pa.getElement(i);
            if (!"credential-store".equals(pe.getKey())) continue;
            credentialStoreName = pe.getValue();
            break;
        }
        if (credentialStoreName == null) {
            throw ElytronSubsystemMessages.ROOT_LOGGER.operationAddressMissingKey("credential-store");
        }
        return credentialStoreName;
    }

    private static PasswordCredential createCredentialFromPassword(char[] password) throws UnsupportedCredentialTypeException {
        try {
            PasswordFactory passwordFactory = PasswordFactory.getInstance((String)"clear");
            return new PasswordCredential(passwordFactory.generatePassword((KeySpec)new ClearPasswordSpec(password)));
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new UnsupportedCredentialTypeException((Throwable)e);
        }
    }

    private static void storeSecret(CredentialStore credentialStore, String alias, String secretValue) throws CredentialStoreException {
        char[] secret = secretValue != null ? secretValue.toCharArray() : new char[]{};
        credentialStore.store(alias, (Credential)CredentialStoreResourceDefinition.createCredentialFromPassword(secret));
        try {
            credentialStore.flush();
        }
        catch (CredentialStoreException e) {
            credentialStore.remove(alias, PasswordCredential.class);
            throw e;
        }
    }

    private static String dumpCause(Throwable e) {
        StringBuffer sb = new StringBuffer().append(e.getLocalizedMessage());
        Throwable c = e.getCause();
        int depth = 0;
        while (c != null && depth++ < 10) {
            sb.append("->").append(c.getLocalizedMessage());
            c = c.getCause() == c ? null : c.getCause();
        }
        return sb.toString();
    }

    static {
        ArrayList<String> entryTypes = new ArrayList<String>();
        for (Class<?> SUPPORTED_CREDENTIAL_TYPE : SUPPORTED_CREDENTIAL_TYPES) {
            String canonicalName = SUPPORTED_CREDENTIAL_TYPE.getCanonicalName();
            entryTypes.add(canonicalName);
        }
        ENTRY_TYPE = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("entry-type", ModelType.STRING, true).setAllowedValues(entryTypes.toArray(new String[entryTypes.size()]))).build();
        SECRET_VALUE = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("secret-value", ModelType.STRING, true).setMinSize(0)).build();
        RELOAD = new SimpleOperationDefinitionBuilder("reload", (ResourceDescriptionResolver)RESOURCE_RESOLVER).setRuntimeOnly().build();
        READ_ALIASES = new SimpleOperationDefinitionBuilder("read-aliases", (ResourceDescriptionResolver)RESOURCE_RESOLVER).setRuntimeOnly().setReadOnly().build();
        ADD_ALIAS = new SimpleOperationDefinitionBuilder("add-alias", (ResourceDescriptionResolver)RESOURCE_RESOLVER).setParameters(new AttributeDefinition[]{ALIAS, ENTRY_TYPE, SECRET_VALUE}).setRuntimeOnly().build();
        REMOVE_ALIAS = new SimpleOperationDefinitionBuilder("remove-alias", (ResourceDescriptionResolver)RESOURCE_RESOLVER).setParameters(new AttributeDefinition[]{ALIAS}).setRuntimeOnly().build();
        SET_SECRET = new SimpleOperationDefinitionBuilder("set-secret", (ResourceDescriptionResolver)RESOURCE_RESOLVER).setParameters(new AttributeDefinition[]{ALIAS, ENTRY_TYPE, SECRET_VALUE}).setRuntimeOnly().build();
        CONFIG_ATTRIBUTES = new AttributeDefinition[]{LOCATION, CREATE, MODIFIABLE, IMPLEMENTATION_PROPERTIES, CREDENTIAL_REFERENCE, TYPE, PROVIDER_NAME, PROVIDERS, OTHER_PROVIDERS, RELATIVE_TO};
        ADD = new CredentialStoreAddHandler();
        REMOVE = new TrivialCapabilityServiceRemoveHandler(ADD, Capabilities.CREDENTIAL_STORE_RUNTIME_CAPABILITY);
    }

    private static class CredentialStoreReadAliasesHandler
    extends CredentialStoreRuntimeOnlyHandler {
        private static final CredentialStoreReadAliasesHandler INSTANCE = new CredentialStoreReadAliasesHandler();

        private CredentialStoreReadAliasesHandler() {
            super(true);
        }

        @Override
        protected void performRuntime(ModelNode result, OperationContext context, ModelNode operation, CredentialStoreService credentialStoreService) throws OperationFailedException {
            try {
                ArrayList<ModelNode> list = new ArrayList<ModelNode>();
                for (String s : credentialStoreService.getValue().getAliases()) {
                    ModelNode modelNode = new ModelNode(s);
                    list.add(modelNode);
                }
                result.set(list);
            }
            catch (CredentialStoreException e) {
                throw ElytronSubsystemMessages.ROOT_LOGGER.unableToCompleteOperation(e, CredentialStoreResourceDefinition.dumpCause(e));
            }
        }
    }

    private static class CredentialStoreHandler
    extends CredentialStoreRuntimeOnlyHandler {
        private static final CredentialStoreHandler INSTANCE = new CredentialStoreHandler();

        private CredentialStoreHandler() {
            super(true, true);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        protected void performRuntime(ModelNode result, OperationContext context, ModelNode operation, CredentialStoreService credentialStoreService) throws OperationFailedException {
            String operationName;
            switch (operationName = operation.require("operation").asString()) {
                case "reload": {
                    try {
                        credentialStoreService.stop(null);
                        credentialStoreService.start(null);
                        return;
                    }
                    catch (StartException e) {
                        throw ElytronSubsystemMessages.ROOT_LOGGER.unableToCompleteOperation(e, CredentialStoreResourceDefinition.dumpCause(e));
                    }
                }
                case "add-alias": {
                    try {
                        String alias = ALIAS.resolveModelAttribute(context, operation).asString();
                        String entryType = ElytronExtension.asStringIfDefined(context, (AttributeDefinition)ENTRY_TYPE, operation);
                        String secretValue = ElytronExtension.asStringIfDefined(context, (AttributeDefinition)SECRET_VALUE, operation);
                        CredentialStore credentialStore = credentialStoreService.getValue();
                        if (entryType == null || entryType.equals(PasswordCredential.class.getCanonicalName())) {
                            if (credentialStore.exists(alias, PasswordCredential.class)) {
                                throw ElytronSubsystemMessages.ROOT_LOGGER.credentialAlreadyExists(alias, PasswordCredential.class.getName());
                            }
                        } else {
                            String credentialStoreName = CredentialStoreResourceDefinition.credentialStoreName(operation);
                            throw ElytronSubsystemMessages.ROOT_LOGGER.credentialStoreEntryTypeNotSupported(credentialStoreName, entryType);
                        }
                        CredentialStoreResourceDefinition.storeSecret(credentialStore, alias, secretValue);
                        return;
                    }
                    catch (CredentialStoreException e) {
                        throw ElytronSubsystemMessages.ROOT_LOGGER.unableToCompleteOperation(e, CredentialStoreResourceDefinition.dumpCause(e));
                    }
                }
                case "remove-alias": {
                    try {
                        String alias = ALIAS.resolveModelAttribute(context, operation).asString();
                        CredentialStore credentialStore = credentialStoreService.getValue();
                        PasswordCredential retrieved = (PasswordCredential)credentialStore.retrieve(alias, PasswordCredential.class);
                        if (retrieved == null) {
                            throw ElytronSubsystemMessages.ROOT_LOGGER.credentialDoesNotExist(alias, PasswordCredential.class.getName());
                        }
                        credentialStore.remove(alias, PasswordCredential.class);
                        context.addResponseWarning(Level.WARNING, ElytronSubsystemMessages.ROOT_LOGGER.updateDependantServices(alias));
                        try {
                            credentialStore.flush();
                            return;
                        }
                        catch (CredentialStoreException e) {
                            credentialStore.store(alias, (Credential)retrieved);
                            throw e;
                        }
                    }
                    catch (CredentialStoreException e) {
                        throw ElytronSubsystemMessages.ROOT_LOGGER.unableToCompleteOperation(e, CredentialStoreResourceDefinition.dumpCause(e));
                    }
                }
                case "set-secret": {
                    try {
                        String alias = ALIAS.resolveModelAttribute(context, operation).asString();
                        String entryType = ElytronExtension.asStringIfDefined(context, (AttributeDefinition)ENTRY_TYPE, operation);
                        String secretValue = ElytronExtension.asStringIfDefined(context, (AttributeDefinition)SECRET_VALUE, operation);
                        CredentialStore credentialStore = credentialStoreService.getValue();
                        if (entryType == null || entryType.equals(PasswordCredential.class.getCanonicalName())) {
                            if (!credentialStore.exists(alias, PasswordCredential.class)) {
                                throw ElytronSubsystemMessages.ROOT_LOGGER.credentialDoesNotExist(alias, PasswordCredential.class.getName());
                            }
                        } else {
                            String credentialStoreName = CredentialStoreResourceDefinition.credentialStoreName(operation);
                            throw ElytronSubsystemMessages.ROOT_LOGGER.credentialStoreEntryTypeNotSupported(credentialStoreName, entryType);
                        }
                        CredentialStoreResourceDefinition.storeSecret(credentialStore, alias, secretValue);
                        context.addResponseWarning(Level.WARNING, ElytronSubsystemMessages.ROOT_LOGGER.reloadDependantServices());
                        return;
                    }
                    catch (CredentialStoreException e) {
                        throw ElytronSubsystemMessages.ROOT_LOGGER.unableToCompleteOperation(e, CredentialStoreResourceDefinition.dumpCause(e));
                    }
                }
                default: {
                    throw ElytronSubsystemMessages.ROOT_LOGGER.invalidOperationName(operationName, "load");
                }
            }
        }
    }

    static abstract class CredentialStoreRuntimeOnlyHandler
    extends ElytronRuntimeOnlyHandler {
        private final boolean serviceMustBeUp;
        private final boolean writeAccess;

        CredentialStoreRuntimeOnlyHandler(boolean serviceMustBeUp, boolean writeAccess) {
            this.serviceMustBeUp = serviceMustBeUp;
            this.writeAccess = writeAccess;
        }

        CredentialStoreRuntimeOnlyHandler(boolean serviceMustBeUp) {
            this(serviceMustBeUp, false);
        }

        protected void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
            ServiceName credentialStoreServiceName = CREDENTIAL_STORE_UTIL.serviceName(operation);
            ServiceController credentialStoreServiceController = context.getServiceRegistry(this.writeAccess).getRequiredService(credentialStoreServiceName);
            ServiceController.State serviceState = credentialStoreServiceController.getState();
            if (serviceState != ServiceController.State.UP) {
                if (this.serviceMustBeUp) {
                    try {
                        credentialStoreServiceController.awaitValue(500L, TimeUnit.MILLISECONDS);
                    }
                    catch (IllegalStateException | InterruptedException | TimeoutException e) {
                        throw ElytronSubsystemMessages.ROOT_LOGGER.requiredServiceNotUp(credentialStoreServiceName, credentialStoreServiceController.getState());
                    }
                }
                if ((serviceState = credentialStoreServiceController.getState()) != ServiceController.State.UP) {
                    if (this.serviceMustBeUp) {
                        throw ElytronSubsystemMessages.ROOT_LOGGER.requiredServiceNotUp(credentialStoreServiceName, serviceState);
                    }
                    return;
                }
            }
            CredentialStoreService service = (CredentialStoreService)credentialStoreServiceController.getService();
            this.performRuntime(context.getResult(), context, operation, service);
        }

        protected abstract void performRuntime(ModelNode var1, OperationContext var2, ModelNode var3, CredentialStoreService var4) throws OperationFailedException;
    }

    private static class CredentialStoreAddHandler
    extends BaseAddHandler {
        private CredentialStoreAddHandler() {
            super(Capabilities.CREDENTIAL_STORE_RUNTIME_CAPABILITY, CONFIG_ATTRIBUTES);
        }

        protected void performRuntime(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
            String providersCapabilityName;
            CredentialStoreService csService;
            HashMap<String, String> implementationAttributes;
            ModelNode model = resource.getModel();
            String location = ElytronExtension.asStringIfDefined(context, (AttributeDefinition)LOCATION, model);
            boolean modifiable = MODIFIABLE.resolveModelAttribute(context, model).asBoolean();
            boolean create = CREATE.resolveModelAttribute(context, model).asBoolean();
            ModelNode implAttrModel = IMPLEMENTATION_PROPERTIES.resolveModelAttribute(context, model);
            if (implAttrModel.isDefined()) {
                implementationAttributes = new HashMap<String, String>();
                for (String s : implAttrModel.keys()) {
                    implementationAttributes.put(s, implAttrModel.require(s).asString());
                }
            } else {
                implementationAttributes = null;
            }
            String type = ElytronExtension.asStringIfDefined(context, (AttributeDefinition)TYPE, model);
            String providers = ElytronExtension.asStringIfDefined(context, (AttributeDefinition)PROVIDERS, model);
            String otherProviders = ElytronExtension.asStringIfDefined(context, (AttributeDefinition)OTHER_PROVIDERS, model);
            String providerName = ElytronExtension.asStringIfDefined(context, (AttributeDefinition)PROVIDER_NAME, model);
            String name = CredentialStoreResourceDefinition.credentialStoreName(operation);
            String relativeTo = ElytronExtension.asStringIfDefined(context, (AttributeDefinition)RELATIVE_TO, model);
            ServiceTarget serviceTarget = context.getServiceTarget();
            try {
                csService = CredentialStoreService.createCredentialStoreService(name, location, modifiable, create, implementationAttributes, type, providerName, relativeTo, providers, otherProviders);
            }
            catch (CredentialStoreException e) {
                throw new OperationFailedException((Throwable)e);
            }
            ServiceName credentialStoreServiceName = CREDENTIAL_STORE_UTIL.serviceName(operation);
            ServiceBuilder credentialStoreServiceBuilder = serviceTarget.addService(credentialStoreServiceName, (Service)csService).setInitialMode(ServiceController.Mode.ACTIVE);
            if (relativeTo != null) {
                credentialStoreServiceBuilder.addDependency(PathManagerService.SERVICE_NAME, PathManager.class, csService.getPathManagerInjector());
                credentialStoreServiceBuilder.addDependency(FileAttributeDefinitions.pathName(relativeTo));
            }
            if (providers != null) {
                providersCapabilityName = RuntimeCapability.buildDynamicCapabilityName((String)"org.wildfly.security.providers", (String)providers);
                ServiceName providerLoaderServiceName = context.getCapabilityServiceName(providersCapabilityName, Provider[].class);
                credentialStoreServiceBuilder.addDependency(providerLoaderServiceName, Provider[].class, csService.getProvidersInjector());
            }
            if (otherProviders != null) {
                providersCapabilityName = RuntimeCapability.buildDynamicCapabilityName((String)"org.wildfly.security.providers", (String)otherProviders);
                ServiceName otherProvidersLoaderServiceName = context.getCapabilityServiceName(providersCapabilityName, Provider[].class);
                credentialStoreServiceBuilder.addDependency(otherProvidersLoaderServiceName, Provider[].class, csService.getOtherProvidersInjector());
            }
            csService.getCredentialSourceSupplierInjector().inject((Object)CredentialReference.getCredentialSourceSupplier((OperationContext)context, (ObjectTypeAttributeDefinition)CREDENTIAL_REFERENCE, (ModelNode)model, (ServiceBuilder)credentialStoreServiceBuilder));
            ElytronDefinition.commonDependencies(credentialStoreServiceBuilder).install();
        }
    }
}

