/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.SSLContext;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ListAttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.operations.validation.IntRangeValidator;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.as.controller.services.path.PathManagerService;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartException;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.common.function.ExceptionBiConsumer;
import org.wildfly.extension.elytron.AggregateComponentDefinition;
import org.wildfly.extension.elytron.Capabilities;
import org.wildfly.extension.elytron.ElytronExtension;
import org.wildfly.extension.elytron.FileAttributeDefinitions;
import org.wildfly.extension.elytron.TrivialAddHandler;
import org.wildfly.extension.elytron.TrivialResourceDefinition;
import org.wildfly.extension.elytron.TrivialService;
import org.wildfly.extension.elytron._private.ElytronSubsystemMessages;
import org.wildfly.extension.elytron.capabilities._private.SecurityEventListener;
import org.wildfly.security.audit.AuditEndpoint;
import org.wildfly.security.audit.AuditLogger;
import org.wildfly.security.audit.EventPriority;
import org.wildfly.security.audit.FileAuditEndpoint;
import org.wildfly.security.audit.JsonSecurityEventFormatter;
import org.wildfly.security.audit.PeriodicRotatingFileAuditEndpoint;
import org.wildfly.security.audit.SimpleSecurityEventFormatter;
import org.wildfly.security.audit.SizeRotatingFileAuditEndpoint;
import org.wildfly.security.audit.SyslogAuditEndpoint;
import org.wildfly.security.auth.server.event.SecurityEventVisitor;

class AuditResourceDefinitions {
    static final SimpleAttributeDefinition PATH = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(FileAttributeDefinitions.PATH).setRequired(true)).setRestartAllServices()).build();
    static final SimpleAttributeDefinition SYNCHRONIZED = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("synchronized", ModelType.BOOLEAN, true).setAllowExpression(true)).setDefaultValue(new ModelNode(true))).setRestartAllServices()).build();
    static final SimpleAttributeDefinition FORMAT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("format", ModelType.STRING, true).setAllowExpression(true)).setDefaultValue(new ModelNode(Format.SIMPLE.toString()))).setAllowedValues(new String[]{Format.SIMPLE.toString(), Format.JSON.toString()})).setRestartAllServices()).build();
    static final SimpleAttributeDefinition SERVER_ADDRESS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("server-address", ModelType.STRING, false).setAllowExpression(true)).setRestartAllServices()).build();
    static final SimpleAttributeDefinition PORT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("port", ModelType.INT, false).setAllowExpression(true)).setRestartAllServices()).build();
    static final SimpleAttributeDefinition TRANSPORT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("transport", ModelType.STRING, true).setAllowExpression(true)).setDefaultValue(new ModelNode(Transport.TCP.toString()))).setAllowedValues(new String[]{Transport.TCP.toString(), Transport.UDP.toString(), Transport.SSL_TCP.toString()})).setRestartAllServices()).build();
    static final SimpleAttributeDefinition HOST_NAME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("host-name", ModelType.STRING, false).setAllowExpression(true)).setRestartAllServices()).build();
    static final SimpleAttributeDefinition MAX_BACKUP_INDEX = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("max-backup-index", ModelType.INT, true).setAllowExpression(true)).setDefaultValue(new ModelNode(1))).setValidator((ParameterValidator)new IntRangeValidator(1, true))).setRestartAllServices()).build();
    static final SimpleAttributeDefinition ROTATE_ON_BOOT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("rotate-on-boot", ModelType.BOOLEAN, true).setAllowExpression(true)).setDefaultValue(new ModelNode(false))).setRestartAllServices()).build();
    static final SimpleAttributeDefinition ROTATE_SIZE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("rotate-size", ModelType.STRING, true).setAllowExpression(true)).setValidator((ParameterValidator)new SizeValidator())).setDefaultValue(new ModelNode("10m"))).setRestartAllServices()).build();
    static final SimpleAttributeDefinition SIZE_SUFFIX = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("suffix", ModelType.STRING, true).setAllowExpression(true)).setRestartAllServices()).build();
    static final SimpleAttributeDefinition PERIODIC_SUFFIX = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("suffix", ModelType.STRING).setAllowExpression(true)).setRequired(true)).setValidator((ParameterValidator)new SuffixValidator())).setRestartAllServices()).build();
    static final SimpleAttributeDefinition SSL_CONTEXT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("ssl-context", ModelType.STRING, true).setAllowExpression(false)).setRestartAllServices()).setCapabilityReference("org.wildfly.security.ssl-context", "org.wildfly.security.security-event-listener", true)).build();
    private static final AggregateComponentDefinition<SecurityEventListener> AGGREGATE_SECURITY_EVENT_LISTENER = AggregateComponentDefinition.create(SecurityEventListener.class, "aggregate-security-event-listener", "security-event-listeners", Capabilities.SECURITY_EVENT_LISTENER_RUNTIME_CAPABILITY, SecurityEventListener::aggregate, false);
    static final ListAttributeDefinition REFERENCES = AGGREGATE_SECURITY_EVENT_LISTENER.getReferencesAttribute();
    static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";

    AuditResourceDefinitions() {
    }

    static AggregateComponentDefinition<SecurityEventListener> getAggregateSecurityEventListenerDefinition() {
        return AGGREGATE_SECURITY_EVENT_LISTENER;
    }

    static ResourceDefinition getFileAuditLogResourceDefinition() {
        AttributeDefinition[] attributes = new AttributeDefinition[]{PATH, FileAttributeDefinitions.RELATIVE_TO, SYNCHRONIZED, FORMAT};
        TrivialAddHandler<SecurityEventListener> add = new TrivialAddHandler<SecurityEventListener>(SecurityEventListener.class, attributes, Capabilities.SECURITY_EVENT_LISTENER_RUNTIME_CAPABILITY){

            @Override
            protected TrivialService.ValueSupplier<SecurityEventListener> getValueSupplier(ServiceBuilder<SecurityEventListener> serviceBuilder, OperationContext context, ModelNode model) throws OperationFailedException {
                final boolean synv = SYNCHRONIZED.resolveModelAttribute(context, model).asBoolean();
                final Format format = Format.valueOf(FORMAT.resolveModelAttribute(context, model).asString());
                final InjectedValue pathManager = new InjectedValue();
                final String path = PATH.resolveModelAttribute(context, model).asString();
                final String relativeTo = ElytronExtension.asStringIfDefined(context, (AttributeDefinition)FileAttributeDefinitions.RELATIVE_TO, model);
                if (relativeTo != null) {
                    serviceBuilder.addDependency(PathManagerService.SERVICE_NAME, PathManager.class, (Injector)pathManager);
                    serviceBuilder.addDependency(FileAttributeDefinitions.pathName(relativeTo));
                }
                return new EndpointClosingEventListenerSupplier(){

                    @Override
                    public SecurityEventListener get() throws StartException {
                        FileAttributeDefinitions.PathResolver pathResolver = FileAttributeDefinitions.pathResolver();
                        pathResolver.path(path);
                        if (relativeTo != null) {
                            pathResolver.relativeTo(relativeTo, (PathManager)pathManager.getValue());
                        }
                        File resolvedPath = pathResolver.resolve();
                        Supplier<DateTimeFormatter> dateTimeFormatterSupplier = () -> DateTimeFormatter.ofPattern(AuditResourceDefinitions.DATE_FORMAT).withZone(ZoneId.systemDefault());
                        SecurityEventVisitor formatter = Format.JSON == format ? JsonSecurityEventFormatter.builder().setDateTimeFormatterSupplier(dateTimeFormatterSupplier).build() : SimpleSecurityEventFormatter.builder().setDateTimeFormatterSupplier(dateTimeFormatterSupplier).build();
                        try {
                            this.endpoint = FileAuditEndpoint.builder().setLocation(resolvedPath.toPath()).setSyncOnAccept(synv).setDateTimeFormatterSupplier(dateTimeFormatterSupplier).build();
                        }
                        catch (IOException e) {
                            throw ElytronSubsystemMessages.ROOT_LOGGER.unableToStartService(e);
                        }
                        return SecurityEventListener.from(AuditLogger.builder().setPriorityMapper(m -> EventPriority.WARNING).setMessageFormatter(m -> (String)m.accept(formatter, null)).setAuditEndpoint((ExceptionBiConsumer)this.endpoint).build());
                    }
                };
            }
        };
        return new TrivialResourceDefinition("file-audit-log", add, attributes, Capabilities.SECURITY_EVENT_LISTENER_RUNTIME_CAPABILITY);
    }

    static ResourceDefinition getPeriodicRotatingFileAuditLogResourceDefinition() {
        AttributeDefinition[] attributes = new AttributeDefinition[]{PATH, FileAttributeDefinitions.RELATIVE_TO, SYNCHRONIZED, FORMAT, PERIODIC_SUFFIX};
        TrivialAddHandler<SecurityEventListener> add = new TrivialAddHandler<SecurityEventListener>(SecurityEventListener.class, attributes, Capabilities.SECURITY_EVENT_LISTENER_RUNTIME_CAPABILITY){

            @Override
            protected TrivialService.ValueSupplier<SecurityEventListener> getValueSupplier(ServiceBuilder<SecurityEventListener> serviceBuilder, OperationContext context, ModelNode model) throws OperationFailedException {
                final boolean synv = SYNCHRONIZED.resolveModelAttribute(context, model).asBoolean();
                final Format format = Format.valueOf(FORMAT.resolveModelAttribute(context, model).asString());
                final String suffix = PERIODIC_SUFFIX.resolveModelAttribute(context, model).asString();
                final InjectedValue pathManager = new InjectedValue();
                final String path = PATH.resolveModelAttribute(context, model).asString();
                final String relativeTo = ElytronExtension.asStringIfDefined(context, (AttributeDefinition)FileAttributeDefinitions.RELATIVE_TO, model);
                if (relativeTo != null) {
                    serviceBuilder.addDependency(PathManagerService.SERVICE_NAME, PathManager.class, (Injector)pathManager);
                    serviceBuilder.addDependency(FileAttributeDefinitions.pathName(relativeTo));
                }
                return new EndpointClosingEventListenerSupplier(){

                    @Override
                    public SecurityEventListener get() throws StartException {
                        FileAttributeDefinitions.PathResolver pathResolver = FileAttributeDefinitions.pathResolver();
                        pathResolver.path(path);
                        if (relativeTo != null) {
                            pathResolver.relativeTo(relativeTo, (PathManager)pathManager.getValue());
                        }
                        File resolvedPath = pathResolver.resolve();
                        Supplier<DateTimeFormatter> dateTimeFormatterSupplier = () -> DateTimeFormatter.ofPattern(AuditResourceDefinitions.DATE_FORMAT).withZone(ZoneId.systemDefault());
                        SecurityEventVisitor formatter = Format.JSON == format ? JsonSecurityEventFormatter.builder().setDateTimeFormatterSupplier(dateTimeFormatterSupplier).build() : SimpleSecurityEventFormatter.builder().setDateTimeFormatterSupplier(dateTimeFormatterSupplier).build();
                        try {
                            FileAuditEndpoint.Builder builder = PeriodicRotatingFileAuditEndpoint.builder().setSuffix(suffix).setLocation(resolvedPath.toPath()).setSyncOnAccept(synv).setDateTimeFormatterSupplier(dateTimeFormatterSupplier);
                            this.endpoint = builder.build();
                        }
                        catch (IOException e) {
                            throw ElytronSubsystemMessages.ROOT_LOGGER.unableToStartService(e);
                        }
                        return SecurityEventListener.from(AuditLogger.builder().setPriorityMapper(m -> EventPriority.WARNING).setMessageFormatter(m -> (String)m.accept(formatter, null)).setAuditEndpoint((ExceptionBiConsumer)this.endpoint).build());
                    }
                };
            }
        };
        return new TrivialResourceDefinition("periodic-rotating-file-audit-log", add, attributes, Capabilities.SECURITY_EVENT_LISTENER_RUNTIME_CAPABILITY);
    }

    static ResourceDefinition getSizeRotatingFileAuditLogResourceDefinition() {
        AttributeDefinition[] attributes = new AttributeDefinition[]{PATH, FileAttributeDefinitions.RELATIVE_TO, SYNCHRONIZED, FORMAT, MAX_BACKUP_INDEX, ROTATE_ON_BOOT, ROTATE_SIZE, SIZE_SUFFIX};
        TrivialAddHandler<SecurityEventListener> add = new TrivialAddHandler<SecurityEventListener>(SecurityEventListener.class, attributes, Capabilities.SECURITY_EVENT_LISTENER_RUNTIME_CAPABILITY){

            @Override
            protected TrivialService.ValueSupplier<SecurityEventListener> getValueSupplier(ServiceBuilder<SecurityEventListener> serviceBuilder, OperationContext context, ModelNode model) throws OperationFailedException {
                final boolean synv = SYNCHRONIZED.resolveModelAttribute(context, model).asBoolean();
                final Format format = Format.valueOf(FORMAT.resolveModelAttribute(context, model).asString());
                final int maxBackupIndex = MAX_BACKUP_INDEX.resolveModelAttribute(context, model).asInt(0);
                final boolean rotateOnBoot = ROTATE_ON_BOOT.resolveModelAttribute(context, model).asBoolean();
                final long rotateSize = SizeValidator.parseSize(ROTATE_SIZE.resolveModelAttribute(context, model));
                final ModelNode suffix = SIZE_SUFFIX.resolveModelAttribute(context, model);
                final InjectedValue pathManager = new InjectedValue();
                final String path = PATH.resolveModelAttribute(context, model).asString();
                final String relativeTo = ElytronExtension.asStringIfDefined(context, (AttributeDefinition)FileAttributeDefinitions.RELATIVE_TO, model);
                if (relativeTo != null) {
                    serviceBuilder.addDependency(PathManagerService.SERVICE_NAME, PathManager.class, (Injector)pathManager);
                    serviceBuilder.addDependency(FileAttributeDefinitions.pathName(relativeTo));
                }
                return new EndpointClosingEventListenerSupplier(){

                    @Override
                    public SecurityEventListener get() throws StartException {
                        FileAttributeDefinitions.PathResolver pathResolver = FileAttributeDefinitions.pathResolver();
                        pathResolver.path(path);
                        if (relativeTo != null) {
                            pathResolver.relativeTo(relativeTo, (PathManager)pathManager.getValue());
                        }
                        File resolvedPath = pathResolver.resolve();
                        Supplier<DateTimeFormatter> dateTimeFormatterSupplier = () -> DateTimeFormatter.ofPattern(AuditResourceDefinitions.DATE_FORMAT).withZone(ZoneId.systemDefault());
                        SecurityEventVisitor formatter = Format.JSON == format ? JsonSecurityEventFormatter.builder().setDateTimeFormatterSupplier(dateTimeFormatterSupplier).build() : SimpleSecurityEventFormatter.builder().setDateTimeFormatterSupplier(dateTimeFormatterSupplier).build();
                        try {
                            SizeRotatingFileAuditEndpoint.Builder builder = SizeRotatingFileAuditEndpoint.builder().setMaxBackupIndex(maxBackupIndex).setRotateOnBoot(rotateOnBoot).setRotateSize(rotateSize);
                            if (suffix.isDefined()) {
                                builder.setSuffix(suffix.asString());
                            }
                            builder.setLocation(resolvedPath.toPath()).setSyncOnAccept(synv).setDateTimeFormatterSupplier(dateTimeFormatterSupplier);
                            this.endpoint = builder.build();
                        }
                        catch (IOException e) {
                            throw ElytronSubsystemMessages.ROOT_LOGGER.unableToStartService(e);
                        }
                        return SecurityEventListener.from(AuditLogger.builder().setPriorityMapper(m -> EventPriority.WARNING).setMessageFormatter(m -> (String)m.accept(formatter, null)).setAuditEndpoint((ExceptionBiConsumer)this.endpoint).build());
                    }
                };
            }
        };
        return new TrivialResourceDefinition("size-rotating-file-audit-log", add, attributes, Capabilities.SECURITY_EVENT_LISTENER_RUNTIME_CAPABILITY);
    }

    static ResourceDefinition getSyslogAuditLogResourceDefinition() {
        AttributeDefinition[] attributes = new AttributeDefinition[]{SERVER_ADDRESS, PORT, TRANSPORT, HOST_NAME, FORMAT, SSL_CONTEXT};
        TrivialAddHandler<SecurityEventListener> add = new TrivialAddHandler<SecurityEventListener>(SecurityEventListener.class, attributes, Capabilities.SECURITY_EVENT_LISTENER_RUNTIME_CAPABILITY){

            @Override
            protected TrivialService.ValueSupplier<SecurityEventListener> getValueSupplier(ServiceBuilder<SecurityEventListener> serviceBuilder, OperationContext context, ModelNode model) throws OperationFailedException {
                InetAddress serverAddress;
                String address = SERVER_ADDRESS.resolveModelAttribute(context, model).asString();
                try {
                    serverAddress = InetAddress.getByName(address);
                }
                catch (UnknownHostException e) {
                    throw ElytronSubsystemMessages.ROOT_LOGGER.serverNotKnown(address, e);
                }
                final int port = PORT.resolveModelAttribute(context, model).asInt();
                final Transport transport = Transport.valueOf(TRANSPORT.resolveModelAttribute(context, model).asString());
                final String hostName = HOST_NAME.resolveModelAttribute(context, model).asString();
                final Format format = Format.valueOf(FORMAT.resolveModelAttribute(context, model).asString());
                final InjectedValue sslContextInjector = new InjectedValue();
                String sslContextName = ElytronExtension.asStringIfDefined(context, (AttributeDefinition)SSL_CONTEXT, model);
                if (sslContextName != null) {
                    String sslCapability = RuntimeCapability.buildDynamicCapabilityName((String)"org.wildfly.security.ssl-context", (String)sslContextName);
                    ServiceName sslServiceName = context.getCapabilityServiceName(sslCapability, SSLContext.class);
                    serviceBuilder.addDependency(sslServiceName, SSLContext.class, (Injector)sslContextInjector);
                }
                return new EndpointClosingEventListenerSupplier(){

                    @Override
                    public SecurityEventListener get() throws StartException {
                        Supplier<DateTimeFormatter> dateTimeFormatterSupplier = () -> DateTimeFormatter.ofPattern(AuditResourceDefinitions.DATE_FORMAT).withZone(ZoneId.systemDefault());
                        SecurityEventVisitor formatter = Format.JSON == format ? JsonSecurityEventFormatter.builder().setDateTimeFormatterSupplier(dateTimeFormatterSupplier).build() : SimpleSecurityEventFormatter.builder().setDateTimeFormatterSupplier(dateTimeFormatterSupplier).build();
                        SSLContext sslContext = (SSLContext)sslContextInjector.getOptionalValue();
                        try {
                            this.endpoint = SyslogAuditEndpoint.builder().setServerAddress(serverAddress).setPort(port).setSsl(transport == Transport.SSL_TCP).setTcp(transport == Transport.TCP || transport == Transport.SSL_TCP).setHostName(hostName).setSocketFactory(transport == Transport.SSL_TCP && sslContext != null ? sslContext.getSocketFactory() : null).build();
                        }
                        catch (IOException e) {
                            throw ElytronSubsystemMessages.ROOT_LOGGER.unableToStartService(e);
                        }
                        return SecurityEventListener.from(AuditLogger.builder().setPriorityMapper(m -> EventPriority.WARNING).setMessageFormatter(m -> (String)m.accept(formatter, null)).setAuditEndpoint((ExceptionBiConsumer)this.endpoint).build());
                    }
                };
            }
        };
        return new TrivialResourceDefinition("syslog-audit-log", add, attributes, Capabilities.SECURITY_EVENT_LISTENER_RUNTIME_CAPABILITY);
    }

    static class SuffixValidator
    extends ModelTypeValidator {
        private final boolean denySeconds;

        public SuffixValidator() {
            this(false, true);
        }

        public SuffixValidator(boolean nullable, boolean denySeconds) {
            super(ModelType.STRING, nullable);
            this.denySeconds = denySeconds;
        }

        public void validateParameter(String parameterName, ModelNode value) throws OperationFailedException {
            super.validateParameter(parameterName, value);
            if (value.isDefined()) {
                String suffix = value.asString();
                try {
                    DateTimeFormatter.ofPattern(suffix);
                    if (this.denySeconds) {
                        for (int i = 0; i < suffix.length(); ++i) {
                            char c = suffix.charAt(i);
                            if (c == '\'') {
                                c = suffix.charAt(++i);
                                while (c != '\'') {
                                    c = suffix.charAt(++i);
                                }
                            }
                            if (c != 's' && c != 'S') continue;
                            throw ElytronSubsystemMessages.ROOT_LOGGER.suffixContainsMillis(suffix);
                        }
                    }
                }
                catch (IllegalArgumentException e) {
                    throw ElytronSubsystemMessages.ROOT_LOGGER.invalidSuffix(suffix);
                }
            }
        }
    }

    static class SizeValidator
    extends ModelTypeValidator {
        private static final Pattern SIZE_PATTERN = Pattern.compile("(\\d+)([kKmMgGbBtT])?");

        public SizeValidator() {
            this(false);
        }

        public SizeValidator(boolean nullable) {
            super(ModelType.STRING, nullable);
        }

        public void validateParameter(String parameterName, ModelNode value) throws OperationFailedException {
            super.validateParameter(parameterName, value);
            if (value.isDefined()) {
                SizeValidator.parseSize(value);
            }
        }

        public static long parseSize(ModelNode value) throws OperationFailedException {
            Matcher matcher = SIZE_PATTERN.matcher(value.asString());
            if (!matcher.matches()) {
                throw ElytronSubsystemMessages.ROOT_LOGGER.invalidSize(value.asString());
            }
            long qty = Long.parseLong(matcher.group(1), 10);
            String chr = matcher.group(2);
            if (chr != null) {
                switch (chr.charAt(0)) {
                    case 'B': 
                    case 'b': {
                        break;
                    }
                    case 'K': 
                    case 'k': {
                        qty <<= 10;
                        break;
                    }
                    case 'M': 
                    case 'm': {
                        qty <<= 20;
                        break;
                    }
                    case 'G': 
                    case 'g': {
                        qty <<= 30;
                        break;
                    }
                    case 'T': 
                    case 't': {
                        qty <<= 40;
                        break;
                    }
                    default: {
                        throw ElytronSubsystemMessages.ROOT_LOGGER.invalidSize(value.asString());
                    }
                }
            }
            return qty;
        }
    }

    private static enum Transport {
        TCP,
        UDP,
        SSL_TCP;

    }

    private static enum Format {
        SIMPLE,
        JSON;

    }

    private static abstract class EndpointClosingEventListenerSupplier
    implements TrivialService.ValueSupplier<SecurityEventListener> {
        AuditEndpoint endpoint;

        private EndpointClosingEventListenerSupplier() {
        }

        @Override
        public void dispose() {
            if (this.endpoint == null) {
                return;
            }
            try {
                this.endpoint.close();
            }
            catch (IOException e) {
                ElytronSubsystemMessages.ROOT_LOGGER.trace("Unable to close audit endpoint", e);
            }
        }
    }
}

