/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.PersistentResourceXMLDescription;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;
import org.wildfly.extension.elytron.AuthenticationFactoryDefinitions;
import org.wildfly.extension.elytron.SaslServerDefinitions;

class AuthenticationFactoryParser {
    private PersistentResourceXMLDescription httpServerMechanismFactoryParser = PersistentResourceXMLDescription.builder((PathElement)PathElement.pathElement((String)"http-authentication-factory")).addAttribute((AttributeDefinition)AuthenticationFactoryDefinitions.BASE_SECURITY_DOMAIN_REF).addAttribute((AttributeDefinition)AuthenticationFactoryDefinitions.HTTP_SERVER_MECHANISM_FACTORY).addAttribute(AuthenticationFactoryDefinitions.getMechanismConfiguration("org.wildfly.security.http-authentication-factory")).build();
    private PersistentResourceXMLDescription saslAuthenticationFactoryyParser = PersistentResourceXMLDescription.builder((PathElement)PathElement.pathElement((String)"sasl-authentication-factory")).addAttribute((AttributeDefinition)SaslServerDefinitions.SASL_SERVER_FACTORY).addAttribute((AttributeDefinition)SaslServerDefinitions.SECURITY_DOMAIN).addAttribute(AuthenticationFactoryDefinitions.getMechanismConfiguration("org.wildfly.security.sasl-authentication-factory")).build();

    AuthenticationFactoryParser() {
    }

    void readHttpAuthenticationFactoryElement(PathAddress parentAddress, XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        this.httpServerMechanismFactoryParser.parse(reader, parentAddress, operations);
    }

    void readSaslAuthenticationFactoryElement(PathAddress parentAddress, XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        this.saslAuthenticationFactoryyParser.parse(reader, parentAddress, operations);
    }

    private void writeMechanismConfiguration(ModelNode configuration, XMLExtendedStreamWriter writer) throws XMLStreamException {
        if (configuration.hasDefined("mechanism-configurations")) {
            writer.writeStartElement("mechanism-configuration");
            for (ModelNode currentMechConfig : configuration.require("mechanism-configurations").asList()) {
                writer.writeStartElement("mechanism");
                AuthenticationFactoryDefinitions.MECHANISM_NAME.marshallAsAttribute(currentMechConfig, (XMLStreamWriter)writer);
                AuthenticationFactoryDefinitions.HOST_NAME.marshallAsAttribute(currentMechConfig, (XMLStreamWriter)writer);
                AuthenticationFactoryDefinitions.PROTOCOL.marshallAsAttribute(currentMechConfig, (XMLStreamWriter)writer);
                AuthenticationFactoryDefinitions.BASE_PRE_REALM_PRINCIPAL_TRANSFORMER.marshallAsAttribute(currentMechConfig, (XMLStreamWriter)writer);
                AuthenticationFactoryDefinitions.BASE_POST_REALM_PRINCIPAL_TRANSFORMER.marshallAsAttribute(currentMechConfig, (XMLStreamWriter)writer);
                AuthenticationFactoryDefinitions.BASE_FINAL_PRINCIPAL_TRANSFORMER.marshallAsAttribute(currentMechConfig, (XMLStreamWriter)writer);
                AuthenticationFactoryDefinitions.BASE_REALM_MAPPER.marshallAsAttribute(currentMechConfig, (XMLStreamWriter)writer);
                AuthenticationFactoryDefinitions.BASE_CREDENTIAL_SECURITY_FACTORY.marshallAsAttribute(currentMechConfig, (XMLStreamWriter)writer);
                if (currentMechConfig.hasDefined("mechanism-realm-configurations")) {
                    for (ModelNode currentMechRealmConfig : currentMechConfig.require("mechanism-realm-configurations").asList()) {
                        writer.writeStartElement("mechanism-realm");
                        AuthenticationFactoryDefinitions.REALM_NAME.marshallAsAttribute(currentMechRealmConfig, (XMLStreamWriter)writer);
                        AuthenticationFactoryDefinitions.BASE_PRE_REALM_PRINCIPAL_TRANSFORMER.marshallAsAttribute(currentMechRealmConfig, (XMLStreamWriter)writer);
                        AuthenticationFactoryDefinitions.BASE_POST_REALM_PRINCIPAL_TRANSFORMER.marshallAsAttribute(currentMechRealmConfig, (XMLStreamWriter)writer);
                        AuthenticationFactoryDefinitions.BASE_FINAL_PRINCIPAL_TRANSFORMER.marshallAsAttribute(currentMechRealmConfig, (XMLStreamWriter)writer);
                        AuthenticationFactoryDefinitions.BASE_REALM_MAPPER.marshallAsAttribute(currentMechRealmConfig, (XMLStreamWriter)writer);
                        writer.writeEndElement();
                    }
                }
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
    }

    boolean writeHttpAuthenticationFactory(boolean started, ModelNode subsystem, XMLExtendedStreamWriter writer, WrapperWriter wrapperWriter) throws XMLStreamException {
        if (subsystem.hasDefined("http-authentication-factory")) {
            wrapperWriter.start(started);
            ModelNode httpAuthenticationFactory = subsystem.require("http-authentication-factory");
            for (String name : httpAuthenticationFactory.keys()) {
                ModelNode configuration = httpAuthenticationFactory.require(name);
                writer.writeStartElement("http-authentication-factory");
                writer.writeAttribute("name", name);
                AuthenticationFactoryDefinitions.HTTP_SERVER_MECHANISM_FACTORY.marshallAsAttribute(configuration, (XMLStreamWriter)writer);
                AuthenticationFactoryDefinitions.BASE_SECURITY_DOMAIN_REF.marshallAsAttribute(configuration, (XMLStreamWriter)writer);
                this.writeMechanismConfiguration(configuration, writer);
                writer.writeEndElement();
            }
            return true;
        }
        return false;
    }

    boolean writeSaslAuthenticationFactory(boolean started, ModelNode subsystem, XMLExtendedStreamWriter writer, WrapperWriter wrapperWriter) throws XMLStreamException {
        if (subsystem.hasDefined("sasl-authentication-factory")) {
            wrapperWriter.start(started);
            ModelNode securityDomainSaslConfigurationInstances = subsystem.require("sasl-authentication-factory");
            for (String name : securityDomainSaslConfigurationInstances.keys()) {
                ModelNode configuration = securityDomainSaslConfigurationInstances.require(name);
                writer.writeStartElement("sasl-authentication-factory");
                writer.writeAttribute("name", name);
                SaslServerDefinitions.SASL_SERVER_FACTORY.marshallAsAttribute(configuration, (XMLStreamWriter)writer);
                SaslServerDefinitions.SECURITY_DOMAIN.marshallAsAttribute(configuration, (XMLStreamWriter)writer);
                this.writeMechanismConfiguration(configuration, writer);
                writer.writeEndElement();
            }
            return true;
        }
        return false;
    }

    @FunctionalInterface
    static interface WrapperWriter {
        public void start(boolean var1) throws XMLStreamException;
    }
}

