/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.util.List;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.PersistentResourceXMLDescription;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.security.CredentialReference;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;
import org.wildfly.extension.elytron.ElytronSubsystemParser;
import org.wildfly.extension.elytron.FileAttributeDefinitions;
import org.wildfly.extension.elytron.FilteringKeyStoreDefinition;
import org.wildfly.extension.elytron.KeyStoreDefinition;
import org.wildfly.extension.elytron.LdapKeyStoreDefinition;
import org.wildfly.extension.elytron.SSLDefinitions;

class TlsParser {
    private PersistentResourceXMLDescription keyManagerParser = PersistentResourceXMLDescription.builder((PathElement)PathElement.pathElement((String)"key-manager")).setXmlWrapperElement("key-managers").addAttribute((AttributeDefinition)SSLDefinitions.ALGORITHM).addAttribute((AttributeDefinition)SSLDefinitions.KEYSTORE).addAttribute((AttributeDefinition)SSLDefinitions.ALIAS_FILTER).addAttribute((AttributeDefinition)SSLDefinitions.PROVIDERS).addAttribute((AttributeDefinition)SSLDefinitions.PROVIDER_NAME).addAttribute((AttributeDefinition)CredentialReference.getAttributeDefinition()).build();
    private PersistentResourceXMLDescription keyStoreParser = PersistentResourceXMLDescription.builder((PathElement)PathElement.pathElement((String)"key-store")).addAttribute((AttributeDefinition)KeyStoreDefinition.TYPE).addAttribute((AttributeDefinition)KeyStoreDefinition.PROVIDER_NAME).addAttribute((AttributeDefinition)KeyStoreDefinition.PROVIDERS).addAttribute((AttributeDefinition)KeyStoreDefinition.CREDENTIAL_REFERENCE).addAttribute((AttributeDefinition)KeyStoreDefinition.ALIAS_FILTER).addAttribute((AttributeDefinition)KeyStoreDefinition.REQUIRED).addAttribute((AttributeDefinition)FileAttributeDefinitions.PATH).addAttribute((AttributeDefinition)FileAttributeDefinitions.RELATIVE_TO).addAttribute((AttributeDefinition)CredentialReference.getAttributeDefinition()).build();
    private PersistentResourceXMLDescription ldapKeyStoreParser = PersistentResourceXMLDescription.builder((PathElement)PathElement.pathElement((String)"ldap-key-store")).addAttribute((AttributeDefinition)LdapKeyStoreDefinition.DIR_CONTEXT).addAttribute((AttributeDefinition)LdapKeyStoreDefinition.SEARCH_PATH).addAttribute((AttributeDefinition)LdapKeyStoreDefinition.SEARCH_RECURSIVE).addAttribute((AttributeDefinition)LdapKeyStoreDefinition.SEARCH_TIME_LIMIT).addAttribute((AttributeDefinition)LdapKeyStoreDefinition.FILTER_ALIAS).addAttribute((AttributeDefinition)LdapKeyStoreDefinition.FILTER_CERTIFICATE).addAttribute((AttributeDefinition)LdapKeyStoreDefinition.FILTER_ITERATE).addAttribute((AttributeDefinition)LdapKeyStoreDefinition.NewItemTemplateObjectDefinition.OBJECT_DEFINITION).addAttribute((AttributeDefinition)LdapKeyStoreDefinition.ALIAS_ATTRIBUTE).addAttribute((AttributeDefinition)LdapKeyStoreDefinition.CERTIFICATE_ATTRIBUTE).addAttribute((AttributeDefinition)LdapKeyStoreDefinition.CERTIFICATE_TYPE).addAttribute((AttributeDefinition)LdapKeyStoreDefinition.CERTIFICATE_CHAIN_ATTRIBUTE).addAttribute((AttributeDefinition)LdapKeyStoreDefinition.CERTIFICATE_CHAIN_ENCODING).addAttribute((AttributeDefinition)LdapKeyStoreDefinition.KEY_ATTRIBUTE).addAttribute((AttributeDefinition)LdapKeyStoreDefinition.KEY_TYPE).build();
    private PersistentResourceXMLDescription trustManagerParser = PersistentResourceXMLDescription.builder((PathElement)PathElement.pathElement((String)"trust-manager")).setXmlWrapperElement("trust-managers").addAttribute((AttributeDefinition)SSLDefinitions.ALGORITHM).addAttribute((AttributeDefinition)SSLDefinitions.KEYSTORE).addAttribute((AttributeDefinition)SSLDefinitions.ALIAS_FILTER).addAttribute((AttributeDefinition)SSLDefinitions.PROVIDERS).addAttribute((AttributeDefinition)SSLDefinitions.PROVIDER_NAME).addAttribute((AttributeDefinition)SSLDefinitions.CERTIFICATE_REVOCATION_LIST).build();
    private PersistentResourceXMLDescription filteringKeyStoreParser = PersistentResourceXMLDescription.builder((PathElement)PathElement.pathElement((String)"filtering-key-store")).addAttribute((AttributeDefinition)FilteringKeyStoreDefinition.KEY_STORE).addAttribute((AttributeDefinition)FilteringKeyStoreDefinition.ALIAS_FILTER).build();
    private PersistentResourceXMLDescription serverSslContextParser = PersistentResourceXMLDescription.builder((PathElement)PathElement.pathElement((String)"server-ssl-context")).setXmlWrapperElement("server-ssl-contexts").setMarshallDefaultValues(true).addAttribute((AttributeDefinition)SSLDefinitions.SECURITY_DOMAIN).addAttribute((AttributeDefinition)SSLDefinitions.CIPHER_SUITE_FILTER).addAttribute((AttributeDefinition)SSLDefinitions.PROTOCOLS).addAttribute((AttributeDefinition)SSLDefinitions.WANT_CLIENT_AUTH).addAttribute((AttributeDefinition)SSLDefinitions.NEED_CLIENT_AUTH).addAttribute((AttributeDefinition)SSLDefinitions.AUTHENTICATION_OPTIONAL).addAttribute((AttributeDefinition)SSLDefinitions.USE_CIPHER_SUITES_ORDER).addAttribute((AttributeDefinition)SSLDefinitions.MAXIMUM_SESSION_CACHE_SIZE).addAttribute((AttributeDefinition)SSLDefinitions.SESSION_TIMEOUT).addAttribute((AttributeDefinition)SSLDefinitions.WRAP).addAttribute((AttributeDefinition)SSLDefinitions.KEY_MANAGER).addAttribute((AttributeDefinition)SSLDefinitions.TRUST_MANAGER).addAttribute((AttributeDefinition)SSLDefinitions.PROVIDERS).addAttribute((AttributeDefinition)SSLDefinitions.PROVIDER_NAME).addAttribute((AttributeDefinition)SSLDefinitions.PRE_REALM_PRINCIPAL_TRANSFORMER).addAttribute((AttributeDefinition)SSLDefinitions.POST_REALM_PRINCIPAL_TRANSFORMER).addAttribute((AttributeDefinition)SSLDefinitions.FINAL_PRINCIPAL_TRANSFORMER).addAttribute((AttributeDefinition)SSLDefinitions.REALM_MAPPER).build();
    private PersistentResourceXMLDescription clientSslContextParser = PersistentResourceXMLDescription.builder((PathElement)PathElement.pathElement((String)"client-ssl-context")).setXmlWrapperElement("client-ssl-contexts").addAttribute((AttributeDefinition)SSLDefinitions.SECURITY_DOMAIN).addAttribute((AttributeDefinition)SSLDefinitions.CIPHER_SUITE_FILTER).addAttribute((AttributeDefinition)SSLDefinitions.PROTOCOLS).addAttribute((AttributeDefinition)SSLDefinitions.WANT_CLIENT_AUTH).addAttribute((AttributeDefinition)SSLDefinitions.NEED_CLIENT_AUTH).addAttribute((AttributeDefinition)SSLDefinitions.AUTHENTICATION_OPTIONAL).addAttribute((AttributeDefinition)SSLDefinitions.USE_CIPHER_SUITES_ORDER).addAttribute((AttributeDefinition)SSLDefinitions.MAXIMUM_SESSION_CACHE_SIZE).addAttribute((AttributeDefinition)SSLDefinitions.SESSION_TIMEOUT).addAttribute((AttributeDefinition)SSLDefinitions.WRAP).addAttribute((AttributeDefinition)SSLDefinitions.KEY_MANAGER).addAttribute((AttributeDefinition)SSLDefinitions.TRUST_MANAGER).addAttribute((AttributeDefinition)SSLDefinitions.PROVIDERS).addAttribute((AttributeDefinition)SSLDefinitions.PROVIDER_NAME).build();

    TlsParser() {
    }

    void readTls(PathAddress parentAddress, XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        boolean keyManagersFound = false;
        boolean keyStoresFound = false;
        boolean trustManagersFound = false;
        boolean serverSSLContextsFound = false;
        boolean clientSSLContextsFound = false;
        while (reader.hasNext() && reader.nextTag() != 2) {
            ElytronSubsystemParser.verifyNamespace(reader);
            String localName = reader.getLocalName();
            if ("key-managers".equals(localName) && !keyManagersFound) {
                keyManagersFound = true;
                this.readWithWrapper(parentAddress, reader, operations, this.keyManagerParser);
                continue;
            }
            if ("key-stores".equals(localName) && !keyStoresFound) {
                keyStoresFound = true;
                this.readKeyStores(parentAddress, reader, operations);
                continue;
            }
            if ("trust-managers".equals(localName) && !trustManagersFound) {
                trustManagersFound = true;
                this.readWithWrapper(parentAddress, reader, operations, this.trustManagerParser);
                continue;
            }
            if ("server-ssl-contexts".equals(localName) && !serverSSLContextsFound) {
                serverSSLContextsFound = true;
                this.readWithWrapper(parentAddress, reader, operations, this.serverSslContextParser);
                continue;
            }
            if ("client-ssl-contexts".equals(localName) && !clientSSLContextsFound) {
                clientSSLContextsFound = true;
                this.readWithWrapper(parentAddress, reader, operations, this.clientSslContextParser);
                continue;
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void readWithWrapper(PathAddress parentAddress, XMLExtendedStreamReader reader, List<ModelNode> operations, PersistentResourceXMLDescription parser) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        while (reader.hasNext() && reader.nextTag() != 2) {
            ElytronSubsystemParser.verifyNamespace(reader);
            String localName = reader.getLocalName();
            if (parser.getPathElement().getKey().equals(localName)) {
                parser.parse(reader, parentAddress, operations);
                continue;
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void readKeyStores(PathAddress parentAddress, XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        while (reader.hasNext() && reader.nextTag() != 2) {
            ElytronSubsystemParser.verifyNamespace(reader);
            String localName = reader.getLocalName();
            if ("key-store".equals(localName)) {
                this.keyStoreParser.parse(reader, parentAddress, operations);
                continue;
            }
            if ("ldap-key-store".equals(localName)) {
                this.ldapKeyStoreParser.parse(reader, parentAddress, operations);
                continue;
            }
            if ("filtering-key-store".equals(localName)) {
                this.filteringKeyStoreParser.parse(reader, parentAddress, operations);
                continue;
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void startTLS(boolean started, XMLExtendedStreamWriter writer) throws XMLStreamException {
        if (!started) {
            writer.writeStartElement("tls");
        }
    }

    void writeTLS(ModelNode subsystem, XMLExtendedStreamWriter writer) throws XMLStreamException {
        boolean tlsStarted = false;
        tlsStarted |= this.writeKeyStores(tlsStarted, subsystem, writer);
        tlsStarted |= this.writeElement(tlsStarted, subsystem, writer, this.keyManagerParser);
        tlsStarted |= this.writeElement(tlsStarted, subsystem, writer, this.trustManagerParser);
        tlsStarted |= this.writeElement(tlsStarted, subsystem, writer, this.serverSslContextParser);
        if (tlsStarted |= this.writeElement(tlsStarted, subsystem, writer, this.clientSslContextParser)) {
            writer.writeEndElement();
        }
    }

    private boolean writeElement(boolean started, ModelNode subsystem, XMLExtendedStreamWriter writer, PersistentResourceXMLDescription parser) throws XMLStreamException {
        if (subsystem.hasDefined(parser.getPathElement().getKey())) {
            this.startTLS(started, writer);
            parser.persist(writer, subsystem);
            return true;
        }
        return false;
    }

    private boolean writeKeyStores(boolean started, ModelNode subsystem, XMLExtendedStreamWriter writer) throws XMLStreamException {
        if (subsystem.hasDefined("key-store") || subsystem.hasDefined("ldap-key-store") || subsystem.hasDefined("filtering-key-store")) {
            this.startTLS(started, writer);
            writer.writeStartElement("key-stores");
            this.keyStoreParser.persist(writer, subsystem);
            this.ldapKeyStoreParser.persist(writer, subsystem);
            this.filteringKeyStoreParser.persist(writer, subsystem);
            writer.writeEndElement();
            return true;
        }
        return false;
    }
}

