/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.util.List;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.AttributeMarshaller;
import org.jboss.as.controller.AttributeParser;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.PersistentResourceXMLDescription;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;
import org.wildfly.extension.elytron.AuthenticationClientDefinitions;
import org.wildfly.extension.elytron.ElytronSubsystemParser;

class AuthenticationClientParser {
    private final PersistentResourceXMLDescription authenticationConfigurationParser = PersistentResourceXMLDescription.builder((PathElement)PathElement.pathElement((String)"authentication-configuration"), null).addAttributes(AuthenticationClientDefinitions.AUTHENTICATION_CONFIGURATION_SIMPLE_ATTRIBUTES).addAttribute((AttributeDefinition)AuthenticationClientDefinitions.MECHANISM_PROPERTIES, AttributeParser.PROPERTIES_PARSER, AttributeMarshaller.PROPERTIES_MARSHALLER).addAttribute((AttributeDefinition)AuthenticationClientDefinitions.CREDENTIAL_REFERENCE, AuthenticationClientDefinitions.CREDENTIAL_REFERENCE.getParser(), AuthenticationClientDefinitions.CREDENTIAL_REFERENCE.getAttributeMarshaller()).build();
    private final PersistentResourceXMLDescription authenticationContextParser = PersistentResourceXMLDescription.builder((PathElement)PathElement.pathElement((String)"authentication-context"), null).addAttribute((AttributeDefinition)AuthenticationClientDefinitions.CONTEXT_EXTENDS).addAttribute((AttributeDefinition)AuthenticationClientDefinitions.MATCH_RULES, AttributeParser.UNWRAPPED_OBJECT_LIST_PARSER, AttributeMarshaller.UNWRAPPED_OBJECT_LIST_MARSHALLER).build();

    AuthenticationClientParser() {
    }

    void readAuthenticationClient(ModelNode parentAddressNode, XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        block8: while (reader.hasNext() && reader.nextTag() != 2) {
            ElytronSubsystemParser.verifyNamespace(reader);
            String localName = reader.getLocalName();
            PathAddress parentAddress = PathAddress.pathAddress((ModelNode)parentAddressNode);
            switch (localName) {
                case "authentication-configuration": {
                    this.authenticationConfigurationParser.parse(reader, parentAddress, operations);
                    continue block8;
                }
                case "authentication-context": {
                    this.authenticationContextParser.parse(reader, parentAddress, operations);
                    continue block8;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    void writeAuthenticationClient(ModelNode subsystem, XMLExtendedStreamWriter writer) throws XMLStreamException {
        if (!this.shouldWrite(subsystem)) {
            return;
        }
        writer.writeStartElement("authentication-client");
        this.authenticationConfigurationParser.persist(writer, subsystem);
        this.authenticationContextParser.persist(writer, subsystem);
        writer.writeEndElement();
    }

    private boolean shouldWrite(ModelNode subsystem) {
        return subsystem.hasDefined("authentication-configuration") || subsystem.hasDefined("authentication-context");
    }
}

