/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.util.List;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.StringListAttributeDefinition;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.descriptions.StandardResourceDescriptionResolver;
import org.jboss.as.controller.operations.common.GenericSubsystemDescribeHandler;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.server.deployment.AttachmentKey;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.wildfly.extension.elytron.ElytronDefinition;
import org.wildfly.extension.elytron.ElytronSubsystemParser;
import org.wildfly.security.auth.client.AuthenticationContext;

public class ElytronExtension
implements Extension {
    public static final String NAMESPACE = "urn:wildfly:elytron:1.0";
    public static final String SUBSYSTEM_NAME = "elytron";
    public static final AttachmentKey<AuthenticationContext> AUTHENTICATION_CONTEXT_KEY = AttachmentKey.create(AuthenticationContext.class);
    static final ModelVersion ELYTRON_1_0_0;
    private static final ModelVersion ELYTRON_CURRENT;
    static final String ISO_8601_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    private final ElytronSubsystemParser parser = new ElytronSubsystemParser();
    protected static final PathElement SUBSYSTEM_PATH;
    private static final String RESOURCE_NAME;
    static final ServiceName BASE_SERVICE_NAME;

    static StandardResourceDescriptionResolver getResourceDescriptionResolver(String ... keyPrefixes) {
        StringBuilder sb = new StringBuilder(SUBSYSTEM_NAME);
        if (keyPrefixes != null) {
            for (String current : keyPrefixes) {
                sb.append(".").append(current);
            }
        }
        return new StandardResourceDescriptionResolver(sb.toString(), RESOURCE_NAME, ElytronExtension.class.getClassLoader(), true, false);
    }

    public void initializeParsers(ExtensionParsingContext context) {
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, NAMESPACE, (XMLElementReader)this.parser);
    }

    public void initialize(ExtensionContext context) {
        SubsystemRegistration subsystemRegistration = context.registerSubsystem(SUBSYSTEM_NAME, ELYTRON_CURRENT);
        subsystemRegistration.setHostCapable();
        ManagementResourceRegistration registration = subsystemRegistration.registerSubsystemModel((ResourceDefinition)ElytronDefinition.INSTANCE);
        registration.registerOperationHandler((OperationDefinition)GenericSubsystemDescribeHandler.DEFINITION, (OperationStepHandler)GenericSubsystemDescribeHandler.INSTANCE);
        subsystemRegistration.registerXMLElementWriter((XMLElementWriter)this.parser);
    }

    static ModelNode createAddSubsystemOperation() {
        ModelNode subsystem = new ModelNode();
        subsystem.get("operation").set("add");
        subsystem.get("address").add("subsystem", SUBSYSTEM_NAME);
        return subsystem;
    }

    static <T> ServiceController<T> getRequiredService(ServiceRegistry serviceRegistry, ServiceName serviceName, Class<T> serviceType) {
        ServiceController controller = serviceRegistry.getRequiredService(serviceName);
        return controller;
    }

    static String asStringIfDefined(OperationContext context, AttributeDefinition attributeDefinition, ModelNode model) throws OperationFailedException {
        ModelNode value = attributeDefinition.resolveModelAttribute(context, model);
        if (value.isDefined()) {
            return value.asString();
        }
        return null;
    }

    static String[] asStringArrayIfDefined(OperationContext context, StringListAttributeDefinition attributeDefinition, ModelNode model) throws OperationFailedException {
        ModelNode resolved = attributeDefinition.resolveModelAttribute(context, model);
        if (resolved.isDefined()) {
            List values = resolved.asList();
            String[] response = new String[values.size()];
            for (int i = 0; i < response.length; ++i) {
                response[i] = ((ModelNode)values.get(i)).asString();
            }
            return response;
        }
        return null;
    }

    static Double asDoubleIfDefined(OperationContext context, SimpleAttributeDefinition attributeDefinition, ModelNode model) throws OperationFailedException {
        ModelNode value = attributeDefinition.resolveModelAttribute(context, model);
        if (value.isDefined()) {
            return value.asDouble();
        }
        return null;
    }

    static int asIntIfDefined(OperationContext context, SimpleAttributeDefinition attributeDefinition, ModelNode model) throws OperationFailedException {
        ModelNode value = attributeDefinition.resolveModelAttribute(context, model);
        if (value.isDefined()) {
            return value.asInt();
        }
        return -1;
    }

    static {
        ELYTRON_CURRENT = ELYTRON_1_0_0 = ModelVersion.create((int)1);
        SUBSYSTEM_PATH = PathElement.pathElement((String)"subsystem", (String)SUBSYSTEM_NAME);
        RESOURCE_NAME = ElytronExtension.class.getPackage().getName() + ".LocalDescriptions";
        BASE_SERVICE_NAME = ServiceName.of((String[])new String[]{SUBSYSTEM_NAME});
    }
}

